<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
    }

    function abortion_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too many params was sent",
                "validations" => array(
                    "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                //VW_ABORTION
                $response = $this->DAO->selectEntity('vw_abortionComplete', array('id_abortion' => $id, 'status'=>1), TRUE);
            } else {
                $response = $this->DAO->selectEntity('vw_abortion', array('status' => 1));
            }
        }
        $this->response($response, $response['status_code']);
    }

    function abortionForReport_get()
    {
        $desde = $this->get('desde');
        $hasta = $this->get('hasta');
        if (count($this->get()) > 4) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too many params was sent",
                "validations" => array(
                    "specie" => "Send Id (Get) to get specific insemination, or empty to get all inseminations"
                ),
                "data" => null
            );
        } else {
            if ($desde) {
                $response = $this->DAO->abortForReport($desde, $hasta);
            } else {
                $response = $this->DAO->abortForReport();
            }
        }
        $this->response($response, $response['status_code']);
    }


    function animalsForabortion_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too many params was sent",
                "validations" => array(
                    "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('animals_abortion', array('id_abortion' => $id, 'status'=>1), false);
            } else {
                $response = $this->DAO->selectEntity('animals_abortion', array('status' => 1));
            }
        }
        $this->response($response, $response['status_code']);
    }

    function animalsCount_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too many params was sent",
                "validations" => array(
                    "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('animals_abortion', array('id_abortion' => $id, 'status' => 1), false);
            } else {
                $response = $this->DAO->selectEntity('animals_abortion', array('status' => 1));
            }
        }
        $this->response($response, $response['status_code']);
    }





    function abortion_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 30) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
                "data" => count($data),
                "validations" => array(
                    "date_birth" => "required and unique",
                    "earring_female" => "required and unique",
                   
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('date_abortion', 'date_abortion', 'required');
            $this->form_validation->set_rules('earring_female', 'earring_female', 'required');
           
           
            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "validations error",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');

                $birth = array(
                    "date_abortion" => $this->post('date_abortion'),
                    "earring_female" => $this->post('earring_female'),
                    "cause" => $this->post('cause'),
                    "created_date"=>$currentDate,
                    "created_user" => $this->post('created_user'),
                    "comment" => $this->post('comments'),
                );
                $dataResponse = $this->DAO->saveOrUpdateItem('abortion', $birth, null, true);
                $id_abortion  = $dataResponse['key'];
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');

                if ($dataResponse['key']) {
                    foreach ($data['sex_abortion'] as $i => $val) {
                        $dataAbortion = array(
                            'id_abortion' => $id_abortion ,
                            'weight' => $data['weight'][$i],
                            "sex_abortion" => $data['sex_abortion'][$i],
                            'created_date' => $currentDate,
                           

                        );
                        $pvResponse = $this->DAO->saveOrUpdateItem('animals_abortion', $dataAbortion, null, true);
                    }

                }

                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" =>  "item created successfully",
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        }
        //$this->response($response,200);
        $this->response($response, $response['status_code']);
    }

    function abortion_put()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('abortion', array('id_abortion' => $id), TRUE);
            if ($dataExists) {
                if (count($this->put()) > 12) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Too many data was sent",
                        "validations" => array(
                            "date_abortion" => "required and unique",
                            "earring_female" => "required and unique",
                        ),
                        "data" => null
                    );
                } else if (count($this->put()) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "No data was sent",
                        "validations" => array(
                            "date_abortion" => "required and unique",
                            "earring_female" => "required and unique",
                        ),
                        "data" => null
                    );
                } else {
                    $this->form_validation->set_data($this->put());
                    $this->form_validation->set_rules('date_abortion', 'date_abortion', 'required');
                    $this->form_validation->set_rules('earring_female', 'earring_female', 'required');
                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validation fail, see validations object for more details",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        $data = array(
                            "date_abortion" => $this->put('date_abortion'),
                            "earring_female" => $this->put('earring_female'),
                            "cause" => $this->put('cause'),
                            "created_date" => $currentDate,
                            "created_user" => $this->put('created_user'),
                            "comment" => $this->put('comments'),
                        );

                        $response = $this->DAO->saveOrUpdateItem('abortion', $data, array('id_abortion' => $id));
                    }
                }
            }
        } else {

            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too data was sent",
                "validations" => array(
                    "id" => "Required",

                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    function abortion_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('abortion', array('id_abortion' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $abortion = array(
                    'status' => 0,
                    'updated_date' => $currentDate
                );
                $response = $this->DAO->updateData('abortion', $abortion, array('id_abortion' => $id));
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "the code of births does not exists",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id wasn't sent",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    function AnimalsAbortion_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('animals_abortion', array('id_animalAbortion' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $abortion = array(
                    'status' => 0,
                    'updated_date' => $currentDate
                );
                $response = $this->DAO->updateData('animals_abortion', $abortion, array('id_animalAbortion' => $id));
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "the code of births does not exists",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id wasn't sent",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }


    function animal_exists($str)
    {
        if (strlen($str) >= 1  && strlen($str) <= 45) {
            $animalExists = $this->DAO->selectEntity('animals', array('earring' => $str), TRUE);
            if ($animalExists['data']) {
                return TRUE;
            } else {
                $this->form_validation->set_message('animal_exists', 'The field {field} does not exists');
                return FALSE;
            }
        }
    }
}
