<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
        $this->load->model('GraphsQueries');
    }

    function all_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too many params was sent",
                "validations" => array(
                    "id" => "Send Id (Get) to get specific item, or empty to get all data"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('data_logger', array('id' => $id), TRUE);
            } else {
                $query = $this->db->query('SELECT * FROM `data_logger` ORDER BY date DESC');
                $response = array(
                    "status" => "success",
                    "status_code" => 200,
                    "message" => "Data loaded, successful",
                    "validations" => null,
                    "data" => $query->result()
                );
            }
        }
        $this->response($response, $response['status_code']);
    }


    function by_hour_current_day_get()
    {
        $response = $this->GraphsQueries->dataLoggerByHourCurrentDay();
        $this->response($response, $response['status_code']);
    }
    function custom_query_post()
    {
        $start = $this->post('start');
        $end = $this->post('end');
        $rodeo = $this->post('rodeo');
        $response = $this->GraphsQueries->customDataLoggerGeneral($start, $end, $rodeo);
        $this->response($response, $response['status_code']);
    }
    function custom_query_by_day_post()
    {
        $rodeo = $this->post('rodeo');
        $date = $this->post('date');
        $response = $this->GraphsQueries->customDataLoggerByDay($date, $rodeo);
        $this->response($response, $response['status_code']);
    }
    function register_post()
    {
        $data = $this->post();
        $dataLogger = [];
        foreach ($data as $row) {
            $existsData = $this->DAO->selectEntity('data_logger', array('date' => $row['date'], 'time' => $row['time'], 'rodeo' => $row['rodeo']), TRUE);
            if (!$existsData['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $dataLogger[] = array(
                    "date" => $row['date'],
                    "time" => $row['time'],
                    "temperature" => $row['temperature'],
                    "humidity" => $row['humidity'],
                    "dew" => $row['dew'],
                    "rodeo" => $row['rodeo'],
                    "created_date" => $currentDate,
                    "created_user" => $row['created_user'],
                );
            }
        }
        $dataResponse = $this->DAO->saveOrUpdateBatchItems('data_logger', $dataLogger);
        if ($dataResponse['status'] == "success") {
            $response = array(
                "status" => "success",
                "status_code" => 200,
                "message" =>  "item created successfully",
                "data" => null,
            );
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" =>  $dataResponse['message'],
                "data" => null,
            );
        }
        $this->response($response, $response['status_code']);
    }
    function custom_query_last_register_post()
    {
        $response = $this->GraphsQueries->dataLoggerLastRegister();
        $this->response($response, $response['status_code']);
    }
    /* function register()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 12) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
                "data" => count($data),
                "validations" => array(
                    "date" => "Campo requerido.",
                    "time" => "Campo requerido.",
                    "temperature" => "Campo requerido.",
                    "humidity" => "Campo requerido.",
                    "dew" => "Campo requerido."
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('date', 'date', 'required');

            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "validations error",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                $existsData = $this->DAO->selectEntity('data_logger', array('date' => $data['date'], 'time' => $data['time'], 'rodeo' => $data['rodeo']), TRUE);
                if ($existsData['data']) {
                    $dataResponse = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" =>  "item created successfully",
                        "data" => null,
                    );
                } else {
                    date_default_timezone_set('America/Mexico_City');
                    $currentDate = date('Y-m-d H:i:s');
                    $dataLogger = array(
                        "date" => $data['date'],
                        "time" => $data['time'],
                        "temperature" => $data['temperature'],
                        "humidity" => $data['humidity'],
                        "dew" => $data['dew'],
                        "rodeo" => $data['rodeo'],
                        "created_date" => $currentDate,
                        "created_user" => $data['created_user'],
                    );
                    $dataResponse = $this->DAO->saveOrUpdateItem('data_logger', $dataLogger, null, true);
                }



                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" =>  "item created successfully",
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        }
        $this->response($response, $response['status_code']);
    } */
}
