<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('DAO');
  }

  function deworming_get()
  {
    $id = $this->get('id');
    $idAnimal = $this->get('idAnimal');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('deworming', array('id_deworming' => $id), TRUE);
      } else if ($idAnimal) {
        $response = $this->DAO->selectEntity('deworming', array('id_animal' => $idAnimal,'status' => 1), false);
      } else{
        $response = $this->DAO->selectEntity('vw_deworming', array('status' => 1), false);
      }
    }
    $this->response($response, $response['status_code']);
  }


  function deworming_post()
  {
    $data = $this->post();
    if (count($data) == 0 || count($data) > 12) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
        "data" => count($data),
        "validations" => array(
          "date_deworming" => "required and unique",
          "product_applied" => "required and unique",
          "animal_weight" => "required and unique",
          "dose" => "required and unique",
          "id_animal" => "required and unique",
        )
      );
    } else {
      $this->form_validation->set_data($data);
      $this->form_validation->set_rules('date_deworming', 'date_deworming', 'required');
      $this->form_validation->set_rules('product_applied', 'product_applied', 'required');
      $this->form_validation->set_rules('id_animal', 'id_animal', 'required');
      $this->form_validation->set_rules('animal_weight', 'animal_weight', 'required');
      $this->form_validation->set_rules('dose', 'dose', 'required');
      if ($this->form_validation->run() == FALSE) {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "validations error",
          "data" => null,
          "validations" => $this->form_validation->error_array()
        );
      } else {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $deworming = array(
          "date_deworming" => $this->post('date_deworming'),
          "product_applied" => $this->post('product_applied'),
          "animal_weight" => $this->post('animal_weight'),
          "id_animal" => $this->post('id_animal'),
          "dose" => $this->post('dose'),
          "next_dose" => $this->post('next_dose'),
          "created_user" => $this->post('created_user'),
          "created_date"=>$currentDate,
        );
        $dataResponse = $this->DAO->saveOrUpdateItem('deworming', $deworming, null, true);
        if ($dataResponse['status'] == "success") {
          $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" =>  "item created successfully",
            "data" => null,
          );
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" =>  $dataResponse['message'],
            "data" => null,
          );
        }
      }
    }
    $this->response($response, $response['status_code']);
  }

  function deworming_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('deworming', array('id_deworming' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 12) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "date_deworming" => "required and unique",
              "product_applied" => "required and unique",
              "animal_weight" => "required and unique",
              "dose" => "required and unique",
              // "next_dose" => "required and unique",
             
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "date_deworming" => "required and unique",
              "product_applied" => "required and unique",
              "animal_weight" => "required and unique",
              "dose" => "required and unique",
              // "next_dose" => "required and unique",
            ),
            "data" => null
          );
        } else {
          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('date_deworming', 'date_deworming', 'required');
          $this->form_validation->set_rules('product_applied', 'product_applied', 'required');
          $this->form_validation->set_rules('animal_weight', 'animal_weight', 'required');
          $this->form_validation->set_rules('id_animal', 'id_animal', 'required');
          $this->form_validation->set_rules('dose', 'dose', 'required');
         
          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            date_default_timezone_set('America/Mexico_City');
            $currentDate = date('Y-m-d H:i:s');
          
            $data = array(
              "date_deworming" => $this->put('date_deworming'),
              "product_applied" => $this->put('product_applied'),
              "animal_weight" => $this->put('animal_weight'),
              "dose" => $this->put('dose'),
              "id_animal" => $this->put('id_animal'),
              "next_dose" => $this->put('next_dose'),
              "updated_date" => $currentDate,
              "updated_user" => $this->put('updated_user'),
              
            );

            $response = $this->DAO->saveOrUpdateItem('deworming', $data, array('id_deworming' => $id));
          }
        }
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }


  function deworming_delete()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('deworming', array('id_deworming' => $id), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $births = array(
          'status' => 0,
          'updated_date' => $currentDate
        );
        $response = $this->DAO->updateData('deworming', $births, array('id_deworming' => $id));
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the code of deworming does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
}
