<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('DAO');
  }

  function lots_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('lots', array('id_lots' => $id), TRUE);
      } else {
        $response = $this->DAO->selectEntity('lots', array('status' => 1));
      }
    }
    $this->response($response, $response['status_code']);
  }

  function lots_post()
  {
    $data = $this->post();
    if (count($data) == 0 || count($data) > 12) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
        "data" => count($data),
        "validations" => array(
          "name_lots" => "required and unique",
          "date_lots" => "required and unique",
          "provider" => "required and unique",
          "no_animals" => "required and unique",
          "average_weight" => "required and unique",
          "total_weight" => "required and unique",
          "comments" => "required and unique",
        )
      );
    } else {
      $this->form_validation->set_data($data);
      $this->form_validation->set_rules('name_lots', 'name_lots', 'required');
      $this->form_validation->set_rules('date_lots', 'date_lots', 'required');
      $this->form_validation->set_rules('provider', 'provider', 'required');
      $this->form_validation->set_rules('no_animals', 'no_animals', 'required');
      $this->form_validation->set_rules('average_weight', 'average_weight', 'required');
      $this->form_validation->set_rules('total_weight', 'total_weight', 'required');
      $this->form_validation->set_rules('comments', 'comments', 'required');
      if ($this->form_validation->run() == FALSE) {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "validations error",
          "data" => null,
          "validations" => $this->form_validation->error_array()
        );
      } else {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $lots = array(
          "name_lots" => $this->post('name_lots'),
          "date_lots" => $this->post('date_lots'),
          "provider" => $this->post('provider'),
          "no_animals" => $this->post('no_animals'),
          "average_weight" => $this->post('average_weight'),
          "total_weight" => $this->post('total_weight'),
          "comments" => $this->post('comments'),
          'create_date' => $currentDate,
          'update_date' => $currentDate
        );
        $dataResponse = $this->DAO->saveOrUpdateItem('lots', $lots, null, true);
        if ($dataResponse['status'] == "success") {
          $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" =>  "item created successfully",
            "data" => null,
          );
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" =>  $dataResponse['message'],
            "data" => null,
          );
        }
      }
    }

    //$this->response($response,200);
    $this->response($response, $response['status_code']);
  }

  function lots_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('rodeos', array('id_rodeos' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 12) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "name_rodeo" => "required and unique",
              "name_lots" => "required and unique",
              "date_lots" => "required and unique",
              "provider" => "required and unique",
              "no_animals" => "required and unique",
              "average_weight" => "required and unique",
              "total_weight" => "required and unique",
              "comments" => "required and unique",
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "name_rodeo" => "required and unique",
              "name_lots" => "required and unique",
              "date_lots" => "required and unique",
              "provider" => "required and unique",
              "no_animals" => "required and unique",
              "average_weight" => "required and unique",
              "total_weight" => "required and unique",
              "comments" => "required and unique",
            ),
            "data" => null
          );
        } else {
          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('name_lots', 'name_lots', 'required');
          $this->form_validation->set_rules('date_lots', 'date_lots', 'required');
          $this->form_validation->set_rules('provider', 'provider', 'required');
          $this->form_validation->set_rules('no_animals', 'no_animals', 'required');
          $this->form_validation->set_rules('average_weight', 'average_weight', 'required');
          $this->form_validation->set_rules('total_weight', 'total_weight', 'required');
          $this->form_validation->set_rules('comments', 'comments', 'required');
          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            date_default_timezone_set('America/Mexico_City');
            $currentDate = date('Y-m-d H:i:s');
            $data = array(
              "name_lots" => $this->put('name_rodeo'),
              "date_lots" => $this->put('date_lots'),
              "provider" => $this->put('provider'),
              "no_animals" => $this->put('no_animals'),
              "average_weight" => $this->put('average_weight'),
              "total_weight" => $this->put('total_weight'),
              "comments" => $this->put('comments'),
              'create_date' => $currentDate,
              'update_date' => $currentDate
            );
            $response = $this->DAO->saveOrUpdateItem('lots', $data, array('id_lots' => $id));
          }
        }
      }
    } else {

      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }

  function lots_delete()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('lots', array('id_lots' => $id), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $births = array(
          'status' => 0,
          'update_date' => $currentDate
        );
        $response = $this->DAO->updateData('lots', $births, array('id_lots' => $id));
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the code of rodeo does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
}
