<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('DAO');
  }

  function ornamental_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('ornamental_birds', array('id_ornamentalBirds' => $id), TRUE);
      } else {
        $response = $this->DAO->selectEntity('ornamental_birds', array('status' => 1), false);
      }
    }
    $this->response($response, $response['status_code']);
  }

  function ornamentalForReport_get()
  {
    $desde = $this->get('desde');
    $hasta = $this->get('hasta');
    if (count($this->get()) > 4) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "specie" => "Send Id (Get) to get specific insemination, or empty to get all inseminations"
        ),
        "data" => null
      );
    } else {
      if ($desde) {
        $response = $this->DAO->ornamentalForReport($desde, $hasta);
      } else {
        $response = $this->DAO->ornamentalForReport();
      }
    }
    $this->response($response, $response['status_code']);
  }

  function ornamental_post()
  {
    $data = $this->post();
    if (count($data) == 0 || count($data) > 12) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
        "data" => count($data),
        "validations" => array(
          "start_date" => "required and unique",
          "number_egg" => "required and unique",
          "bird_origin" => "required and unique",
          "nest_number" => "required and unique",
          "bird_in_nest" => "required and unique",
          "date_birth" => "required and unique",
          "number_hatched_eggs" => "required and unique",
          "non_incubated_eggs" => "required and unique",
        )
      );
    } else {
      $this->form_validation->set_data($data);
      $this->form_validation->set_rules('start_date', 'start_date', 'required');
      $this->form_validation->set_rules('number_egg', 'number_egg', 'required');
      $this->form_validation->set_rules('bird_origin', 'bird_origin', 'required');
      $this->form_validation->set_rules('nest_number', 'nest_number', 'required');
      $this->form_validation->set_rules('bird_in_nest', 'bird_in_nest', 'required');
      $this->form_validation->set_rules('date_birth', 'date_birth', 'required');
      $this->form_validation->set_rules('number_hatched_eggs', 'number_hatched_eggs', 'required');
      $this->form_validation->set_rules('non_incubated_eggs', 'non_incubated_eggs', 'required');

      if ($this->form_validation->run() == FALSE) {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "validations error",
          "data" => null,
          "validations" => $this->form_validation->error_array()
        );
      } else {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');

        $e = array(
          "start_date" => $this->post('start_date'),
          "number_egg" => $this->post('number_egg'),
          "bird_origin" => $this->post('bird_origin'),
          "nest_number" => $this->post('nest_number'),
          "bird_in_nest" => $this->post('bird_in_nest'),
          "date_birth" => $this->post('date_birth'),
          "created_user" => $this->post('created_user'),
          "number_hatched_eggs" => $this->post('number_hatched_eggs'),
          "non_incubated_eggs" => $this->post('non_incubated_eggs'),
          "created_date" => $currentDate,

        );
        $dataResponse = $this->DAO->saveOrUpdateItem('ornamental_birds', $e, null, true);
        if ($dataResponse['status'] == "success") {
          $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" =>  "item created successfully",
            "data" => null,
          );
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" =>  $dataResponse['message'],
            "data" => null,
          );
        }
      }
    }
    $this->response($response, $response['status_code']);
  }

  function ornamental_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('ornamental_birds', array('id_ornamentalBirds' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 12) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "start_date" => "required and unique",
              "number_egg" => "required and unique",
              "bird_origin" => "required and unique",
              "nest_number" => "required and unique",
              "bird_in_nest" => "required and unique",
              "date_birth" => "required and unique",
              "number_hatched_eggs" => "required and unique",
              "non_incubated_eggs" => "required and unique",
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "start_date" => "required and unique",
              "number_egg" => "required and unique",
              "bird_origin" => "required and unique",
              "nest_number" => "required and unique",
              "bird_in_nest" => "required and unique",
              "date_birth" => "required and unique",
              "number_hatched_eggs" => "required and unique",
              "non_incubated_eggs" => "required and unique",
            ),
            "data" => null
          );
        } else {
          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('start_date', 'start_date', 'required');
          $this->form_validation->set_rules('number_egg', 'number_egg', 'required');
          $this->form_validation->set_rules('bird_origin', 'bird_origin', 'required');
          $this->form_validation->set_rules('nest_number', 'nest_number', 'required');
          $this->form_validation->set_rules('bird_in_nest', 'bird_in_nest', 'required');
          $this->form_validation->set_rules('date_birth', 'date_birth', 'required');
          $this->form_validation->set_rules('number_hatched_eggs', 'number_hatched_eggs', 'required');
          $this->form_validation->set_rules('non_incubated_eggs', 'non_incubated_eggs', 'required');
          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            date_default_timezone_set('America/Mexico_City');
            $currentDate = date('Y-m-d H:i:s');

            $data = array(
              "start_date" => $this->put('start_date'),
              "number_egg" => $this->put('number_egg'),
              "bird_origin" => $this->put('bird_origin'),
              "nest_number" => $this->put('nest_number'),
              "bird_in_nest" => $this->put('bird_in_nest'),
              "date_birth" => $this->put('date_birth'),
              "number_hatched_eggs" => $this->put('number_hatched_eggs'),
              "non_incubated_eggs" => $this->put('non_incubated_eggs'),
              "updated_user" => $this->put('created_user'),
              "updated_date" => $currentDate,
            );

            $response = $this->DAO->saveOrUpdateItem('ornamental_birds', $data, array('id_ornamentalBirds' => $id));
          }
        }
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }


  function ornamental_delete()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('ornamental_birds', array('id_ornamentalBirds' => $id), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $births = array(
          'status' => 0,
          'updated_date' => $currentDate
        );
        $response = $this->DAO->updateData('ornamental_birds', $births, array('id_ornamentalBirds' => $id));
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the code of animal does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
}
