<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('DAO');
  }

  function ornamentalEgg_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('ornamental_egg', array('id_ornamental_egg' => $id), TRUE);
      } else {
        $response = $this->DAO->selectEntity('ornamental_egg', array('status' => 1), false);
      }
    }
    $this->response($response, $response['status_code']);
  }

  function ornamentalEggForReport_get()
  {
    $desde = $this->get('desde');
    $hasta = $this->get('hasta');
    if (count($this->get()) > 4) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "specie" => "Send Id (Get) to get specific insemination, or empty to get all inseminations"
        ),
        "data" => null
      );
    } else {
      if ($desde) {
        $response = $this->DAO->ornamentalEggForReport($desde, $hasta);
      } else {
        $response = $this->DAO->ornamentalEggForReport();
      }
    }
    $this->response($response, $response['status_code']);
  }

  function ornamentalEgg_post()
  {
    $data = $this->post();
    if (count($data) == 0 || count($data) > 14) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
        "data" => count($data),
        "validations" => array(
          "mother_earring" =>"Campo requerido.",
          "collection_date" => "Campo requerido.",
          "egg_weight" => "Campo requerido.",
          "total_eggs" => "Campo requerido.",
          "specie" => "Campo requerido.",
          "collection_location" => "Campo requerido.",

        )
      );
    } else {
      $this->form_validation->set_data($data);
      $this->form_validation->set_message('required', 'Campo requerido.');
      $this->form_validation->set_rules('collection_date', 'collection_date', 'required');
      $this->form_validation->set_rules('egg_weight', 'egg_weight', 'required');
      $this->form_validation->set_rules('mother_earring', 'mother_earring', 'required');
      $this->form_validation->set_rules('total_eggs', 'total_eggs', 'required');
      $this->form_validation->set_rules('specie', 'specie', 'required');
      $this->form_validation->set_rules('collection_location', 'collection_location', 'required');

      if ($this->form_validation->run() == FALSE) {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "validations error",
          "data" => null,
          "validations" => $this->form_validation->error_array()
        );
      } else {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');

        $e = array(
          "collection_date" => $this->post('collection_date'),
          "mother_earring" => $this->post('mother_earring'),
          "egg_weight" => $this->post('egg_weight'),
          "total_eggs" => $this->post('total_eggs'),
          "specie" => $this->post('specie'),
          "collection_location" => $this->post('collection_location'),
          "comment" => $this->post('comment'),
          "created_user" => $this->post('created_user'),
          "created_date" => $currentDate,

        );
        $dataResponse = $this->DAO->saveOrUpdateItem('ornamental_egg', $e, null, true);
        if ($dataResponse['status'] == "success") {
          $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" =>  "item created successfully",
            "data" => null,
          );
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" =>  $dataResponse['message'],
            "data" => null,
          );
        }
      }
    }
    $this->response($response, $response['status_code']);
  }

  function ornamentalEgg_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('ornamental_egg', array('id_ornamental_egg' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 12) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "collection_date" => "required and unique",
              "egg_weight" => "required and unique",
              "total_eggs" => "required and unique",
              "specie" => "required and unique",
              "collection_location" => "required and unique",

            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "collection_date" => "required and unique",
              "egg_weight" => "required and unique",
              "total_eggs" => "required and unique",
              "specie" => "required and unique",
              "collection_location" => "required and unique",

            ),
            "data" => null
          );
        } else {
          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('collection_date', 'collection_date', 'required');
          $this->form_validation->set_rules('egg_weight', 'egg_weight', 'required');
          $this->form_validation->set_rules('total_eggs', 'total_eggs', 'required');
          $this->form_validation->set_rules('specie', 'specie', 'required');
          $this->form_validation->set_rules('collection_location', 'collection_location', 'required');

          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            date_default_timezone_set('America/Mexico_City');
            $currentDate = date('Y-m-d H:i:s');

            $data = array(
              "collection_date" => $this->put('collection_date'),
              "egg_weight" => $this->put('egg_weight'),
              "total_eggs" => $this->put('total_eggs'),
              "specie" => $this->put('specie'),
              "collection_location" => $this->put('collection_location'),
              "comment" => $this->put('comment'),
              "updated_date" => $currentDate,
              "updated_user" => $this->put('updated_user'),

            );

            $response = $this->DAO->saveOrUpdateItem('ornamental_egg', $data, array('id_ornamental_egg' => $id));
          }
        }
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }


  function ornamentalEgg_delete()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('ornamental_egg', array('id_ornamental_egg' => $id), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $births = array(
          'status' => 0,
          'updated_date' => $currentDate
        );
        $response = $this->DAO->updateData('ornamental_egg', $births, array('id_ornamental_egg' => $id));
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the code of animal does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
}
