<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('DAO');
    $this->load->model('EggProduction');
  }

  function productions_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('vw_production', array('id_production' => $id), TRUE);
      } else {
        $response = $this->DAO->selectEntity('vw_production', array('status' => 1));
      }
    }
    $this->response($response, $response['status_code']);
  }

  function eggs_productions_get()
  {
    $page = $this->get('page');
    $limit = $this->get('limit');
    $id = $this->get('id');
    if (count($this->get()) > 3) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('vw_production', array('id_production' => $id), TRUE);
      } else {
        /* $response = $this->DAO->selectEntity('vw_production', array('status' => 1, 'product_type' => 'Huevo')); */
        $response = $this->EggProduction->getEggProductionAll($page, $limit);
      }
    }
    $this->response($response, $response['status_code']);
  }

  function eggs_productions_details_get()
  {
    $production = $this->get('production');
    $detail_id = $this->get('detail_id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "production" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($production) {
        $query = $this->db->query("SELECT * FROM `vw_eggProductionDetails` WHERE id_production=$production AND status=1 ORDER BY id_egg_production ASC ");
        /* $response = $this->DAO->selectEntity('vw_eggProductionDetails', array('id_production' => $production, 'status' => 1), FALSE); */
        $response = array(
          "status" => "success",
          "status_code" => 200,
          "message" => "Data loaded, successful",
          "validations" => null,
          "data" => $query->result()
        );
      } else if ($detail_id) {
        $response = $this->DAO->selectEntity('egg_production', array('id_egg_production' => $detail_id), TRUE);
      } else {
        $response = $this->DAO->selectEntity('egg_production', array('status' => 1));
      }
    }
    $this->response($response, $response['status_code']);
  }

  function eggs_productions_post()
  {
    $data = $this->post();
    if (count($data) == 0 || count($data) > 15) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => count($data) == 0 ? 'Ningun dato fue recibido' : 'Demasiados datos recibidos',
        "data" => count($data),
        "validations" => array(
          "date_productions" => "Campo requerido.",
          "id_rodeo" => "Campo requerido",
          "responsible" => "Campo requerido.",
          "quantity_kg" => "Campo requerido.",
          "num_pieces" => "Campo requerido.",
          "status_eggs" => "Campo requerido.",
          "sizeEgg" => "Campo requerido.",
          "comments" => "Campo opcional."
        )
      );
    } else {
      $this->form_validation->set_data($data);
      $this->form_validation->set_rules('date_productions', 'date_productions', 'required');
      $this->form_validation->set_rules('id_rodeo', 'id_rodeo', 'required');
      $this->form_validation->set_rules('responsible', 'responsible', 'required');
      if ($this->form_validation->run() == FALSE) {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "validations error",
          "data" => null,
          "validations" => $this->form_validation->error_array()
        );
      } else {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $production = array(
          "species" => "Aves",
          "date_productions" => $this->post('date_productions'),
          "id_rodeo" => $this->post('id_rodeo'),
          "responsible" => $this->post('responsible'),
          "product_type" => 'Huevo',
          "comments" => $this->post('comments'),
          'created_date' => $currentDate,
          'updated_date' => $currentDate,
          'created_user' => $this->post('created_user')
        );
        $productionResponse = $this->DAO->saveOrUpdateItem('production', $production, null, true);

        if ($productionResponse['key']) {
          $qty = $this->post('quantity_kg');
          $pz = $this->post('num_pieces');
          $status = $this->post('status_eggs');
          $sizeEgg = $this->post('sizeEgg');
          $eggs_production = [];
          for ($i = 0; $i < sizeof($qty); $i++) {
            $eggs_production[] = array(
              'quantity_kg' => $qty[$i],
              'num_pieces' => $pz[$i],
              'status_eggs' => $status[$i],
              'created_date' => $currentDate,
              'updated_date' => $currentDate,
              'size_egg' => $sizeEgg[$i],
              'id_production' => $productionResponse['key'],
              'created_user' => $this->post('created_user')
            );
          }
          $this->db->insert_batch('egg_production', $eggs_production);
          $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" =>  "item created successfully",
            "data" => null,
          );
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" =>  $productionResponse['message'],
            "data" => null,
          );
        }
        //

      }
    }
    $this->response($response, $response['status_code']);
  }
  function eggs_production_mobile_post()
  {
    $data = $this->post();
    if (count($data) == 0 || count($data) > 15) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => count($data) == 0 ? 'Ningun dato fue recibido' : 'Demasiados datos recibidos',
        "data" => count($data),
        "validations" => array(
          "date_productions" => "Campo requerido.",
          "id_rodeo" => "Campo requerido",
          "responsible" => "Campo requerido.",
          "quantity_kg" => "Campo requerido.",
          "num_pieces" => "Campo requerido.",
          "status_eggs" => "Campo requerido.",
          "sizeEgg" => "Campo requerido.",
          "comments" => "Campo opcional."
        )
      );
    } else {
      $this->form_validation->set_data($data);
      $this->form_validation->set_rules('date_productions', 'fecha', 'required');
      $this->form_validation->set_rules('id_rodeo', 'corral', 'required');
      $this->form_validation->set_rules('responsible', 'responsable', 'required');
      $this->form_validation->set_message('required', 'El campo {field} es requerido.');
      if ($this->form_validation->run() == FALSE) {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "validations error",
          "data" => null,
          "validations" => $this->form_validation->error_array()
        );
      } else {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $production = array(
          "species" => "Aves",
          "date_productions" => $this->post('date_productions'),
          "id_rodeo" => $this->post('id_rodeo'),
          "responsible" => $this->post('responsible'),
          "product_type" => 'Huevo',
          "comments" => $this->post('comments'),
          'created_date' => $currentDate,
          'updated_date' => $currentDate,
          'created_user' => $this->post('created_user')
        );
        $productionResponse = $this->DAO->saveOrUpdateItem('production', $production, null, true);

        if ($productionResponse['key']) {

          foreach ($data['eggDetails'] as $i => $val) {

            $eggs_production = array(
              'quantity_kg' => $val['quantity_kg'],
              'num_pieces' => $val['num_pieces'],
              'status_eggs' => $val['status_eggs'],
              'created_date' => $currentDate,
              'updated_date' => $currentDate,
              'size_egg' => $val['size_egg'],
              'id_production' => $productionResponse['key'],
              'created_user' => $this->post('created_user')
            );
            $this->DAO->saveOrUpdateItem('egg_production', $eggs_production, null, true);
          }

          $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" =>  "item created successfully",
            "data" => null,
          );
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" =>  $productionResponse['message'],
            "data" => null,
          );
        }
        //

      }
    }
    $this->response($response, $response['status_code']);
  }
  function eggs_productions_details_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('egg_production', array('id_egg_production' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 12) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "quantity_kg_u" => "Campo requerido.",
              "num_pieces_u" => "Campo requerido.",
              "status_eggs_u" => "Campo requerido.",
              "sizeEgg_u" => "Campo requerido.",
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "quantity_kg_u" => "Campo requerido.",
              "num_pieces_u" => "Campo requerido.",
              "status_eggs_u" => "Campo requerido.",
              "sizeEgg_u" => "Campo requerido.",
            ),
            "data" => null
          );
        } else {
          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('quantity_kg_u', 'quantity_kg_u', 'required');
          $this->form_validation->set_rules('num_pieces_u', 'num_pieces_u', 'required');
          $this->form_validation->set_rules('status_eggs_u', 'status_eggs_u', 'required');
          $this->form_validation->set_rules('sizeEgg_u', 'sizeEgg_u', 'required');
          $this->form_validation->set_message('required', 'El campo {field} es requerido.');
          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            date_default_timezone_set('America/Mexico_City');
            $currentDate = date('Y-m-d H:i:s');
            $qty = $this->put('quantity_kg_u');
            $pz = $this->put('num_pieces_u');
            $status = $this->put('status_eggs_u');
            $sizeEgg = $this->put('sizeEgg_u');
            $eggs_production = array(
              'quantity_kg' => $qty,
              'num_pieces' => $pz,
              'status_eggs' => $status,
              'updated_date' => $currentDate,
              'size_egg' => $sizeEgg,
              'updated_user' => $this->put('updated_user')
            );
            $response = $this->DAO->saveOrUpdateItem('egg_production', $eggs_production, array('id_egg_production' => $id));
          }
        }
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }

  function eggs_productions_details_mobile_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('egg_production', array('id_egg_production' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 30) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "quantity_kg" => "El campo cantidad es requerido.",
              "num_pieces" => "El campo piezas es requerido.",
              "status_eggs" => "El campo estado es requerido.",
              "size_egg" => "El campo tamaño es requerido.",
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "quantity_kg" => "El campo cantidad es requerido.",
              "num_pieces" => "El campo piezas es requerido.",
              "status_eggs" => "El campo estado es requerido.",
              "size_egg" => "El campo tamaño es requerido.",
            ),
            "data" => null
          );
        } else {
          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('quantity_kg', 'cantidad', 'required');
          $this->form_validation->set_rules('num_pieces', 'piezas', 'required');
          $this->form_validation->set_rules('status_eggs', 'estado', 'required');
          $this->form_validation->set_rules('size_egg', 'tamaño', 'required');
          $this->form_validation->set_message('required', 'El campo {field} es requerido.');
          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            date_default_timezone_set('America/Mexico_City');
            $currentDate = date('Y-m-d H:i:s');
            $qty = $this->put('quantity_kg');
            $pz = $this->put('num_pieces');
            $status = $this->put('status_eggs');
            $sizeEgg = $this->put('size_egg');
            $eggs_production = array(
              'quantity_kg' => $qty,
              'num_pieces' => $pz,
              'status_eggs' => $status,
              'updated_date' => $currentDate,
              'size_egg' => $sizeEgg,
              'updated_user' => $this->put('updated_user')
            );
            $response = $this->DAO->saveOrUpdateItem('egg_production', $eggs_production, array('id_egg_production' => $id));
          }
        }
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }

  function eggs_productions_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('production', array('id_production' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 25) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "date_productions" => "El campo fecha es requerido.",
              "id_rodeo" => "El campo corral es requerido",
              "responsible" => "El campo responsable es requerido.",
              "comments" => "El campo comentarios es opcional."
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "date_productions" => "El campo fecha es requerido.",
              "id_rodeo" => "El campo corral es requerido",
              "responsible" => "El campo responsable es requerido.",
              "comments" => "El campo comentarios es opcional."
            ),
            "data" => null
          );
        } else {
          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('date_productions', 'fecha', 'required');
          $this->form_validation->set_rules('id_rodeo', 'corral', 'required');
          $this->form_validation->set_rules('responsible', 'responsable', 'required');
          $this->form_validation->set_message('required', 'El campo {field} es requerido.');
          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            date_default_timezone_set('America/Mexico_City');
            $currentDate = date('Y-m-d H:i:s');
            $productionData = array(
              "date_productions" => $this->put('date_productions'),
              "id_rodeo" => $this->put('id_rodeo'),
              "responsible" => $this->put('responsible'),
              "comments" => $this->put('comments'),
              'updated_date' => $currentDate,
              'updated_user' => $this->put('updated_user')
            );

            $response = $this->DAO->saveOrUpdateItem('production', $productionData, array('id_production' => $id));
          }
        }
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }

  function productionsForDay_get()
  {
    $day = $this->get('day');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($day) {
        $response = $this->DAO->selectEntity('vw_production', array('date_productions' => $day, 'status' => 1, 'species' => "Aves"), true);
      } else {
        $response = $this->DAO->selectEntity('vw_production', array('status' => 1));
      }
    }
    $this->response($response, $response['status_code']);
  }


  function productions_post()
  {
    $data = $this->post();
    if (count($data) == 0 || count($data) > 12) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
        "data" => count($data),
        "validations" => array(
          "species" => "required and unique",
          "date_productions" => "required and unique",
          "quantity" => "required and unique",
          "id_rodeo" => "required and unique",
          "anialsForRodeo" => "required and unique",

          "unit_measure" => "required and unique",
          "product_type" => "required and unique",
        )
      );
    } else {
      $this->form_validation->set_data($data);
      $this->form_validation->set_rules('species', 'id_category', 'required');
      $this->form_validation->set_rules('date_productions', 'date_productions', 'required');
      $this->form_validation->set_rules('product_type', 'product_type', 'required');
      $this->form_validation->set_rules('unit_measure', 'unit_measure', 'required');
      $this->form_validation->set_rules('quantity', 'quantity', 'required');
      $this->form_validation->set_rules('id_rodeo', 'id_rodeo', 'required');
      $this->form_validation->set_rules('anialsForRodeo', 'anialsForRodeo', 'required');

      if ($this->form_validation->run() == FALSE) {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "validations error",
          "data" => null,
          "validations" => $this->form_validation->error_array()
        );
      } else {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $lots = array(
          "species" => $this->post('species'),
          "date_productions" => $this->post('date_productions'),
          "quantity" => $this->post('quantity'),
          "id_rodeo" => $this->post('id_rodeo'),
          "anialsForRodeo" => $this->post('anialsForRodeo'),
          "unit_measure" => $this->post('unit_measure'),
          "created_user" => $this->post('created_user'),
          "product_type" => $this->post('product_type'),
          "comments" => $this->post('comments'),
          'created_date' => $currentDate,
          'updated_date' => $currentDate
        );
        $dataResponse = $this->DAO->saveOrUpdateItem('production', $lots, null, true);
        if ($dataResponse['status'] == "success") {
          $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" =>  "item created successfully",
            "data" => null,
          );
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" =>  $dataResponse['message'],
            "data" => null,
          );
        }
      }
    }

    //$this->response($response,200);
    $this->response($response, $response['status_code']);
  }

  function productions_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('production', array('id_production' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 12) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "species" => "required and unique",
              "date_productions" => "required and unique",
              "quantity" => "required and unique",
              "id_rodeo" => "required and unique",
              "anialsForRodeo" => "required and unique",
              "comments" => "required and unique",
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "species" => "required and unique",
              "date_productions" => "required and unique",
              "quantity" => "required and unique",
              "id_rodeo" => "required and unique",
              "anialsForRodeo" => "required and unique",
              "comments" => "required and unique",
            ),
            "data" => null
          );
        } else {
          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('species', 'species', 'required');
          $this->form_validation->set_rules('date_productions', 'date_productions', 'required');
          $this->form_validation->set_rules('quantity', 'quantity', 'required');
          $this->form_validation->set_rules('id_rodeo', 'id_rodeo', 'required');
          $this->form_validation->set_rules('anialsForRodeo', 'anialsForRodeo', 'required');
          $this->form_validation->set_rules('comments', 'comments', 'required');
          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            date_default_timezone_set('America/Mexico_City');
            $currentDate = date('Y-m-d H:i:s');
            $data = array(
              "species" => $this->put('species'),
              "date_productions" => $this->put('date_productions'),
              "quantity" => $this->put('quantity'),
              "id_rodeo" => $this->put('id_rodeo'),
              "updated_user" => $this->put('created_user'),
              "anialsForRodeo" => $this->put('anialsForRodeo'),
              "comments" => $this->put('comments'),
              'created_date' => $currentDate,
              'updated_date' => $currentDate
            );
            $response = $this->DAO->saveOrUpdateItem('production', $data, array('id_production' => $id));
          }
        }
      }
    } else {

      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
  function eggProductionDelete_put()
  {
    $id = $this->get('id');
    $productionData = $this->put();
    if ($id) {
      $dataExists = $this->DAO->selectEntity('production', array('id_production' => $id), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $productionDetails = array(
          "updated_user" => (@$productionData["updated_user"]) ? $productionData["updated_user"] : '',
          'status' => 0,
          'updated_date' => $currentDate
        );
        $this->DAO->updateData('egg_production', $productionDetails, array('id_production' => $id));
        $production = array(
          "updated_user" => (@$productionData["updated_user"]) ? $productionData["updated_user"] : '',
          'status' => 0,
          'updated_date' => $currentDate
        );
        $response = $this->DAO->updateData('production', $production, array('id_production' => $id));
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the code of production does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }

  function eggs_productions_delete()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('production', array('id_production' => $id), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $productionDetails = array(
          'status' => 0,
          'updated_date' => $currentDate
        );
        $this->DAO->updateData('egg_production', $productionDetails, array('id_production' => $id));
        $production = array(
          'status' => 0,
          'updated_date' => $currentDate
        );
        $response = $this->DAO->updateData('production', $production, array('id_production' => $id));
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the code of production does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
  
  function eggsProductionsDetailsDelete_put()
  {
    $id = $this->get('id');
    $detailsData = $this->put();
    if ($id) {
      $dataExists = $this->DAO->selectEntity('egg_production', array('id_egg_production' => $id), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $productionDetails = array(
          "updated_user" => (@$detailsData["updated_user"]) ? $detailsData["updated_user"] : '',
          'status' => 0,
          'updated_date' => $currentDate
        );
        $response = $this->DAO->updateData('egg_production', $productionDetails, array('id_egg_production' => $id));
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the code of production does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }

  function eggs_productions_details_delete()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('egg_production', array('id_egg_production' => $id), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $productionDetails = array(
          'status' => 0,
          'updated_date' => $currentDate
        );
        $response = $this->DAO->updateData('egg_production', $productionDetails, array('id_egg_production' => $id));
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the code of production does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }

  function productions_delete()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('production', array('id_production' => $id), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $births = array(
          'status' => 0,
          'updated_date' => $currentDate
        );
        $response = $this->DAO->updateData('production', $births, array('id_production' => $id));
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the code of rodeo does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
}
