<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('DAO');
  }

  function rodeos_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('rodeos', array('id_rodeos' => $id), TRUE);
      } else {
        $response = $this->DAO->selectEntity('rodeos', array('status' => 1));
      }
    }
    $this->response($response, $response['status_code']);
  }


  function rodeoBySpecie_get()
  {
    $specie = $this->get('specie');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Demasiados parametros fueron enviados",
        "validations" => array(
          "specie" => "Enviar specie (specie) para obtener corrales por especie"
        ),
        "data" => null
      );
    } else {
      if ($specie) {
        $response = $this->DAO->selectEntity('rodeos', array('type_animals' => $specie, 'status'=>1), FALSE);
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "Ningún dato fue enviado",
          "validations" => array(
            "specie" => "Enviar specie (specie) para obtener corrales por especie"
          ),
          "data" => null
        );
      }
    }
    $this->response($response, $response['status_code']);
  }
  
  function rodeosForCode_get()
  {
    $code = $this->get('code');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($code) {
        $response = $this->DAO->selectEntity('rodeos', array('code_rodeo' => $code), TRUE);
      } else {
        $response = $this->DAO->selectEntity('rodeos', array('status' => 1));
      }
    }
    $this->response($response, $response['status_code']);
  }



  function birthForRodeos_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->birthsForRodeo($id);
      } else {
        $response = $this->DAO->birthsForRodeo();
      }
    }
    $this->response($response, $response['status_code']);
  }

  function estrusForRodeos_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->estrusForRodeo($id);
      } else {
        $response = $this->DAO->estrusForRodeo();
      }
    }
    $this->response($response, $response['status_code']);
  }



  function inactive_rodeos_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific an inactive rodeo, or empty to get all inactives rodeos"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('rodeos', array('rodeos' => $id, 'status' => 0), TRUE);
      } else {
        $response = $this->DAO->selectEntity('rodeos', array('status' => 0));
      }
    }
    $this->response($response, $response['status_code']);
  }

  function Animalsrodeos_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->animalsForRodeo($id);
      } else {
        $response = $this->DAO->animalsForRodeo();
      }
    }
    $this->response($response, $response['status_code']);
  }


  function animalsRodeo_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('animals', array('id_animals' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 12) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "id_rodeos" => "required and unique",
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "id_rodeos" => "required and unique",
            ),
            "data" => null
          );
        } else {
          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('id_rodeos', 'id_rodeos', 'required');
          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            $data = array(
              "id_rodeo" => $this->put('id_rodeos'),
              "cause" => $this->put('cause'),
              "id_old" => $this->put('id_old'),
            );

            $response = $this->DAO->saveOrUpdateItem('animals', $data, array('id_animals' => $id));
          }
        }
      }
    } else {

      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }





  function rodeo_post()
  {
    $data = $this->post();
    if (count($data) == 0 || count($data) > 12) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
        "data" => count($data),
        "validations" => array(
          "name_rodeo" => "required and unique",
          "type_animals" => "required and unique",
          "description" => "required and unique",
          "code_rodeo" => "required and unique",
          // "alert_weaning" => "required and unique",
          // "move_after" => "required and unique",
          // "move_before" => "required and unique",

        )
      );
    } else {
      $this->form_validation->set_data($data);
      $this->form_validation->set_rules('name_rodeo', 'name_rodeo', 'required');
      $this->form_validation->set_rules('type_animals', 'type_animals', 'required');
      $this->form_validation->set_rules('description', 'description', 'required');
      // $this->form_validation->set_rules('alert_weaning', 'alert_weaning', 'required');
      // $this->form_validation->set_rules('move_after', 'move_after', 'required');
      // $this->form_validation->set_rules('move_before', 'move_before', 'required');


      if ($this->form_validation->run() == FALSE) {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "validations error",
          "data" => null,
          "validations" => $this->form_validation->error_array()
        );
      } else {
        $e = array(
          "name_rodeo" => $this->post('name_rodeo'),
          "type_animals" => $this->post('type_animals'),
          "description" => $this->post('description'),
          "created_user" => $this->post('created_user'),
          "code_rodeo" => strtoupper('rea' . random_string('alnum', 4)),
          // "alert_weaning" => $this->post('alert_weaning'),
          // "move_after" => $this->post('move_after'),
          // "move_before" => $this->post('move_before'),


        );
        $dataResponse = $this->DAO->saveOrUpdateItem('rodeos', $e, null, true);
        if ($dataResponse['status'] == "success") {
          $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" =>  "item created successfully",
            "data" => null,
          );
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" =>  $dataResponse['message'],
            "data" => null,
          );
        }
      }
    }

    //$this->response($response,200);
    $this->response($response, $response['status_code']);
  }

  function rodeos_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('rodeos', array('id_rodeos' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 12) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "name_rodeo" => "required and unique",
              "type_animals" => "required and unique",
              "description" => "required and unique",

              "alert_weaning" => "required and unique",
              "move_after" => "required and unique",
              "move_before" => "required and unique",
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "name_rodeo" => "required and unique",
              "type_animals" => "required and unique",
              "description" => "required and unique",

              "alert_weaning" => "required and unique",
              "move_after" => "required and unique",
              "move_before" => "required and unique",
            ),
            "data" => null
          );
        } else {

          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('name_rodeo', 'name_rodeo', 'required');
          $this->form_validation->set_rules('type_animals', 'type_animals', 'required');
          $this->form_validation->set_rules('description', 'description', 'required');
          $this->form_validation->set_rules('alert_weaning', 'alert_weaning', 'required');
          $this->form_validation->set_rules('move_after', 'move_after', 'required');
          $this->form_validation->set_rules('move_before', 'move_before', 'required');


          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            $data = array(
              "name_rodeo" => $this->put('name_rodeo'),
              "type_animals" => $this->put('type_animals'),
              "description" => $this->put('description'),
              "production_management" => $this->put('production_management'),
              "alert_weaning" => $this->put('alert_weaning'),
              "updated_user" => $this->put('created_user'),
              "move_after" => $this->put('move_after'),
              "move_before" => $this->put('move_before'),
            );

            $response = $this->DAO->saveOrUpdateItem('rodeos', $data, array('id_rodeos' => $id));
          }
        }
      }
    } else {

      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
  function activate_rodeos_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('rodeos', array('id_rodeos' => $id), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $rodeos = array(
          'status' => 1,
          'update_date' => $currentDate
        );
        $animalResponse = $this->DAO->updateData('rodeos', $rodeos, array('id_rodeos' => $id));
        if ($animalResponse['status'] == 'success') {
          $response = array(
            'status' => 'success',
            'status_code' => '200',
            'message' => "The rodeo has been activated successfully",
            'validations' => null,
            'data' => null
          );
        }
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the code of rodeo does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
  function rodeo_delete()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('rodeos', array('id_rodeos' => $id), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $births = array(
          'status' => 0,
          'update_date' => $currentDate
        );
        $response = $this->DAO->updateData('rodeos', $births, array('id_rodeos' => $id));
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the code of rodeo does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
}
