<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('DAO');
  }

  function sales_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('vw_animals', array('id_animals' => $id), TRUE);
      } else {
        $response = $this->DAO->selectEntity('vw_animals', array('is_sold' => 1));
      }
    }
    $this->response($response, $response['status_code']);
  }

 

  function sales_delete()
  {
    $earring = $this->get('earring');
    if ($earring) {
      $dataExists = $this->DAO->selectEntity('animals', array('earring' => $earring), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $births = array(
          'status' => 0,
          'is_sold' => 1,
          'update_date' => $currentDate,
          'date_sold' => $currentDate
        );
        $response = $this->DAO->updateData('animals', $births, array('earring' => $earring));
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the code of animal does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }




  function sales_post()
  {
    $data = $this->post();
    if (count($data) == 0 || count($data) > 12) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
        "data" => count($data),
        "validations" => array(
          "earring" => "required and unique",
          "date_sold" => "required and unique",
          // "comments"=>"required and unique",
        )
      );
    } else {
      $this->form_validation->set_data($data);
      $this->form_validation->set_rules('earring', 'earring', 'required');
      $this->form_validation->set_rules('date_sold', 'detected_date', 'required');
      if ($this->form_validation->run() == FALSE) {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "validations error",
          "data" => null,
          "validations" => $this->form_validation->error_array()
        );
      } else {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $earring = $this->post('earring');
        $e = array(
          "earring" => $earring,
          "date_sold" => $this->post('date_sold'),
          'status' => 0,
          'is_sold' => 1,
          'update_date' => $currentDate,
        );
        $dataResponse = $this->DAO->updateData('animals', $e, array('earring' => $earring), true);
        if ($dataResponse['status'] == "success") {
          $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" =>  "item created successfully",
            "data" => null,
          );
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" =>  $dataResponse['message'],
            "data" => null,
          );
        }
      }
    }
    $this->response($response, $response['status_code']);
  }

  function sales_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('animals', array('earring' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 12) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "earring" => "required and unique",
              "detected_date" => "required and unique",
              "comments" => "required and unique",
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "earring" => "required and unique",
              "detected_date" => "required and unique",
              "comments" => "required and unique",
            ),
            "data" => null
          );
        } else {
          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('earring', 'earring', 'required');
          $this->form_validation->set_rules('detected_date', 'detected_date', 'required');
          $this->form_validation->set_rules('comments', 'comments', 'required');
          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            $data = array(
              "earring" => $this->put('earring'),
              "detected_date" => $this->put('detected_date'),
              "comments" => $this->put('comments'),
            );

            $response = $this->DAO->saveOrUpdateItem('estrus', $data, array('id_estrus' => $id));
          }
        }
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }


  function estrus_delete()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('estrus', array('id_estrus' => $id), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $births = array(
          'status' => 0,
          'update_date' => $currentDate
        );
        $response = $this->DAO->updateData('estrus', $births, array('id_estrus' => $id));
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the code of animal does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
}
