<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
    }
    
    function treatments_get()
      {
        $page=$this->get('page');
        $limit=$this->get('limit');
          $id = $this->get('id');
          if (count($this->get()) > 3) {
              $response = array(
                  "status" => "error",
                  "status_code" => 409,
                  "message" => "Too many params was sent",
                  "validations" => array(
                      "id" => "Send Id (Get) to get specific treatment, or empty to get all treatments"
                  ),
                  "data" => null
              );
          } else {
              if ($id) {
                  $response = $this->DAO->selectEntity('treatment', array('id_treatment' => $id), TRUE);
              } else {
                  $response = $this->DAO->ordertreatment($page, $limit);
              }
          }
          $this->response($response, $response['status_code']);
      }


    function animalstreatments_get()
    {
        $id = $this->get('id');
        $idAnimal = $this->get('idAnimal');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too many params was sent",
                "validations" => array(
                    "id" => "Send Id (Get) to get specific treatment, or empty to get all treatments"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('animal_treatment', array('id_treatment' => $id, 'status' =>1), false);
            }
            else if ($idAnimal) {
                $response = $this->DAO->selectEntity('animal_treatment', array('animal_treatment_id' => $idAnimal), true);
            } else {
                $response = $this->DAO->selectEntity('animal_treatment');
            }
        }
        $this->response($response, $response['status_code']);
    }


    function treatmentsobinos_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too many params was sent",
                "validations" => array(
                    "id" => "Send Id (Get) to get specific treatment, or empty to get all treatments"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('treatment', array('id_treatment' => $id), TRUE);
            } else {
                $response = $this->DAO->selectEntity('vw_treatment', array('status' => '1', 'register_type' => '2'));
            }
        }
        $this->response($response, $response['status_code']);
    }

    function monitoringTreatments_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too many params was sent",
                "validations" => array(
                    "id" => "Send Id (Get) to get specific treatment, or empty to get all treatments"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('monitoring_treatment', array('id_treatment' => $id), false);
            } else {
                $response = $this->DAO->selectEntity('monitoring_treatment', array('status' => '1'));
            }
        }
        $this->response($response, $response['status_code']);
    }
    function treatmentsForAnimal_get()
    {
        $id =  $this->get('id');
        $desde = $this->get('desde');
        $hasta = $this->get('hasta');

        if (count($this->get()) > 4) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too many params was sent",
                "validations" => array(
                    "specie" => "Send Id (Get) to get specific tratments, or empty to get all inseminations"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->treatmentsForAnimal($id, $desde, $hasta);
            } else {
                $response = $this->DAO->treatmentsForAnimal();
            }
        }
        $this->response($response, $response['status_code']);
    }

    function treatmentsForearring_get()
    {
        $earring =  $this->get('earring');
        $desde = $this->get('desde');
        $hasta = $this->get('hasta');

        if (count($this->get()) > 4) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too many params was sent",
                "validations" => array(
                    "specie" => "Send Id (Get) to get specific tratments, or empty to get all inseminations"
                ),
                "data" => null
            );
        } else {
            if ($earring) {
                $response = $this->DAO->treatmentsForearring($earring, $desde, $hasta);
            } else {
                $response = $this->DAO->treatmentsForearring();
            }
        }
        $this->response($response, $response['status_code']);
    }


    function monitoringTreatments_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 12) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
                "data" => count($data),
                "validations" => array(
                    "id_tratamient" => "Required field",
                    "treatment" => "Required field",
                    "date_monitoring" => "Required field",
                    "comment" => "Required field",
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('id_tratamient', 'id_tratamient', 'required');
            $this->form_validation->set_rules('treatment', 'treatment', 'required');
            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "validations error",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');

                $treatment = array(
                    'id_treatment' => $data['id_tratamient'],
                    'treatment' => $data['treatment'],
                    "date_monitoring" => $data['date_monitoring'],
                    'comment' => $data['comment'],
                    'created_date' => $currentDate,
                    'updated_date' => $currentDate
                );

                $dataResponse = $this->DAO->saveOrUpdateItem('monitoring_treatment', $treatment, null, true);
                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" =>  "Item created successfully",
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        }
        $this->response($response, $response['status_code']);
    }


    function treatmentscaninos_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 12) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
                "data" => count($data),
                "validations" => array(
                    "start_date" => "Required field",
                    "treatment" => "Required field",
                    "responsible" => "Required field",
                    "comment" => "Optional field"
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('start_date', 'start_date', 'required');
            $this->form_validation->set_rules('treatment', 'treatment', 'required');
            $this->form_validation->set_rules('responsible', 'responsible', 'required');
            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "validations error",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $file = time();
                $config['upload_path'] = 'uploads';
                $config['allowed_types'] = '*';
                $config['max_size'] = '0';
                $config['overwrite'] = TRUE;
                $config['file_name'] = $file;

                $this->load->library('upload', $config);
                if ($this->upload->do_upload("doc_treatment")) {
                    $doc_data = array('upload_data' => $this->upload->data());
                    $doc_treatment = $doc_data['upload_data']['file_name'];
                } else {
                    $doc_treatment = '1';
                }

                if ($data['duration']==1) {
                   $status_ = 1;
                }else{
                    $status_ = 0;
                }
                $treatment = array(
                    // 'earring' => $data['earring'],
                    'animal_id' => $data['id_animal'],
                    'start_date' => $data['start_date'],
                    'end_date' => $data['end_date'],
                    'register_type' => 2,
                    'treatment' => $data['treatment'],
                    'duration' => $data['duration'],
                    "created_user" => $data['created_user'],
                    'doc_treatment' =>  $doc_treatment,
                    'status_treatment' =>  $status_,


                    'responsible' => $data['responsible'],
                    'comments' => $data['comment'],
                    'created_date' => $currentDate,
                    'updated_date' => $currentDate
                );

                $dataResponse = $this->DAO->saveOrUpdateItem('treatment', $treatment, null, true);
                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" =>  "Item created successfully",
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        }
        $this->response($response, $response['status_code']);
    }


    function treatments_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 12) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
                "data" => count($data),
                "validations" => array(
                    "start_date" => "Required field",
                    "treatment" => "Required field",
                    "responsible" => "Required field",
                    "comment" => "Optional field"
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('start_date', 'start_date', 'required');
            $this->form_validation->set_rules('treatment', 'treatment', 'required');
            $this->form_validation->set_rules('responsible', 'responsible', 'required');

            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "validations error",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $file = time();
                $config['upload_path'] = 'uploads';
                $config['allowed_types'] = '*';
                $config['max_size'] = '0';
                $config['overwrite'] = TRUE;
                $config['file_name'] = $file;
                $this->load->library('upload', $config);
                if ($this->upload->do_upload("doc_treatment")) {
                    $doc_data = array('upload_data' => $this->upload->data());
                    $doc_treatment = $doc_data['upload_data']['file_name'];
                } else {
                    $doc_treatment = '1';
                }
                if ($data['duration']==1) {
                    $status_ = 1;
                }else{
                    $status_ = 0;
                }
                
                  $pecie_ = $data['specie'];
                  
                $treatment = array(
                    'start_date' => $data['start_date'],
                    'end_date' => $data['end_date'],
                    'treatment' => $data['treatment'],
                    'duration' => $data['duration'],
                    'status_treatment' => $status_,
                    'doc_treatment' => $doc_treatment,
                    'responsible' => $data['responsible'],
                    'comments' => $data['comment'],
                    'created_date' => $currentDate,
                    'updated_date' => $currentDate
                );

                $treatmentResponse = $this->DAO->saveOrUpdateItem('treatment', $treatment, null, true);
                if ($treatmentResponse['key']) {
                    $id_treatment_ = $treatmentResponse['key'];
                    foreach ($data['earring'] as $i => $val) {
                        
                         $earringFormat = $pecie_ . $data['earring'][$i];
                        $dataTreat = array(
                            'id_treatment' => $id_treatment_,
                           'earring' => $earringFormat,
                            "comment" => $data['commentAnimal'][$i],
                            'created_date' => $currentDate,
                            'updated_date' => $currentDate
                        );
                        $pvResponse = $this->DAO->saveOrUpdateItem('animal_treatment', $dataTreat, null, true);
                    }
                    if ($pvResponse['status'] == 'success') {
                        $response = array(
                            "status" => "success",
                            "status_code" => 200,
                            "message" =>  "Tratamiento creado exitosamente",
                            "data" => $data,
                        );
                    }
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $treatmentResponse['message'],
                        "data" => null,
                    );
                }
            }
        }
        $this->response($response, $response['status_code']);
    }


    // function treatment_excel_post()
    // {
    //     $data = $this->post();
    //     $dataTreatment = [];
    //     foreach ($data as $row) {
    //         date_default_timezone_set('America/Mexico_City');
    //         $currentDate = date('Y-m-d H:i:s');
    //         $dataTreatment[] = array(
    //             "start_date" => ($row['start_date']) ? $row['start_date'] : '',
    //             "earring" => ($row['earring']) ? $row['earring'] : '',
    //             "duration" => ($row['duration']) ? $row['duration'] : '',
    //             "comments" => ($row['comments']) ? $row['comments'] : '',
    //             "status_treatment" => ($row['status_treatment']) ? $row['status_treatment'] : '',
    //             "responsible" => ($row['responsible']) ? $row['responsible'] : '',
    //             "treatment" => ($row['treatment']) ? $row['treatment'] : '',
    //             "created_user" => ($row['created_user']) ? $row['created_user'] : '',
    //             "created_date" => $currentDate,
    //             "updated_date" => $currentDate
    //         );
    //     }
    //     $dataResponse = $this->DAO->saveOrUpdateBatchItems('treatment', $dataTreatment);
    //     if ($dataResponse['status'] == "success") {
    //         $response = array(
    //             "status" => "success",
    //             "status_code" => 200,
    //             "message" =>  "Registro creado correctamente",
    //             "data" => null,
    //         );
    //     } else {
    //         $response = array(
    //             "status" => "error",
    //             "status_code" => 409,
    //             "message" =>  $dataResponse['message'],
    //             "data" => null,
    //         );
    //     }
    //     $this->response($response, $response['status_code']);
    // }

    function treatment_excel_post()
    {
        $data = $this->post();
        $dataAnimalsTreatment = [];
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $treatmentGeneraldata = array(
            "start_date" => $data['treatment_generaldata']['start_date'],
            "end_date" => $data['treatment_generaldata']['end_date'],
            "treatment" => $data['treatment_generaldata']['treatment'],
            "duration" => $data['treatment_generaldata']['duration'],
            "responsible" => $data['treatment_generaldata']['responsible'],
            "status_treatment" => $data['treatment_generaldata']['status_treatment'],
            "created_user" => $data['treatment_generaldata']['created_user'],
            "created_date" => $currentDate,
            "updated_date" => $currentDate
        );
        $treatmentResponse = $this->DAO->saveOrUpdateItem('treatment', $treatmentGeneraldata, null, true);
        if ($treatmentResponse['key']) {
            $id_treatment = $treatmentResponse['key'];
            foreach ($data['animalTreatment'] as $row) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $dataAnimalsTreatment[] = array(
                    'id_treatment' => $id_treatment,
                    "earring" => ($row['earring']) ? $row['earring'] : '',
                    "comment" => ($row['comment']) ? $row['comment'] : '',
                    "created_date" => $currentDate,
                    "updated_date" => $currentDate
                );
            }
            $response = $this->DAO->saveOrUpdateBatchItems('animal_treatment', $dataAnimalsTreatment);
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" =>  $treatmentResponse['message'],
                "data" => null,
            );
        }
        $this->response($treatmentResponse, $treatmentResponse['status_code']);
    }



    function animaltreatments_put()
    {
        $id = $this->get('id');
        $data = $this->put();
        if ($id) {
            $dataExists = $this->DAO->selectEntity('animal_treatment', array('animal_treatment_id' => $id), TRUE);
            if ($dataExists['data']) {
                if (count($data) == 0 || count($data) > 12) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
                        "data" => count($data),
                        "validations" => array(
                            "earring" => "Required field",
                            "comment" => "Required field",
                        )
                    );
                } else {
                    $this->form_validation->set_data($data);
                    $this->form_validation->set_rules('earring', 'earring', 'required');
                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validation fail, see validations object for more details",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        $treatment = array(
                            'earring' => $data['earring'],
                            'comment' => $data['comment'],
                            'updated_date' => $currentDate
                        );
                        $response = $this->DAO->saveOrUpdateItem('animal_treatment', $treatment, array('animal_treatment_id' => $id));
                    }
                }
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too data was sent",
                "validations" => array(
                    "id" => "Required",

                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }


    function treatments_put()
    {
        $id = $this->get('id');
        $data = $this->put();
        if ($id) {
            $dataExists = $this->DAO->selectEntity('treatment', array('id_treatment' => $id), TRUE);
            if ($dataExists['data']) {
                if (count($data) == 0 || count($data) > 12) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
                        "data" => count($data),
                        "validations" => array(
                            "start_date" => "Required field",
                            "treatment" => "Required field",
                            "responsible" => "Required field",
                            "comment" => "Optional field"
                        )
                    );
                } else {
                    $this->form_validation->set_data($data);
                    $this->form_validation->set_rules('start_date', 'start_date', 'required');
                    $this->form_validation->set_rules('treatment', 'treatment', 'required');
                    $this->form_validation->set_rules('responsible', 'responsible', 'required');

                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validation fail, see validations object for more details",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        if ($data['duration']==1) {
                           $status_ = 1;
                        }else{
                            $status_ = 0;
                        }
                        $treatment = array(
                            'start_date' => $data['start_date'],
                            'end_date' => $data['end_date'],
                            'register_type' => 1,
                            "updated_user" => $this->put('created_user'),
                            'treatment' => $data['treatment'],
                            'duration' => $data['duration'],
                            'status_treatment'=>$status_ ,
                            'responsible' => $data['responsible'],
                            'comments' => $data['comment'],
                            'updated_date' => $currentDate
                        );
                        $response = $this->DAO->saveOrUpdateItem('treatment', $treatment, array('id_treatment' => $id));
                    }
                }
            }
        } else {

            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too data was sent",
                "validations" => array(
                    "id" => "Required",

                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }



    function treatmentsCaninos_put()
    {
        $id = $this->get('id');
        $data = $this->put();
        if ($id) {
            $dataExists = $this->DAO->selectEntity('treatment', array('id_treatment' => $id), TRUE);
            if ($dataExists['data']) {
                if (count($data) == 0 || count($data) > 12) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
                        "data" => count($data),
                        "validations" => array(
                            "start_date" => "Required field",
                            "treatment" => "Required field",
                            "responsible" => "Required field",
                            "comment" => "Optional field"
                        )
                    );
                } else {
                    $this->form_validation->set_data($data);
                    $this->form_validation->set_rules('start_date', 'start_date', 'required');
                    $this->form_validation->set_rules('treatment', 'treatment', 'required');
                    $this->form_validation->set_rules('responsible', 'responsible', 'required');

                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validation fail, see validations object for more details",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        if ($data['duration'] == 1) {
                            $status_ = 1;
                        } else {
                            $status_ = 0;
                        }
                        $treatment = array(
                            'start_date' => $data['start_date'],
                            'end_date' => $data['end_date'],
                            
                            "updated_user" => $this->put('created_user'),
                            'treatment' => $data['treatment'],
                            'duration' => $data['duration'],
                            'status_treatment' => $status_,
                            'responsible' => $data['responsible'],
                            'comments' => $data['comment'],
                            'updated_date' => $currentDate
                        );
                        $response = $this->DAO->saveOrUpdateItem('treatment', $treatment, array('id_treatment' => $id));
                    }
                }
            }
        } else {

            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too data was sent",
                "validations" => array(
                    "id" => "Required",

                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }



    function treatments_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('treatment', array('id_treatment' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $treatment = array(
                    'status' => 0,
                    'updated_date' => $currentDate
                );
                $response = $this->DAO->updateData('treatment', $treatment, array('id_treatment' => $id));
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "the code of the treatment does not exists",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id wasn't sent",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    function Animaltreatments_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('animal_treatment', array('animal_treatment_id' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $treatment = array(
                    'status' => 0,
                    'updated_date' => $currentDate
                );
                $response = $this->DAO->updateData('animal_treatment', $treatment, array('animal_treatment_id' => $id));
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "the code of the treatment does not exists",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id wasn't sent",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

  

    function treatmentStatus_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('treatment', array('id_treatment' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $treatment = array(
                    'status_treatment' => 1,
                    'updated_date' => $currentDate,
                    'end_date' => $currentDate
                );
                $response = $this->DAO->updateData('treatment', $treatment, array('id_treatment' => $id));
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "the code of the treatment does not exists",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id wasn't sent",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    function treatmentFinado_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('treatment', array('id_treatment' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $treatment = array(
                    'status_treatment' => 3,
                    'updated_date' => $currentDate,
                    'end_date' => $currentDate
                );
                $response = $this->DAO->updateData('treatment', $treatment, array('id_treatment' => $id));
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "the code of the treatment does not exists",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id wasn't sent",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }


    function animal_exists($str)
    {
        if (strlen($str) >= 1  && strlen($str) <= 45) {
            $animalExists = $this->DAO->selectEntity('animals', array('id_animals' => $str), TRUE);
            if ($animalExists['data']) {
                return TRUE;
            } else {
                $this->form_validation->set_message('animal_exists', 'The field {field} does not exists');
                return FALSE;
            }
        }
    }
}
