<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
    }

    function weight_gain_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too many params was sent",
                "validations" => array(
                    "id" => "Send Id (Get) to get specific daily weight gain, or empty to get all daily weight gains"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('daily_weight_gain', array('weightGain_id' => $id), TRUE);
            } else {
                $response = $this->DAO->selectEntity('daily_weight_gain', array('status' => '1'));
            }
        }
        $this->response($response, $response['status_code']);
    }
    function weight_gain_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 12) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
                "data" => count($data),
                "validations" => array(
                    "date_weighing" => "Required field",
                    "weight" => "Required field",
                   
                )
            );
        } else {
            $this->form_validation->set_data($data);
            $this->form_validation->set_rules('date_weighing', 'date_weighing', 'required');
            $this->form_validation->set_rules('weight', 'weight', 'required');
            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "validations error",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $weightGain = array(
                    'earring' => $data['earring'],
                    'date' => $data['date_weighing'],
                    'weight' => $data['weight'],
                    'observation' => $data['comments'],
                    'age' => $data['age'],
                    "created_user" => $data['created_user'],
                    'created_date' => $currentDate,
                    'updated_date' => $currentDate
                );

                $dataResponse = $this->DAO->saveOrUpdateItem('daily_weight_gain', $weightGain, null, true);
                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" =>  "Item created successfully",
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        }
        $this->response($response, $response['status_code']);
    }


    function weight_gain_put()
    {
        $id = $this->get('id');
        $data = $this->put();
        if ($id) {
            $dataExists = $this->DAO->selectEntity('daily_weight_gain', array('weightGain_id' => $id), TRUE);
            if ($dataExists['data']) {
                if (count($data) == 0 || count($data) > 12) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
                        "data" => count($data),
                        "validations" => array(
                            
                            "weight" => "Required field",
                            "observation" => "Optional field"
                        )
                    );
                } else {

                    $this->form_validation->set_data($data);
                   
                   
                    $this->form_validation->set_rules('weight', 'weight', 'required');

                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validation fail, see validations object for more details",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        

                        $weightGain = array(
                            'earring' =>  $data['earring'],
                            'date' => $data['date_weighing'],
                            'weight' => $data['weight'],
                            'observation' => $data['comments'],
                            'age' => $data['age'],
                            "updated_user" => $data['created_user'],
                            'updated_date' => $currentDate
                        );
                        $response = $this->DAO->saveOrUpdateItem('daily_weight_gain', $weightGain, array('weightGain_id' => $id));
                    }
                }
            }
        } else {

            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too data was sent",
                "validations" => array(
                    "id" => "Required",

                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
    function weight_gain_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('daily_weight_gain', array('weightGain_id' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $treatment = array(
                    'status' => 0,
                    'updated_date' => $currentDate
                );
                $response = $this->DAO->updateData('daily_weight_gain', $treatment, array('weightGain_id' => $id));
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "the code of the weight does not exists",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id wasn't sent",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
    function animal_exists($str)
    {
        if (strlen($str) >= 1  && strlen($str) <= 45) {
            $animalExists = $this->DAO->selectEntity('animals', array('id_animals' => $str), TRUE);
            if ($animalExists['data']) {
                return TRUE;
            } else {
                $this->form_validation->set_message('animal_exists', 'The field {field} does not exists');
                return FALSE;
            }
        }
    }
}
