<?php

defined('BASEPATH') or exit('No direct script access allowed');

class DAO extends CI_Model
{
    function __construct()
    {
        parent::__construct();
    }
    function insertData($entityName, $data)
    {
        $this->db->insert($entityName, $data);

        $resposeDB = array(
            "status" => "success",
            "status_code" => 200,
            "validations" => null,
            "message" => "registro correcto"
        );
        return $resposeDB;
    }
    function selectEntity($entityName, $whereClause = NULL, $isUnique = FALSE, $orderBy = NULL)
    {
        if ($whereClause) {
            $this->db->where($whereClause);
        }
        if ($orderBy) {
            $this->db->order_by($orderBy);
        }
        $query = $this->db->get($entityName);
        if ($this->db->error()['message'] != "") {
            $reponseDB = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Db error: " . $this->db->error()['message'],
                "validations" => null,
                "data" => null
            );
        } else {

            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $isUnique ? $query->row() : $query->result()
            );
        }
        return $reponseDB;
    }


    function ordertreatment($page = NULL, $limit=NULL)
{
      if ($page != NULL && $limit != NULL) {
          $page_num=max(0, ($page-1)*$limit);
          $query = $this->db->query("SELECT *  FROM `treatment` WHERE status=1 ORDER BY id_treatment DESC LIMIT {$page_num}, {$limit}");
      }else{
          $query = $this->db->query("SELECT *  FROM `treatment` WHERE status=1 ORDER BY id_treatment DESC");
      }
      $reponseDB = array(
            "status" => "success",
            "status_code" => 200,
            "message" => "Data loaded, successful",
            "validations" => null,
            "data" => $query->result()
        );

    return $reponseDB;
}
    
    function selectEntity1($entity, $whereClause = NULL)
    {
        if ($whereClause) {
            $this->db->where($whereClause);
        }
        $query = $this->db->get($entity);


        return $whereClause ? $query->row() : $query->result();
    }
    function updateData($entityName, $data, $whereClause)
    {
        $this->db->where($whereClause);
        $this->db->update($entityName, $data);
        if ($this->db->error()['message'] != "") {
            $reponseDB = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Db error: " . $this->db->error()['message'],
                "validations" => null,
                "data" => null
            );
        } else {
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data updated successful",
                "validations" => null,
                "data" => null
            );
        }
        return $reponseDB;
    }
    function saveOrUpdateItem($entityName, $data, $whereClause = NULL, $generateKey =  FALSE)
    {

        if ($whereClause) {
            $this->db->where($whereClause);
            $this->db->update($entityName, $data);
        } else {
            $this->db->insert($entityName, $data);
        }
        if ($this->db->error()['message'] != '') {
            $responseDB = array(
                "status" => "error",
                "status_code" => 409,
                "message" => $this->db->error()['message']
            );
        } else {
            $responseDB = array(
                "status" => "success",
                "status_code" => $whereClause ? 200 : 201,
                "message" => "Item created Successfully",
                "data" => $data,
                "key" => $generateKey ? $this->db->insert_id() : null
            );
        }
        return $responseDB;
    }



    function saveBatchItems($entityName, $data)
    {

        $this->db->insert_batch($entityName, $data);

        if ($this->db->error()['message'] != '') {
            $responseDB = array(
                "status" => "error",
                "status_code" => 409,
                "message" => $this->db->error()['message']
            );
        } else {
            $responseDB = array(
                "status" => "success",
                "status_code" => 201,
                "message" => "Item created Successfully"
            );
        }
        return $responseDB;
    }

    function saveOrUpdateBatchIdTitles($entityName, $data, $whereClause = null)
    {

        if ($whereClause) {

            $this->db->where($whereClause);
            $this->db->update($entityName, $data);
        } else {

            $this->db->insert_batch($entityName, $data);
        }

        if ($this->db->error()['message'] != '') {
            $responseDB = array(
                "status" => "error",
                "status_code" => 409,
                "message" => $this->db->error()['message']
            );
        } else {
            $responseDB = array(
                "status" => "success",
                "status_code" => 201,
                "message" => "titles created successfully"
            );
        }
        return $responseDB;
    }

   function saveOrUpdateBatchItems($entityName, $data, $whereClause = NULL)
    {
        if ($whereClause) {
            $this->db->update_batch($entityName, $data, $whereClause);
        } else {
            $this->db->insert_batch($entityName, $data);
        }
        if ($this->db->error()['message'] != '') {
            $responseDB = array(
                "status" => "error",
                "status_code" => 409,
                "message" => $this->db->error()['message']
            );
        } else {
            $responseDB = array(
                "status" => "success",
                "status_code" => 201,
                "message" => "Item created Successfully"
            );
        }
        return $responseDB;
    }
    function deleteData($entityName, $whereClause)
    {
        $this->db->where($whereClause);
        $this->db->delete($entityName);
        if ($this->db->error()['message'] != "") {
            switch ($this->db->error()['code']) {
                case '1062':
                    $reponseDB = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Duplicate entry error",
                        "validations" => null,
                        "data" => null
                    );
                    break;
                case '1451':
                    $reponseDB = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Foreign key error",
                        "validations" => null,
                        "data" => null
                    );
                    break;

                default:
                    $reponseDB = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Db error: " . $this->db->error()['message'],
                        "validations" => null,
                        "data" => null
                    );
                    break;
            }
        } else {
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data deleted successful",
                "validations" => null,
                "data" => null
            );
        }
        return $reponseDB;
    }


    function client_log_in($email, $password)
    {
        $this->db->where('email_cliente', $email);
        //$this->db->where('status',1);
        $result = $this->getClientUser($password);
        if (!empty($result)) {
            return $result;
        } else {
            return null;
        }
    }
    //$this->load->library('bcrypt');
    function getClientUser($password)
    {
        $query = $this->db->get('clientes');
        if ($query->num_rows() > 0) {
            $result = $query->row_array();
            $this->load->library('bcrypt');
            if ($this->bcrypt->check_password($password, $result['password_cliente'])) {
                return $result;
            } else {
                //contraseña no coincide
                return array();
            }
        } else {
            return array();
        }
    }

    function user_log_in($email, $password)
    {
        $this->db->where('email', $email);
        //$this->db->where('status',1);
        $result = $this->getUser($password);
        if (!empty($result)) {
            return $result;
        } else {
            return null;
        }
    }
    //$this->load->library('bcrypt');


    function getUser($password)
    {
        $query = $this->db->get('usuario');
        if ($query->num_rows() > 0) {
            $result = $query->row_array();
            $this->load->library('bcrypt');
            if ($this->bcrypt->check_password($password, $result['password'])) {
                return $result;
            } else {
                //contraseña no coincide
                return array();
            }
        } else {
            return array();
        }
    }
    
    
     function last_diet($id_rod)
    {
        $query = $this->db->query("SELECT * FROM diet_history WHERE id_rodeo = $id_rod and (status=1) ORDER by id_dietHistory DESC LIMIT 1  ");
        $reponseDB = array(
            "status" => "success",
            "status_code" => 200,
            "message" => "Data loaded, successful",
            "validations" => null,
            "data" => $query->row()
        );
        return $reponseDB;
    }



    function animalsForRodeo($id = NULL)
    {
        if ($id) {

            $query = $this->db->query("SELECT COUNT(id_rodeo) AS animalsRodeo FROM `animals` WHERE id_rodeo=$id");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        } else {
            $query = $this->db->query("SELECT COUNT(id_rodeo) AS animalsRodeo FROM `animals`");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }
    
    
    
    function abortForReport($desde, $hasta)
    {
        if ($desde) {

            $query = $this->db->query("SELECT * FROM `vw_abortionComplete` WHERE (date_abortion BETWEEN '$desde' 
            AND '$hasta') AND (status =1) ORDER BY date_abortion ASC");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->result()
            );
        } else {
            $query = $this->db->query("SELECT * FROM `vw_abortionComplete` WHERE (date_abortion BETWEEN '$desde' AND '$hasta') AND (status =1) ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }
    


    function animalsCount($id = NULL)
    {
        if ($id) {

            $query = $this->db->query("SELECT COUNT(id_animals) AS animals FROM `animals` WHERE status=1");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        } else {
            $query = $this->db->query("SELECT COUNT(id_animals) AS animals FROM `animals` WHERE status=1");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }

    
    function mortalityDayCount($day = NULL)
    {
        if ($day) {

            $query = $this->db->query("SELECT COUNT(id_mortality) AS muertes FROM `mortality` WHERE status=1 and date_mortality= '$day'");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        } else {
            $query = $this->db->query("SELECT COUNT(id_mortality) AS muertes FROM `mortality` WHERE status=1");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }


    function ovinosCount($id = NULL)
    {
        if ($id) {

            $query = $this->db->query("SELECT COUNT(id_animals) AS ovinos FROM `animals` WHERE (status=1) and specie='Ovino'");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        } else {
            $query = $this->db->query("SELECT COUNT(id_animals) AS ovinos FROM `animals` WHERE (status=1) and specie='Ovino'");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }

    
    function mortalityCount($id = NULL)
    {
        if ($id) {

            $query = $this->db->query("SELECT COUNT(id_mortality) AS mortality FROM `vw_mortality` WHERE YEARWEEK(date_mortality) = YEARWEEK(CURDATE()) and (status=1)");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        } else {
            $query = $this->db->query("SELECT COUNT(id_mortality) AS mortality FROM `vw_mortality` WHERE YEARWEEK(date_mortality) = YEARWEEK(CURDATE()) and (status=1)");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }

    function mortalityLastWeekCount($id = NULL)
    {
        if ($id) {

            $query = $this->db->query("SELECT COUNT(id_mortality) AS mortalityLastWeek FROM `vw_mortality` WHERE YEARWEEK(date_mortality) = YEARWEEK(NOW() - INTERVAL 1 WEEK) and (status=1)");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        } else {
            $query = $this->db->query("SELECT COUNT(id_mortality) AS mortalityLastWeek FROM `vw_mortality` WHERE YEARWEEK(date_mortality) = YEARWEEK(NOW() - INTERVAL 1 WEEK) and (status=1)");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }


    
    function criasCount($id = NULL)
    {
        if ($id) {

            $query = $this->db->query("SELECT sum(females) AS females, sum(males) AS males FROM `births` WHERE MONTH(date_birth) = MONTH(CURDATE()) and (status=1)");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        } else {
            $query = $this->db->query("SELECT sum(females) AS females, sum(males) AS males FROM `births` WHERE MONTH(date_birth) = MONTH(CURDATE()) and (status=1)");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }

    function productionsForDay($day = NULL)
    {
        if ($day) {

            $query = $this->db->query("SELECT * FROM `vw_mortality` WHERE date_productions = $day");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        } else {
            $query = $this->db->query("SELECT COUNT(id_mortality) AS mortality FROM `vw_mortality` WHERE YEARWEEK(date_mortality) = YEARWEEK(CURDATE()) and (status=1)");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }


    function birthsCount($id = NULL)
    {
        if ($id) {

            $query = $this->db->query("SELECT COUNT(id_births) AS births FROM `births` WHERE YEARWEEK(date_birth) = YEARWEEK(CURDATE()) and (status=1)");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        } else {
            $query = $this->db->query("SELECT COUNT(id_births) AS births FROM `births` WHERE YEARWEEK(date_birth) = YEARWEEK(CURDATE()) and (status=1)");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }
    
    

    function weaningCount($id = NULL)
    {
        if ($id) {

            $query = $this->db->query("SELECT COUNT(id_weaning) AS weaningCount FROM `vw_weaning` WHERE YEARWEEK(date) = YEARWEEK(CURDATE()) and (status=1) and (id_rodeo =$id)");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        } else {
            $query = $this->db->query("SELECT COUNT(id_weaning) AS weaningCount FROM `vw_weaning` WHERE YEARWEEK(date) = YEARWEEK(CURDATE()) and (status=1)");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }



    function birthsCountLastWeek($id = NULL)
    {
        if ($id) {

            $query = $this->db->query("SELECT COUNT(id_births) AS birthsLastWeek FROM `births` WHERE YEARWEEK(date_birth) = YEARWEEK(NOW() - INTERVAL 1 WEEK) and (status=1)");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        } else {
            $query = $this->db->query("SELECT COUNT(id_births) AS birthsLastWeek FROM `births` WHERE YEARWEEK(date_birth) = YEARWEEK(NOW() - INTERVAL 1 WEEK) and (status=1)");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }
    function ornamentalForReport($desde, $hasta)
    {
        if ($desde) {

            $query = $this->db->query("SELECT * FROM `ornamental_birds` WHERE (date_birth BETWEEN '$desde' AND '$hasta') AND (status =1) ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->result()
            );
        } else {
            $query = $this->db->query("SELECT * FROM `ornamental_birds` WHERE (date_birth BETWEEN '$desde' AND '$hasta') AND (status =1) ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }

    

    function ornamentalEggForReport($desde, $hasta)
    {
        if ($desde) {

            $query = $this->db->query("SELECT * FROM `ornamental_egg` WHERE (collection_date BETWEEN '$desde' AND '$hasta') AND (status =1) ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->result()
            );
        } else {
            $query = $this->db->query("SELECT * FROM `ornamental_egg` WHERE (collection_date BETWEEN '$desde' AND '$hasta') AND (status =1) ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }
    

    function animalForearring($earring = NULL)
    {
        if ($earring) {

            $query = $this->db->query("SELECT * FROM daily_weight_gain WHERE earring = '$earring' and (status=1) ORDER by weightGain_id DESC LIMIT 1  ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        } else {
            $query = $this->db->query("SELECT * FROM daily_weight_gain WHERE earring = '$earring' and (status=1) ORDER by weightGain_id DESC LIMIT 1  ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }


    function avesCount($id = NULL)
    {
        if ($id) {

            $query = $this->db->query("SELECT COUNT(id_animals) AS aves FROM `animals` WHERE (status=1) and specie='Aves'");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        } else {
            $query = $this->db->query("SELECT COUNT(id_animals) AS aves FROM `animals` WHERE (status=1) and specie='Aves'");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }

    
    function treatmentsForAnimal($id,$desde,$hasta)
    {
        if ($id) {

            $query = $this->db->query("SELECT * FROM `treatment` WHERE (start_date BETWEEN '$desde' AND '$hasta') and (status=1) and earring='$id'");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->result()
            );
        } else {
            $query = $this->db->query("SELECT * FROM `treatment` WHERE (start_date BETWEEN '$desde' AND '$hasta') and (status=1) and earring='$id'");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }


    function birthsForRodeo($id = NULL)
    {
        if ($id) {

            $query = $this->db->query("SELECT COUNT(id_rodeos) AS birtsForRodeo FROM `vw_births` WHERE id_rodeos=$id");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        } else {
            $query = $this->db->query("SELECT COUNT(id_rodeos) AS birtsForRodeo FROM `vw_births`");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }

    function estrusForRodeo($id = NULL)
    {
        if ($id) {

            $query = $this->db->query("SELECT COUNT(id_rodeos) AS estrusForRodeo FROM `vw_estrus` WHERE id_rodeos=$id");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        } else {
            $query = $this->db->query("SELECT COUNT(id_rodeos) AS estrusForRodeo FROM `vw_estrus`");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }

    function mortalityReport($specie,$desde,$hasta)
    {
        if ($specie) {

            $query = $this->db->query("SELECT * FROM `vw_mortality` WHERE ( date_mortality BETWEEN '$desde' AND
             '$hasta') AND (status =1) and (specie = '$specie') ORDER BY date_mortality ASC");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->result()
            );
        } else {
            $query = $this->db->query("SELECT * FROM `vw_mortality` WHERE ( date_mortality BETWEEN '$desde' 
            AND '$hasta') AND (status =1) ORDER BY date_mortality ASC ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }


    function inseminationsForReport($desde, $hasta)
    {
        if ($desde) {

            $query = $this->db->query("SELECT * FROM `insemination` WHERE ( date_insemination BETWEEN '$desde' AND '$hasta') AND (status =1)");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->result()
            );
        } else {
            $query = $this->db->query("SELECT * FROM `insemination` WHERE ( date_insemination BETWEEN '$desde' AND '$hasta') AND (status =1) ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }

    


    function CycleReport($desde, $hasta)
    {
        if ($desde) {

            $query = $this->db->query("SELECT * FROM `vw_mortality` WHERE ( date_mortality BETWEEN '$desde' AND '$hasta') AND (status =1) and (specie = '$specie') ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->result()
            );
        } else {
            $query = $this->db->query("SELECT * FROM `vw_mortality` WHERE ( date_mortality BETWEEN '$desde' AND '$hasta') AND (status =1) ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }

    
    function animForReport($specie)
    {
        if ($specie) {
            $query = $this->db->query("SELECT * FROM `vw_animals` WHERE  (status =1) and (specie = '$specie') ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->result()
            );
        } else {
            $query = $this->db->query("SELECT * FROM `vw_animals` WHERE  (status =1) ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }
    

    function weaningsForReport($desde,$hasta)
    {
        if ($desde) {

            $query = $this->db->query("SELECT * FROM `weaning` WHERE (date BETWEEN '$desde' AND '$hasta') AND (status =1) ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->result()
            );
        } else {
            $query = $this->db->query("SELECT * FROM `weaning` WHERE (date BETWEEN '$desde' AND '$hasta') AND (status =1) ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }
    

     function birthsForReport($desde,$hasta)
    {
        if ($desde) {

            $query = $this->db->query("SELECT * FROM `vw_births` WHERE (date_birth BETWEEN '$desde' 
            AND '$hasta') AND (status =1) ORDER BY date_birth ASC");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->result()
            );
        } else {
            $query = $this->db->query("SELECT * FROM `vw_births` WHERE (date_birth BETWEEN '$desde' AND '$hasta') AND (status =1) ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }

    function birthsForReportAbort($desde, $hasta)
    {
        if ($desde) {

            $query = $this->db->query("SELECT * FROM `vw_births` WHERE (date_birth BETWEEN '$desde' 
            AND '$hasta') AND (abortions=1) AND (status =1) ORDER BY date_birth ASC");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->result()
            );
        } else {
            $query = $this->db->query("SELECT * FROM `vw_births` WHERE (date_birth BETWEEN '$desde' AND '$hasta') AND (abortions=1) AND (status =1) ");
            $reponseDB = array(
                "status" => "success",
                "status_code" => 200,
                "message" => "Data loaded, successful",
                "validations" => null,
                "data" => $query->row()
            );
        }
        return $reponseDB;
    }
  
    function getBirths($page = NULL, $limit = NULL)
    {
        if ($page != NULL && $limit != NULL) {
            $page_num = max(0, ($page - 1) * $limit);
            $query = $this->db->query("SELECT *  FROM `vw_births` WHERE status=1 ORDER BY date_birth DESC LIMIT {$page_num}, {$limit}");
        } else {
            $query = $this->db->query("SELECT *  FROM `vw_births` WHERE status=1 ORDER BY date_birth DESC");
        }
        $reponseDB = array(
            "status" => "success",
            "status_code" => 200,
            "message" => "Data loaded, successful",
            "validations" => null,
            "data" => $query->result()
        );

        return $reponseDB;
    }

    function getMortality($page = NULL, $limit = NULL)
    {
        if ($page != NULL && $limit != NULL) {
            $page_num = max(0, ($page - 1) * $limit);
            $query = $this->db->query("SELECT *  FROM `vw_mortality` WHERE status=1 ORDER BY date_mortality DESC LIMIT {$page_num}, {$limit}");
        } else {
            $query = $this->db->query("SELECT *  FROM `vw_mortality` WHERE status=1 ORDER BY date_mortality DESC");
        }
        $reponseDB = array(
            "status" => "success",
            "status_code" => 200,
            "message" => "Data loaded, successful",
            "validations" => null,
            "data" => $query->result()
        );

        return $reponseDB;
    }
    function getReproductionRecords($page = NULL, $limit = NULL)
    {
        if ($page != NULL && $limit != NULL) {
            $page_num = max(0, ($page - 1) * $limit);
            $query = $this->db->query("SELECT *  FROM `vw_reproductiveManagement` WHERE status=1 ORDER BY date_reproductive DESC LIMIT {$page_num}, {$limit}");
        } else {
            $query = $this->db->query("SELECT *  FROM `vw_reproductiveManagement` WHERE status=1 ORDER BY date_reproductive DESC");
        }
        $reponseDB = array(
            "status" => "success",
            "status_code" => 200,
            "message" => "Data loaded, successful",
            "validations" => null,
            "data" => $query->result()
        );

        return $reponseDB;
    }

}
