<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard extends CI_Controller
{

	public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata('user_admin_sess')) {
			redirect('login');
		}
	}


	public function index()
	{
		$totalproduction = [];
		$totalMuertes = [];
		for ($i = 1; $i <= date('j'); $i++) {

			$date = date('Y') . "-" . date('m') . "-" . str_pad($i, 2, '0', STR_PAD_LEFT);
			$dates[] = $date;
			
			$mortalityday = $this->MostalityForDayC($date);
			if ($mortalityday) {
				$mortalityDa = $mortalityday->muertes;
			} else {
				$mortalityDa = 0;
			}
			
			$totalMuertes[] = $mortalityDa;
		}
		$semana = 0;
		for ($i = 1; $i <= date('W'); $i++) {
			$semana = $semana +1;
			$date = date('Y') . "-" . date('m') . "-" . str_pad($i, 2, '0', STR_PAD_LEFT);
			$dates[] = $date;
		
		}


		$animalesbirths = $this->countAnimalsBirth();
		$females = $animalesbirths->females;
		$males = $animalesbirths->males;
		$totales = $females + $males;

		$mortalityActual = $this->mortality();
		$mortalityActual1 = $mortalityActual->mortality;
		$mortalityLast = $this->mortalitylastWeek();
		$mortalitylastWeek = $mortalityLast->mortalityLastWeek;
		$total = $mortalityActual1 + $mortalitylastWeek;
		$incremento =  $mortalityActual1 - $mortalitylastWeek;
		if($mortalitylastWeek !=0 && $incremento != 0){
		    $divicion = $incremento / $mortalitylastWeek * 100;
		}else{
		    $divicion=0;
		}
		

		$birthsActual = $this->births()->births;
		$birthsLastWeek = $this->birthslastWeek()->birthsLastWeek;
		/* var_dump($birthsLastWeek); */

		$incrementoBirth = $birthsActual-$birthsLastWeek;
		if($incrementoBirth !=0 && $birthsLastWeek != 0){
		    $divicionBirth = $incrementoBirth / $birthsLastWeek * 100;    
		}else{
		    $divicionBirth=0;
		}
		

		/* var_dump($mortalityActual1."Incremento".$divicion ); */
		
			if ($totales != 0) {
			$PorcFemales = number_format($females * 100 / $totales, 1, '.', '');
			$PorcMales = number_format($males * 100 / $totales, 1, '.', '');
		}else{
		    $PorcFemales = 0;
		$PorcMales = 0;    
		}
		
		$mortalityC = $this->get_morta()->total_muertes;
		$mortalityInanicion = $this->get_mortalityCause('Inanicion')->total_muertes;
		$mortalityHipotermia = $this->get_mortalityCause('Hipotermia')->total_muertes;
		$mortalityPartos = $this->get_mortalityCause('Partos')->total_muertes;
		$mortalityEnfermedades = $this->get_mortalityCause('Enfermedades')->total_muertes;
		$mortalityDepredacion = $this->get_mortalityCause('Depredacion')->total_muertes;
		$mortalityAccidentes = $this->get_mortalityCause('Accidentes')->total_muertes;
		$mortalityOtra = $this->get_mortalityCause('Otra')->total_muertes;

		if ($mortalityInanicion != 0 && $mortalityC != 0) {
			$por_inanicion = number_format($mortalityInanicion * 100 / $mortalityC, 1, '.', '');
		} else {
			$por_inanicion = 0;
		}
		if ($mortalityOtra != 0 && $mortalityC != 0) {
			$por_otra = number_format($mortalityOtra * 100 / $mortalityC, 1, '.', '');
		} else {
			$por_otra = 0;
		}
		if ($mortalityHipotermia != 0 && $mortalityC != 0) {
			$por_Hipotermina = number_format($mortalityHipotermia * 100 / $mortalityC, 1, '.', '');
		} else {
			$por_Hipotermina = 0;
		}

		if ($mortalityPartos != 0 && $mortalityC != 0) {
			$por_partos = number_format($mortalityPartos * 100 / $mortalityC, 1, '.', '');
		} else {
			$por_partos = 0;
		}
		if ($mortalityEnfermedades != 0 && $mortalityC != 0) {
			$por_Enfermedades = number_format($mortalityEnfermedades * 100 / $mortalityC, 1, '.', '');
		} else {
			$por_Enfermedades = 0;
		}
		if ($mortalityAccidentes != 0 && $mortalityC != 0) {
			$por_accidentes = number_format($mortalityAccidentes * 100 / $mortalityC, 1, '.', '');
		} else {
			$por_accidentes = 0;
		}
		
		
		
			$granTotal = $this->getBirthProm()->totalBirth;
		$femalesYear = $this->getBirthProm()->totalFemales;
		$malesYear = $this->getBirthProm()->totalMales;

		if ($femalesYear != 0 && $granTotal != 0) {
			$promFemales = number_format($femalesYear * 100 / $granTotal, 1, '.', '');
		} else {
			$promFemales = 0;
		}

		if ($malesYear != 0 && $granTotal != 0) {
			$promMales = number_format($malesYear * 100 / $granTotal, 1, '.', '');
		} else {
			$promMales = 0;
		}
		$data['promFemales'] = $promFemales;
		$data['promMales'] = $promMales;



		// 1
		$data['inanicion'] = $mortalityInanicion;
		$data['hipotermia'] = $mortalityHipotermia;
		$data['partos'] = $mortalityPartos;
		$data['enfermedades'] = $mortalityEnfermedades;
		$data['accidentes'] = $mortalityAccidentes;
		$data['otra'] = $mortalityOtra;
		$data['depredacion'] = $mortalityDepredacion;
		
		$data['getBirthForMonth'] = $this->getBirthForMonth();
		
		
		$data['totalMuertes'] = $totalMuertes;
		$data['totalproduction'] = $totalproduction;
		$data['animals'] = $this->animals_get();
		$data['ovinos'] = $this->ovinos_get();
		$data['totales'] = $totales;
		
		//para graficos de temperatura
		
		$data['getMortalityForMonth'] = $this->getMortalityForMonth();
		$data['rodeos'] = $this->getRodeosBySpecie('Aves');
		$data['dataLoggerByHourCurrentDay'] = $this->getDataLoggerByHourCurrentDay();
		$data['dataLoggerLastRegister'] = $this->getDataLoggerLastRegister();
		$data['hoursRange'] = $this->generateHoursRange();
		$data['eggProductionMonthlyData'] = $this->getMonthlyEggProduction();
		$data['eggProductionBySizeCurrentMonth'] = $this->getEggProductionBySizeCurrentMonth();
		$data['brokenEggProductionCurrentMonth'] = $this->getBrokenEggProductionCurrentMonth();
		$data['divicionBirth'] = number_format($divicionBirth, 2, '.', '');
		$data['divicion'] = $divicion;
		$data['PorcFemales'] = $PorcFemales;
		$data['PorcMales'] = $PorcMales;
		$data['females'] = $females;
		$data['males'] = $males;
		$data['aves'] = $this->aves();
		$data['mortality'] = $this->mortality();
		$data['births'] = $this->births();
		$data['body'] = 'dashboard/dashboard';
		$this->load->view('layout/main', $data);
	}
	
	
	
		function get_mortalityCause($cause)
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'mortality/api/mortalityCause/cause/' . $cause,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$mortality1 = json_decode($response);
		return $mortality1->data;
	}
	
	
	
		function getBirthForMonth()
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'births/api/birthGeneral',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_POSTFIELDS => '',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#',
				'Content-Type: application/json'
			),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);
		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_decode($response);
			return $result->data;
		}
	}
	
	
		function getBirthProm()
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'births/api/birthProm',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_POSTFIELDS => '',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#',
				'Content-Type: application/json'
			),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);
		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_decode($response);
			return $result->data;
		}
	}
	
	
	
	function get_morta()
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'mortality/api/mortalityCause',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$mortality1 = json_decode($response);
		return $mortality1->data;
	}
	
	
	//producción de huevo
	function getMonthlyEggProduction()
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'eggs_production/api/by_month',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);

		$production = json_decode($response);
		$eggProductionPzMonthData = [];
		$eggProductionKgMonthData = [];
		$months = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
		$total_pz = 0;
		$total_kg = 0;


		foreach ($months as $m) {
			foreach ($production->data as $value) {
				$month = $value->month;
				if ($month == $m) {
					$total_pz = $value->total_pz;
					$total_kg = number_format($value->total_kg, 3, '.', '');
				}
			}
			if ($total_pz) {
				$eggProductionPzMonthData[] = $total_pz;
				$total_pz = 0;
			} else {
				$eggProductionPzMonthData[] = 0;
			}
			if ($total_kg) {
				$eggProductionKgMonthData[] = $total_kg;
				$total_kg = 0;
			} else {
				$eggProductionKgMonthData[] = 0;
			}
		}

		$data = array(
			'eggProductionPzMonthData' => $eggProductionPzMonthData,
			'eggProductionKgMonthData' => $eggProductionKgMonthData
		);

		return $data;
	}
	function getEggProductionBySizeCurrentMonth()
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'eggs_production/api/by_size_current_month',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);

		$production = json_decode($response);
		return $production->data;
	}
	
	
	
		function getMortalityForMonth()
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL.'mortality/api/mortalityGeneral',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_POSTFIELDS => '
',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#',
				'Content-Type: application/json'
			),
		));

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);
		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_decode($response);
			return $result->data;
		}
	}
	
	
	

	function getBrokenEggProductionCurrentMonth()
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'eggs_production/api/broken_eggs_current_month',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);

		$production = json_decode($response);
		return $production->data;
	}
//para graficos de temperatura
	function getRodeosBySpecie($specie)
	{
		$curl = curl_init();
		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . "rodeos/api/rodeoBySpecie/specie/{$specie}",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));

		$response = curl_exec($curl);
		curl_close($curl);
		$rodeos = json_decode($response);
		return $rodeos->data;
	}

	function getDataLoggerByHourCurrentDay()
	{
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "data_logger/api/by_hour_current_day",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => [
				"x-api-key: QroSystem%21#"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		}
		$result = json_decode($response);
		$humidity = 0;
		$dew_point = 0;
		$hour_time = 0;
		$temperature = 0;
		$rodeo = '';
		$dataTemperature = [];

		for ($i = 0; $i < 24; $i++) {
			foreach ($result->data as $data) {
				$hour = $data->hour;
				$date = $data->date;
				$rodeo = $data->rodeo;
				$hour_time = $hour_time + $i;
				if ($hour == $i) {
					$humidity = $data->humidity;
					$dew_point = $data->dew;
					$temperature = $data->temperature;
				}
			}
			if ($temperature) {
				$dataTemperature[] = array(
					'humidity' => $humidity,
					'dew' => $dew_point,
					'temperature' => $temperature,
					'rodeo' => $rodeo,
					'hour' => $hour_time,
					'date' => $date
				);
				$humidity = 0;
				$dew_point = 0;
				$temperature = 0;
			} else {
				if (@$date) {
					$dataTemperature[] = array(
						'humidity' => 0,
						'dew' => 0,
						'temperature' => 0,
						'rodeo' => 0,
						'hour' => $hour_time,
						'date' => $date
					);
				} else {
					date_default_timezone_set('America/Mexico_City');
					$currentDate = date("Y-m-d");
					$dataTemperature[] = array(
						'humidity' => 0,
						'dew' => 0,
						'temperature' => 0,
						'rodeo' => 0,
						'hour' => $hour_time,
						'date' => $currentDate
					);
				}
			}
		}
		return $dataTemperature;
	}
	function generateHoursRange()
	{
		$lower = 0;
		$upper = 86400;
		$step = 3600;
		$format = '';
		$times = array();

		if (empty($format)) {
			$format = 'g:i a';
		}

		foreach (range($lower, $upper, $step) as $increment) {
			$increment = gmdate('H:i', $increment);

			list($hour, $minutes) = explode(':', $increment);

			$date = new DateTime($hour . ':' . $minutes);

			$times[(string) $increment] = $date->format($format);
		}

		return $times;
	}
	function customEggProduction()
	{
		$rodeo = $_POST['rodeo'];
		$start = $_POST['start'];
		$end = $_POST['end'];
		$ud = $_POST['ud'];
		if ($start == $end) {
			//$result = $this->getCustomDataLoggerByDay($start, $rodeo);
			$responseProduction= $this->getCustomDataEggProductionByDay($start, $rodeo, $ud);
			$data = array(
				'is_by_day' => true,
				'label_name' => 'Categorias',
				'labels' => $responseProduction['categories'],
				'data' => $responseProduction['production']
			);
			echo json_encode($data);
		}else{
			$responseProduction= $this->getCustomDataEggProductionGeneral($start, $end, $rodeo);
			$period = $this->generateRangeDates($start, $end);
			foreach ($period as $i => $date) {
				$formatedDate = $date->format('d/m');
				$labels[(string) $i . 'd'] = $formatedDate;
			}
			$data = array(
				'is_by_day' => false,
				'label_name' => 'Fecha',
				'labels' => $labels,
				'data' => $responseProduction,
				'rodeos'=>$this->getRodeosBySpecie('Aves')
			);
			echo json_encode($data);
		}
	}
	function customDataLogger()
	{
		$rodeo = $_POST['rodeo'];
		$start = $_POST['start'];
		$end = $_POST['end'];
		if ($start == $end) {
			$result = $this->getCustomDataLoggerByDay($start, $rodeo);
			$data = array(
				'is_by_day' => true,
				'label_name' => 'Hora',
				'labels' => $this->generateHoursRange(),
				'data' => $result
			);
			echo json_encode($data);
		} else {
			$result = $this->getCustomDataLoggerGeneral($start, $end, $rodeo);
			$period = $this->generateRangeDates($start, $end);
			$labels = array();
			foreach ($period as $i => $date) {
				$formatedDate = $date->format('d/m');
				$labels[(string) $i . 'd'] = $formatedDate;
			}
			$data = array(
				'is_by_day' => false,
				'label_name' => 'Fecha',
				'labels' => $labels,
				'data' => $result
			);
			//
			echo json_encode($data);
		}
		//echo json_encode($_POST['rodeo']);

	}
		function getDataLoggerLastRegister()
	{
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "data_logger/api/custom_query_last_register",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => [
				"x-api-key: QroSystem%21#"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		}
		$result = json_decode($response);
		$humidity = 0;
		$dew_point = 0;
		$hour_time = 0;
		$temperature = 0;
		$rodeo = '';
		$dataTemperature = [];

		for ($i = 0; $i < 24; $i++) {
			foreach ($result->data as $data) {
				$hour = $data->hour;
				$date = $data->date;
				$rodeo = $data->rodeo;
				$hour_time = $hour_time + $i;
				if ($hour == $i) {
					$humidity = $data->humidity;
					$dew_point = $data->dew;
					$temperature = $data->temperature;
				}
			}
			if ($temperature) {
				$dataTemperature[] = array(
					'humidity' => $humidity,
					'dew' => $dew_point,
					'temperature' => $temperature,
					'rodeo' => $rodeo,
					'hour' => $hour_time,
					'date' => $date
				);
				$humidity = 0;
				$dew_point = 0;
				$temperature = 0;
			} else {
				if (@$date) {
					$dataTemperature[] = array(
						'humidity' => 0,
						'dew' => 0,
						'temperature' => 0,
						'rodeo' => 0,
						'hour' => $hour_time,
						'date' => $date
					);
				} else {
					date_default_timezone_set('America/Mexico_City');
					$currentDate = date("Y-m-d");
					$dataTemperature[] = array(
						'humidity' => 0,
						'dew' => 0,
						'temperature' => 0,
						'rodeo' => 0,
						'hour' => $hour_time,
						'date' => $currentDate
					);
				}
			}
		}
		return $dataTemperature;
	}
	function getCustomDataLoggerGeneral($start, $end, $rodeo)
	{
		$data = array(
			'start' => $start,
			'end' => $end,
			'rodeo' => $rodeo
		);
		$data_to_string = json_encode($data);
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "data_logger/api/custom_query",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => $data_to_string,
			CURLOPT_HTTPHEADER => [
				"Content-Type: application/json",
				"x-api-key: QroSystem%21#"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_decode($response);
			//return $result;
			$period = $this->generateRangeDates($start, $end);
			//$formatedDates = [];
			$humidity = 0;
			$dew_point = 0;
			$hour_time = 0;
			$temperature = 0;
			$rodeo = '';
			$dataTemperature = [];
			$date_ini = '';
			foreach ($period as $date_value) {
				$formatedDate = $date_value->format('Y-m-d');
				$date_ini = $formatedDate;
				foreach ($result->data as $data) {
					$date = $data->date;
					$rodeo = $data->rodeo;
					if ($date == $formatedDate) {
						$humidity = $data->humidity;
						$dew_point = $data->dew;
						$temperature = $data->temperature;
					}
				}

				if ($temperature) {
					$dataTemperature[] = array(
						'humidity' => number_format($humidity, 2, '.', ','),
						'dew' => number_format($dew_point, 2, '.', ','),
						'temperature' => number_format($temperature, 2, '.', ','),
						'rodeo' => $rodeo,
						'date' => $date_ini
					);
					$humidity = 0;
					$dew_point = 0;
					$temperature = 0;
				} else {
					$dataTemperature[] = array(
						'humidity' => 0,
						'dew' => 0,
						'temperature' => 0,
						'rodeo' => 0,
						'date' => $date_ini
					);
				}
			}
			return $dataTemperature;
		}
	}
	function generateRangeDates($start_date, $end_date)
	{
		$period = [];
		$begin = new DateTime($start_date);
		$end = new DateTime($end_date);
		$end = $end->modify('+1 day');

		$interval = new DateInterval('P1D');
		$daterange = new DatePeriod($begin, $interval, $end);

		foreach ($daterange as $key => $value) {
			$period[] = $value;
		}
		return $period;
	}
		function getCustomDataEggProductionGeneral($start, $end, $rodeo){
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL."eggs_production/api/custom_query/start/{$start}/end/{$end}/rodeo/{$rodeo}",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => [
				"x-api-key: QroSystem%21#"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result= json_decode($response);
			$period = $this->generateRangeDates($start, $end);
			$rodeos=$this->getRodeosBySpecie('Aves');
			$date_productions='';
			$total_kg=0;
			$total_pz=0;
			$rodeo_name='';
			$production = [];
			$date_ini = '';
			$rodeo_tmp='';
			if ($rodeo != 'all') {
				foreach ($period as $date_value) {
					$formatedDate = $date_value->format('Y-m-d');
					$date_ini = $formatedDate;
					foreach ($result->data as $data) {
						$date = $data->date_productions;
						if ($date == $formatedDate) {
							$date_productions=$date;
							$total_kg=$data->total_kg;
							$total_pz=$data->total_pz;
							if (@$data->rodeo_name) {
								$rodeo_name=$data->rodeo_name;
							}
						}
					}
					if ($date_productions) {
						$production[]=array(
							'date_productions'=>$date_productions,
							'total_kg'=>number_format($total_kg, 2, '.', ','),
							'total_pz'=>$total_pz,
							'rodeo_name'=>$rodeo_name
						);
						$date_productions='';
						$total_kg=0;
						$total_pz=0;
						$rodeo_name='';
						$date_ini = '';
					}else{
						$production[]=array(
							'date_productions'=>$date_ini,
							'total_kg'=>0,
							'total_pz'=>0,
							'rodeo_name'=>$rodeo_name
						);
						$rodeo_name='';
					}
	
				}
			}else{
				foreach ($rodeos as $rodeo) {
				foreach ($period as $date_value) {
					$formatedDate = $date_value->format('Y-m-d');
					$date_ini = $formatedDate;
					foreach ($result->data as $data) {
						$date = $data->date_productions;
						if ($date == $formatedDate) {
							
								$rodeo_tmp=$rodeo->name_rodeo;
								if ($data->rodeo_name==$rodeo->name_rodeo) {
									$rodeo_name=$data->rodeo_name;
									$date_productions=$date;
									$total_kg=$data->total_kg;
									$total_pz=$data->total_pz;
								}
						
							
						}
					}
				
					if ($date_productions && $rodeo_name) {
						$production[(string) $rodeo_name][]=array(
							'date_productions'=>$date_productions,
							'total_kg'=>number_format($total_kg, 2, '.', ','),
							'total_pz'=>$total_pz,
							'rodeo_name'=>$rodeo_name
						);
						$date_productions='';
						$total_kg=0;
						$total_pz=0;
						$rodeo_name='';
						$date_ini = '';
					}else{
						$production[(string) $rodeo_tmp][]=array(
							'date_productions'=>$date_ini,
							'total_kg'=>0,
							'total_pz'=>0,
							'rodeo_name'=>$rodeo_tmp
						);
						$rodeo_name='';
					}
	
				}
			}
			}
		
			return $production;
		}
	}
	function getCustomDataEggProductionByDay($date, $rodeo,$ud)
	{
		if ($rodeo != 'general') {
			$uri=API_URL."eggs_production/api/custom_query_by_day/date/{$date}/rodeo/{$rodeo}/ud/{$ud}";
		}else if ($rodeo=='general'){
			$uri=API_URL."eggs_production/api/custom_query_by_day/date/{$date}/rodeo/{$rodeo}";
		}
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => $uri,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "GET",
			CURLOPT_POSTFIELDS => "",
			CURLOPT_HTTPHEADER => [
				"x-api-key: QroSystem%21#"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result= json_decode($response);
			$categories=['Chico','Mediano','Grande', 'Extra Grande', 'Jumbo', 'Quebrado'];
			//['Chico', 'Extra Grande', 'Grande', 'Mediano', 'Jumbo',  'Quebrado'];
			$size_egg='';
			$total_kg=0;
			$total_pz=0;
			$rodeo_name='';
			$production=[];
			/* echo var_dump($result->data); */
			if ($rodeo!='all') {
				foreach($categories as $category) {
					foreach($result->data as $value) {
						if ($value->size_egg==$category) {
							$size_egg=$value->size_egg;
							$total_kg= $value->total_kg;
							$total_pz=$value->total_pz;
							if (@$value->rodeo_name) {
								$rodeo_name=$value->rodeo_name;
							}
						}else{
							$size_egg=$category;
						}
	
					}
					if ($size_egg) {
						$production[]=array(
							'size_egg'=>$size_egg,
							'total_kg'=>number_format($total_kg,2,'.','.'),
							'total_pz'=>number_format($total_pz, 2, '.', ','),
							'rodeo_name'=>$rodeo_name,
						);
						$size_egg='';
						$total_kg=0;
						$total_pz=0;
						$rodeo_name='';
					}else{
						$production[]=array(
							'size_egg'=>$size_egg,
							'total_kg'=>0,
							'total_pz'=>0,
							'rodeo_name'=>$rodeo_name,
						);
						$size_egg='';
						$total_kg=0;
						$total_pz=0;
						$rodeo_name='';
					}
				}
				return array(
					'production'=>$production,
					'categories'=>$categories
				);
			}else{
				$production=[];
				foreach ($result->data as $value) {
					$production[]=array(
						'date_production'=>$value->date_productions,
						'chico'=>number_format($value->chico,2,'.', ','),
						'mediano' =>number_format($value->mediano,2,'.', ','),
						'grande'=>number_format($value->grande,2,'.', ','),
						'extra_grande'=>number_format($value->extra_grande,2,'.', ','),
						'jumbo'=>number_format($value->jumbo,2,'.', ','),
						'quebrado'=>number_format($value->quebrado,2,'.', ','),
						'rodeo_name'=>$value->rodeo_name,
					);
				}
				return array(
					'production'=>$production,
					'categories'=>$categories
				);
			}
		
		}
		
		 
	}
	function getCustomDataLoggerByDay($date, $rodeo)
	{
		$data = array(
			'date' => $date,
			'rodeo' => $rodeo
		);
		$data_to_string = json_encode($data);
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "data_logger/api/custom_query_by_day",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => $data_to_string,
			CURLOPT_HTTPHEADER => [
				"Content-Type: application/json",
				"x-api-key: QroSystem%21#"
			],
		]);

		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_decode($response);
			$humidity = 0;
			$dew_point = 0;
			$hour_time = 0;
			$temperature = 0;
			$rodeo = '';
			$dataTemperature = [];

			for ($i = 0; $i < 24; $i++) {
				foreach ($result->data as $data) {
					$hour = $data->hour;
					$date = $data->date;
					$rodeo = $data->rodeo;
					$hour_time = $hour_time + $i;
					if ($hour == $i) {
						$humidity = $data->humidity;
						$dew_point = $data->dew;
						$temperature = $data->temperature;
					}
				}
				if ($temperature) {
					$dataTemperature[] = array(
						'humidity' => number_format($humidity, 2, '.', ','),
						'dew' => number_format($dew_point, 2, '.', ','),
						'temperature' => number_format($temperature, 2, '.', ','),
						'rodeo' => $rodeo,
						'hour' => $hour_time,
						'date' => $date
					);
					$humidity = 0;
					$dew_point = 0;
					$temperature = 0;
				} else {
					if (@$date) {
						$dataTemperature[] = array(
							'humidity' => 0,
							'dew' => 0,
							'temperature' => 0,
							'rodeo' => 0,
							'hour' => $hour_time,
							'date' => $date
						);
					} else {
						date_default_timezone_set('America/Mexico_City');
						$currentDate = date("Y-m-d");
						$dataTemperature[] = array(
							'humidity' => 0,
							'dew' => 0,
							'temperature' => 0,
							'rodeo' => 0,
							'hour' => $hour_time,
							'date' => $currentDate
						);
					}
				}
			}
			return $dataTemperature;
		}
	}

	function birthslastWeek()
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL.'births/api/birthsCountLastWeek',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));
		$response = curl_exec($curl);
		curl_close($curl);
		$birthslastWeek = json_decode($response);
		return $birthslastWeek->data;

	}
	function countAnimalsBirth()
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'births/api/criasCount',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		/* echo $response; */
		$countAnimalsBirth = json_decode($response);
		return $countAnimalsBirth->data;
	}

	function MostalityForDayC($day)
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'mortality/api/mortalityDayCount/day/' . $day,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		/* echo $response; */
		$MostalityForDayC = json_decode($response);
		return $MostalityForDayC->data;
	}


	function productionForDay($day)
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'productions/api/productionsForDay/day/' . $day,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		/* echo $response; */
		$productionFDay = json_decode($response);
		return $productionFDay->data;
	}
	
	
	function customMortality()
	{
		
		$start = $_POST['start'];
		$end = $_POST['end'];
		if ($start == $end) {
		} else {
			$result = $this->getCustomMortalityDate($start, $end);
			$period = $this->generateRangeDates($start, $end);
			$labels = array();
			foreach ($period as $i => $date) {
				$formatedDate = $date->format('d/m');
			}
			$data = array(
				'is_by_day' => false,
				'label_name' => 'Fecha',
				'labels' => $labels,
				'data' => $result
			);
			echo json_encode($data);
		}

	}
	
	
	function getCustomMortalityDate($start, $end)
	{
		$data = array(
			'start' => $start,
			'end' => $end,
			
		);
		$data_to_string = json_encode($data);
		$curl = curl_init();

		curl_setopt_array($curl, [
			CURLOPT_URL => API_URL . "mortality/api/custom_mortality",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => "",
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 30,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => "POST",
			CURLOPT_POSTFIELDS => $data_to_string,
			CURLOPT_HTTPHEADER => [
				"Content-Type: application/json",
				"x-api-key: QroSystem%21#"
			],
		]);
		$response = curl_exec($curl);
		$err = curl_error($curl);

		curl_close($curl);
		if ($err) {
			echo "cURL Error #:" . $err;
		} else {
			$result = json_decode($response);
			// return $result;
			$period = $this->generateRangeDates($start, $end);
			// $formatedDates = [];
			$mortalityOvi = 0;
			$mortalityAves = 0;
			
			$mortalityPeriod = [];
			$date_ini = '';
			foreach ($period as $date_value) {
				$formatedDate = $date_value->format('Y-m-d');
				$dateForm = $date_value->format('M-d');
				$date_ini = $formatedDate;
				foreach ($result->data as $data) {
					$date = $data->date_mortality;
					
					if ($date == $formatedDate) {
						$mortalityOvi = $data->mortality_ovinos;
						$mortalityAves = $data->mortality_aves;
						
					}
				}
				if ($mortalityOvi) {
					$mortalityPeriod[] = array(
						'mortalityDates_' => $mortalityOvi,
						'mortalityAves_' => $mortalityAves,
						'date' => $dateForm
					);
					$mortalityOvi = 0;
				} else {
					$mortalityPeriod[] = array(
						'mortalityDates_' => 0,
						'mortalityAves_' => 0,
						'date' => $dateForm
					);
				}
			}
			return $mortalityPeriod;
		}
	}
	

	function births()
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'births/api/birthsCount',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$births = json_decode($response);
		return $births->data;
	}
	function mortality()
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'mortality/api/mortalityCount',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);

		$mortality = json_decode($response);
		return $mortality->data;
	}

	function mortalitylastWeek()
	{

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'mortality/api/mortalityLastWeekCount',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		/* echo $response; */
		$mortalitylastWeek = json_decode($response);
		return $mortalitylastWeek->data;
	}
	function animals_get()
	{

		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'animals/api/animalesCount',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		/* echo $response; */
		$animals = json_decode($response);
		return $animals->data;
	}

	function ovinos_get()
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'animals/api/OvinosCount',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$ovinos = json_decode($response);
		return $ovinos->data;
	}

	function aves()
	{
		$curl = curl_init();

		curl_setopt_array($curl, array(
			CURLOPT_URL => API_URL . 'animals/api/avesCount',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'GET',
			CURLOPT_HTTPHEADER => array(
				'x-api-key: QroSystem%21#'
			),
		));

		$response = curl_exec($curl);

		curl_close($curl);
		$aves = json_decode($response);
		return $aves->data;
	}
}
