<?php
defined('BASEPATH') or exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class DataLogger extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        if (!$this->session->userdata('user_admin_sess')) {
            redirect('login');
        }
    }

    function index()
    {
        $data['rodeos'] = $this->getRodeosBySpecie('Aves');
        $data['dataLogger'] = $this->getDataLogger();
        $data['body'] = 'data_logger/view';
        $this->load->view('layout/main', $data);
    }

    function getRodeosBySpecie($specie)
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . "rodeos/api/rodeoBySpecie/specie/{$specie}",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);
        curl_close($curl);
        $rodeos = json_decode($response);
        return $rodeos->data;
    }

    function getDataLogger()
    {

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'data_logger/api/all',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $result = json_decode($response);
        return $result->data;
    }

    function read_data($file)
    {
        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $reader->setReadDataOnly(FALSE);
        $spreadsheet = $reader->load($file);
        $sheet = $spreadsheet->getSheet(0);
        $highestRow = $sheet->getHighestRow();
       
        for ($row = 4; $row <= $highestRow; $row++) {
            $cellValue = $spreadsheet->getSheet(0)->getCell("A{$row}")->getValue();

            if ($cellValue) {
                $number = $spreadsheet->getSheet(0)->getCell("A{$row}")->getValue();
                $date = $spreadsheet->getSheet(0)->getCell("B{$row}")->getValue();
                $time = $spreadsheet->getSheet(0)->getCell("C{$row}")->getValue();
                $temperature = $spreadsheet->getSheet(0)->getCell("D{$row}")->getValue();
                $humidity = $spreadsheet->getSheet(0)->getCell("E{$row}")->getValue();
                $dew = $spreadsheet->getSheet(0)->getCell("F{$row}")->getValue();
                $resultDate = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($date)->format('Y-m-d');
                $resultTime = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($time)->format('H:i:s');
                yield array(
                    'number' => $number,
                    'date' => $resultDate,
                    'time' => $resultTime,
                    'temperature' => $temperature,
                    'humidity' => $humidity,
                    'dew' => $dew,
                    /* 'rodeo' => $rodeo */
                );
            }
        }
    }
        function importData()
    {
        $file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        $rodeo = $this->input->post('rodeo');
        $final_data = array();

        if (isset($_FILES['file_data']['name']) && in_array($_FILES['file_data']['type'], $file_mimes)) {
            $arr_file = explode('.', $_FILES['file_data']['name']);
            $file = $_FILES['file_data']['tmp_name'];
            $data_result = $this->read_data($file);

            $begin_time = microtime(true);
            $created_user = $this->session->userdata('user_admin_sess')->fullname;
    
            $data=[];
            foreach ($data_result as $dataLogger) {
               
                $data[] = array(
                    'num'=>$dataLogger['number'],
                    'created_user' => $created_user,
                    'date' => $dataLogger['date'],
                    'time' => $dataLogger['time'],
                    'temperature' => $dataLogger['temperature'],
                    'humidity' => $dataLogger['humidity'],
                    'dew' => $dataLogger['dew'],
                    'rodeo' => $rodeo,
                );
            }
            $data_to_string = json_encode($data);
            $curl_request = curl_init(API_URL . "data_logger/api/register");
    
            curl_setopt($curl_request, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($curl_request, CURLOPT_HTTPHEADER, array(
              'Content-Type: application/json',
              'x-api-key: QroSystem%21#'
            ));
            curl_setopt($curl_request, CURLOPT_RETURNTRANSFER, True);
            curl_setopt($curl_request, CURLOPT_POSTFIELDS, $data_to_string);
            $response = curl_exec($curl_request);
    
            if (!$response) {
              $response = json_encode(array(
                "status" => "error",
                "message" => curl_errno($curl_request)
              ));
              echo var_dump($response);
            }
            curl_close($curl_request);
            $response = json_decode($response);
            
/*             $end_time = microtime(true);
            $time = $end_time - $begin_time;
            echo "The time was " . $time . " seconds"; */
        }
  
            redirect('dataLogger');
  
    
}


}
