<?php
defined('BASEPATH') or exit('No direct script access allowed');


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


class Mortality extends CI_Controller
{

  public function __construct()
  {
    parent::__construct();
    if (!$this->session->userdata('user_admin_sess')) {
      redirect('login');
    }
  }


  public function index()
  {
    $data['body'] = 'mortality/mortality';
    $data['mortality'] = $this->getMortality();
    $this->load->view('layout/main', $data);
  }


  function getMortality()
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'mortality/api/mortality',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $mortality = json_decode($response);
    return $mortality->data;
  }


  function motality_excel()
  {

    $specie_ = $this->input->post('specie');
    $desde_ = $this->input->post('desde');
    $hasta_ = $this->input->post('hasta');

    setlocale(LC_TIME, 'spanish');
    $dateDesde = strftime('%d-%b-%y', strtotime($desde_));
    $dateHasta = strftime('%d-%b-%y', strtotime($hasta_));

    $mortalities = $this->mortalityReport_get($specie_,  $desde_, $hasta_);

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png');
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);

    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
    $sheet->mergeCells('A1:E4');
    $sheet->mergeCells('A5:D6');

    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

    $sheet->getStyle('A1')->getAlignment()->setVertical('center');

    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');

    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("E5:E6")->getFont()->setBold(true);

    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);

    $sheet->setCellValue('A1', 'Reporte de muerte de animales');
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(15);
    $sheet->getColumnDimension('C')->setWidth(30);
    $sheet->getColumnDimension('D')->setWidth(20);
    $sheet->getColumnDimension('E')->setWidth(35);

    $sheet->setCellValue('E5', 'Desde: ' . $dateDesde . ' Hasta: ' . $dateHasta);
    $sheet->setCellValue('E6', $specie_);
    $sheet->setCellValue('A8', 'N.°');
    $sheet->setCellValue('B8', 'Arete');
    $sheet->setCellValue('C8', 'Fecha');
    $sheet->setCellValue('D8', 'Causa');
    $sheet->setCellValue('E8', 'Comentarios');
    $counter = 8;
    foreach ($mortalities as $i => $mortality) {
      $counter = $counter + 1;
      $i = $i + 1;
      $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->setCellValue("A{$counter}", $i);
      $sheet->setCellValue("B{$counter}", $mortality->earring);
      $sheet->setCellValue("C{$counter}", $mortality->date_mortality);
      $sheet->setCellValue("D{$counter}", $mortality->cause);
      $sheet->setCellValue("E{$counter}", $mortality->comments);
    }
    $writer = new Xlsx($spreadsheet);

    $filename = 'Reporte_de_muertes';

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
  }

  public function mortalityReport_get($specie, $desde, $hasta)
  {


    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'mortality/api/mortalityReport/specie/' . $specie . '/desde/' . $desde . '/hasta/' . $hasta . '',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    /*  echo $response; */

    $mortalityD = json_decode($response);
    return $mortalityD->data;
  }


  function mortality_add()
  {

    $created_user = $this->session->userdata('user_admin_sess')->fullname;
    $earring = $this->input->post('earring');
    $date_mortality = $this->input->post('date_mortality');
    $cause = $this->input->post('cause');
    $comments = $this->input->post('comments');
    $id_animals_ = $this->input->post('id_animals');
    $specie = $this->input->post('specie');
    $data = array(
      'earring' => $earring,
      'specie' => $specie,
      'date_mortality' => $date_mortality,
      'cause' => $cause,
      'created_user' => $created_user,
      'comments' => $comments
    );

    $data_to_string = json_encode($data);
    $curl_request = curl_init(API_URL . 'mortality/api/mortality');

    curl_setopt($curl_request, CURLOPT_CUSTOMREQUEST, "POST");
    curl_setopt($curl_request, CURLOPT_HTTPHEADER, array(
      'Content-Type: application/json',
      'x-api-key: QroSystem%21#'
    ));
    curl_setopt($curl_request, CURLOPT_RETURNTRANSFER, True);
    curl_setopt($curl_request, CURLOPT_POSTFIELDS, $data_to_string);
    $response = curl_exec($curl_request);

    if (!$response) {
      $response = json_encode(array(
        "status" => "error",
        "message" => curl_errno($curl_request)
      ));
      echo var_dump($response);
    }
    curl_close($curl_request);
    $response = json_decode($response);

    redirect('mortality', 'refresh');
  }

  function getMortalityById($id_getMortalityById)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'mortality/api/mortality/id/' . $id_getMortalityById,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    /* echo $response; */

    $mortality = json_decode($response);
    $this->session->set_flashdata('mortality_details', array('data' => $mortality->data));
    redirect('mortality');
  }


  public function mortality_report()
  {
    $specie_ = $this->input->post('specie');
    $desde_ = $this->input->post('desde');
    $hasta_ = $this->input->post('hasta');
    setlocale(LC_TIME, 'spanish');
    $dateDesde = strftime('%d-%b-%y', strtotime($desde_));
    $dateHasta = strftime('%d-%b-%y', strtotime($hasta_));

    $mortalityData = $this->mortalityReport_get($specie_,  $desde_, $hasta_);


    $general_info = array(
      'begin' => $dateDesde,
      'end' => $dateHasta,
      'specie' => $specie_
    );

    $mpdf = new \Mpdf\Mpdf();
    $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
    $header = $this->load->view('reports/mortality/header', array('general_info' => $general_info), true);
    $mpdf->SetHTMLHeader($header);
    $footer = $this->load->view('reports/mortality/footer', [], true);
    $mpdf->SetHTMLFooter($footer);
    $html = $this->load->view('reports/mortality/body', array('mortalityData' => $mortalityData, 'general_info' => $general_info), true);
    $css = file_get_contents('assets/pdf-reports.css');
    $mpdf->SetTitle('Reporte de muertes');
    $mpdf->WriteHTML('<body>');
    $mpdf->WriteHTML($css, 1);
    $mpdf->WriteHTML($html);
    $mpdf->WriteHTML('</body>');
    $mpdf->Output('Reporte_de_muertes' . date("Ymd") . '.pdf', 'I');

    exit;
    $mpdf->Output();
  }

  public function exportRegisterExcel()
  {
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png');
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);

    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
    $sheet->mergeCells('A1:K4');
    $sheet->mergeCells('A5:K6');
    $sheet->mergeCells('J8:L8');
    $sheet->mergeCells('J9:L9');
    $sheet->mergeCells('J10:L10');
    $sheet->mergeCells('J11:L11');
    $sheet->mergeCells('J12:L12');
    $sheet->mergeCells('J13:L13');
    $sheet->mergeCells('J14:L14');
    $sheet->mergeCells('J15:L15');

    $sheet->mergeCells('L1:S1');
    $sheet->mergeCells('L2:S2');
    $sheet->mergeCells('L3:S3');
    $sheet->mergeCells('L4:S4');
    $sheet->mergeCells('L5:S6');

    $sheet->mergeCells('N8:P8');
    $sheet->mergeCells('N9:P11');
    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);
    $sheet->getStyle('N9')->getAlignment()->setVertical('center');
    $sheet->getStyle('N8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('N9')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A1')->getAlignment()->setVertical('center');
    $sheet->getStyle('L1')->getAlignment()->setVertical('center');
    $sheet->getStyle('L1')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('L2')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('L2')->getAlignment()->setVertical('center');
    $sheet->getStyle('L2:L6')->getAlignment()->setWrapText(true);
    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('N9:P11')->getAlignment()->setWrapText(true);
    $sheet->getStyle('H6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('J9:L15')->getAlignment()->setHorizontal('center');

    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("L1")->getFont()->setSize(14)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);


    $spreadsheet->getActiveSheet()->getStyle("F8")->getFont()->setBold(true);

    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('J8:L8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('J9:L15')->applyFromArray($styleArray);

    $sheet->setCellValue('A1', 'Formato de registro de mortalidad');
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(15);
    $sheet->getColumnDimension('C')->setWidth(30);
    $sheet->getColumnDimension('D')->setWidth(20);
    $sheet->getColumnDimension('E')->setWidth(35);

    $sheet->setCellValue('L1', 'Instrucciones de uso');
    $sheet->setCellValue('L2', 'Todos los campos deben ser llenados de forma correcta, para ello se debe considerar lo siguiente:');
    $sheet->setCellValue('L3', '1.- N.°: Ingresar número de fila comenzando por el 1 (1, 2, 3 etc)');
    $sheet->setCellValue('L4', '2.- Arete: Ingresar el arete ó grapa del animal');
    $sheet->setCellValue('L5', '3.- Causa: Ingresar la causa de la muerte ingresando el nombre de causa tal como se muestra en la tabla (ver tabla de causa)');

    $sheet->setCellValue('D7', 'DD/MM/AAAA');

    $spreadsheet->getActiveSheet()->getStyle("L1:S6")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('ffff00');
    $spreadsheet->getActiveSheet()->getStyle("N8:P11")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('ffff00');

    $sheet->setCellValue('N8', 'NOTA:');
    $sheet->setCellValue('N9', 'Los campos que no contengan información deberán tener lo siguiente: N/A ');
    $sheet->setCellValue('J8', 'Causa');
    $sheet->setCellValue('J9', 'Inanición');
    $sheet->setCellValue('J10', 'Hipotermia');
    $sheet->setCellValue('J11', 'Partos distócicos');
    $sheet->setCellValue('J12', 'Depredación');
    $sheet->setCellValue('J13', 'Enfermedades infecciosas');
    $sheet->setCellValue('J14', 'Accidentes');
    $sheet->setCellValue('J15', 'Otra');
    $sheet->setCellValue('K8', 'Macho');
    $sheet->setCellValue('K9', 'Hembra');
    $sheet->setCellValue('A8', 'N.°');
    $sheet->setCellValue('B8', 'Arete');
    $sheet->setCellValue('C8', 'Causa');
    $sheet->setCellValue('D8', 'Fecha');
    $sheet->setCellValue('E8', 'Comentarios');
    $sheet->setCellValue('A9', 1);
    //$writer = new Xlsx($spreadsheet);
    $writer = new Xlsx($spreadsheet);

    $filename = 'formato_registro_mortalidad';

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
    /*    $writer = new Xlsx($spreadsheet);
    $writer->save('test.xlsx'); */
  }

  function readDataMortalityRegister($file)
  {
    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
    $reader->setReadDataOnly(FALSE);
    $spreadsheet = $reader->load($file);
    $sheet = $spreadsheet->getSheet(0);
    $highestRow = $sheet->getHighestRow();
    for ($row = 9; $row <= $highestRow; $row++) {
      $cellValue = $spreadsheet->getActiveSheet()->getCell("A{$row}")->getValue();
      if ($cellValue) {
        $date = $spreadsheet->getActiveSheet()->getCell("D{$row}")->getValue();
        if ($date == 'N/A' || $date == 'n/a' || $date == '') {
          $resultDate = '';
        } else {
          $resultDate = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($date)->format('Y-m-d');
        }
        $earring = $spreadsheet->getActiveSheet()->getCell("B{$row}")->getValue();
        if ($earring == 'N/A' || $earring == 'n/a') {
          $earring = '';
        }
        $cause = $spreadsheet->getActiveSheet()->getCell("C{$row}")->getValue();
        if ($cause == 'N/A' || $cause == 'n/a') {
          $cause = '';
        }
        $comments = $spreadsheet->getActiveSheet()->getCell("E{$row}")->getValue();
        if ($comments == 'N/A' || $comments == 'n/a') {
          $comments = '';
        }
        yield array(
          'number' => $spreadsheet->getActiveSheet()->getCell("A{$row}")->getValue(),
          'earring' => $earring,
          'date_mortality' => $resultDate,
          'cause' => $cause,
          'comments' => $comments
        );
      }
    }
  }
  function importRegisterFormatMortalityExcel()
  {
    $file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    if (isset($_FILES['registerFormat']['name']) && in_array($_FILES['registerFormat']['type'], $file_mimes)) {
      $arr_file = explode('.', $_FILES['registerFormat']['name']);

      $file = $_FILES['registerFormat']['tmp_name'];
      $dataMortality = $this->readDataMortalityRegister($file);
      $created_user = $this->session->userdata('user_admin_sess')->fullname;
      $data = [];
      foreach ($dataMortality as $key => $value) {
        $data[] = array(
          'earring' => $value['earring'],
          'date_mortality' => $value['date_mortality'],
          'cause' => $value['cause'],
          'created_user' => $created_user,
          'comments' => $value['comments']
        );
      }
      $data_to_string = json_encode($data);
      $curl_request = curl_init(API_URL . 'mortality/api/mortality_excel');

      curl_setopt($curl_request, CURLOPT_CUSTOMREQUEST, "POST");
      curl_setopt($curl_request, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'x-api-key: QroSystem%21#'
      ));
      curl_setopt($curl_request, CURLOPT_RETURNTRANSFER, True);
      curl_setopt($curl_request, CURLOPT_POSTFIELDS, $data_to_string);
      $response = curl_exec($curl_request);

      if (!$response) {
        $response = json_encode(array(
          "status" => "error",
          "message" => curl_errno($curl_request)
        ));
        echo var_dump($response);
      }
      curl_close($curl_request);
      $response = json_decode($response);
    }
    redirect('mortality', 'refresh');
  }
}
