<?php
defined('BASEPATH') or exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Reports extends CI_Controller
{

  public function __construct()
  {
    parent::__construct();
    if (!$this->session->userdata('user_admin_sess')) {
      redirect('login');
    }
  }

  function animals()
  {
    $data['body'] = 'reports/animals_report';
    $this->load->view('layout/main', $data);
  }

  function weanings()
  {
    $data['body'] = 'reports/weanings_report';
    $this->load->view('layout/main', $data);
  }

  function births()
  {
    $data['body'] = 'reports/births_report';
    $this->load->view('layout/main', $data);
  }

  function mortality()
  {
    $data['body'] = 'reports/mortality_report';
    $this->load->view('layout/main', $data);
  }

  function eggProduction()
  {
    $data['rodeos'] = $this->getRodeos();
    $data['body'] = 'reports/egg_production_report';
    $this->load->view('layout/main', $data);
  }

  function ornamentalEggsCollection()
  {
    $data['body'] = 'reports/ornamental_eggs_collection_report';
    $this->load->view('layout/main', $data);
  }

  function ornamentalEggsIncubation()
  {
    $data['body'] = 'reports/ornamental_eggs_report_incubation';
    $this->load->view('layout/main', $data);
  }

  function motality_excel()
  {

    $specie_ = $this->input->post('specie');
    $start = $this->input->post('start');
    $end = $this->input->post('end');

    setlocale(LC_TIME, "es_MX.UTF8");
    $startDate = strftime('%d-%b-%y', strtotime($start));
    $endDate = strftime('%d-%b-%y', strtotime($end));

    $mortalities = $this->getMortalityData($specie_,  $start, $end);

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png');
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);

    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
    $sheet->mergeCells('A1:E4');
    $sheet->mergeCells('A5:D6');

    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

    $sheet->getStyle('A1')->getAlignment()->setVertical('center');

    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');

    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("E5:E6")->getFont()->setBold(true);

    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);

    $sheet->setCellValue('A1', 'Reporte de muerte de animales');
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(15);
    $sheet->getColumnDimension('C')->setWidth(30);
    $sheet->getColumnDimension('D')->setWidth(20);
    $sheet->getColumnDimension('E')->setWidth(35);

    $sheet->setCellValue('E5', 'Desde: ' . $startDate . ' Hasta: ' . $endDate);
    $sheet->setCellValue('E6', $specie_);
    $sheet->setCellValue('A8', 'N°');
    $sheet->setCellValue('B8', 'Arete');
    $sheet->setCellValue('C8', 'Fecha');
    $sheet->setCellValue('D8', 'Causa');
    $sheet->setCellValue('E8', 'Comentarios');
    $counter = 8;
    foreach ($mortalities as $i => $mortality) {
      $counter = $counter + 1;
      $i = $i + 1;
      $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->setCellValue("A{$counter}", $i);
      $sheet->setCellValue("B{$counter}", $mortality->earring);
      $sheet->setCellValue("C{$counter}", $mortality->date_mortality);
      $sheet->setCellValue("D{$counter}", $mortality->cause);
      $sheet->setCellValue("E{$counter}", $mortality->comments);
    }
    $writer = new Xlsx($spreadsheet);

    $filename = 'Reporte_de_muertes';

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
  }

  public function getMortalityData($specie, $start, $end)
  {


    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'mortality/api/mortalityReport/specie/' . $specie . '/desde/' . $start . '/hasta/' . $end,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    $mortalityD = json_decode($response);
    return $mortalityD->data;
  }
  public function mortality_pdf()
  {
    $specie_ = $this->input->post('specie');
    $start = $this->input->post('start');
    $end = $this->input->post('end');
    setlocale(LC_TIME, "es_MX.UTF8");
    $startDate = strftime('%d-%b-%y', strtotime($start));
    $endDate = strftime('%d-%b-%y', strtotime($end));

    $mortalityData = $this->getMortalityData($specie_,  $start, $end);


    $general_info = array(
      'begin' => $startDate,
      'end' => $endDate,
      'specie' => $specie_
    );

    $mpdf = new \Mpdf\Mpdf();
    $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
    $header = $this->load->view('reports/mortality/header', array('general_info' => $general_info), true);
    $mpdf->SetHTMLHeader($header);
    $footer = $this->load->view('reports/mortality/footer', [], true);
    $mpdf->SetHTMLFooter($footer);
    $html = $this->load->view('reports/mortality/body', array('mortalityData' => $mortalityData, 'general_info' => $general_info), true);
    $css = file_get_contents('assets/pdf-reports.css');
    $mpdf->SetTitle('Reporte de muertes');
    $mpdf->WriteHTML('<body>');
    $mpdf->WriteHTML($css, 1);
    $mpdf->WriteHTML($html);
    $mpdf->WriteHTML('</body>');
    $mpdf->Output('Reporte_de_muertes' . date("Ymd") . '.pdf', 'I');

    exit;
    $mpdf->Output();
  }

  public function animals_pdf()
  {
    $specie_ = $this->input->post('specie');
    $animals = $this->getAnimals($specie_);
    $status = $this->input->post('status_');
    $general_info = array(
      'specie' => $specie_,
      'status' => $status,
    );
    $mpdf = new \Mpdf\Mpdf();
    $mpdf = new \Mpdf\Mpdf(['orientation' => 'P']);
    $header = $this->load->view('reports/animals/header', array('general_info' => $general_info), true);
    $mpdf->SetHTMLHeader($header);
    $footer = $this->load->view('reports/animals/footer', [], true);
    $mpdf->SetHTMLFooter($footer);
    $html = $this->load->view('reports/animals/body', array('animals' => $animals, 'general_info' => $general_info), true);
    $css = file_get_contents('assets/pdf-reports.css');
    $mpdf->SetTitle('Reporte de animales');
    $mpdf->WriteHTML('<body>');
    $mpdf->WriteHTML($css, 1);
    $mpdf->WriteHTML($html);
    $mpdf->WriteHTML('</body>');
    $mpdf->Output('Reporte_de_animales' . date("Ymd") . '.pdf', 'I');

    exit;
    $mpdf->Output();
  }

  function getAnimals($specie)
  {

    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'animals/api/animForReport/specie/' . $specie,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    $animals = json_decode($response);
    return $animals->data;
  }
  function getWeight($earring)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'animal_weighing/api/animalForearring/earring/' . $earring,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $weaning = json_decode($response);
    return $weaning->data;
  }

  function animals_excel()
  {
    $specie_ = $this->input->post('specie');
    $animals = $this->getAnimals($specie_);
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png');
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);

    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
    $sheet->mergeCells('A1:J4');
    $sheet->mergeCells('A5:H6');
    $sheet->mergeCells('I5:J6');

    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

    $sheet->getStyle('A1')->getAlignment()->setVertical('center');

    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');

    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("E5:E6")->getFont()->setBold(true);

    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('H8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('I8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('J8')->applyFromArray($styleArray);

    $sheet->setCellValue('A1', 'Reporte de registro de animales');
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(15);
    $sheet->getColumnDimension('C')->setWidth(30);
    $sheet->getColumnDimension('D')->setWidth(30);
    $sheet->getColumnDimension('E')->setWidth(30);
    $sheet->getColumnDimension('F')->setWidth(15);
    $sheet->getColumnDimension('G')->setWidth(15);
    $sheet->getColumnDimension('H')->setWidth(30);
    $sheet->getColumnDimension('I')->setWidth(10);
    $sheet->getColumnDimension('J')->setWidth(20);


    $sheet->setCellValue('I5', $specie_);
    $sheet->setCellValue('A8', 'N.°');
    $sheet->setCellValue('B8', 'Arete/ID');
    $sheet->setCellValue('C8', 'Especie');
    $sheet->setCellValue('D8', 'Raza');
    $sheet->setCellValue('E8', 'Categoria');
    $sheet->setCellValue('F8', 'Genero');
    $sheet->setCellValue('G8', 'Fecha Nac.');
    $sheet->setCellValue('H8', 'Corral');
    $sheet->setCellValue('I8', 'Peso');
    $sheet->setCellValue('J8', 'Status');
    $counter = 8;
    foreach ($animals as $i => $animal) {
      $counter = $counter + 1;
      $i = $i + 1;
      $weight_ = $this->getWeight($animal->earring);
      if ($weight_) {
        $weig_ = $weight_->weight . ' kg';
        if ($weig_ >= 30) {
          $status_ = 'Buena';
        }
        if ($weig_ < 30 && $weig_ >= 25) {
          $status_ = 'Mediana';
        }

        if ($weig_ < 25) {
          $status_ = 'Deficiente';
        }
      } else {
        $weig_ = "";
        $stat = "N/A";
        $status_ = "";
      }

      $fechaT = strftime('%d-%m-%y', strtotime($animal->birth_date));
      $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("F{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("G{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("H{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("I{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("J{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->setCellValue("A{$counter}", $i);
      $sheet->setCellValue("B{$counter}", $animal->earring);
      $sheet->setCellValue("C{$counter}", $animal->specie);
      $sheet->setCellValue("D{$counter}", $animal->race);
      $sheet->setCellValue("E{$counter}", $animal->category_name);
      $sheet->setCellValue("F{$counter}", $animal->gender);
      $sheet->setCellValue("G{$counter}", $fechaT);
      $sheet->setCellValue("H{$counter}", $animal->rodeo_name);
      $sheet->setCellValue("I{$counter}", $weig_);
      $sheet->setCellValue("J{$counter}", $status_);
    }
    $writer = new Xlsx($spreadsheet);
    $filename = 'Reporte_de_animales';

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
  }

  function weanings_pdf()
  {
    $start = $this->input->post('start');
    $end = $this->input->post('end');
    setlocale(LC_TIME, 'spanish');
    $startDate = strftime('%d-%m-%Y', strtotime($start));
    $endDate = strftime('%d-%m-%Y', strtotime($end));
    $weanings = $this->getWeanings($start, $end);
    $general_info = array(
      'begin' => $startDate,
      'end' => $endDate
    );
    $mpdf = new \Mpdf\Mpdf();
    $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
    $header = $this->load->view('reports/weanings/header', array('general_info' => $general_info), true);
    $mpdf->SetHTMLHeader($header);
    $footer = $this->load->view('reports/weanings/footer', [], true);
    $mpdf->SetHTMLFooter($footer);
    $html = $this->load->view('reports/weanings/body', array('weanings' => $weanings, 'general_info' => $general_info), true);
    $css = file_get_contents('assets/pdf-reports.css');
    $mpdf->SetTitle('Reporte de destetes');
    $mpdf->WriteHTML('<body>');
    $mpdf->WriteHTML($css, 1);
    $mpdf->WriteHTML($html);
    $mpdf->WriteHTML('</body>');
    $mpdf->Output('Reporte_destetes' . date("Ymd") . '.pdf', 'I');

    exit;
    $mpdf->Output();
  }
  function getWeanings($desde, $hasta)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'weanings/api/weaningsForReport/desde/' . $desde . '/hasta/' . $hasta,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $weanings = json_decode($response);
    return $weanings->data;
  }

  function weanings_excel()
  {
    $start = $this->input->post('start');
    $end = $this->input->post('end');
    setlocale(LC_TIME, 'spanish');
    $startDate = strftime('%d-%m-%Y', strtotime($start));
    $endDate = strftime('%d-%m-%Y', strtotime($end));
    $weanings = $this->getWeanings($start, $end);
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png');
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);

    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
    $sheet->mergeCells('A1:J4');
    $sheet->mergeCells('A5:H6');
    $sheet->mergeCells('I5:J6');

    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

    $sheet->getStyle('A1')->getAlignment()->setVertical('center');

    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('I5')->getAlignment()->setWrapText(true);
    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("E5:E6")->getFont()->setBold(true);

    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);


    $sheet->setCellValue('A1', 'Reporte de destetes');
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(15);
    $sheet->getColumnDimension('C')->setWidth(10);
    $sheet->getColumnDimension('D')->setWidth(30);
    $sheet->getColumnDimension('E')->setWidth(30);
    $sheet->getColumnDimension('F')->setWidth(30);
    $sheet->getColumnDimension('G')->setWidth(15);


    $sheet->setCellValue('I5', "Desde: {$startDate} Hasta: {$endDate}");
    $sheet->setCellValue('A8', 'N.°');
    $sheet->setCellValue('B8', 'Arete');
    $sheet->setCellValue('C8', 'Fecha');
    $sheet->setCellValue('D8', 'Edad al destetar (Dias)');
    $sheet->setCellValue('E8', 'Peso al destetar');
    $sheet->setCellValue('F8', 'Ganancia de peso');
    $sheet->setCellValue('G8', 'Comentarios');

    $counter = 8;
    foreach ($weanings as $i => $weaning) {
      $counter = $counter + 1;
      $i = $i + 1;
      if ($weaning->comments == "" || $weaning->comments == null) {
        $observations = "---";
      } else {
        $observations = $weaning->comments;
      }
      if ($weaning->gdp == "" || $weaning->gdp == null || $weaning->gdp == 0) {
        $gdp = 0;
      } else {
        $gdp = $weaning->gdp;
      }
      $date = strftime('%d-%m-%Y', strtotime($weaning->date));

      $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("F{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("G{$counter}")->getAlignment()->setHorizontal('center');

      $sheet->setCellValue("A{$counter}", $i);
      $sheet->setCellValue("B{$counter}", $weaning->earring);
      $sheet->setCellValue("C{$counter}", $date);
      $sheet->setCellValue("D{$counter}", $weaning->weaning_age);
      $sheet->setCellValue("E{$counter}", $weaning->weaning_weight);
      $sheet->setCellValue("F{$counter}", $gdp);
      $sheet->setCellValue("G{$counter}", $observations);
    }
    $writer = new Xlsx($spreadsheet);
    $filename = 'Reporte_destetes';

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
  }
  function births_pdf()
  {
    $start = $this->input->post('start');
    $end = $this->input->post('end');
    setlocale(LC_TIME, 'spanish');
    $startDate = strftime('%d-%m-%Y', strtotime($start));
    $endDate = strftime('%d-%m-%Y', strtotime($end));
    if ($this->input->post('abortion')) {
      $births = $this->getAbortions($start, $end);
      $title = "Reporte de abortos";
      $doc_title = "Reporte_abortos";
    } else {
      $births = $this->getBirths($start, $end);
      $title = "Reporte de partos";
      $doc_title = "Reporte_partos";
    }

    $general_info = array(
      'begin' => $startDate,
      'end' => $endDate,
      'title' => $title
    );
    $mpdf = new \Mpdf\Mpdf();
    $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
    $header = $this->load->view('reports/births/header', array('general_info' => $general_info), true);
    $mpdf->SetHTMLHeader($header);
    $footer = $this->load->view('reports/births/footer', [], true);
    $mpdf->SetHTMLFooter($footer);
    $html = $this->load->view('reports/births/body', array('births' => $births, 'general_info' => $general_info), true);
    $css = file_get_contents('assets/pdf-reports.css');
    $mpdf->SetTitle($title);
    $mpdf->WriteHTML('<body>');
    $mpdf->WriteHTML($css, 1);
    $mpdf->WriteHTML($html);
    $mpdf->WriteHTML('</body>');
    $mpdf->Output($doc_title . date("Ymd") . '.pdf', 'I');

    exit;
    $mpdf->Output();
  }

  function getBirths($desde, $hasta)
  {

    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'births/api/birthsForReport/desde/' . $desde . '/hasta/' . $hasta,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);


    $birthsReport = json_decode($response);
    return $birthsReport->data;
  }
  function getAbortions($desde_, $hasta_)
  {


    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'births/api/birthsForReportAbort/desde/' . $desde_ . '/hasta/' . $hasta_,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $abortions = json_decode($response);
    return $abortions->data;
  }
  function births_excel()
  {
    $start = $this->input->post('start');
    $end = $this->input->post('end');
    setlocale(LC_TIME, 'spanish');
    $startDate = strftime('%d-%m-%Y', strtotime($start));
    $endDate = strftime('%d-%m-%Y', strtotime($end));
    if ($this->input->post('abortion')) {
      $births = $this->getAbortions($start, $end);
      $title = "Reporte de abortos";
      $doc_title = "Reporte_abortos";
    } else {
      $births = $this->getBirths($start, $end);
      $title = "Reporte de partos";
      $doc_title = "Reporte_partos";
    }

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png');
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);

    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
    $sheet->mergeCells('A1:J4');
    $sheet->mergeCells('A5:H6');
    $sheet->mergeCells('I5:J6');

    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

    $sheet->getStyle('A1')->getAlignment()->setVertical('center');

    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('I5')->getAlignment()->setWrapText(true);
    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("E5:E6")->getFont()->setBold(true);

    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('H8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('I8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('J8')->applyFromArray($styleArray);

    $sheet->setCellValue('A1', $title);
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(15);
    $sheet->getColumnDimension('C')->setWidth(30);
    $sheet->getColumnDimension('D')->setWidth(30);
    $sheet->getColumnDimension('E')->setWidth(30);
    $sheet->getColumnDimension('F')->setWidth(15);
    $sheet->getColumnDimension('G')->setWidth(15);
    $sheet->getColumnDimension('H')->setWidth(30);
    $sheet->getColumnDimension('I')->setWidth(10);
    $sheet->getColumnDimension('J')->setWidth(20);


    $sheet->setCellValue('I5', "Desde: {$startDate} Hasta: {$endDate}");
    $sheet->setCellValue('A8', 'N.°');
    $sheet->setCellValue('B8', 'Arete');
    $sheet->setCellValue('C8', 'Corral');
    $sheet->setCellValue('D8', 'Fecha de parto/aborto');
    $sheet->setCellValue('E8', 'Aborto');
    $sheet->setCellValue('F8', 'Muertes');
    $sheet->setCellValue('G8', 'Hembras');
    $sheet->setCellValue('H8', 'Machos');
    $sheet->setCellValue('I8', 'Causa');
    $sheet->setCellValue('J8', 'Comentarios');
    $counter = 8;
    foreach ($births as $i => $birth) {
      $counter = $counter + 1;
      $i = $i + 1;
      if ($birth->cause == "") {
        $cause = "N/A";
      } else {
        $cause = $birth->cause;
      }
      if ($birth->abortions == 1) {
        $abortion = "Si";
      } else {
        $abortion = "No";
      }

      $i = $i + 1;
      setlocale(LC_TIME, 'spanish');
      $fechaT = strftime('%d-%m-%Y', strtotime($birth->date_birth));

      $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("F{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("G{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("H{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("I{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("J{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->setCellValue("A{$counter}", $i);
      $sheet->setCellValue("B{$counter}", $birth->earring);
      $sheet->setCellValue("C{$counter}", $birth->name_rodeo);
      $sheet->setCellValue("D{$counter}", $fechaT);
      $sheet->setCellValue("E{$counter}", $abortion);
      $sheet->setCellValue("F{$counter}", $birth->dead);
      $sheet->setCellValue("G{$counter}", $birth->females);
      $sheet->setCellValue("H{$counter}", $birth->males);
      $sheet->setCellValue("I{$counter}", $cause);
      $sheet->setCellValue("J{$counter}", $birth->comments);
    }
    $writer = new Xlsx($spreadsheet);
    $filename = $doc_title;

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
  }

  function getRodeos()
  {
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'rodeos/api/rodeos',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);
    curl_close($curl);
    $rodeos = json_decode($response);
    return $rodeos->data;
  }

  function getEggsProductionReport($start, $end, $rodeo)
  {

    $curl = curl_init();

    curl_setopt_array($curl, [
      CURLOPT_URL => API_URL . "eggs_production/api/report_egg_production/start/{$start}/end/{$end}/rodeo/{$rodeo}",
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "GET",
      CURLOPT_POSTFIELDS => "",
      CURLOPT_HTTPHEADER => [
        "x-api-key: QroSystem%21#"
      ],
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    if ($err) {
      echo "cURL Error #:" . $err;
    } else {
      $production = json_decode($response);
      return $production->data;
    }
  }
  function eggs_production_pdf()
  {
    $rodeo = $this->input->post('rodeo');
    $status_eggs = $this->input->post('status');
    $start_date = $this->input->post('start');
    $end_date = $this->input->post('end');

    $productionData = $this->getEggsProductionReport($start_date, $end_date, $rodeo);
    if ($rodeo == 'all') {
      $rodeo_name = '';
    } else {
      $rodeo_name = $productionData[0]->rodeo_name;
    }
    $general_info = array(
      'begin' => $start_date,
      'end' => $end_date,
      'rodeo_name' => $rodeo_name,
      'rodeo' => $rodeo,
      'status' => $status_eggs
    );
    $mpdf = new \Mpdf\Mpdf();
    $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
    $header = $this->load->view('reports/eggs_production/header', array('general_info' => $general_info), true);
    $mpdf->SetHTMLHeader($header);
    $footer = $this->load->view('reports/eggs_production/footer', [], true);
    $mpdf->SetHTMLFooter($footer);
    $html = $this->load->view('reports/eggs_production/body', array('productionData' => $productionData, 'general_info' => $general_info), true);
    $css = file_get_contents('assets/pdf-reports.css');
    $mpdf->WriteHTML('<body>');
    $mpdf->WriteHTML($css, 1);
    $mpdf->WriteHTML($html);
    $mpdf->WriteHTML('</body>');

    $mpdf->Output();
  }

  function eggs_production_excel()
  {
    $rodeo = $this->input->post('rodeo');
    $status_eggs = $this->input->post('status');
    $start_date = $this->input->post('start');
    $end_date = $this->input->post('end');

    $productionData = $this->getEggsProductionReport($start_date, $end_date, $rodeo);
    if ($rodeo == 'all') {
      $rodeo_name = '';
    } else {
      $rodeo_name = $productionData[0]->rodeo_name;
    }
    $general_info = array(
      'begin' => $start_date,
      'end' => $end_date,
      'rodeo_name' => $rodeo_name,
      'rodeo' => $rodeo,
      'status' => $status_eggs
    );

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png');
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);

    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);

    $sheet->mergeCells('A1:R4');
    $sheet->mergeCells('A5:Q6');
    $sheet->mergeCells('A8:A10');
    $sheet->mergeCells('B8:B10');
    $sheet->mergeCells('C8:N8');
    $sheet->mergeCells('C9:D9');
    $sheet->mergeCells('E9:F9');
    $sheet->mergeCells('G9:H9');
    $sheet->mergeCells('I9:J9');
    $sheet->mergeCells('K9:L9');
    $sheet->mergeCells('M9:N9');
    $sheet->mergeCells('O8:P9');
    $sheet->mergeCells('Q8:Q10');
    $sheet->mergeCells('R8:R10');


    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

    $sheet->getStyle('A1')->getAlignment()->setVertical('center');
    $sheet->getStyle('O8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('O8')->getAlignment()->setVertical('center');
    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A8')->getAlignment()->setVertical('center');
    $sheet->getStyle('A8')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('B8')->getAlignment()->setVertical('center');
    $sheet->getStyle('B8')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('Q8')->getAlignment()->setVertical('center');
    $sheet->getStyle('Q8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('R8')->getAlignment()->setVertical('center');
    $sheet->getStyle('R8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('E5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A8:P10')->getAlignment()->setHorizontal('center');

    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:R10")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("E5:E6")->getFont()->setBold(true);

    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('A10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('H8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('I8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('J8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('K8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('L8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('M8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('N8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('O8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('P8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('Q8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('R8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('A9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('H10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('I10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('J10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('K10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('L10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('M10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('N10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('H9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('I9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('J9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('K9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('L9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('M9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('N9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('O9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('P9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('O10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('P10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('Q9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('R9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('Q10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('R10')->applyFromArray($styleArray);
    $sheet->setCellValue('A1', 'Reporte de producción de huevo');
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(15);
    $sheet->getColumnDimension('Q')->setWidth(35);
    $sheet->getColumnDimension('R')->setWidth(35);

    $sheet->setCellValue('R5', 'Desde: ' . $general_info['begin']);
    $sheet->setCellValue('R6', 'Hasta: ' . $general_info['end']);

    $sheet->setCellValue('B8', 'Fecha');
    $sheet->setCellValue('A8', 'N.°');
    $sheet->setCellValue('B8', 'Fecha');
    $sheet->setCellValue('C8', 'Huevo');
    $sheet->setCellValue('C9', 'Chico');
    $sheet->setCellValue('C10', 'KG');
    $sheet->setCellValue('D10', 'PZ');
    $sheet->setCellValue('E10', 'KG');
    $sheet->setCellValue('F10', 'PZ');
    $sheet->setCellValue('G10', 'KG');
    $sheet->setCellValue('H10', 'PZ');
    $sheet->setCellValue('I10', 'KG');
    $sheet->setCellValue('J10', 'PZ');
    $sheet->setCellValue('K10', 'KG');
    $sheet->setCellValue('L10', 'PZ');
    $sheet->setCellValue('M10', 'KG');
    $sheet->setCellValue('N10', 'PZ');
    $sheet->setCellValue('E9', 'Mediano');
    $sheet->setCellValue('G9', 'Grande');
    $sheet->setCellValue('I9', 'Extra Grande');
    $sheet->setCellValue('K9', 'Jumbo');
    $sheet->setCellValue('M9', 'Quebrado');
    $sheet->setCellValue('O8', 'Total producción');
    $sheet->setCellValue('O10', 'KG');
    $sheet->setCellValue('P10', 'PZ');
    $sheet->setCellValue('Q8', 'Responsable');
    $sheet->setCellValue('R8', 'Observaciones');
    $counter = 10;
    foreach ($productionData as $i => $production) {
      $counter = $counter + 1;
      $i = $i + 1;
      $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("F{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("G{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("H{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("I{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("J{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("K{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("L{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("M{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("O{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("P{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("Q{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("R{$counter}")->getAlignment()->setHorizontal('center');

      $sheet->setCellValue("A{$counter}", $i);
      $sheet->setCellValue("B{$counter}", $production->date_productions);
      $sheet->setCellValue("C{$counter}", number_format($production->chico_kg, 2, '.', ','));
      $sheet->setCellValue("D{$counter}", $production->chico_pz);
      $sheet->setCellValue("E{$counter}", number_format($production->mediano_kg, 2, '.', ','));
      $sheet->setCellValue("F{$counter}", $production->mediano_pz);
      $sheet->setCellValue("G{$counter}", number_format($production->grande_kg, 2, '.', ','));
      $sheet->setCellValue("H{$counter}", $production->grande_pz);
      $sheet->setCellValue("I{$counter}", number_format($production->extra_grande_kg, 2, '.', ','));
      $sheet->setCellValue("J{$counter}", $production->extra_grande_pz);
      $sheet->setCellValue("K{$counter}", number_format($production->jumbo_kg, 2, '.', ','));
      $sheet->setCellValue("L{$counter}", $production->jumbo_pz);
      $sheet->setCellValue("M{$counter}", number_format($production->quebrado_kg, 2, '.', ','));
      $sheet->setCellValue("N{$counter}", $production->quebrado_pz);
      $sheet->setCellValue("O{$counter}", number_format($production->total_kg, 2, '.', ','));
      $sheet->setCellValue("P{$counter}", $production->total_pz);
      $sheet->setCellValue("Q{$counter}", $production->responsible);
      $sheet->setCellValue("R{$counter}", $production->comments);
    }
    $writer = new Xlsx($spreadsheet);

    $filename = 'Reporte_de_produccion_huevo';

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
    /*     $writer = new Xlsx($spreadsheet);
    $writer->save('test.xlsx'); */
  }

  function ornamental_eggs_collection_pdf()
  {
    $start = $this->input->post('start');
    $end = $this->input->post('end');
    setlocale(LC_TIME, 'spanish');
    $startDate = strftime('%d-%m-%Y', strtotime($start));
    $endDate = strftime('%d-%m-%Y', strtotime($end));
    $ornamentalEgg = $this->ornamentalEggForReport($start, $end);
    $general_info = array(
      'begin' => $startDate,
      'end' => $endDate
    );
    $mpdf = new \Mpdf\Mpdf();
    $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
    $header = $this->load->view('reports/ornamentalEgg/header', array('general_info' => $general_info), true);
    $mpdf->SetHTMLHeader($header);
    $footer = $this->load->view('reports/ornamentalEgg/footer', [], true);
    $mpdf->SetHTMLFooter($footer);
    $html = $this->load->view('reports/ornamentalEgg/body', array('ornamentales' => $ornamentalEgg, 'general_info' => $general_info), true);
    $css = file_get_contents('assets/pdf-reports.css');
    $mpdf->SetTitle('Reporte de destetes');
    $mpdf->WriteHTML('<body>');
    $mpdf->WriteHTML($css, 1);
    $mpdf->WriteHTML($html);
    $mpdf->WriteHTML('</body>');
    $mpdf->Output('Reporte_aves_ornamentales' . date("Ymd") . '.pdf', 'I');

    exit;
    $mpdf->Output();
  }

  function ornamentalEggForReport($desde, $hasta)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'ornamental_egg/api/ornamentalEggForReport/desde/' . $desde . '/hasta/' . $hasta,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    $ornamentalForReport = json_decode($response);
    return $ornamentalForReport->data;
  }




  function ornamental_eggs_collection_excel()
  {
    $start = $this->input->post('start');
    $end = $this->input->post('end');
    setlocale(LC_TIME, 'spanish');
    $startDate = strftime('%d-%m-%Y', strtotime($start));
    $endDate = strftime('%d-%m-%Y', strtotime($end));
    $ornamentalesEgg = $this->ornamentalEggForReport($start, $end);
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png');
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);

    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
    $sheet->mergeCells('A1:J4');
    $sheet->mergeCells('A5:H6');
    $sheet->mergeCells('I5:J6');

    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

    $sheet->getStyle('A1')->getAlignment()->setVertical('center');

    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('I5')->getAlignment()->setWrapText(true);
    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("E5:E6")->getFont()->setBold(true);

    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('H8')->applyFromArray($styleArray);


    $sheet->setCellValue('A1', 'Huevo de aves ornamentales (Recolección)');
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(30);
    $sheet->getColumnDimension('C')->setWidth(30);
    $sheet->getColumnDimension('D')->setWidth(30);
    $sheet->getColumnDimension('E')->setWidth(30);
    $sheet->getColumnDimension('F')->setWidth(30);
    $sheet->getColumnDimension('G')->setWidth(30);
    $sheet->getColumnDimension('H')->setWidth(35);
    $sheet->getColumnDimension('I')->setWidth(30);


    $sheet->setCellValue('I5', "Desde: {$startDate} Hasta: {$endDate}");
    $sheet->setCellValue('A8', 'N.°');
    $sheet->setCellValue('B8', 'Fecha de recolección');
    $sheet->setCellValue('C8', 'Arete nadre');
    $sheet->setCellValue('D8', 'Peso del huevo (s)');
    $sheet->setCellValue('E8', 'Número de huevos');
    $sheet->setCellValue('F8', 'Especie');
    $sheet->setCellValue('G8', 'Lugar de recolección');
    $sheet->setCellValue('H8', 'Observaciones');

    $counter = 8;
    foreach ($ornamentalesEgg as $i => $ornamental) {
      $counter = $counter + 1;

      $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("F{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("G{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("H{$counter}")->getAlignment()->setHorizontal('center');


      $sheet->setCellValue("A{$counter}", $i);
      $sheet->setCellValue("B{$counter}", $ornamental->collection_date);
      $sheet->setCellValue("C{$counter}", $ornamental->mother_earring);
      $sheet->setCellValue("D{$counter}", $ornamental->egg_weight);
      $sheet->setCellValue("E{$counter}", $ornamental->total_eggs);
      $sheet->setCellValue("F{$counter}", $ornamental->specie);
      $sheet->setCellValue("G{$counter}", $ornamental->collection_location);
      $sheet->setCellValue("H{$counter}", $ornamental->comment);
    }
    $writer = new Xlsx($spreadsheet);
    $filename = 'Reporte_aves_ornamentales';

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
  }

  function ornamental_eggs_incubation_pdf()
  {
    $start = $this->input->post('start');
    $end = $this->input->post('end');
    setlocale(LC_TIME, 'spanish');
    $startDate = strftime('%d-%m-%Y', strtotime($start));
    $endDate = strftime('%d-%m-%Y', strtotime($end));
    $ornamental = $this->getOrnamentalInfo($start, $end);
    $general_info = array(
      'begin' => $startDate,
      'end' => $endDate
    );
    $mpdf = new \Mpdf\Mpdf();
    $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
    $header = $this->load->view('reports/ornamental/header', array('general_info' => $general_info), true);
    $mpdf->SetHTMLHeader($header);
    $footer = $this->load->view('reports/ornamental/footer', [], true);
    $mpdf->SetHTMLFooter($footer);
    $html = $this->load->view('reports/ornamental/body', array('ornamentales' => $ornamental, 'general_info' => $general_info), true);
    $css = file_get_contents('assets/pdf-reports.css');
    $mpdf->SetTitle('Reporte de destetes');
    $mpdf->WriteHTML('<body>');
    $mpdf->WriteHTML($css, 1);
    $mpdf->WriteHTML($html);
    $mpdf->WriteHTML('</body>');
    $mpdf->Output('Reporte_aves_ornamentales' . date("Ymd") . '.pdf', 'I');

    exit;
    $mpdf->Output();
  }

  function getOrnamentalInfo($desde, $hasta)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'ornamental_birds/api/ornamentalForReport/desde/' . $desde . '/hasta/' . $hasta,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $ornamental = json_decode($response);
    return $ornamental->data;
  }

  function ornamental_eggs_incubation_excel()
  {
    $start = $this->input->post('start');
    $end = $this->input->post('end');
    setlocale(LC_TIME, 'spanish');
    $startDate = strftime('%d-%m-%Y', strtotime($start));
    $endDate = strftime('%d-%m-%Y', strtotime($end));
    $ornamentales = $this->getOrnamentalInfo($start, $end);
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png');
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);

    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
    $sheet->mergeCells('A1:J4');
    $sheet->mergeCells('A5:H6');
    $sheet->mergeCells('I5:J6');

    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

    $sheet->getStyle('A1')->getAlignment()->setVertical('center');

    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('I5')->getAlignment()->setWrapText(true);
    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("E5:E6")->getFont()->setBold(true);

    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('H8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('I8')->applyFromArray($styleArray);


    $sheet->setCellValue('A1', 'Huevo de aves ornamentales');
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(30);
    $sheet->getColumnDimension('C')->setWidth(30);
    $sheet->getColumnDimension('D')->setWidth(30);
    $sheet->getColumnDimension('E')->setWidth(30);
    $sheet->getColumnDimension('F')->setWidth(30);
    $sheet->getColumnDimension('G')->setWidth(30);
    $sheet->getColumnDimension('H')->setWidth(35);
    $sheet->getColumnDimension('I')->setWidth(30);


    $sheet->setCellValue('I5', "Desde: {$startDate} Hasta: {$endDate}");
    $sheet->setCellValue('A8', 'N.°');
    $sheet->setCellValue('B8', 'Inicio de incubacion');
    $sheet->setCellValue('C8', 'Número de huevos');
    $sheet->setCellValue('D8', 'Ave procedencia de huevo (ID)');
    $sheet->setCellValue('E8', 'Número de nido');
    $sheet->setCellValue('F8', 'Ave en nido (ID)');
    $sheet->setCellValue('G8', 'Fecha de nacimiento');
    $sheet->setCellValue('H8', 'Número de huevos empollados');
    $sheet->setCellValue('I8', 'Número de huevos NO incubados');

    $counter = 8;
    foreach ($ornamentales as $i => $ornamental) {
      $counter = $counter + 1;

      $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("F{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("G{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("H{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("I{$counter}")->getAlignment()->setHorizontal('center');

      $sheet->setCellValue("A{$counter}", $i);
      $sheet->setCellValue("B{$counter}", $ornamental->start_date);
      $sheet->setCellValue("C{$counter}", $ornamental->number_egg);
      $sheet->setCellValue("D{$counter}", $ornamental->bird_origin);
      $sheet->setCellValue("E{$counter}", $ornamental->nest_number);
      $sheet->setCellValue("F{$counter}", $ornamental->bird_in_nest);
      $sheet->setCellValue("G{$counter}", $ornamental->date_birth);
      $sheet->setCellValue("H{$counter}", $ornamental->number_hatched_eggs);
      $sheet->setCellValue("I{$counter}", $ornamental->non_incubated_eggs);
    }
    $writer = new Xlsx($spreadsheet);
    $filename = 'Reporte_aves_ornamentales';

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
  }
}
