<?php
defined('BASEPATH') or exit('No direct script access allowed');


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Sales extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if (!$this->session->userdata('user_admin_sess')) {
            redirect('login');
        }
    }


    public function index()
    {
        $data['body'] = 'sales/sales';
        $data['animals'] = $this->sales_get();
        $this->load->view('layout/main', $data);
    }


    function sales_get()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL.'sales/api/sales',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_POSTFIELDS => '{
        "name_config": "Destete",
        "value": "30"
    }',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        // echo $response;
        $sales = json_decode($response);
        return $sales->data;
    }

    function sales_add()
    {
        // $earring = $this->input->post('earring');

        $earring = explode(",", $_POST['earring']);

        $date_sold = $this->input->post('date_sold');

        foreach ($earring as $earring) {
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => API_URL . 'sales/api/sales',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => '{
                "earring": "' . $earring . '",
                "date_sold": "' . $date_sold . '"
                 }',
                CURLOPT_HTTPHEADER => array(
                    'x-api-key: QroSystem%21#',
                    'Content-Type: application/json'
                ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);
            echo $response;
        }
       redirect('sales');
    }

    public function exportRegisterExcel()
    {
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);
        $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
        $drawing->setName('Logo');
        $drawing->setDescription('Logo');
        $drawing->setPath('assets/img/logo.png');
        $drawing->setCoordinates('A1');
        $drawing->setWidthAndHeight(75, 75);
        $drawing->getShadow()->setVisible(false);
        $drawing->getShadow()->setDirection(0);
        $drawing->setWorksheet($spreadsheet->getActiveSheet());
        $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
        $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
        $sheet->mergeCells('A1:K4');
        $sheet->mergeCells('A5:K6');
        $sheet->mergeCells('L1:S1');
        $sheet->mergeCells('L2:S2');
        $sheet->mergeCells('L3:S3');
        $sheet->mergeCells('L4:S4');
        $sheet->mergeCells('L5:S6');
        $sheet->mergeCells('L7:S7');
        $sheet->mergeCells('L8:S8');
        $sheet->mergeCells('L9:S9');
        $sheet->mergeCells('I8:K8');
        $sheet->mergeCells('I9:K11');
        $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
        $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);
        $sheet->getStyle('I9')->getAlignment()->setVertical('center');
        $sheet->getStyle('I8')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('I9')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('A1')->getAlignment()->setVertical('center');
        $sheet->getStyle('L1')->getAlignment()->setVertical('center');
        $sheet->getStyle('L1')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('L2')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('L2')->getAlignment()->setVertical('center');
        $sheet->getStyle('L2:L6')->getAlignment()->setWrapText(true);
        $sheet->getStyle('A5')->getAlignment()->setVertical('center');
        $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('I9:K11')->getAlignment()->setWrapText(true);
        $sheet->getStyle('H6')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('A7:K7')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('A8:K8')->getAlignment()->setHorizontal('center');

        $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("L1")->getFont()->setSize(14)->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A8:K8")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("F8")->getFont()->setBold(true);

        $styleArray = [
            'borders' => [
                'outline' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
                'right' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
                'left' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
            ],
        ];
        $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
        

        $sheet->setCellValue('A1', 'Formato de registro de ventas');
        $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
        $sheet->getColumnDimension('A')->setWidth(10);
        $sheet->getColumnDimension('B')->setWidth(15);
        $sheet->getColumnDimension('C')->setWidth(12);
        $sheet->getColumnDimension('D')->setWidth(20);
        $sheet->getColumnDimension('E')->setWidth(10);
        $sheet->getColumnDimension('F')->setWidth(10);
        $sheet->getColumnDimension('G')->setWidth(10);
        $sheet->getColumnDimension('H')->setWidth(35);

        $sheet->setCellValue('L1', 'Instrucciones de uso');
        $sheet->setCellValue('L2', 'Todos los campos deben ser llenados de forma correcta, para ello se debe considerar lo siguiente:');
        
        $sheet->setCellValue('L3', '2.- Arete: Ingresar el arete del animal');
       
        $sheet->setCellValue('C7', 'DD/MM/AAAA');

        $spreadsheet->getActiveSheet()->getStyle("L1:S5")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('ffff00');
       

     

        $sheet->setCellValue('A8', 'N.°');
        $sheet->setCellValue('B8', 'Arete');
     
        $sheet->setCellValue('C8', 'Fecha');
        
        $sheet->setCellValue('A9', 1);

        $writer = new Xlsx($spreadsheet);

        $filename = 'formato_registro_partos';

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
    }

    function importRegisterFormatSalesExcel()
    {
        $file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        if (isset($_FILES['registerFormat']['name']) && in_array($_FILES['registerFormat']['type'], $file_mimes)) {
            $arr_file = explode('.', $_FILES['registerFormat']['name']);
            $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
            $reader->setReadDataOnly(FALSE);
            $spreadsheet = $reader->load($_FILES['registerFormat']['tmp_name']);
            $sheet = $spreadsheet->getSheet(0);
            $highestRow = $sheet->getHighestRow();
            $highestColumn = 'H';
            $rowData = [];
            $dataSales = [];
            for ($row = 9; $row <= $highestRow; $row++) {
                $cellValue = $spreadsheet->getActiveSheet()->getCell("A{$row}")->getValue();
                if ($cellValue) {
                    $date = $spreadsheet->getActiveSheet()->getCell("C{$row}")->getValue();
                    if ($date == 'N/A' || $date == 'n/a' || $date == '') {
                        $resultDate = '';
                    } else {
                        $resultDate = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($date)->format('Y-m-d');
                    }
                    $earring = $spreadsheet->getActiveSheet()->getCell("B{$row}")->getValue();
                    if ($earring == 'N/A' || $earring == 'n/a') {
                        $earring = '';
                    }

                    $dataSales[] = array(
                        'number' => $spreadsheet->getActiveSheet()->getCell("A{$row}")->getValue(),
                        'earring' => $earring,
                        'date_birth' => $resultDate,
                       
                    );
                }
            }
            $created_user = $this->session->userdata('user_admin_sess')->fullname;
            foreach ($dataSales as $key => $value) {
                $data = array(
                    'earring' => $value['earring'],
                    'date_sold' => $value['date_birth'],
                    
                );
                $data_to_string = json_encode($data);
                $curl_request = curl_init(API_URL . 'sales/api/sales');

                curl_setopt($curl_request, CURLOPT_CUSTOMREQUEST, "POST");
                curl_setopt($curl_request, CURLOPT_HTTPHEADER, array(
                    'Content-Type: application/json',
                    'x-api-key: QroSystem%21#'
                ));
                curl_setopt($curl_request, CURLOPT_RETURNTRANSFER, True);
                curl_setopt($curl_request, CURLOPT_POSTFIELDS, $data_to_string);
                $response = curl_exec($curl_request);

                if (!$response) {
                    $response = json_encode(array(
                        "status" => "error",
                        "message" => curl_errno($curl_request)
                    ));
                    echo var_dump($response);
                }
                curl_close($curl_request);
                $response = json_decode($response);
            }
        }
        if ($response->status == 'error') {
            $this->session->set_flashdata('error', array('message' => $response->message, 'validations' => $response->validations));
            redirect('sales', 'refresh');
        } else {
            redirect('sales', 'refresh');
        }
    }


}
