<?php
defined('BASEPATH') or exit('No direct script access allowed');


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Treatment extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if (!$this->session->userdata('user_admin_sess')) {
            redirect('login');
        }
    }

    public function index()
    {
        $data['body'] = 'treatments/list';
        $data['treatments'] = $this->getTreatments();
        $data['caninos'] = $this->getCaninos();
        $data['animals'] = $this->getAnimals();
        $this->load->view('layout/main', $data);
    }




    function getCaninos()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'animals/api/animalsCaninos',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $caninos = json_decode($response);
        return $caninos->data;
    }

    function getTreatments()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'treatments/api/treatments',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $treatments = json_decode($response);
        return $treatments->data;
    }

    function getTreatmentById($treatment_id)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'treatments/api/treatments/id/' . $treatment_id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));
        $response = curl_exec($curl);

        curl_close($curl);
        $treatment = json_decode($response);
        $this->session->set_flashdata('treatment_details', array('data' => $treatment->data));
        redirect('treatment');
    }

    function getAnimals()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'animals/api/animals',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $animals = json_decode($response);
        return $animals->data;
    }


    function getAnimalsByIdTreatmen($id_treatment_)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'treatments/api/animalstreatments/id/' . $id_treatment_,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $getanimalTreatment = json_decode($response);
        $this->session->set_flashdata('animaltreatment_', array('data' => $getanimalTreatment->data));
        redirect('treatment');
        
    }

    function getAnimalForEdit($idAnimal_)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL.'treatments/api/animalstreatments/idAnimal/'. $idAnimal_,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $getAnimalForEdit = json_decode($response);
        $this->session->set_flashdata('animaltreatment_details', array('data' => $getAnimalForEdit->data));
        redirect('treatment');
    }

    function getTreatmenForReport($earring, $desde, $hasta)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'treatments/api/treatmentsForearring/earring/' . $earring . '/desde/' . $desde . '/hasta/' . $hasta,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $treatment_ = json_decode($response);
        return $treatment_->data;
    }


    public function treatment_report()
    {
        $earring = $this->input->post('earring');
        $desde_ = $this->input->post('desde');
        $hasta_ = $this->input->post('hasta');
        $treatment_ = $this->getTreatmenForReport($earring, $desde_, $hasta_);
        $mpdf = new \Mpdf\Mpdf();
        $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $mpdf->SetHTMLHeader('
          <table class="normal" width="100%">
          <tr>
              <td width="33%"> <img src="' . base_url() . 'assets/img/logo.jpg" width="95" height="95"> </td>
              <td width="33%" align="center"><h1>Rancho El Arenal</h1></td>
              <td width="33%" style="text-align: right;"><h4>Reporte de tratamientos del animal con el arete: ' . $earring . '</h4> </td>
          </tr>
      </table>');
        $mpdf->SetHTMLFooter('
          <table class="normal" width="100%">
          <tr>
              <td width="33%"></td>
              <td width="33%" align="center">{PAGENO}/{nbpg}</td>
              <td width="33%" style="text-align: right;"> {DATE j-m-Y}</td>
          </tr>
      </table>        ');
        $html = '	
          <table width="100%" class="table table-bordered">
               <thead>
               <tr class="thead">
                <th scope="col">N°</th>
                <th scope="col">Nombre del tratamiento</th>        
                <th scope="col">Fecha de inicio</th>
                <th scope="col">Fecha de fin</th>
                <th scope="col">Duracion</th>
                <th scope="col">Responsable</th> 
                <th scope="col">Comentarios </th>       
               
        
                </thead>                   
          ';
        $html .= '<tbody>';

        foreach ($treatment_ as $i => $treatment_) {
            $i = $i + 1;
            setlocale(LC_TIME, 'spanish');
            $html .= '<tr>'
                . '<td>' . $i . '</td>'
                . '<td>' . $treatment_->treatment . '</td>'
                . '<td>' . $treatment_->start_date . '</td>'
                . '<td>' . $treatment_->end_date . '</td>'
                . '<td>' . $treatment_->duration . ' Días</td>'
                . '<td>' . $treatment_->responsible . '</td>'
                . '<td>' . $treatment_->comment . '</td>';
        }
        $html .= '<tr>
                  </tr>
                  </tbody> 
                  
                  </table>
                  ';
        $data = '';
        $data .= '
          <style>
              h1 {
              }
          </style>';
        $data .= '<img width = "10" src = "assets/img/logo.jpg>';
        $css = file_get_contents('assets/pdf-reports.css');
        /* Impresion y salida del documento */
        $mpdf->WriteHTML($data);
        /*   $mpdf->Image('assets/img/logo.jpg', 20, 0, 30, 30, 'jpg', '', true, false); */
        $mpdf->SetTitle('Reporte de tratamientos');
        $mpdf->WriteHTML('<body>');
        $mpdf->writeHTML($css, 1);
        $mpdf->WriteHTML($html);
        $mpdf->WriteHTML('</body>');
        $mpdf->Output('Reporte_de_tratamientos.pdf', 'I');
        $mpdf->setFooter('{PAGENO}');

        $mpdf->WriteHTML('Section 1');
        $mpdf->WriteHTML('');

        exit;
        $mpdf->Output();
    }

    public function treatmentReport_excel()
    {

        $earring = $this->input->post('earring');
        $desde_ = $this->input->post('desde');
        $hasta_ = $this->input->post('hasta');
        $treatment_ = $this->getTreatmenForReport($earring, $desde_, $hasta_);

        setlocale(LC_TIME, 'spanish');
        $dateDesde = strftime('%d-%b-%y', strtotime($desde_));
        $dateHasta = strftime('%d-%b-%y', strtotime($hasta_));
      
        $contador1 = 1;
        $contador = 3;
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->getColumnDimension('A')->setWidth(10);
        $sheet->getColumnDimension('B')->setWidth(35);
        $sheet->getColumnDimension('C')->setWidth(16);
        $sheet->getColumnDimension('D')->setWidth(25);
        $sheet->getColumnDimension('E')->setWidth(25);
        $sheet->getColumnDimension('F')->setWidth(25);
        $sheet->getColumnDimension('G')->setWidth(25);
        $sheet->getStyle("B{$contador1}")->getFont()->setBold(true);
        $sheet->getStyle("E{$contador1}")->getFont()->setBold(true);
        $sheet->getStyle("A{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("B{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("C{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("D{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("E{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("F{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("G{$contador}")->getFont()->setBold(true);
        $sheet->mergeCells("B{$contador1}" . ":C{$contador1}");
        $sheet->setCellValue("B{$contador1}", 'Reporte de muertes');
        $sheet->setCellValue("E{$contador1}", 'Del:' . $dateDesde . ' Al:' . $dateHasta);
        $sheet->setCellValue("A{$contador}", 'N°');
        $sheet->setCellValue("B{$contador}", 'Nombre del tratamient');
        $sheet->setCellValue("C{$contador}", 'Fecha de inicio');
        $sheet->setCellValue("D{$contador}", 'Fecha de fin');
        $sheet->setCellValue("E{$contador}", 'Duracion');
        $sheet->setCellValue("F{$contador}", 'Responsable');
        $sheet->setCellValue("G{$contador}", 'Comentarios');
        foreach ($treatment_ as $i => $l) {
            $i = $i + 1;
            setlocale(LC_TIME, 'spanish');
            $fechaT = strftime('%d-%b-%y', strtotime($l->start_date));
            $contador++;
            $sheet->setCellValue("A{$contador}", $i);
            $sheet->setCellValue("B{$contador}", $l->treatment);
            $sheet->setCellValue("C{$contador}", $fechaT);
            $sheet->setCellValue("D{$contador}", $l->end_date);
            $sheet->setCellValue("E{$contador}", $l->duration);
            $sheet->setCellValue("F{$contador}", $l->responsible);
            $sheet->setCellValue("G{$contador}", $l->comments);
        }
        $writer = new Xlsx($spreadsheet);
        $filename = 'Reporte_mortality';
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        $writer->save('php://output');
    }



    function treatmentReport1_excel()
    {
        $earring = $this->input->post('earring');
        $desde_ = $this->input->post('desde');
        $hasta_ = $this->input->post('hasta');
        $treatment_ = $this->getTreatmenForReport($earring, $desde_, $hasta_);
        $doc_title = "Reporte_tratamientos";
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);
        $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
        $drawing->setName('Logo');
        $drawing->setDescription('Logo');
        $drawing->setPath('assets/img/logo.png');
        $drawing->setCoordinates('A1');
        $drawing->setWidthAndHeight(75, 75);
        $drawing->getShadow()->setVisible(false);
        $drawing->getShadow()->setDirection(0);
        $drawing->setWorksheet($spreadsheet->getActiveSheet());
        $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
        $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
        $sheet->mergeCells('A1:I4');
        $sheet->mergeCells('A5:G6');
        $sheet->mergeCells('H5:I6');
        $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
        $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);
        $sheet->getStyle('A1')->getAlignment()->setVertical('center');
        $sheet->getStyle('A5')->getAlignment()->setVertical('center');
        $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('E5')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('E6')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('H5')->getAlignment()->setWrapText(true);
        $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("E5:E6")->getFont()->setBold(true);

        $styleArray = [
            'borders' => [
                'outline' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
                'right' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
                'left' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
            ],
        ];
        $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
        $sheet->setCellValue('A1', 'Reporte tratamientos regsitrados');
        $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
        $sheet->getColumnDimension('A')->setWidth(10);
        $sheet->getColumnDimension('B')->setWidth(50);
        $sheet->getColumnDimension('C')->setWidth(30);
        $sheet->getColumnDimension('D')->setWidth(30);
        $sheet->getColumnDimension('E')->setWidth(30);
        $sheet->getColumnDimension('F')->setWidth(40);
        $sheet->getColumnDimension('G')->setWidth(15);
        $sheet->getColumnDimension('H')->setWidth(30);
        $sheet->getColumnDimension('I')->setWidth(10);
        $sheet->getColumnDimension('J')->setWidth(20);
        $sheet->setCellValue('H5', "Desde: {$desde_} Hasta: {$hasta_}");
        $sheet->setCellValue('H7', "Arete: {$earring}");
        $sheet->setCellValue('A8', 'N.°');
        $sheet->setCellValue('B8', 'Nombre del tratamiento');
        $sheet->setCellValue('C8', 'Fecha de inicio');
        $sheet->setCellValue('D8', 'Fecha de fin');
        $sheet->setCellValue('E8', 'Duracion');
        $sheet->setCellValue('F8', 'Responsable');
        $sheet->setCellValue('G8', 'Comentarios');
        $counter = 8;
        foreach ($treatment_ as $i => $treatmen) {
            $counter = $counter + 1;
            $i = $i + 1;
   
            setlocale(LC_TIME, 'spanish');
            $fechaT = strftime('%d-%m-%Y', strtotime($treatmen->start_date));
            $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
            $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
            $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
            $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
            $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
            $sheet->getStyle("F{$counter}")->getAlignment()->setHorizontal('center');
            $sheet->getStyle("G{$counter}")->getAlignment()->setHorizontal('center');
            $sheet->setCellValue("A{$counter}", $i);
            $sheet->setCellValue("B{$counter}", $treatmen->treatment);
            $sheet->setCellValue("C{$counter}", $fechaT);
            $sheet->setCellValue("D{$counter}", $treatmen->end_date);
            $sheet->setCellValue("E{$counter}", $treatmen->duration);
            $sheet->setCellValue("F{$counter}", $treatmen->responsible);
            $sheet->setCellValue("G{$counter}", $treatmen->comments);

           
        }
        $writer = new Xlsx($spreadsheet);
        $filename = $doc_title;

        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
    }





    public function exportRegisterExcel()
    {
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);
        $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
        $drawing->setName('Logo');
        $drawing->setDescription('Logo');
        $drawing->setPath('assets/img/logo.png');
        $drawing->setCoordinates('A1');
        $drawing->setWidthAndHeight(75, 75);
        $drawing->getShadow()->setVisible(false);
        $drawing->getShadow()->setDirection(0);
        $drawing->setWorksheet($spreadsheet->getActiveSheet());
        $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
        $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
        $sheet->mergeCells('K1:T1');
        $sheet->mergeCells('K2:T2');
        $sheet->mergeCells('K3:T3');
        $sheet->mergeCells('K4:T4');
        $sheet->mergeCells('K5:T6');
        $sheet->mergeCells('K7:T7');
        $sheet->mergeCells('K8:T8');
        $sheet->mergeCells('K9:T9');
        $sheet->mergeCells('A1:I4');
        $sheet->mergeCells('A5:G6');
        $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
        $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);
        $sheet->getStyle('A1')->getAlignment()->setVertical('center');
        $sheet->getStyle('P1')->getAlignment()->setVertical('center');
        $sheet->getStyle('M12')->getAlignment()->setVertical('center');
        $sheet->getStyle('P1')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('M11')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('M12')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('P2')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('P2')->getAlignment()->setVertical('center');
        $sheet->getStyle('P2:P6')->getAlignment()->setWrapText(true);
        $sheet->getStyle('M12:O15')->getAlignment()->setWrapText(true);
        $sheet->getStyle('A5')->getAlignment()->setVertical('center');
        $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('H6')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('L5')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('L6')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('K1')->getAlignment()->setVertical('center');
        $sheet->getStyle('K1')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('Q7')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('U7')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('Q8')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('U8')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('R8')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('V8')->getAlignment()->setHorizontal('center');
        $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("P1")->getFont()->setSize(14)->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("K1")->getFont()->setSize(14)->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("L5")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("M11")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("Q8")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("U8")->getFont()->setBold(true);
        $sheet->getStyle('L5:O6')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('L5')->getAlignment()->setVertical('center');
        $styleArray = [
            'borders' => [
                'outline' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
                'right' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
                'left' => [
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                    'color' => ['argb' => '#000'],
                ],
            ],
        ];
        $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
        $sheet->setCellValue('A1', 'Formato de registro de tratamientos');
        $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
        $sheet->getColumnDimension('A')->setWidth(25);
        $sheet->getColumnDimension('B')->setWidth(25);
        $sheet->getColumnDimension('C')->setWidth(50);
        $sheet->setCellValue('K1', 'Instrucciones de uso');
        $sheet->setCellValue('K2', 'Todos los campos deben ser llenados de forma correcta, para ello se debe considerar lo siguiente:');
        $spreadsheet->getActiveSheet()->getStyle("K1:T9")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('ffff00');
        $sheet->setCellValue('K3', '1.- Arete o grapa: Ingresar el arete o grapa del animal');
        $sheet->setCellValue('K4', '2.- Observación: Este campo es opcional, si no tiene una observación solo dejar el campo vacio');
        $sheet->setCellValue('A8', 'N.°');
        $sheet->setCellValue('B8', 'Arete/Grapa');
        $sheet->setCellValue('C8', 'Observaciones');
        $sheet->setCellValue('A9', 1);
        $writer = new Xlsx($spreadsheet);
        $filename = 'formato_registro_tratamientos';
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $filename .  date("Ymd") . '.xlsx"');
        header('Cache-Control: max-age=0');
        $writer->save('php://output');
        
    }


 function readDataTreatmentRegister($file, $especie_)
    {
        $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
        $reader->setReadDataOnly(FALSE);
        $spreadsheet = $reader->load($file);
        $sheet = $spreadsheet->getSheet(0);
        $highestRow = $sheet->getHighestRow();

        for ($row = 9; $row <= $highestRow; $row++) {
            $cellValue = $spreadsheet->getActiveSheet()->getCell("A{$row}")->getValue();
            if ($cellValue) {
                $earring = $spreadsheet->getActiveSheet()->getCell("B{$row}")->getValue();
                if ($earring == 'N/A' || $earring == 'n/a') {
                    $earring = '';
                }else{
                    $earring = $especie_ . $earring;
                }
                $comments = $spreadsheet->getActiveSheet()->getCell("C{$row}")->getValue();
                if ($comments == 'N/A' || $comments == 'n/a' || $comments == '') {
                    $comments = '';
                }
                yield array(
                    'number' => $spreadsheet->getActiveSheet()->getCell("A{$row}")->getValue(),
                    'earring' => $earring,
                    'comment' => $comments,
                );
            }
        }
    }



    function importRegisterFormatTreatmenExcel()
    {
        $specie_ = $this->input->post('specie');
        $treatment = $this->input->post('treatment');
        $start_date = $this->input->post('start_date');
        $end_date = $this->input->post('end_date');
        $duration = $this->input->post('duration');
        $responsible = $this->input->post('responsible');
        $created_user = $this->input->post('created_user');

        if($duration==1){
            $statusTreatment = 1;
        }else{
            $statusTreatment = 0;
        }

        $file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        if (isset($_FILES['registerFormat']['name']) && in_array($_FILES['registerFormat']['type'], $file_mimes)) {
            $arr_file = explode('.', $_FILES['registerFormat']['name']);
            $extension = end($arr_file);
            $file = $_FILES['registerFormat']['tmp_name'];
            $dataTreatment = $this->readDataTreatmentRegister($file, $specie_);
            $data = [];
            $treatment_generaldata = array(
                'start_date' => $start_date,
                'end_date' => $end_date,
                'treatment' => $treatment,
                'duration' => $duration,
                'status_treatment' => $statusTreatment,
                'responsible' => $responsible,
                'created_user' => $created_user,
            );
            foreach ($dataTreatment as $key => $value) {
                $data[] = array(
                    'earring' => $value['earring'],
                    'comment' => $value['comment'],
                    'created_user' => $created_user,
                );
            }
            $reproductiveManagementData = array(
                'treatment_generaldata' => $treatment_generaldata,
                'animalTreatment' => $data
            );
            $data_to_string = json_encode($reproductiveManagementData);
            $curl_request = curl_init(API_URL . "treatments/api/treatment_excel");
            curl_setopt($curl_request, CURLOPT_CUSTOMREQUEST, "POST");
            curl_setopt($curl_request, CURLOPT_HTTPHEADER, array(
                'Content-Type: application/json',
                'x-api-key: QroSystem%21#'
            ));
            curl_setopt($curl_request, CURLOPT_RETURNTRANSFER, True);
            curl_setopt($curl_request, CURLOPT_POSTFIELDS, $data_to_string);
            $response = curl_exec($curl_request);

            if (!$response) {
                $response = json_encode(array(
                    "status" => "error",
                    "message" => curl_errno($curl_request)
                ));
                echo var_dump($response);
            }
            curl_close($curl_request);
            $response = json_decode($response);
        }

        var_dump($response);

        if ($response->status == 'error') {
            $this->session->set_flashdata('error', array('message' => $response->message, 'validations' => $response->validations));
            redirect('Treatment');
        } else {
            redirect('Treatment');
        }
    }


}
