<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class WeightGain extends CI_Controller{

    public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata('user_admin_sess')) {
			redirect('login');
		}
	}
    
    public function index()
    {
        $data['body']='weight_gain/list';
        $data['weight_gain'] = $this->getDailyWeightGain();
        $data['animals'] = $this->getAnimals();
        $this->load->view('layout/main', $data);
    }

    function getDailyWeightGain()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'weight_gain/api/weight_gain',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $weightGain = json_decode($response);
        return $weightGain->data;
    }

    function getDailyWeightGainById($id)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'weight_gain/api/weight_gain/id/' . $id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));
        $response = curl_exec($curl);

        curl_close($curl);
        $weightGain = json_decode($response);
        $this->session->set_flashdata('weight_details', array('data' => $weightGain->data));
        redirect('weightGain');
    }

    function getAnimals()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'animals/api/animals',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $animals = json_decode($response);
        return $animals->data;
    }

    function Weighing_post()
    {
        $earring = $this->input->post('earring');
        $date_weighing = $this->input->post('date_weighing');
        $weight = $this->input->post('weight');
        $comments = $this->input->post('comments');
        $age = $this->input->post('age');
        $created_user = $this->session->userdata('user_admin_sess')->fullname;

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'weight_gain/api/weight_gain/',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => '{
            "earring": "' . $earring . '",
            "date_weighing": "' . $date_weighing . '",
            "weight": "' . $weight . '",
            "created_user": "' . $created_user . '",
            "age": "' . $age . '",
            "comments": "' . $comments . '"
             }',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        redirect('WeightGain');
    }

}
?>
