<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.25/css/jquery.dataTables.css">

<?php
if (@$this->session->flashdata('production_details')) {
    $production_details = $this->session->flashdata('production_details')['data'];
}
if (@$this->session->flashdata('productionEggs_details')) {
    $productionEggs_details = $this->session->flashdata('productionEggs_details')['data'];
}

function get_details_production($production)
{
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => API_URL . 'productions/api/eggs_productions_details/production/' . $production,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'x-api-key: QroSystem%21#'
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    // echo $response;
    $production = json_decode($response);
    return $production->data;
}
?>

<div class="right_col" role="main">


    <!-- <div class="row"> -->

    <div class="col-md-12 col-sm-12 ">

        <div class="dashboard_graph">

            <div class="row x_title">

                <div class="col-md-6">
                    <h3>Lista de producción de huevo <small> </small></h3>
                </div>
                <div class="col-md-6">
                    <div id="reportrange" class="pull-right" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc">
                        <i class="glyphicon glyphicon-calendar fa fa-calendar"></i>
                        <span>December 30, 2014 - January 28, 2015</span> <b class="caret"></b>
                    </div>


                </div>

            </div>
            <div class="row x_title">
                <div class="col-md-12">
                    <a data-toggle="modal" style="color:#fff" data-target="#add_eggsProduction" class="btn btn-secondary btn-sm pull-right">
                        <i class="fa fa-plus-square"></i> Registrar produccion</a>
                      <a data-toggle="modal" style="color:#fff" data-target="#pdf_egg_production" class="btn btn-success btn-sm pull-right">
                        <i class="fa fa-folder-open"></i> Generar reportes</a>
                    <table class="table table-striped table-bordered dt-responsive nowrap" id="production_table">
                        <thead>
                            <tr>
                                <th class="all hidden-print">#</th>
                                <th>Fecha</th>
                                <th>Corral</th>
                                <th>Total de producción (KG)</th>
                                <th>Total de piezas</th>
                                <th>Responsable</th>
                                <th>Observación</th>
                                <th>Acciones</th>
                                <th class="none">Detalles de producción</th>
                            </tr>
                        </thead>
                        <tbody>

                            <?php
                            foreach ($production as $i => $production) {
                                $details_production = get_details_production($production->id_production);
                                $production_total = 0;
                                $piezas_total = 0;
                                if (isset($details_production)) {
                                    foreach ($details_production as $d) {
                                        if ($d->status_eggs == 'Bueno') {
                                            $production_total = $production_total + $d->quantity_kg;
                                            $piezas_total = $piezas_total + $d->num_pieces;
                                        }
                                    }
                                }

                            ?>
                                <tr>
                                    <td><?= $i + 1; ?></td>
                                    <td><?= $production->date_productions; ?></td>
                                    <td><?= $production->name_rodeo; ?></td>
                                    <td><?= number_format($production_total, 3, '.', '-'); ?></td>
                                    <td><?= $piezas_total ?></td>
                                    <td><?= $production->responsible; ?></td>
                                    <td><?= $production->comments ?></td>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-secondary btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Acciones
                                            </button>
                                            <div class="dropdown-menu">

                                                <a class="dropdown-item" href="<?= base_url('index.php/productions/getProductionEggById/' . $production->id_production); ?>"><i class="fa fa-edit"></i> Editar</a>
                                                <a class="dropdown-item" onclick="deleteProductionEgg(<?= $production->id_production ?>)"><i class="fa fa-trash-o"></i> Eliminar</a>

                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <table class="table">
                                            <thead class="thead-dark">
                                                <tr>
                                                    <th scope="col">#</th>
                                                    <th scope="col">Cantidad (KG)</th>
                                                    <th scope="col">Piezas</th>
                                                    <th scope="col">Estado</th>
                                                    <th scope="col">Tamaño</th>
                                                    <th scope="col">Acciones</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php if (isset($details_production)) {
                                                    foreach ($details_production as $i => $detail) {
                                                         $size='';
                                                        foreach($weightUnits as $unit){
                                                            if($detail->size_egg == $unit->name){
                                                                $size=$unit->nomeclature;
                                                            }
                                                        }
                                                        /*if ($detail->size_egg == 'Chico') {
                                                            $size = 'S';
                                                        } else if ($detail->size_egg == 'Mediano') {
                                                            $size = 'M';
                                                        } else if ($detail->size_egg == 'Grande') {
                                                            $size = 'L';
                                                        } else if ($detail->size_egg == 'Extra Grande') {
                                                            $size = 'XL';
                                                        }else if ($detail->size_egg == 'Jumbo') {
                                                            $size = 'XLL';
                                                        }*/
                                                        if ($detail->status_eggs == 'Bueno') {
                                                            $badge = '<span class="badge badge-success text-white fa fa-check-circle"> <strong>Bueno</strong></span>';
                                                        } else if ($detail->status_eggs == 'Defectuoso') {
                                                            $badge = '<span class="badge text-white fa fa-exclamation-circle" style="background: #fd7909;"> <strong>Defectuoso</strong></span>';
                                                        } else if ($detail->status_eggs == 'Quebrado') {
                                                            $badge = '<span class="badge badge-danger text-white fa fa-times-circle"> <strong>Quebrado</strong></span>';
                                                        }

                                                ?>
                                                        <tr>
                                                            <td scope="row"><?= $i + 1; ?></td>
                                                            <td><?= number_format($detail->quantity_kg, 3, '.', ',') ?></td>
                                                            <td><?= $detail->num_pieces ?></td>
                                                            <td><?= $badge ?></td>
                                                            <td><?= $size ?></td>
                                                            <td>
                                                                
                                                                <a href="<?= base_url('index.php/productions/getProductionEggDetailsById/' . $detail->id_egg_production); ?>" class="btn btn-outline-primary btn-sm"><i class="fa fa-edit"></i></a>
                                                                <a  onclick="deleteProductionEggDetails(<?= $detail->id_egg_production ?>)" class="btn btn-outline-danger btn-sm text-danger"><i class="fa fa-trash-o"></i></a>
                                                                
                                                            </td>
                                                        </tr>
                                                <?php }
                                                } ?>
                                            </tbody>
                                        </table>

                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
<br />
</div>
<!-- 

<?php include APPPATH . 'views/modals/production/pdf_modal.php'; ?> -->
<?php include APPPATH . 'views/modals/production/reports/eggs_production.php'; ?>
<?php include APPPATH . 'views/modals/production/add_production_eggs.php'; ?>
<?php include APPPATH . 'views/modals/production/update_production_detail_eggs.php'; ?>
<?php include APPPATH . 'views/scripts/eggsProduction.php'; ?>
<script>
    var numCols = 1;
    $(document).ready(function() {
        var id = "1";
        var item = $("#detailsTag");
        var before = $("#extraTag");
        $("#addMore").on("click", function() {
            numCols = numCols + 1;
            var clone = item.clone(true);
            console.log(clone)
            clone.attr("id", 'detailsTag' + numCols);
            var btnTag = clone.children(".buttonTag");
            btnTag.html('<button class="btn btn-danger btn-sm pull-center mt-4" onclick="removeRow(' + numCols + ')" type="button">' +
                '<i class="fa fa-minus-square"></i> </button>')
            var qtyTag = clone.children(".qtyTag");
            qtyTag.html('<label> Cantidad (KG) <span class="text-danger">*</span></label>' +
                '<input type="text" class="form-control" onkeyup="get_size(' + numCols + ')" placeholder="Cantidad en kg" oninput="changeValueToPositive(this)" name="quantity_kg[]" id="quantity_kg' + numCols + '" required>')

            var pzTag = clone.children(".pzTag");
            pzTag.html('<label for="">Piezas<span class="text-danger">*</span></label>' +
                '<input type="text" oninput="changeValueToPositive(this)" onkeyup="get_size(' + numCols + ')" class="form-control" placeholder="Núm de piezas" name="num_pieces[]" id="num_pieces' + numCols + '" required>')
            var pzTag = clone.children(".sizeTag");
            pzTag.html('<label for="">Tamaño<span class="text-danger">*</span></label>' +
                '<input type="text" class="form-control"  placeholder="" id="sizeEgg' + numCols + '" name="sizeEgg[]" readonly>');
            var statusTag = clone.children(".statusTag");
            statusTag.html('<label for="">Estado<span class="text-danger">*</span></label>' +
                '<select name="status_eggs[]" id="status_eggs' + numCols + '" class="form-control" required>' +
                '<option value="Bueno" selected>Bueno</option>' +
                '<option value="Defectuoso">Defectuoso</option>' +
                '<option value="Quebrado">Quebrado</option>' +
                '</select>')
            clone.attr('class', 'form-group row extracolumns mb-3');
            before.before(clone)
            var elementExists = document.getElementById("quantity_kg" + numCols);
            console.log(elementExists);
            $("#quantity_kg" + numCols).rules('add', {
                required: true,
                messages: {
                    required: "Campo requerido."
                }
            })
        })
    });

    function removeRow(rowNum) {
        $("#detailsTag" + rowNum).remove();
        numCols = numCols - 1
    }

    function changeValueToPositive(input) {
        value = input.value;
        val = value.replace(/[^0-9.]/g, '').replace(/(\..*)\./g, '$1');
        $("#" + input.id).val(val)
    }
   var weightUnits = [];
    <?php foreach ($weightUnits as $unit) { ?>
        weightUnits.push({
            id: '<?= $unit->id ?>',
            name: '<?= $unit->name ?>',
            nomeclature: '<?= $unit->nomeclature ?>',
            starting_weight: <?= ($unit->starting_weight) ? $unit->starting_weight : 0 ?>,
            final_weight: <?= ($unit->final_weight) ? $unit->final_weight : 0 ?>
        });
    <?php } ?>
    function get_sizeegg() {
        qty_kg = $("#quantity_kg").val();
        qty_g = qty_kg * 1000;
        pz = $("#num_pieces").val();
        average_size = qty_g / pz;
   let length_arr = weightUnits.length;
        let name_weight='';
        for (let i = 0; i < length_arr; i++) {
            if (weightUnits[i].starting_weight == 0) {
                if (average_size <= weightUnits[i].final_weight) {
                    name_weight = weightUnits[i].name
                }
            } else if (weightUnits[i].final_weight == 0) {
                if (average_size >= weightUnits[i].starting_weight) {
                    name_weight = weightUnits[i].name
                }
            } else {
                if (average_size >= weightUnits[i].starting_weight && average_size <= weightUnits[i].final_weight) {
                    name_weight = weightUnits[i].name
                }
            }
        }
        $("#sizeEgg").val(name_weight)
        /*if (average_size <= 52.9) {
            $("#sizeEgg").val('Chico')
        } else if (average_size >= 53 && average_size <= 59.9) {
            $("#sizeEgg").val('Mediano')
        } else if (average_size >= 60 && average_size <= 66.9) {
            $("#sizeEgg").val('Grande')
        }else if(average_size >= 67 && average_size <=77.9){
            $("#sizeEgg").val('Extra Grande')
        } else if (average_size >= 78) {
            $("#sizeEgg").val('Jumbo')
        }*/
    }
    function get_sizeeggu() {
        qty_kg = $("#quantity_kg_u").val();
        qty_g = qty_kg * 1000;
        pz = $("#num_pieces_u").val();
        average_size = qty_g / pz;
   let length_arr = weightUnits.length;
        let name_weight='';
        for (let i = 0; i < length_arr; i++) {
            if (weightUnits[i].starting_weight == 0) {
                if (average_size <= weightUnits[i].final_weight) {
                    name_weight = weightUnits[i].name
                }
            } else if (weightUnits[i].final_weight == 0) {
                if (average_size >= weightUnits[i].starting_weight) {
                    name_weight = weightUnits[i].name
                }
            } else {
                if (average_size >= weightUnits[i].starting_weight && average_size <= weightUnits[i].final_weight) {
                    name_weight = weightUnits[i].name
                }
            }
        }
        $("#sizeEgg_u").val(name_weight)
        /*if (average_size < 52.9) {
            $("#sizeEgg_u").val('Chico')
        } else if (average_size >= 53 && average_size <= 59.9) {
            $("#sizeEgg_u").val('Mediano')
        } else if (average_size >= 60 && average_size <= 66.9) {
            $("#sizeEgg_u").val('Grande')
        } else if (average_size >= 67 && average_size <= 77.9) {
            $("#sizeEgg_u").val('Extra Grande')
        }else if (average_size  >= 78) {
            $("#sizeEgg_u").val('Jumbo')
        }*/
    }
    function get_size(numCol) {
        qty_kg = $("#quantity_kg" + numCol).val();
        qty_g = qty_kg * 1000;
        pz = $("#num_pieces" + numCol).val();
        average_size = qty_g / pz;
 let length_arr = weightUnits.length;
        let name_weight='';
        for (let i = 0; i < length_arr; i++) {
            if (weightUnits[i].starting_weight == 0) {
                if (average_size <= weightUnits[i].final_weight) {
                    name_weight = weightUnits[i].name
                }
            } else if (weightUnits[i].final_weight == 0) {
                if (average_size >= weightUnits[i].starting_weight) {
                    name_weight = weightUnits[i].name
                }
            } else {
                if (average_size >= weightUnits[i].starting_weight && average_size <= weightUnits[i].final_weight) {
                    name_weight = weightUnits[i].name
                }
            }
        }
        $("#sizeEgg" + numCol).val(name_weight)
        /*
        if (average_size < 52.9) {
            $("#sizeEgg" + numCol).val('Chico')
        } else if (average_size >= 53 && average_size <= 59.9) {
            $("#sizeEgg" + numCol).val('Mediano')
        } else if (average_size >= 60 && average_size <= 66.9) {
            $("#sizeEgg" + numCol).val('Grande')
        } else if (average_size >= 67 && average_size <= 77.9) {
            $("#sizeEgg" + numCol).val('Extra Grande')
        }else if (average_size  >= 78) {
            $("#sizeEgg"+numCol).val('Jumbo')
        }*/
    }
      $(document).ready(function () {
        $("#reportEggsProductionForm").validate({
            rules: {
                rodeo: "required",
                status: "required",
                start_date: "required",
                end_date: "required",
            },
            messages: {
                rodeo: "Campo requerido.",
                status: "Campo requerido.",
                start_date: "Campo requerido.",
                end_date: "Campo requerido.",
            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");
                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            }
        });
    });
</script>