<div class="right_col" role="main">


    <!-- <div class="row"> -->

    <div class="col-md-12 col-sm-12 ">

        <div class="dashboard_graph">

            <div class="row x_title text-center">

                <div class="col-md-12">
                    <h3>Reporte de animales</h3>
                </div>

            </div>
            <div class="row x_title">
                <div class="col-md-12 d-flex justify-content-center">
                    <!-- CONTENIDO AQUI -->
                    <form method="post" id="animalsReportForm" target="_blank">
                        <div class="form-group row">
                            <div class="col-md-auto">
                                <label>Especie <span class="text-danger">*</span></label>
                                <select name="specie" id="specie" class="form-control">
                                    <option value="" selected>--Seleccione una opción--</option>
                                    <option value="Aves">Aves</option>
                                    <option value="Ovino">Ovinos</option>
                                    <option value="Bovino">Bovinos</option>
                                    <option value="Porcino">Porcinos</option>
                                    <option value="Caprino">Caprinos</option>
                                    <option value="Felinos">Felinos</option>
                                    <option value="Caninos">Caninos</option>
                                    <option value="Equino">Equinos (Caballos y Yeguas)</option>
                                </select>
                            </div>
                            <div class="col-md-auto" id="stat" style="display: none">
                                <label>Estatus <span class="text-danger">*</span></label>
                                <select name="status_" id="status_" class="form-control">
                                    <option value="0" selected>Todas</option>
                                    <option value="3">Buena</option>
                                    <option value="2">Mediana</option>
                                    <option value="1">Deficiente</option>
                                </select>
                            </div>
                        </div>
                        <div class="form-group row" style='padding: 26px;'>
                            <div class="col-md-6">
                                <button type="button" id="excelReportBtn" style="color:#fff" class="btn btn-success btn-sm pull-right">
                                    <i class="fa fa-file-excel-o"></i> Reporte Excel</button>
                            </div>
                            <div class="col-md-6">
                                <button type="button" id="pdfReportBtn" style="color:#fff" class="btn btn-primary btn-sm pull-left">
                                    <i class="fa fa-file-pdf-o"></i> Reporte PDF</button>
                            </div>
                        </div>
                    </form>
                </div>

            </div>
        </div>
    </div>
</div>
</div>

<script>
    $(document).ready(function() {
        $("#animalsReportForm").validate({
            rules: {
                specie: "required",
                start: "required",
                end: "required",
                status_: "required"
            },
            messages: {
                specie: "Campo requerido.",
                start: "Campo requerido.",
                end: "Campo requerido.",
                status_: "Campo requerido."
            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");
                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            },
            submitHandler: function(form) {
                form.submit();
            }
        });

    });

    $("#specie").change(function() {
        specie = $(this).val();
        if (specie == "Ovino") {
            $("#stat").show();
        } else {
            $("#stat").hide();
        }

    });
    $("#pdfReportBtn").on('click', function() {
        document.getElementById("animalsReportForm").setAttribute('action', '<?= base_url("index.php/reports/animals_pdf") ?>')
        $("#animalsReportForm").submit();

    });
    $("#excelReportBtn").on('click', function() {
        document.getElementById("animalsReportForm").setAttribute('action', '<?= base_url("index.php/reports/animals_excel") ?>')
        $("#animalsReportForm").submit();
    });
</script>