<script type="text/javascript">
$(document).ready(function() {
     $('#category_table').DataTable({
          "language": {
               "decimal": "",
               "emptyTable": "No hay información",
               "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
               "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",
               "infoFiltered": "(Filtrado de _MAX_ total entradas)",
               "infoPostFix": "",
               "ihousands": ",",
               "lengthMenu": "Mostrar _MENU_ Entradas",
               "loadingRecords": "Cargando...",
               "processing": "Procesando...",
               "search": "Buscar:",
               "zeroRecords": "Sin resultados encontrados",
               "paginate": {
                    "first": "Primero",
                    "last": "Ultimo",
                    "next": "Siguiente",
                    "previous": "Anterior"
               }
          },
     });
});
$(document).ready(function() {
    $(".category_form").validate({
       rules: {
            name: "required"
       },
       messages: {
            name: "Campo requerido."
       },
       errorElement: "em",
       errorPlacement: function(error, element) {
            error.addClass("invalid-feedback");

            if (element.prop("type") === "checkbox") {
                error.insertAfter(element.next("label"));
            } else {
                error.insertAfter(element);
            }
       },
       highlight: function(element, errorClass, validClass) {
            $(element).addClass("is-invalid").removeClass("is-valid");
       },
       unhighlight: function(element, errorClass, validClass) {
            $(element).addClass("is-valid").removeClass("is-invalid");
       }
    });
});

    $(document).on("submit", "#category_form ", function(event) {
        event.preventDefault();
        $("#btn-save").html('<button class="btn btn-sm btn-primary" type="button" disabled>' +
            '<span class = "spinner-border spinner-border-sm" role="status" aria-hidden="true"> </span>' +
            'Guardando...</button>');
        $.ajax({
            url: "<?= API_URL ?>animal_category/api/animal_category/",
            method: "POST",
            headers: {
                "X-API-KEY": "QroSystem%21#",
            },
            data: $(document).find(this).serialize(),
            success: function(_response) {
                response = _response.message;
                $('#category_modal').modal('hide')
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: 'Categoria registrada con exito',
                    showConfirmButton: false,
                    timer: 2500,
                    onAfterClose: () => {
                        window.location.reload();
                        show_loading();
                    }
                })
            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Ha ocurrido un error interno',
                    text: "'" + response.message + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                        show_loading();
                    }
                })
            },
        });
    });

    function delete_category(id) {
        event.preventDefault();

        Swal.fire({
            title: '¿Está seguro?',
            text: "¡No podrá recuperar el registro una vez sea eliminado!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: '¡Si, Eliminar!',
            cancelButtonText: "¡No, Cancelar!"
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?= API_URL; ?>animal_category/api/animal_category/id/" +
                        id,
                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "QroSystem%21#",
                    },
                    success: function(_response) {
                        response = _response.message;
                        if (_response.status == "error") {
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                title: 'Ha ocurrido un error interno',
                                text: "'" + response + "'",
                                showConfirmButton: true,
                                onAfterClose: () => {
                                    window.location.reload();
                                    show_loading();
                                }
                            })
                        } else {
                            $("#show_loading").html('');
                            Swal.fire({
                                position: 'center',
                                icon: 'success',
                                title: 'Categoria eliminada con exito',
                                showConfirmButton: false,
                                timer: 2500,
                                onAfterClose: () => {
                                    window.location.reload();
                                    show_loading();
                                }
                            })
                        }
                    },
                    error: function() {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();
                                show_loading();
                            }
                        })
                    },
                });
            }
        })
    }

    <?php if (@$category_details) { ?>
        $(document).ready(function() {
            $("#category_modal").modal('show');
        });
        $(document).on("submit", "#categoryUpdate_form ", function(event) {
            event.preventDefault();
            $("#btn-save").html('<button class="btn btn-sm btn-primary" type="button" disabled>' +
                '<span class = "spinner-border spinner-border-sm" role="status" aria-hidden="true"> </span>' +
                'Guardando...</button>');
            $.ajax({
                url: "<?= API_URL . 'animal_category/api/animal_category/id/' . $category_details->category_id ?>",
                method: "PUT",
                headers: {
                    "X-API-KEY": "QroSystem%21#",
                },
                data: $(document).find(this).serialize(),
                success: function(_response) {
                    response = _response.message;
                    $('#category_modal').modal('hide')
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Categoria actualizada con exito',
                        showConfirmButton: false,
                        timer: 2500,
                        onAfterClose: () => {
                            window.location.reload();
                            show_loading();
                        }
                    })
                },
                error: function(error) {
                    response = JSON.stringify(error.responseText);
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Ha ocurrido un error interno',
                        text: "'" + response.message + "'",
                        showConfirmButton: true,
                    })
                },
            });
        });

    <?php } ?>
</script>
