<script>
    $(document).ready(function() {
        $('#table_mortality').DataTable({
            "language": {
                "decimal": "",
                "emptyTable": "No hay información",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",
                "infoFiltered": "(Filtrado de _MAX_ total entradas)",
                "infoPostFix": "",
                "ihousands": ",",
                "lengthMenu": "Mostrar _MENU_ Entradas",
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "search": "Buscar:",
                "zeroRecords": "Sin resultados encontrados",
                "paginate": {
                    "first": "Primero",
                    "last": "Ultimo",
                    "next": "Siguiente",
                    "previous": "Anterior"
                }
            },
        });
    });

    $("#earring").change(function() {
        $("#spiner_add").html(' <div class="lds-spinner"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>');
        $("#spacies").html("");
        $("#gender").html("");
        $("#mother_earring").html("");
        $("#race").html("");
        $("#birth_date").html("");
        $("#father_earring").html("");
        id = $(this).val();
        specie = $("#specie").val();
        ini = specie.substr(0, 3)
        var settings = {
            "url": "<?= API_URL; ?>animals/api/animalsByEarring/earring/" + ini + id,
            "method": "GET",
            "timeout": 0,
            "headers": {
                "x-api-key": "QroSystem%21#"
            },
        };
        $.ajax(settings).done(function(response) {
            // console.log(response);
            if (response.data) {
                $("#spiner_add").html('')
                spacies = response.data.specie;
                gender = response.data.gender;
                mother = response.data.mother_earring;
                race = response.data.race;
                birth_date = response.data.birth_date;
                father = response.data.father_earring;
                id_animals = response.data.id_animals;
                category_name = response.data.category_name;
                rodeo_name = response.data.rodeo_name;
                $("#cat_ani").html("<td>" + category_name + "</td>");
                $("#rodeo_n").html("<td>" + rodeo_name + "</td>");
                $("#spacies").html("<td>" + spacies + "</td>");
                $("#gender").html("<td>" + gender + "</td>");
                $("#mother_earring").html("<td>" + mother + "</td>");
                $("#race").html("<td>" + race + "</td>");
                $("#birth_date").html("<td>" + birth_date + "</td>");
                $("#father_earring").html("<td>" + father + "</td>");
                $("#id_animals").val(id_animals);

                $("#btn_addMortality").removeAttr('disabled')
            } else {
                document.getElementById("btn_addMortality").setAttribute('disabled', "true");
                $("#spiner_add").html('')
                $("#earring").val("");
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'No se encuentra este animal!',
                })
            }
        });

    });

    $(document).ready(function() {
        $(".mortality_form").validate({
            rules: {
                specie: "required",
                earring: "required",
                date_mortality: "required",
                //cause: "required", 
            },
            messages: {
                specie: "Campo requerido.",
                earring: "Campo requerido.",
                date_mortality: "Campo requerido.",
                //cause: "Campo requerido.",
            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");
                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            },
        });

    });

    $(document).ready(function() {
        $("#reportMortality_form").validate({
            rules: {
                specie: "required",
                desde: "required",
                hasta: "required",
            },
            messages: {
                specie: "Campo requerido.",
                desde: "Campo requerido.",
                hasta: "Campo requerido.",
            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");
                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            },
            submitHandler: function(form) {
                $("#pdf_modal").modal('hide');
                form.submit();
            }
        });

    });

    $("#reportPdf").on('click', function() {
        document.getElementById("reportMortality_form").setAttribute('action', '<?= base_url("index.php/mortality/mortality_report") ?>')
        $("#reportMortality_form").submit();

    });
    $("#reportExcel").on('click', function() {
        document.getElementById("reportMortality_form").setAttribute('action', '<?= base_url("index.php/mortality/motality_excel") ?>')
        $("#reportMortality_form").submit();
        /*   $("#pdf_modal").modal('hide'); */
    });


    function elimnarMortality(_id) {
        Swal.fire({
            title: '¿Está seguro?',
            text: "¡No podrá recuperar este registro, una vez sea eliminado!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Si, Eliminar!'
        }).then((result) => {
            if (result.value) {

                $.ajax({
                    url: "<?= API_URL; ?>mortality/api/mortality/id/" + _id,
                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "QroSystem%21#",
                    },
                    success: function(_response) {
                        response = _response.message;
                        if (_response.status == "error") {
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                title: 'Ha ocurrido un error interno',
                                text: "'" + response + "'",
                                showConfirmButton: true,
                                onAfterClose: () => {
                                    window.location.reload();

                                }
                            })
                        } else {

                            Swal.fire({
                                position: 'center',
                                icon: 'success',
                                title: 'Registro eliminado correctamente',
                                showConfirmButton: false,
                                timer: 2500,
                                onAfterClose: () => {
                                    window.location.reload();

                                }
                            })
                        }
                    },
                    error: function() {

                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();

                            }
                        })
                    },
                });
            }
        })

    }




    <?php if (@$mortality_details) { ?>
        $(document).ready(function() {
            $("#add_mortality").modal('show');
        });
        $("#btn_addMortality").removeAttr('disabled')
        $(document).on("submit", ".mortality_form", function(event) {
            event.preventDefault();
            $.ajax({
                url: "<?= API_URL . 'mortality/api/mortality/id/' . $mortality_details->id_mortality ?>",
                method: "PUT",
                headers: {
                    "X-API-KEY": "QroSystem%21#",
                },
                data: $(document).find(this).serialize(),
                success: function(_response) {
                    response = _response.message;

                    $('#add_mortality').modal('hide')
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Mortalidad actualizada con exito',
                        showConfirmButton: false,
                        timer: 2500,
                        onAfterClose: () => {
                            window.location.reload();
                            show_loading();
                        }
                    })
                },
                error: function(error) {


                    response = JSON.stringify(error.responseText);
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Ha ocurrido un error interno',
                        text: "'" + response.message + "'",
                        showConfirmButton: true,
                        onAfterClose: () => {
                            window.location.reload();
                            show_loading();
                        }
                    })
                },
            });
        });

    <?php } ?>
</script>