<script src="<?php echo base_url('assets/plugins/sweetalert2/sweetalert2.all.min.js') ?>"></script>
<script>
    $(document).ready(function() {

        $('#table_ornamentalEgg').DataTable({
            "language": {
                "decimal": "",
                "emptyTable": "No hay información",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",
                "infoFiltered": "(Filtrado de _MAX_ total entradas)",
                "infoPostFix": "",
                "ihousands": ",",
                "lengthMenu": "Mostrar _MENU_ Entradas",
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "search": "Buscar:",
                "zeroRecords": "Sin resultados encontrados",
                "paginate": {
                    "first": "Primero",
                    "last": "Ultimo",
                    "next": "Siguiente",
                    "previous": "Anterior"
                }
            },

            initComplete: function() {
                this.api().columns().every(function() {
                    var column = this;

                    _id_column = column.header().id;
                    if (_id_column == '_no' || _id_column == 'egg_weight_' || _id_column == 'total_eggs_' || _id_column == 'collection_location_' || _id_column == 'collection_location_' || _id_column == 'action_' || _id_column == '_date_b' ||
                        _id_column == '_weight') {

                    } else if (_id_column == '_status2') {
                        var select = $('<select class="form-control"><option value="">Filtrar por: </option></select>')
                            .appendTo($(column.header()))
                            .on('change', function() {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );
                                console.log(val)
                                column
                                    .search(val ? '^' + val + '$' : '', true, false)
                                    .draw();
                            });
                        i = 0;
                        select.append('<option value="' + ' Buena' + '">' + ' Buena' + '</option><option value="' + ' Mediana' +
                            '">' + ' Mediana' + '</option><option value="' + ' Deficiente' + '">' + ' Deficiente' + '</option>')
                        column.data().unique().sort().each(function(d, j) {
                            i = i + 1;
                            console.log(i);

                        });
                    } else if (_id_column == 'fecha_venta') {
                        var select = $('<br><input type="text" class="form-control" placeholder="Filtrar por:" />')
                            .appendTo($(column.header()))
                            .on('keyup change clear', function() {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );
                                if (column.search() !== val) {
                                    column
                                        .search(val ? '^' + val + '-' : '', true, false)
                                        .draw();
                                }
                            })
                    } else {
                        var select = $('<select class="form-control"><option value="">Filtrar por: </option></select>')
                            .appendTo($(column.header()))
                            .on('change', function() {
                                var val = $.fn.dataTable.util.escapeRegex(
                                    $(this).val()
                                );
                                column
                                    .search(val ? '^' + val + '$' : '', true, false)
                                    .draw();
                            });
                        column.data().unique().sort().each(function(d, j) {
                            select.append('<option value="' + d + '">' + d + '</option>')
                        });
                    }
                });
            }
        });


    });

    function ornamentalEgg_delete(_id) {
        Swal.fire({
            title: '¿Está seguro?',
            text: "¡No podrá recuperar este registro, una vez sea eliminado!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Si, Eliminar!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?= API_URL; ?>ornamental_egg/api/ornamentalEgg/id//" +
                        _id,

                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "QroSystem%21#",
                    },
                    success: function(_response) {
                        response = _response.message;
                        if (_response.status == "error") {
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                title: 'Ha ocurrido un error interno',
                                text: "'" + response + "'",
                                showConfirmButton: true,
                                onAfterClose: () => {
                                    window.location.reload();
                                }
                            })
                        } else {
                            Swal.fire({
                                position: 'center',
                                icon: 'success',
                                title: 'Registro eliminado correctamente',
                                showConfirmButton: false,
                                timer: 2500,
                                onAfterClose: () => {
                                    window.location.reload();

                                }
                            })
                        }
                    },
                    error: function() {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();

                            }
                        })
                    },
                });
            }
        })
    }

    $(document).ready(function() {
        $("#ornamentalesEgg_form").validate({
            rules: {
                collection_date: "required",
                mother_earring: "required",
                egg_weight: "required",
                total_eggs: "required",
                specie: "required",
                collection_location: "required",
            },
            messages: {
                collection_date: "Campo requerido.",
                mother_earring: "Campo requerido.",
                egg_weight: "Campo requerido.",
                total_eggs: "Campo requerido.",
                specie: "Campo requerido.",
                collection_location: "Campo requerido.",

            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");

                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            }
        });
    });

    $(document).on("submit", "#ornamentalesEgg_form ", function(event) {
        event.preventDefault();
        $.ajax({
            url: "<?= API_URL ?>ornamental_egg/api/ornamentalEgg",
            method: "POST",
            headers: {
                "X-API-KEY": "QroSystem%21#",
            },
            data: new FormData(this),
            processData: false,
            contentType: false,
            cache: false,
            async: false,
            // data: $(document).find(this).serialize(),
            success: function(_response) {
                response = _response.message;
                $('#add_animals').modal('hide')
                Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: 'Registrado con exito',
                    showConfirmButton: false,
                    timer: 2500,
                    onAfterClose: () => {
                        window.location.reload();
                        show_loading();
                    }
                })
            },
            error: function(error) {
                // $("#btn-save").html('<button type="submit" class="btn btn-primary btn-sm">Guardar</button>');
                response = error.responseJSON;
                if (error.message == 'validations error') {
                    validations_err = JSON.stringify(response.validations);

                    $("#errorMsg").html(validations_err)
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Ha ocurrido un error en las validaciones del formulario',
                        showConfirmButton: true,
                    })
                } else {
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Ha ocurrido un error interno',
                        text: error.message,
                        showConfirmButton: true,
                    })
                }

            },
        });
    });



    $("#reportPdf").on('click', function() {
        document.getElementById("reportOrnamental_form").setAttribute('action', '<?= base_url("index.php/ornamentalEgg/ornamentalEgg_report") ?>')
        $("#reportOrnamental_form").submit();
    });
    $("#reportExcel").on('click', function() {
        document.getElementById("reportOrnamental_form").setAttribute('action', '<?= base_url("index.php/ornamentalEgg/ornamentalEgg_excel") ?>')
        $("#reportOrnamental_form").submit();
        /*   $("#pdf_modal").modal('hide'); */
    });


    <?php if (@$ornamentalEgg_details) { ?>
        $(document).ready(function() {
            $("#add_ornamentalEgg").modal('show');
        });

        // console.log(<?= $ornamentalEgg_details->id_ornamental_egg ?>);
        $(document).on("submit", "#ornamentalEggUpdate_form", function(event) {
            event.preventDefault();
            $.ajax({
                url: "<?= API_URL . 'ornamental_egg/api/ornamentalEgg/id/' . $ornamentalEgg_details->id_ornamental_egg ?>",
                method: "PUT",
                headers: {
                    "X-API-KEY": "QroSystem%21#",
                },
                data: $(document).find(this).serialize(),
                success: function(_response) {
                    response = _response.message;

                    $('#add_animals').modal('hide')
                    Swal.fire({
                        position: 'center',
                        icon: 'success',
                        title: 'Registro actualizado con exito',
                        showConfirmButton: false,
                        timer: 2500,
                        onAfterClose: () => {
                            window.location.reload();
                            show_loading();
                        }
                    })
                },
                error: function(error) {
                    response = JSON.stringify(error.responseJSON);
                    Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Ha ocurrido un error interno',
                        text: "'" + response.message + "'",
                        showConfirmButton: true,
                        onAfterClose: () => {
                            window.location.reload();
                            show_loading();
                        }
                    })
                },
            });
        });

    <?php } ?>
</script>