<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');
    require_once('vendor/autoload.php');
    use PhpOffice\PhpSpreadsheet\Spreadsheet;
    use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


class ReportPall extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->library('session', 'pagination');
        $this->output->set_header('Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0');
        $this->output->set_header('Pragma: no-cache');
        $this->load->model("Reportepall_model");
    }
    public function index()
    {
        $page_data['page_name']     = 'reportPall';
        $page_data['page_title']    = get_phrase('Reporte de nomina');
        $this->load->view('backend/index', $page_data);
    }
    public function empleadosid($id_empleado){
        $result = $this->Reportepall_model->get_employes_by_id($id_empleado);
        echo json_encode($result);
    }

    public function generarRecibo(){


        $department_id=$this->input->post('department_id');

        $result2 = $this->Reportepall_model->get_departament_by_id($department_id);
       
        $departme= $result2->name;
        $nombre_empleado=$this->input->post('nombre_empleado');
        $sueldo=$this->input->post('sueldo');
        $diasTra=$this->input->post('diasTra');
        $horasExtras=$this->input->post('horasExtras');
        $precioExtras=$this->input->post('precioHora');
        $desde1 = date('d-m-Y', strtotime($_POST['desde']));
        $hasta1 = date('d-m-Y', strtotime($_POST['hasta']));
        $dia_pago1 = date('d-m-Y', strtotime($_POST['dia_pago']));
        $dia= $sueldo/7;
        $salarioDiario=bcdiv($dia, '1', 2);
        $sema= $dia*$diasTra;
        $semana= bcdiv($sema, '1', 2);
        $ExtPesos = $horasExtras * $precioExtras;
        
        $total = $ExtPesos + $semana;

      /*   <h4 style="text-transform: uppercase;">'.$nombre_empleado.'</h4>  */
        /* $formatterES = new NumberFormatter("es", NumberFormatter::SPELLOUT);
        $totalLetras = echo $formatterES->format(123); */


        $mpdf = new \Mpdf\Mpdf();
        $mpdf = new \Mpdf\Mpdf(['orientation' => 'P']);
        $mpdf->SetHTMLHeader('

        <table class="normal" width="100%">
        <tr>
            <td width="30%"><img src="'.base_url().'assets/img/logo.jpg" width="95" height="95">  </td>
            <td width="40%" align="center"> <h1>Rancho El Arenal</h1> </td>
            <td width="30%" style="text-align: right;"><table><tr>  <th >Fecha de pago</th></tr><tr>  <td ALIGN="center">'.$dia_pago1.'</td></tr></table></td>
        </tr>
    </table>
    
    <table class="normal" width="100%">
        <tr>
            <td width="50%"><h4>RFC:</h4>  </td>
            <td width="25%" align="center"></td>
            <td width="25%" style="text-align: right;"></td>
        </tr>
    </table>
    <table class="normal" width="100%">
        <tr>
            <td width="20%"></td>
            <td width="60%" align="center"> <h2>RECIBO DE PAGO</h2> </td>
            <td width="20%" style="text-align: right;"></td>
        </tr>
    </table>
    <table class="normal" width="100%">
        <tr>
            <td width="50%"> <table><tr><td ><h4 style="text-transform: uppercase;">'.$nombre_empleado.'</h4> </td> <tr><td ><h5>Departamento: '.$departme.'</h5></td></tr></table> </td>
            <td width="25%" align="center"><table><tr><td align="center" ><h5>Salario diario</h5></td><td align="left"> $ '.$salarioDiario.'</td></tr><tr><td align="left" ><h5>Dias pagados</h5></td><td align="left">'.$diasTra.'</td></tr><tr><td align="center" ><h5>Horas extra</h5></td><td align="left">'.$horasExtras.'</td></tr></table></td>
            <td width="25%" style="text-align: right;"><table  style="border: 1px solid #000;"><tr>  <th style="border-bottom: 1px solid #000;">Periodo de pago</th></tr><tr>  <td ALIGN="center"> <h5>  DEL '.$desde1.' </h5></td></tr></tr><tr>  <td ALIGN="center"> <h5> Al '.$hasta1.'</h5></td></tr></table></td>
        </tr>
    </table>
    <hr>
    <table class="normal" width="100%">
    
        <tr>
            <td width="35%"></td>
            <td width="30%"></td>
            <td width="35%" style="text-align: right;"><table><tr><td align="center" ><h5>Salario normal</h5></td><td align="left"> $ '.$sueldo.'</td> <tr><td align="center" ><h5>Salario por pagar</h5></td><td align="left"> $ '.$semana.'</td></tr> <tr><td align="center" ><h5>Horas extra</h5></td><td align="left"> $ '.$ExtPesos.'</td></tr></table> </td>
        </tr>
    </table>

    <hr>
    <table class="normal" width="100%">
    
        <tr>
            <td width="35%"></td>
            <td width="30%"></td>
            <td width="35%" style="text-align: right;"><table><tr><td align="center" ><h5>Neto recibido: </h5></td><td align="left"> $ '.$total.'</td></tr></table> </td>
        </tr>
    </table>

    <table class="normal" width="100%">
    
        <tr>
            <td width="70%" align="justify"><p align="justify" >RECIBI la cantidad anotada en el recibo por concepto de mi sueldo, que incluye el importe por las horas extra y ademas prestaciones correspondientes al periodo que termina hoy, sin que a la fecha se me adeude ninguna cantidad por otro concepto.</p> </td>
            <td width="0%"></td>
            <td width="35%" style="text-align: right;"><table><tr><td align="center" >____________________________ </td><tr><td align="center" ><h5>FIRMA</h5></td></tr></table> </td>
        </tr>
    </table>

    


    ');
        $mpdf->SetHTMLFooter('
              ');
        $html = '	
        
                ';
        $data = '';
        $data .= '
        <style>
            h1 {
            
            }
        </style>';
        $data .= '<img width = "10" src = "assets/img/logo.jpg>';
        $css = file_get_contents('assets/pdf.css');
        /* Impresion y salida del documento */
        $mpdf->WriteHTML($data);
        /*   $mpdf->Image('assets/img/logo.jpg', 20, 0, 30, 30, 'jpg', '', true, false); */
        $mpdf->SetTitle('Reporte de pagos');
        $mpdf->WriteHTML('<body>');
        $mpdf->writeHTML($css, 1);
        $mpdf->WriteHTML($html);
        $mpdf->WriteHTML('</body>');
        $mpdf->Output('Reporte_pagos.pdf', 'I');
        $mpdf->setFooter('{PAGENO}');

        $mpdf->WriteHTML('Section 1');
        $mpdf->WriteHTML('');

        exit;
        $mpdf->Output();

    }

    /* function get_employees($department_id = '')
    {
        $employees = $this->db->get_where(
            'user',
            array('type' => 2, 'department_id' => $department_id)
        )->result_array();
        foreach ($employees as $row)
            echo '<option value="' . $row['user_id'] . '">' . $row['name'] . '</option>';
    } */

}