<?php
   
require APPPATH . 'libraries/REST_Controller.php';
     
class Employees extends REST_Controller {
    
	  /**
     * Get All Data from this method.
     *
     * @return Response
    */
    public function __construct() {
       parent::__construct();
       $this->load->database();
    }
       
    /**
     * Get All Data from this method.
     *
     * @return Response
    */
     public function code_get($code = NULL)
    {
        if (!empty($code)) {
            $data = $this->db->get_where("user", ['user_code' => $code])->row();
            
            if ($data) {
                $response = array(
                    'status'=>'success',
                    'status_code'=>200,
                    'message'=>'Employee loaded successfully',
                    'data'=>$data
                );
            }else{
                $response=array(
                    'status'=>"success",
                    'status_code'=>200,
                    'message'=>'Employee not found',
                    'data'=>null
                );
            }
        } else {
            $response=array(
                'status'=>"error",
                'status_code'=>403,
                'message'=>'Please send the employee code',
                'data'=>null
            );
        }
        $this->response($response, $response['status_code']);
    }
public function index_get($id = 0)
    {
        if (!empty($id)) {
            $data = $this->db->get_where("user", ['id_user' => $id])->row_array();
        } else {
            $data = $this->db->get_where("user")->result();
        }

        $this->response($data, REST_Controller::HTTP_OK);
    }
      
    /**
     * Get All Data from this method.
     *  
     * @return Response
    */
    public function index_post()
    {
        $input = $this->input->post();
        $this->db->insert('user',$input);
     
        $this->response(['User created successfully.'], REST_Controller::HTTP_OK);
    } 
     
    /**
     * Get All Data from this method.
     *
     * @return Response
    */
    public function index_put($id)
    {
        $input = $this->put();
        $this->db->update('user', $input, array('id'=>$id));
     
        $this->response(['User updated successfully.'], REST_Controller::HTTP_OK);
    }
     
    /**
     * Get All Data from this method.
     *
     * @return Response
    */
    public function index_delete($id)
    {
        $this->db->delete('user', array('id'=>$id));
       
        $this->response(['User deleted successfully.'], REST_Controller::HTTP_OK);
    }
    	
}