<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('DAO');
  }

  function animalWeighing_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('animal_weighing', array('id_estrus' => $id), TRUE);
      } else {
        $response = $this->DAO->selectEntity('animal_weighing', array('status' => 1));
      }
    }
    $this->response($response, $response['status_code']);
  }

  function animalForearring_get()
  {
    $earring = $this->get('earring');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($earring) {
        $response = $this->DAO->animalForearring($earring);
      } else {
        $response = $this->DAO->animalForearring();
      }
    }
    $this->response($response, $response['status_code']);
  }




  function animalWeighing_post()
  {
    $data = $this->post();
    if (count($data) == 0 || count($data) > 12) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
        "data" => count($data),
        "validations" => array(
          "earring" => "required and unique",
          "date_weighing" => "required and unique",
          "weight" => "required and unique",
          "comments" => "required and unique",
        )
      );
    } else {
      $this->form_validation->set_data($data);
      $this->form_validation->set_rules('earring', 'earring', 'required');
      $this->form_validation->set_rules('date_weighing', 'date_weighing', 'required');
      $this->form_validation->set_rules('weight', 'weight', 'required');
      $this->form_validation->set_rules('comments', 'comments', 'required');
      if ($this->form_validation->run() == FALSE) {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "validations error",
          "data" => null,
          "validations" => $this->form_validation->error_array()
        );
      } else {
        $currentDate = date('Y-m-d H:i:s');
        date_default_timezone_set('America/Mexico_City');
        
        $e = array(
          "earring" => $this->post('earring'),
          "date_weighing" => $this->post('date_weighing'),
          "weight" => $this->post('weight'),
          "comments" => $this->post('comments'),
          "created_date" => $currentDate,
          "updated_date" => $currentDate
        );
        $dataResponse = $this->DAO->saveOrUpdateItem('animal_weighing', $e, null, true);
        if ($dataResponse['status'] == "success") {
          $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" =>  "item created successfully",
            "data" => null,
          );
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" =>  $dataResponse['message'],
            "data" => null,
          );
        }
      }
    }
    $this->response($response, $response['status_code']);
  }

  function animalWeighing_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('animal_weighing', array('id_weighing' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 12) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "earring" => "required and unique",
              "date_weighing" => "required and unique",
              "weight" => "required and unique",
              "comments" => "required and unique",
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "earring" => "required and unique",
              "date_weighing" => "required and unique",
              "weight" => "required and unique",
              "comments" => "required and unique",
            ),
            "data" => null
          );
        } else {
          $this->form_validation->set_data($this->put());
          $this->form_validation->set_rules('earring', 'earring', 'required');
          $this->form_validation->set_rules('date_weighing', 'date_weighing', 'required');
          $this->form_validation->set_rules('weight', 'weight', 'required');
          $this->form_validation->set_rules('comments', 'comments', 'required');
          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            $currentDate = date('Y-m-d H:i:s');
            date_default_timezone_set('America/Mexico_City');

            $data = array(
              "earring" => $this->put('earring'),
              "date_weighing" => $this->put('date_weighing'),
              "weight" => $this->put('weight'),
              "comments" => $this->put('comments'),
              "created_date" => $currentDate,
              "updated_date" => $currentDate
            );

            $response = $this->DAO->saveOrUpdateItem('animal_weighing', $data, array('id_weighing' => $id));
          }
        }
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }


  function animalWeighing_delete()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('animal_weighing', array('id_weighing' => $id), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $births = array(
          'status' => 0,
          'updated_date' => $currentDate
        );
        $response = $this->DAO->updateData('animal_weighing', $births, array('id_weighing' => $id));
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the code of weighing does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
}
