<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('DAO');
    $this->load->model('GraphsQueries');
    $this->load->model('EggProduction');
  }


  function all_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('vw_production', array('id_production' => $id), TRUE);
      } else {
        $response = $this->DAO->selectEntity('vw_production', array('status' => 1, 'product_type' => 'Huevo'));
      }
    }
    $this->response($response, $response['status_code']);
  }
   function report_egg_production_get()
  {
    $start = $this->get('start');
    $end = $this->get('end');
    $rodeo = $this->get('rodeo');
    if (count($this->get()) > 3) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Demasiados parametros fueron enviados",
        "validations" => array(
          "start" => "Envia fecha de inicio",
          "end" => "Envia fecha de termino",
          "rodeo" => "Envia rodeo"
        ),
        "data" => null
      );
    } else {
      if ($start && $end && $rodeo != 'all') {
        $response = $this->EggProduction->getEggProduction($start, $end, $rodeo);
      } else {
        $response = $this->EggProduction->getEggProduction($start, $end);
      }
    }
    $this->response($response, $response['status_code']);
  }
  function by_month_get()
  {
    $response = $this->GraphsQueries->eggProductionByMonth();
    $this->response($response, $response['status_code']);
  }
  //byday
  function custom_query_by_day_get()
  {
    $date = $this->get('date');
    $rodeo = $this->get('rodeo');
    $ud = $this->get('ud');
    if ($rodeo == 'general') {
      $response = $this->GraphsQueries->customEggProductionByDay($date);
    } else if ($rodeo == 'all') {
      $response = $this->GraphsQueries->customEggProductionByDay($date, $rodeo, $ud);
    } else {
      $response = $this->GraphsQueries->customEggProductionByDay($date, $rodeo);
    }
    $this->response($response, $response['status_code']);
  }
  function custom_query_get()
  {
    $start = $this->get('start');
    $end = $this->get('end');
    $rodeo = $this->get('rodeo');
    if ($rodeo == 'general') {
      $response = $this->GraphsQueries->currentEggProductionGeneral($start, $end);
    } else if ($rodeo == 'all') {
      $response = $this->GraphsQueries->currentEggProductionGeneral($start, $end, $rodeo);
    } else {
      $response = $this->GraphsQueries->currentEggProductionGeneral($start, $end, $rodeo);
    }
    $this->response($response, $response['status_code']);
  }
  function by_size_current_month_get()
  {
    $response = $this->GraphsQueries->eggProductionBySizeCurrentMonth();
    $this->response($response, $response['status_code']);
  }
  function broken_eggs_current_month_get()
  {
    $response = $this->GraphsQueries->brokenEggProductionCurrentMonth();
    $this->response($response, $response['status_code']);
  }

  function by_day_current_month_get()
  {
    $response = $this->GraphsQueries->eggProductionByDayCurrentMonth();
    $this->response($response, $response['status_code']);
  }
}
