<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
    }

    function inseminations_get()
    {
        $id = $this->get('id');
        if (count($this->get()) > 1) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too many params was sent",
                "validations" => array(
                    "id" => "Send Id (Get) to get specific insemination, or empty to get all inseminations"
                ),
                "data" => null
            );
        } else {
            if ($id) {
                $response = $this->DAO->selectEntity('vw_insemination', array('id_insemination' => $id), TRUE);
            } else {
                $response = $this->DAO->selectEntity('vw_insemination', array('status' => '1'));
            }
        }
        $this->response($response, $response['status_code']);
    }

    function inseminationsForReport_get()
    {
        $desde = $this->get('desde');
        $hasta = $this->get('hasta');
        if (count($this->get()) > 2) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too many params was sent",
                "validations" => array(
                    "id" => "Send Id (Get) to get specific insemination, or empty to get all inseminations"
                ),
                "data" => null
            );
        } else {
            if ($desde) {
                $response = $this->DAO->inseminationsForReport($desde, $hasta);
            } else {
                $response = $this->DAO->inseminationsForReport();
            }
        }
        $this->response($response, $response['status_code']);
    }

    function inseminations_post()
    {
        $data = $this->post();
        if (count($data) == 0 || count($data) > 12) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
                "data" => count($data),
                "validations" => array(
                    // "animal" => "Required field, previously registered",
                    "date" => "Required field",
                    "hour" => "Required field",
                    "sperm_type" => "Required field",
                    "comment" => "Optional field"
                )
            );
        } else {
            $this->form_validation->set_data($data);
            // $this->form_validation->set_rules('animal', 'animal', 'required|callback_animal_exists');
            $this->form_validation->set_rules('date', 'date', 'required');
            $this->form_validation->set_rules('hour', 'hour', 'required');
            $this->form_validation->set_rules('sperm_type', 'sperm_type', 'required');

            if ($this->form_validation->run() == FALSE) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "validations error",
                    "data" => null,
                    "validations" => $this->form_validation->error_array()
                );
            } else {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                

                $insemination = array(
                    'earring' => $data['earring'],
                    'date_insemination' => $data['date'],
                    'animal_id' => $data['animal'],
                    'hour_insemination' => $data['hour'],
                    'sperm_type' => $data['sperm_type'],
                    'comment' => $data['comment'],
                    'created_date' => $currentDate,
                    'updated_date' => $currentDate
                );

                $dataResponse = $this->DAO->saveOrUpdateItem('insemination', $insemination, null, true);
                if ($dataResponse['status'] == "success") {
                    $response = array(
                        "status" => "success",
                        "status_code" => 200,
                        "message" =>  "Item created successfully",
                        "data" => null,
                    );
                } else {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" =>  $dataResponse['message'],
                        "data" => null,
                    );
                }
            }
        }
        $this->response($response, $response['status_code']);
    }

    function inseminations_put()
    {
        $id = $this->get('id');
        $data = $this->put();
        if ($id) {
            $dataExists = $this->DAO->selectEntity('insemination', array('id_insemination' => $id), TRUE);
            if ($dataExists['data']) {
                if (count($data) > 12) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Too many data was sent",
                        "validations" => array(
                            "animal" => "Required field, previously registered",
                            "date" => "Required field",
                            "hour" => "Required field",
                            "sperm_type" => "Required field",
                            "comment" => "Optional field"
                        ),
                        "data" => null
                    );
                } else if (count($data) == 0) {
                    $response = array(
                        "status" => "error",
                        "status_code" => 409,
                        "message" => "Too many data was sent",
                        "validations" => array(
                            "animal" => "Required field, previously registered",
                            "date" => "Required field",
                            "hour" => "Required field",
                            "sperm_type" => "Required field",
                            "comment" => "Optional field"
                        ),
                        "data" => null
                    );
                } else {

                    $this->form_validation->set_data($data);
                    $this->form_validation->set_rules('animal', 'animal', 'required|callback_animal_exists');
                    $this->form_validation->set_rules('date', 'date', 'required');
                    $this->form_validation->set_rules('hour', 'hour', 'required');
                    $this->form_validation->set_rules('sperm_type', 'sperm_type', 'required');

                    if ($this->form_validation->run() == FALSE) {
                        $response = array(
                            "status" => "error",
                            "status_code" => 409,
                            "message" => "Validation fail, see validations object for more details",
                            "validations" => $this->form_validation->error_array(),
                            "data" => null
                        );
                    } else {
                        date_default_timezone_set('America/Mexico_City');
                        $currentDate = date('Y-m-d H:i:s');
                        $animal = $this->DAO->selectEntity('animals', array('id_animals' => $data['animal']), TRUE)['data'];

                        $insemination = array(
                            'earring' => $animal->earring,
                            'date_insemination' => $data['date'],
                            'animal_id' => $data['animal'],
                            'hour_insemination' => $data['hour'],
                            'sperm_type' => $data['sperm_type'],
                            'comment' => $data['comment'],
                            'updated_date' => $currentDate
                        );
                        $response = $this->DAO->saveOrUpdateItem('insemination', $insemination, array('id_insemination' => $id));
                    }
                }
            }
        } else {

            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Too data was sent",
                "validations" => array(
                    "id" => "Required",

                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }
    function inseminations_delete()
    {
        $id = $this->get('id');
        if ($id) {
            $dataExists = $this->DAO->selectEntity('insemination', array('id_insemination' => $id), TRUE);
            if ($dataExists['data']) {
                date_default_timezone_set('America/Mexico_City');
                $currentDate = date('Y-m-d H:i:s');
                $insemination = array(
                    'status' => 0,
                    'updated_date' => $currentDate
                );
                $response = $this->DAO->updateData('insemination', $insemination, array('id_insemination' => $id));
            } else {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "the code of insemination does not exists",
                    "validations" => null,
                    "data" => null
                );
            }
        } else {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Id wasn't sent",
                "validations" => array(
                    "id" => "Required (get)",
                ),
                "data" => null
            );
        }
        $this->response($response, $response['status_code']);
    }

    function animal_exists($str)
    {
        if (strlen($str) >= 1  && strlen($str) <= 45) {
            $animalExists = $this->DAO->selectEntity('animals', array('id_animals' => $str), TRUE);
            if ($animalExists['data']) {
                return TRUE;
            } else {
                $this->form_validation->set_message('animal_exists', 'The field {field} does not exists');
                return FALSE;
            }
        }
    }
}
