<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

    function __construct()
    {
        parent::__construct();
        $this->load->model('DAO');
        $this->load->helper('string');
    }
    function login_get()
    {
        $id = $this->get('id');
        if ($id) {
            $response = array(
                "status" => "success",
                "message" => '',
                "data" => $this->DAO->selectEntity('vw_User', array('user' => $id)),
            );
        } else {
            $response = array(
                "status" => "success",
                "message" => '',
                "data" => $this->DAO->selectEntity('vw_User'),
            );
        }
        $this->response($response, 200);
    }
    function login_post()
    {
        if (count($this->post()) > 10) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados datos fueron enviados",
                "validations" => array(
                    "email" => "required",
                    "password" => "required"
                ),
                "data" => null
            );
        } else {
            $this->form_validation->set_data($this->post());
            $this->form_validation->set_rules('email', 'email', 'required');
            $this->form_validation->set_rules('password', 'password', 'required');


            if ($this->form_validation->run() == false) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "¡Correo electrónico o contraseña incorrecto, por favor ingresa credenciales correctas!",
                    "validations" => $this->form_validation->error_array(),
                    "data" => $this->post()
                );
            } else {
                $userExists = $this->DAO->client_log_in($this->post('email'), $this->post('password'));
                if ($userExists) {
                    if ($userExists['status'] == 0) {
                        $response = array(
                            "status" => "error",
                            "message" => "Cuenta no verificada"
                        );
                    } else {
                        $token=random_string('alnum',40);
                        $response = array(
                            "status" => "success",
                            "message" => "Inicio de sesión correctamente",
                            "data" => array(
                                'email' => $userExists['email_cliente'],
                                'id' => $userExists['id_cliente'],
                                'phone' => $userExists['telefono_cliente'],
                                'curp' => $userExists['curp_cliente'],
                                'name' => $userExists['nombre_cliente'],
                                'father_lastname' => $userExists['apellido_paterno_cliente'],
                                'mother_lastname' => $userExists['apellido_materno_cliente'],
                                //'photo'=>$userExists->photo
                                'fullname' => $userExists['nombre_cliente'] . ' ' . $userExists['apellido_paterno_cliente'] . ' ' . $userExists['apellido_materno_cliente'],
                                 'token'=>$token
                            )

                        );
                    }
                } else {
                    $response = array(
                        "status" => "error",
                        "message" => "¡Correo electrónico o contraseña incorrecto, por favor ingresa credenciales correctas!"
                    );
                }
            }
        }


        $this->response($response, 200);
    }

    function user_login_post()
    {

        if (count($this->post()) > 10) {
            $response = array(
                "status" => "error",
                "status_code" => 409,
                "message" => "Demasiados datos fueron enviados",
                "validations" => array(
                    "email" => "required",
                    "password" => "required"

                ),
                "data" => null
            );
        } else {
            $this->form_validation->set_data($this->post());
            $this->form_validation->set_rules('email', 'email', 'required');
            $this->form_validation->set_rules('password', 'password', 'required');

            if ($this->form_validation->run() == false) {
                $response = array(
                    "status" => "error",
                    "status_code" => 409,
                    "message" => "¡Correo electrónico o contraseña incorrecto, por favor ingresa credenciales correctas!",
                    "validations" => $this->form_validation->error_array(),
                    "data" => $this->post()
                );
            } else {
                $userExists = $this->DAO->user_log_in($this->post('email'), $this->post('password'));
                if ($userExists) {
                    if ($userExists['status'] == 0) {
                        $response = array(
                            "status" => "error",
                            "message" => "Cuenta desactivada, para mas detalles contacte al administrador"
                        );
                    }else{
                         $response = array(
                        "status" => "success",
                        "message" => "Inicio de sesión correctamente",
                        "data" => array(
                            'email' => $userExists['email'],
                            'id' => $userExists['id_usuario'],
                            'phone' => $userExists['telefono_usuario'],
                            'name' => $userExists['nombre_usuario'],
                            'fullname' => $userExists['nombre_usuario'].' '.$userExists['apellido_paterno'].' '.$userExists['apellido_materno'].' ',
                            'img-profile' => $userExists['img_perfil'],
                            'type' => $userExists['nivel']
                        )

                    );
                    } 
                   
                } else {
                    $response = array(
                        "status" => "error",
                        "message" => "¡Correo electrónico o contraseña incorrecto, por favor ingresa credenciales correctas!"
                    );
                }
            }
        }


        $this->response($response, 200);
    }
}
