<?php

use Restserver\Libraries\REST_Controller;

defined('BASEPATH') or exit('No direct script access allowed');

require APPPATH . 'libraries/REST_Controller.php';
require APPPATH . 'libraries/Format.php';

class Api extends REST_Controller
{

  function __construct()
  {
    parent::__construct();
    $this->load->model('DAO');
  }

  function reproductiveCycle_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('reproductive_cycle', array('id_estrus' => $id), TRUE);
      } else {
        $response = $this->DAO->selectEntity('reproductive_cycle', array('status' => 1));
      }
    }
    $this->response($response, $response['status_code']);
  }

  function reproductiveCycleReport_get()
  {
    $desde = $this->get('desde');
    $hasta = $this->get('hasta');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($desde) {
        $response = $this->DAO->CycleReport($desde, $hasta);
      } else {
        $response = $this->DAO->CycleReport();
      }
    }
    $this->response($response, $response['status_code']);
  }


  function reproductiveCycleForWeek_get()
  {
    $id = $this->get('id');
    if (count($this->get()) > 1) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too many params was sent",
        "validations" => array(
          "id" => "Send Id (Get) to get specific brand, or empty to get all brands"
        ),
        "data" => null
      );
    } else {
      if ($id) {
        $response = $this->DAO->selectEntity('reproductive_cycle', array('id_cycle' => $id), TRUE);
      } else {
        $response = $this->DAO->selectEntity('reproductive_cycle', array('status' => 1));
      }
    }
    $this->response($response, $response['status_code']);
  }



  function reproductiveCycle_post()
  {
    $data = $this->post();
    if (count($data) == 0 || count($data) > 12) {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => count($data) == 0 ? 'No data received' : 'Too many data received',
        "data" => count($data),
        "validations" => array(
          "week" => "required and unique",
          "food_rest" => "required and unique",
          "average_tem" => "required and unique",
          "light_hours" => "required and unique",
          "broken_eggs" => "required and unique",
          "good_eggs" => "required and unique",
          "total_eggs" => "required and unique",
          "total_kg" => "required and unique",
          "average_weight" => "required and unique",
        )
      );
    } else {
      $this->form_validation->set_data($data);
      $this->form_validation->set_rules('week', 'week ', 'required');
      $this->form_validation->set_rules('food_rest', 'food_rest ', 'required');
      $this->form_validation->set_rules('average_tem', 'average_tem', 'required');
      $this->form_validation->set_rules('light_hours', 'light_hours', 'required');
      $this->form_validation->set_rules('broken_eggs', 'broken_eggs', 'required');
      $this->form_validation->set_rules('good_eggs', 'good_eggs', 'required');
      $this->form_validation->set_rules('total_eggs', 'total_eggs', 'required');
      $this->form_validation->set_rules('total_kg', 'total_kg', 'required');
      $this->form_validation->set_rules('average_weight', 'average_weight', 'required');
      if ($this->form_validation->run() == FALSE) {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "validations error",
          "data" => null,
          "validations" => $this->form_validation->error_array()
        );
      } else {
        $eggs = array(
          "week" => $this->post('week'),
          "food_rest" => $this->post('food_rest'),
          "average_tem" => $this->post('average_tem'),
          "light_hours" => $this->post('light_hours'),
          "broken_eggs" => $this->post('broken_eggs'),
          "good_eggs" => $this->post('good_eggs'),
          "total_eggs" => $this->post('total_eggs'),
          "total_kg" => $this->post('total_kg'),
          "average_weight" => $this->post('average_weight'),
        );
        $dataResponse = $this->DAO->saveOrUpdateItem('reproductive_cycle', $eggs, null, true);
        if ($dataResponse['status'] == "success") {
          $response = array(
            "status" => "success",
            "status_code" => 200,
            "message" =>  "item updated successfully",
            "data" => null,
          );
        } else {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" =>  $dataResponse['message'],
            "data" => null,
          );
        }
      }
    }
    $this->response($response, $response['status_code']);
  }

  function reproductiveCycle_put()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('reproductive_cycle', array('id_cycle' => $id), TRUE);
      if ($dataExists) {
        if (count($this->put()) > 12) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "Too many data was sent",
            "validations" => array(
              "week" => "required and unique",
              "food_rest" => "required and unique",
              "average_tem" => "required and unique",
              "light_hours" => "required and unique",
              "broken_eggs" => "required and unique",
              "good_eggs" => "required and unique",
              "total_eggs" => "required and unique",
              "total_kg" => "required and unique",
              "average_weight" => "required and unique",
            ),
            "data" => null
          );
        } else if (count($this->put()) == 0) {
          $response = array(
            "status" => "error",
            "status_code" => 409,
            "message" => "No data was sent",
            "validations" => array(
              "week" => "required and unique",
              "food_rest" => "required and unique",
              "average_tem" => "required and unique",
              "light_hours" => "required and unique",
              "broken_eggs" => "required and unique",
              "good_eggs" => "required and unique",
              "total_eggs" => "required and unique",
              "total_kg" => "required and unique",
              "average_weight" => "required and unique",
            ),
            "data" => null
          );
        } else {
          $this->form_validation->set_rules('week', 'week ', 'required');
          $this->form_validation->set_rules('food_rest', 'food_rest ', 'required');
          $this->form_validation->set_rules('average_tem', 'average_tem', 'required');
          $this->form_validation->set_rules('light_hours', 'light_hours', 'required');
          $this->form_validation->set_rules('broken_eggs', 'broken_eggs', 'required');
          $this->form_validation->set_rules('good_eggs', 'good_eggs', 'required');
          $this->form_validation->set_rules('total_eggs', 'total_eggs', 'required');
          $this->form_validation->set_rules('total_kg', 'total_kg', 'required');
          $this->form_validation->set_rules('average_weight', 'average_weight', 'required');
          if ($this->form_validation->run() == FALSE) {
            $response = array(
              "status" => "error",
              "status_code" => 409,
              "message" => "Validation fail, see validations object for more details",
              "validations" => $this->form_validation->error_array(),
              "data" => null
            );
          } else {
            $data = array(
              "week" => $this->put('week'),
              "food_rest" => $this->put('food_rest'),
              "average_tem" => $this->put('average_tem'),
              "light_hours" => $this->put('light_hours'),
              "broken_eggs" => $this->put('broken_eggs'),
              "good_eggs" => $this->put('good_eggs'),
              "total_eggs" => $this->put('total_eggs'),
              "total_kg" => $this->put('total_kg'),
              "average_weight" => $this->put('average_weight'),
            );

            $response = $this->DAO->saveOrUpdateItem('reproductive_cycle', $data, array('id_cycle' => $id));
          }
        }
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Too data was sent",
        "validations" => array(
          "id" => "Required",

        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }


  function reproductiveCycle_delete()
  {
    $id = $this->get('id');
    if ($id) {
      $dataExists = $this->DAO->selectEntity('reproductive_cycle', array('id_cycle' => $id), TRUE);
      if ($dataExists['data']) {
        date_default_timezone_set('America/Mexico_City');
        $currentDate = date('Y-m-d H:i:s');
        $births = array(
          'status' => 0,
          'updated_date' => $currentDate
        );
        $response = $this->DAO->updateData('reproductive_cycle', $births, array('id_cycle' => $id));
      } else {
        $response = array(
          "status" => "error",
          "status_code" => 409,
          "message" => "the code of animal does not exists",
          "validations" => null,
          "data" => null
        );
      }
    } else {
      $response = array(
        "status" => "error",
        "status_code" => 409,
        "message" => "Id wasn't sent",
        "validations" => array(
          "id" => "Required (get)",
        ),
        "data" => null
      );
    }
    $this->response($response, $response['status_code']);
  }
}
