<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class AnimalCategory extends CI_Controller{

  public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata('user_admin_sess')) {
			redirect('login');
		}
	}

  function index()
  {
    $data['body']='animal_category/list';
    $data['animal_category'] = $this->getCategories();
    $this->load->view('layout/main', $data);
  }

  public function getCategories()
  {
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'animal_category/api/animal_category',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    $animalCategory = json_decode($response);
    return $animalCategory->data;
  }

  function getCategoryById($id)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'animal_category/api/animal_category/id/' . $id,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));
    $response = curl_exec($curl);

    curl_close($curl);
    $animalCategory = json_decode($response);
    $this->session->set_flashdata('category_details', array('data' => $animalCategory->data));
    redirect('animalCategory');
  }

}
