<?php
defined('BASEPATH') or exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;




class Animals extends CI_Controller
{
  public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata('user_admin_sess')) {
			redirect('login');
		}
	}

  public function index()
  {
    $data['body'] = 'animals/animals';
    $data['animals'] = $this->getAnimals();
    // $data['rodeos'] = $this->getRodeos();
    $data['categories'] = $this->getCategories();
    $this->load->view('layout/main', $data);

    // var_dump($this->session->userdata('user_admin_sess')->name);
  }

  public function getCategories()
  {
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'animal_category/api/animal_category',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    $animalCategory = json_decode($response);
    return $animalCategory->data;
  }


 
  function animForReport($specie)
  {

    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'animals/api/animForReport/specie/' . $specie,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    $animalsFor = json_decode($response);
    return $animalsFor->data;
  }

  function getAnimals()
  {
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL.'animals/api/animals',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    $animals = json_decode($response);
    return $animals->data;
  }

  function valid_earring(){
    $animals=$this->getAnimals();
    $earrings=[];
    foreach ($animals as $animal){
      $earrings[]=$animal->earring;
    }
    $requestedEarring=$_REQUEST['earring'];
    if (in_array($requestedEarring, $earrings)){
      echo 'false';
    }else{
      echo 'true';
    }
  }

  function delete_animals($id_animals)
  {

    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL.'animals/api/animals/id/'.$id_animals,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'DELETE',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    echo $response;
  }

  function edit_animals($id_animals)
  {

    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL.'animals/api/animals/id/'.$id_animals,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'PUT',
      CURLOPT_POSTFIELDS =>'{"name":"Borrego1",
        "spacies":"Ovinos1",
        "race":"Dorpe1",
        "gender":"Macho",
        "birth_date":"2021-06-17",
        "birth_weight":"20",
        "earring":"15001267",
        "mother_earring":"150012",
        "father_earring":"150032",
        "id_rodeo":"1",
        "comments":"Comentario de prueba"
        }',
        CURLOPT_HTTPHEADER => array(
          'x-api-key: QroSystem%21#',
          'Content-Type: application/json'
        ),
      ));

      $response = curl_exec($curl);

      curl_close($curl);
      echo $response;
    }

    function getRodeos()
    {
      $curl = curl_init();
      curl_setopt_array($curl, array(
        CURLOPT_URL => API_URL.'rodeos/api/rodeos',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
          'x-api-key: QroSystem%21#'
        ),
      ));

      $response = curl_exec($curl);
      curl_close($curl);
      $rodeos = json_decode($response);
      return $rodeos->data;
    }

    function getDisabledAnimals()
    {
      $curl = curl_init();
      curl_setopt_array($curl, array(
        CURLOPT_URL => API_URL.'animals/api/inactive_animals',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
          'x-api-key: QroSystem%21#'
        ),
      ));
      $response = curl_exec($curl);
      curl_close($curl);
      $disabledAnimals = json_decode($response);
      return $disabledAnimals->data;
    }

    function inactiveAnimals(){
      $data['body'] = 'animals/inactive_animals';
      $data['animals'] = $this->getDisabledAnimals();
      $this->load->view('layout/main', $data);
    }


  function get_weaning($earring)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'animal_weighing/api/animalForearring/earring/' . $earring,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    // echo $response;
    $weaning = json_decode($response);
    return $weaning->data;
  }


    function getAnimalsById($id_animal)
    {
      $curl = curl_init();
      curl_setopt_array($curl, array(
        CURLOPT_URL => API_URL.'animals/api/animals/id/'.$id_animal,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
          'x-api-key: QroSystem%21#'
        ),
      ));
      $response = curl_exec($curl);
      curl_close($curl);
      $animals = json_decode($response);
      $this->session->set_flashdata('animals_details', array('data' => $animals->data));
      redirect('animals');
    }
  public function animals_report()
  {
    $specie_ = $this->input->post('specie');
    $animals = $this->animForReport($specie_);
    $status=$this->input->post('status_');
    $general_info = array(
      'specie' => $specie_,
      'status'=>$status,
    );
    $mpdf = new \Mpdf\Mpdf();
    $mpdf = new \Mpdf\Mpdf(['orientation' => 'P']);
    $header = $this->load->view('reports/animals/header', array('general_info' => $general_info), true);
    $mpdf->SetHTMLHeader($header);
    $footer = $this->load->view('reports/animals/footer', [], true);
    $mpdf->SetHTMLFooter($footer);
    $html = $this->load->view('reports/animals/body', array('animals' => $animals, 'general_info' => $general_info), true);
    $css = file_get_contents('assets/pdf-reports.css');
    $mpdf->SetTitle('Reporte de animales');
    $mpdf->WriteHTML('<body>');
    $mpdf->WriteHTML($css, 1);
    $mpdf->WriteHTML($html);
    $mpdf->WriteHTML('</body>');
    $mpdf->Output('Reporte_de_animales' . date("Ymd") . '.pdf', 'I');

    exit;
    $mpdf->Output();
  }
 public function animals_reportxx()
  {

    $specie_ = $this->input->post('specie');
    $stat_ = $this->input->post('status_');


    setlocale(LC_TIME, 'spanish');


    $animals = $this->animForReport($specie_);
    /* $mortalities = $this->getMortality(); */
    $mpdf = new \Mpdf\Mpdf();
    $mpdf = new \Mpdf\Mpdf(['orientation' => 'P']);
    $mpdf->SetHTMLHeader('
          <table class="test" width="100%"> 
	<TR>
		<TD width="33%" ROWSPAN=2><img src="' . base_url() . 'assets/img/logo.jpg" width="95" height="95"></TD>
	  <TD width="33%" align="center"><h1>Rancho El Arenal</h1></TD> 
    <TD  width="33%" style="text-align: right;"><h4>Reporte de registro de animales</h4></TD> 
	</TR>
	<TR>
		<TD align="center" style="padding-top:0px;"> <h4 style="padding-top:0px;">Centro Ecoturistico</h4></TD> 
    <TD style="text-align: right;"> <img src="' . base_url() . 'assets/img/grafica1.png" width="300" height="95"></TD> 
	</TR>
 </table>
');
    $mpdf->SetHTMLFooter('
          <table class="normal" width="100%">
          <tr>
              <td width="33%"></td>
              <td width="33%" align="center">{PAGENO}/{nbpg}</td>
              <td width="33%" style="text-align: right;"> {DATE j-m-Y}</td>
          </tr>
      </table>        ');
    $html = '	
          <table width="100%" class="table table-bordered">
               <thead>
               <tr>
                <th>N°</th>
                <th>Arete</th>        
                <th>Especie</th>
                <th>Raza</th>
                <th>Categoria</th>
                <th>Genero</th>
                <th>F Nac.</th>        
                <th>Corral</th>
                <th>Peso</th>
                <th>Sta</th>
               
                </thead>                   
          ';
    $html .= '<tbody>';
    $total = 0;
    foreach ($animals as $i => $animal) {


      $i = $i + 1;

      setlocale(LC_TIME, 'spanish');
      $fechaT = strftime('%d-%b-%y', strtotime($animal->birth_date));
      $weight_ = $this->get_weaning($animal->earring);

      if ($stat_ == 0) {
        $total = $total + 1;

        if ($weight_) {
          $weig_ = $weight_->weight . ' kg';
          if ($weig_ >= 30) {
            $status_ = '<img src="' . base_url() . 'assets/img/buena1.png" width="20" height="20"></TD>';
          }
          if ($weig_ < 30 && $weig_ >= 25) {
            $status_ = '<img src="' . base_url() . 'assets/img/media.png" width="20" height="20"></TD>';
          }

          if ($weig_ < 25) {
            $status_ = '<img src="' . base_url() . 'assets/img/mala.png" width="20" height="20"></TD>';
          }
        } else {
          $weig_ = "- - -";
          $stat = "N/A";
          $status_ = "- - -";
        }

        $html .= '<tr>'
          . '<td>' . $i . '</td>'
          . '<td>' . $animal->earring . '</td>'
          . '<td>' . $animal->specie . '</td>'
          . '<td>' . $animal->race . '</td>'
          . '<td>' . $animal->category_name . '</td>'
          . '<td>' . $animal->gender . '</td>'
          . '<td>' . $fechaT . '</td>'
          // . '<td>' . $animal->birth_weight . '</td>'
          . '<td>' . $animal->rodeo_name . '</td>'
          . '<td>' . $weig_ . '</td>'
          . '<td>' . $status_ . '</td>';
      }
      if ($stat_ == 3) {

        if ($weight_) {
          $weig_ = $weight_->weight . ' kg';
          if ($weig_ >= 30) {
            $total = $total + 1;

            $status_ = '<img src="' . base_url() . 'assets/img/buena1.png" width="20" height="20"></TD>';
            $html .= '<tr>'
              . '<td>' . $i . '</td>'
              . '<td>' . $animal->earring . '</td>'
              . '<td>' . $animal->specie . '</td>'
              . '<td>' . $animal->race . '</td>'
              . '<td>' . $animal->category_name . '</td>'
              . '<td>' . $animal->gender . '</td>'
              . '<td>' . $fechaT . '</td>'
              // . '<td>' . $animal->birth_weight . '</td>'
              . '<td>' . $animal->rodeo_name . '</td>'
              . '<td>' . $weig_ . '</td>'
              . '<td>' . $status_ . '</td>';
          }
        } else {
          $weig_ = "- - -";
          $stat = "N/A";
          $status_ = "- - -";
        }
      }
      if ($stat_ == 2) {

        if ($weight_) {
          $total = $total + 1;
          $weig_ = $weight_->weight . ' kg';

          if ($weig_ < 30 && $weig_ >= 25) {
            $status_ = '<img src="' . base_url() . 'assets/img/media.png" width="20" height="20"></TD>';
            $html .= '<tr>'
              . '<td>' . $i . '</td>'
              . '<td>' . $animal->earring . '</td>'
              . '<td>' . $animal->specie . '</td>'
              . '<td>' . $animal->race . '</td>'
              . '<td>' . $animal->category_name . '</td>'
              . '<td>' . $animal->gender . '</td>'
              . '<td>' . $fechaT . '</td>'
              // . '<td>' . $animal->birth_weight . '</td>'
              . '<td>' . $animal->rodeo_name . '</td>'
              . '<td>' . $weig_ . '</td>'
              . '<td>' . $status_ . '</td>';
          }
        } else {
          $weig_ = "- - -";
          $stat = "N/A";
          $status_ = "- - -";
        }
      }
      if ($stat_ == 1) {

        if ($weight_) {
          $total = $total + 1;
          $weig_ = $weight_->weight . ' kg';

          if ($weig_ < 25) {
            $status_ = '<img src="' . base_url() . 'assets/img/mala.png" width="20" height="20"></TD>';
            $html .= '<tr>'
              . '<td>' . $i . '</td>'
              . '<td>' . $animal->earring . '</td>'
              . '<td>' . $animal->specie . '</td>'
              . '<td>' . $animal->race . '</td>'
              . '<td>' . $animal->category_name . '</td>'
              . '<td>' . $animal->gender . '</td>'
              . '<td>' . $fechaT . '</td>'
              // . '<td>' . $animal->birth_weight . '</td>'
              . '<td>' . $animal->rodeo_name . '</td>'
              . '<td>' . $weig_ . '</td>'
              . '<td>' . $status_ . '</td>';
          }
        } else {
          $weig_ = "- - -";
          $stat = "N/A";
          $status_ = "- - -";
        }
      }
    }
    $html .= '<tr>
                  </tr>
                  </tbody> 
                  <tfoot>
                  <tr>
                    <th colspan="2">Animales totales</th>
                    <td colspan="7"></td>    
            <th colspan="1">' . $total . '</th>
                  </tr>
                </tfoot>
                  </table>
                  ';
    $data = '';
    $data .= '
          <style>
              h1 {
              }
          </style>';
    $data .= '<img width = "10" src = "assets/img/logo.jpg>';
    $css = file_get_contents('assets/pdf.css');
    /* Impresion y salida del documento */
    $mpdf->WriteHTML($data);
    /*   $mpdf->Image('assets/img/logo.jpg', 20, 0, 30, 30, 'jpg', '', true, false); */
    $mpdf->SetTitle('Reporte de animales');
    $mpdf->WriteHTML('<body>');
    $mpdf->writeHTML($css, 1);
    $mpdf->WriteHTML($html);
    $mpdf->WriteHTML('</body>');
    $mpdf->Output('Reporte_de_animales.pdf', 'I');
    $mpdf->setFooter('{PAGENO}');

    $mpdf->WriteHTML('Section 1');
    $mpdf->WriteHTML('');

    exit;
    $mpdf->Output();
  }

  public function animals_report1()
  {
    $specie_ = $this->input->post('specie');
    $desde_ = $this->input->post('desde');
    $hasta_ = $this->input->post('hasta');
    setlocale(LC_TIME, 'spanish');
    $dateDesde = strftime('%d-%b-%y', strtotime($desde_));
    $dateHasta = strftime('%d-%b-%y', strtotime($hasta_));

    $animals = $this->animForReport($specie_, $desde_, $hasta_);
    /* $mortalities = $this->getMortality(); */
    $mpdf = new \Mpdf\Mpdf();
    $mpdf = new \Mpdf\Mpdf(['orientation' => 'P']);
    $mpdf->SetHTMLHeader('
          <table class="normal" width="100%">
          <tr>
              <td width="33%"> <img src="' . base_url() . 'assets/img/logo.jpg" width="95" height="95"> </td>
              <td width="33%" align="center"><h1>Rancho El Arenal</h1></td>
              <td width="33%" style="text-align: right;"><h4>Reporte de registro de animales</h4> <h5>Desde ' . $dateDesde . ' Hasta ' . $dateHasta . ' </h5> </td>
          </tr>
      </table>');
    $mpdf->SetHTMLFooter('
          <table class="normal" width="100%">
          <tr>
              <td width="33%"></td>
              <td width="33%" align="center">{PAGENO}/{nbpg}</td>
              <td width="33%" style="text-align: right;"> {DATE j-m-Y}</td>
          </tr>
      </table>        ');
    $html = '	
          <table width="100%" class="table table-bordered">
               <thead>
               <tr>
                <th>N°</th>
                <th>Arete / ID</th>        
                <th>Especie</th>
                <th>Raza</th>
                
                <th>Genero</th>
                <th>Fecha de nacimiento</th>        
                <th>Peso al nacer</th>
                <th>Corral</th>
        
                </thead>                   
          ';
    $html .= '<tbody>';
    $total = 0;
    foreach ($animals as $i => $animal) {
      $i = $i + 1;
      $total = $total + 1;
      setlocale(LC_TIME, 'spanish');
      $fechaT = strftime('%d-%b-%y', strtotime($animal->birth_date));
      $html .= '<tr>'
      . '<td>' . $i . '</td>'
      . '<td>' . $animal->earring . '</td>'
      . '<td>' . $animal->specie . '</td>'
      . '<td>' . $animal->race . '</td>'
     
      . '<td>' . $animal->gender . '</td>'
      . '<td>' . $fechaT . '</td>'
      . '<td>' . $animal->birth_weight . '</td>'
      . '<td>' . $animal->rodeo_name . '</td>';

    }
    $html .= '<tr>
                  </tr>
                  </tbody> 
                  <tfoot>
                  <tr>
                    <th colspan="2">Animales totales</th>
                    <td colspan="5"></td>    
            <th colspan="1">' . $total . '</th>
                  </tr>
                </tfoot>
                  </table>
                  ';
    $data = '';
    $data .= '
          <style>
              h1 {
              }
          </style>';
    $data .= '<img width = "10" src = "assets/img/logo.jpg>';
    $css = file_get_contents('assets/pdf.css');
    /* Impresion y salida del documento */
    $mpdf->WriteHTML($data);
    /*   $mpdf->Image('assets/img/logo.jpg', 20, 0, 30, 30, 'jpg', '', true, false); */
    $mpdf->SetTitle('Reporte de animales');
    $mpdf->WriteHTML('<body>');
    $mpdf->writeHTML($css, 1);
    $mpdf->WriteHTML($html);
    $mpdf->WriteHTML('</body>');
    $mpdf->Output('Reporte_de_ventas.pdf', 'I');
    $mpdf->setFooter('{PAGENO}');

    $mpdf->WriteHTML('Section 1');
    $mpdf->WriteHTML('');

    exit;
    $mpdf->Output();
  }

  function animals_excel(){
    $specie_ = $this->input->post('specie');
    $animals = $this->animForReport($specie_);
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png');
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);

    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
    $sheet->mergeCells('A1:J4');
    $sheet->mergeCells('A5:H6');
    $sheet->mergeCells('I5:J6');
    
    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

    $sheet->getStyle('A1')->getAlignment()->setVertical('center');

    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');

    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("E5:E6")->getFont()->setBold(true);

    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('H8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('I8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('J8')->applyFromArray($styleArray);

    $sheet->setCellValue('A1', 'Reporte de registro de animales');
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(15);
    $sheet->getColumnDimension('C')->setWidth(30);
    $sheet->getColumnDimension('D')->setWidth(30);
    $sheet->getColumnDimension('E')->setWidth(30);
    $sheet->getColumnDimension('F')->setWidth(15);
    $sheet->getColumnDimension('G')->setWidth(15);
    $sheet->getColumnDimension('H')->setWidth(30);
    $sheet->getColumnDimension('I')->setWidth(10);
    $sheet->getColumnDimension('J')->setWidth(20);

    
    $sheet->setCellValue('I5', $specie_);
    $sheet->setCellValue('A8', 'N.°');
    $sheet->setCellValue('B8', 'Arete/ID');
    $sheet->setCellValue('C8', 'Especie');
    $sheet->setCellValue('D8', 'Raza');
    $sheet->setCellValue('E8', 'Categoria');
    $sheet->setCellValue('F8', 'Genero');
    $sheet->setCellValue('G8', 'Fecha Nac.');
    $sheet->setCellValue('H8', 'Corral');
    $sheet->setCellValue('I8', 'Peso');
    $sheet->setCellValue('J8', 'Status');
    $counter = 8;
    foreach ($animals as $i => $animal) {
      $counter = $counter + 1;
      $i = $i + 1;
      $weight_ = $this->get_weaning($animal->earring);
      if ($weight_) {
        $weig_ = $weight_->weight . ' kg';
        if ($weig_ >= 30) {
          $status_ = 'Buena';
        }
        if ($weig_ < 30 && $weig_ >= 25) {
          $status_ = 'Mediana';
        }

        if ($weig_ < 25) {
          $status_ = 'Deficiente';
        }
      } else {
        $weig_ = "";
        $stat = "N/A";
        $status_ = "";
      }

      $fechaT = strftime('%d-%m-%y', strtotime($animal->birth_date));
      $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("F{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("G{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("H{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("I{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("J{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->setCellValue("A{$counter}", $i);
      $sheet->setCellValue("B{$counter}", $animal->earring);
      $sheet->setCellValue("C{$counter}", $animal->specie);
      $sheet->setCellValue("D{$counter}", $animal->race);
      $sheet->setCellValue("E{$counter}", $animal->category_name);
      $sheet->setCellValue("F{$counter}", $animal->gender);
      $sheet->setCellValue("G{$counter}", $fechaT);
      $sheet->setCellValue("H{$counter}", $animal->rodeo_name);
      $sheet->setCellValue("I{$counter}", $weig_);
      $sheet->setCellValue("J{$counter}", $status_);
    }
    $writer = new Xlsx($spreadsheet);
    $filename = 'Reporte_de_animales';

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
  }

    public function animals_excelxxx(){

      $specie_ = $this->input->post('specie');
      $desde_ = $this->input->post('desde');
      $hasta_ = $this->input->post('hasta');
      
      setlocale(LC_TIME, 'spanish');
      $dateDesde = strftime('%d-%b-%y', strtotime($desde_));
      $dateHasta = strftime('%d-%b-%y', strtotime($hasta_));
      
      $animals = $this->animForReport($specie_,$desde_,$hasta_);
  
      
       /*  $mortalities = $this->getMortality(); */
        $contador1 = 1;
        $contador = 3;
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->getColumnDimension('A')->setWidth(10);
        $sheet->getColumnDimension('B')->setWidth(17);
        $sheet->getColumnDimension('C')->setWidth(16);
        $sheet->getColumnDimension('D')->setWidth(25);
        $sheet->getColumnDimension('E')->setWidth(25);
        $sheet->getColumnDimension('F')->setWidth(10);
        $sheet->getColumnDimension('G')->setWidth(19);
        $sheet->getColumnDimension('H')->setWidth(14);
        $sheet->getColumnDimension('I')->setWidth(10);
        $sheet->getColumnDimension('J')->setWidth(16);
        $sheet->getColumnDimension('K')->setWidth(16);

        $sheet->getStyle("B{$contador1}")->getFont()->setBold(true);
        $sheet->getStyle("E{$contador1}")->getFont()->setBold(true);
        $sheet->getStyle("A{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("B{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("C{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("D{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("E{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("F{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("G{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("H{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("I{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("J{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("K{$contador}")->getFont()->setBold(true);
        $sheet->mergeCells ("B{$contador1}".":C{$contador1}");
        $sheet->setCellValue("B{$contador1}", 'Reporte de animales registrados');
        $sheet->setCellValue("E{$contador1}", 'Del:'.$dateDesde.' Al:'. $dateHasta);
        $sheet->setCellValue("A{$contador}", 'N°');
        $sheet->setCellValue("B{$contador}", 'Arete / Id');
        $sheet->setCellValue("C{$contador}", 'Especie');
        $sheet->setCellValue("D{$contador}", 'Raza');
        $sheet->setCellValue("E{$contador}", 'Categoria');
        $sheet->setCellValue("F{$contador}", 'Genero');
        $sheet->setCellValue("G{$contador}", 'Fecha de nacimiento');
        $sheet->setCellValue("H{$contador}", 'Corral');
        $sheet->setCellValue("I{$contador}", 'Peso');
        $sheet->setCellValue("J{$contador}", 'Estatus');
       
        foreach($animals as $i =>$l){
          $i = $i + 1;
          setlocale(LC_TIME, 'spanish');

      $weight_ = $this->get_weaning($l->earring);
      if ($weight_) {
        $weig_ = $weight_->weight . ' kg';
        if ($weig_ >= 30) {
          $status_ = 'Buena';
        }
        if ($weig_ < 30 && $weig_ >= 25) {
          $status_ = 'Mediana';
        }

        if ($weig_ < 25) {
          $status_ = 'Deficiente';
        }
      } else {
        $weig_ = "- - -";
        $stat = "N/A";
        $status_ = "- - -";
      }

          $fechaT = strftime('%d-%b-%y', strtotime($l->birth_date));
            //Incrementamos una fila más, para ir a la siguiente.
            $contador++;
            //Informacion de las filas de la consulta.
            $sheet->setCellValue("A{$contador}", $i);
            $sheet->setCellValue("B{$contador}", $l->earring);
            $sheet->setCellValue("C{$contador}", $l->specie);
            $sheet->setCellValue("D{$contador}", $l->race);
            $sheet->setCellValue("E{$contador}", $l->category_name);
            $sheet->setCellValue("F{$contador}", $l->gender);
            $sheet->setCellValue("G{$contador}", $fechaT);
            $sheet->setCellValue("H{$contador}", $l->rodeo_name);
            $sheet->setCellValue("I{$contador}", $weig_);
            $sheet->setCellValue("J{$contador}", $status_);
           
           
         }
        $writer = new Xlsx($spreadsheet);
        $filename = 'Reporte_animales';
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'. $filename .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        $writer->save('php://output'); 
      }


  public function animals_excel1()
  {

    $specie_ = $this->input->post('specie');
    $desde_ = $this->input->post('desde');
    $hasta_ = $this->input->post('hasta');

    setlocale(LC_TIME, 'spanish');
    $dateDesde = strftime('%d-%b-%y', strtotime($desde_));
    $dateHasta = strftime('%d-%b-%y', strtotime($hasta_));

    $animals = $this->animForReport($specie_, $desde_, $hasta_);


    /*  $mortalities = $this->getMortality(); */
    $contador1 = 1;
    $contador = 3;
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(17);
    $sheet->getColumnDimension('C')->setWidth(16);
    $sheet->getColumnDimension('D')->setWidth(25);
    $sheet->getColumnDimension('E')->setWidth(25);
    $sheet->getColumnDimension('F')->setWidth(10);
    $sheet->getColumnDimension('G')->setWidth(19);
    $sheet->getColumnDimension('H')->setWidth(14);
    $sheet->getColumnDimension('I')->setWidth(10);
    $sheet->getColumnDimension('J')->setWidth(16);
    $sheet->getColumnDimension('K')->setWidth(16);

    $sheet->getStyle("B{$contador1}")->getFont()->setBold(true);
    $sheet->getStyle("E{$contador1}")->getFont()->setBold(true);
    $sheet->getStyle("A{$contador}")->getFont()->setBold(true);
    $sheet->getStyle("B{$contador}")->getFont()->setBold(true);
    $sheet->getStyle("C{$contador}")->getFont()->setBold(true);
    $sheet->getStyle("D{$contador}")->getFont()->setBold(true);
    $sheet->getStyle("E{$contador}")->getFont()->setBold(true);
    $sheet->getStyle("F{$contador}")->getFont()->setBold(true);
    $sheet->getStyle("G{$contador}")->getFont()->setBold(true);
    $sheet->getStyle("H{$contador}")->getFont()->setBold(true);
 
    $sheet->mergeCells("B{$contador1}" . ":C{$contador1}");
    $sheet->setCellValue("B{$contador1}", 'Reporte de animales registrados');
    $sheet->setCellValue("E{$contador1}", 'Del:' . $dateDesde . ' Al:' . $dateHasta);
    $sheet->setCellValue("A{$contador}", 'N°');
    $sheet->setCellValue("B{$contador}", 'Arete / ID');
    $sheet->setCellValue("C{$contador}", 'Especie');
    $sheet->setCellValue("D{$contador}", 'Raza');
    
    $sheet->setCellValue("E{$contador}", 'Genero');
    $sheet->setCellValue("F{$contador}", 'Fecha de nacimiento');
    $sheet->setCellValue("G{$contador}", 'Peso al nacer');
    $sheet->setCellValue("H{$contador}", 'Corral');
   
    foreach ($animals as $i => $l) {
      $i = $i + 1;
      setlocale(LC_TIME, 'spanish');
      $fechaT = strftime('%d-%b-%y', strtotime($l->birth_date));
      //Incrementamos una fila más, para ir a la siguiente.
      $contador++;
      //Informacion de las filas de la consulta.
      $sheet->setCellValue("A{$contador}", $i);
      $sheet->setCellValue("B{$contador}", $l->earring);
      $sheet->setCellValue("C{$contador}", $l->specie);
      $sheet->setCellValue("D{$contador}", $l->race);
   
      $sheet->setCellValue("E{$contador}", $l->gender);
      $sheet->setCellValue("F{$contador}", $fechaT);
      $sheet->setCellValue("G{$contador}", $l->birth_weight);
      $sheet->setCellValue("H{$contador}", $l->rodeo_name);

    }
    $writer = new Xlsx($spreadsheet);
    $filename = 'Reporte_animales';
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
    header('Cache-Control: max-age=0');
    $writer->save('php://output');
  }

  function getRodeosBySpecie($specie)
  {
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . "rodeos/api/rodeoBySpecie/specie/{$specie}",
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);
    curl_close($curl);
    $rodeos = json_decode($response);
    return $rodeos->data;
  }


  public function exportRegisterOvinoExcel()
  {
    $rodeos = $this->getRodeosBySpecie('Ovino');
    $categories = $this->getCategories();
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png'); // put your path and image here
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);

    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
    $sheet->mergeCells('A1:O4');
    $sheet->mergeCells('A5:K6');
    $sheet->mergeCells('L5:O6');
    $sheet->mergeCells('N7:O7');
    /* $sheet->mergeCells('N8:O8');
    $sheet->mergeCells('N9:O9'); */
    $sheet->mergeCells('Q7:S7');
    $sheet->mergeCells('U7:W7');
    $sheet->mergeCells('R8:S8');
    $sheet->mergeCells('V8:W8');
    $sheet->mergeCells('P1:W1');
    $sheet->mergeCells('P2:W2');
    $sheet->mergeCells('P3:W3');
    $sheet->mergeCells('P4:W4');
    $sheet->mergeCells('P5:W5');
    $sheet->mergeCells('P6:W6');
    $sheet->mergeCells('M11:O11');
    $sheet->mergeCells('M12:O15');
    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

    $sheet->getStyle('A1')->getAlignment()->setVertical('center');
    $sheet->getStyle('P1')->getAlignment()->setVertical('center');
    $sheet->getStyle('M12')->getAlignment()->setVertical('center');
    $sheet->getStyle('P1')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('M11')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('M12')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('P2')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('P2')->getAlignment()->setVertical('center');
    $sheet->getStyle('P2:P6')->getAlignment()->setWrapText(true);
    $sheet->getStyle('M12:O15')->getAlignment()->setWrapText(true);
    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('H6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('L5')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('L6')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('N7:N9')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('Q7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('U7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('Q8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('U8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('R8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('V8')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("P1")->getFont()->setSize(14)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("N7")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("L5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("M11")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("Q7")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("U7")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("Q8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("U8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("R8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("V8")->getFont()->setBold(true);
    $sheet->getStyle('L5:O6')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('L5')->getAlignment()->setVertical('center');
    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('H8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('I8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('J8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('K8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('L8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('Q8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('U8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('N7:O7')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('Q7:S7')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('U7:W7')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('N8:O9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('R8:S8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('V8:W8')->applyFromArray($styleArray);

    $sheet->setCellValue('A1', 'Formato de registro de animales');
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(12);
    $sheet->getColumnDimension('C')->setWidth(10);
    $sheet->getColumnDimension('D')->setWidth(10);
    $sheet->getColumnDimension('E')->setWidth(20);
    $sheet->getColumnDimension('F')->setWidth(12);
    $sheet->getColumnDimension('G')->setWidth(15);
    $sheet->getColumnDimension('H')->setWidth(15);
    $sheet->getColumnDimension('I')->setWidth(12);
    $sheet->getColumnDimension('J')->setWidth(12);
    $sheet->getColumnDimension('K')->setWidth(12);
    $sheet->getColumnDimension('L')->setWidth(35);
    $sheet->setCellValue('P1', 'Instrucciones de uso');
    $sheet->setCellValue('P2', 'Todos los campos deben ser llenados de forma correcta, para ello se debe considerar lo siguiente:');
    $sheet->setCellValue('P3', '1.- N.°: Ingresar número de fila comenzando por el 1 (1, 2, 3 etc)');
    $sheet->setCellValue('P4', '2.- Genero: Ingresar M para macho ó H para hembra');
    $sheet->setCellValue('P5', '3.- Categoria: Ingresar el ID de la categoria correspondiente (ver tabla de categorias)');
    $sheet->setCellValue('P6', '4.- Corrales: Ingresar el ID del corral correspondiente (ver tabla de corrales)');
    $sheet->setCellValue('Q7', 'Categorias');
    $sheet->setCellValue('U7', 'Corrales');
    $sheet->setCellValue('Q8', 'ID');
    $sheet->setCellValue('U8', 'ID');
    $sheet->setCellValue('R8', 'NOMBRE');
    $sheet->setCellValue('V8', 'NOMBRE');
    $sheet->setCellValue('G7', 'DD/MM/AAAA');
    $cn = 8;
    foreach ($categories as $category) {
      $cn = $cn + 1;
      $sheet->setCellValue("Q{$cn}", $category->category_id);
      $sheet->mergeCells("R{$cn}:S{$cn}");
      $sheet->setCellValue("R{$cn}", $category->name);
    }
    $spreadsheet->getActiveSheet()->getStyle("Q8:Q{$cn}")->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle("P1:W6")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('ffff00');
    $spreadsheet->getActiveSheet()->getStyle("M11:O15")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('ffff00');
    $sheet->getStyle("Q8:Q{$cn}")->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getStyle("R8:S{$cn}")->applyFromArray($styleArray);
    $sheet->getStyle("R8:S{$cn}")->getAlignment()->setHorizontal('center');

    $cn = 8;
    foreach ($rodeos as $rodeo) {
      $cn = $cn + 1;
      $sheet->setCellValue("U{$cn}", $rodeo->id_rodeos);
      $sheet->mergeCells("V{$cn}:W{$cn}");
      $sheet->setCellValue("V{$cn}", $rodeo->name_rodeo);
    }
    $spreadsheet->getActiveSheet()->getStyle("U8:U{$cn}")->applyFromArray($styleArray);
    $sheet->getStyle("U8:U{$cn}")->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getStyle("V8:W{$cn}")->applyFromArray($styleArray);
    $sheet->getStyle("V8:W{$cn}")->getAlignment()->setHorizontal('center');

    $sheet->setCellValue('L5', 'Especie: Ovino');
    $sheet->setCellValue('N7', 'Genero');
    $sheet->setCellValue('M11', 'NOTA:');
    $sheet->setCellValue('M12', 'Los campos que no contengan información deberán tener lo siguiente: N/A ');
    $sheet->setCellValue('N8', 'M');
    $sheet->setCellValue('N9', 'H');
    $sheet->setCellValue('O8', 'Macho');
    $sheet->setCellValue('O9', 'Hembra');
    $sheet->setCellValue('A8', 'N.°');
    $sheet->setCellValue('B8', 'Genero');
    $sheet->setCellValue('C8', 'Arete');
    $sheet->setCellValue('D8', 'Grapa');
    $sheet->setCellValue('E8', 'Raza');
    $sheet->setCellValue('F8', 'Categoria');
    $sheet->setCellValue('G8', 'Fecha nac.');
    $sheet->setCellValue('H8', 'Peso al nacer');
    $sheet->setCellValue('I8', 'Corral');
    $sheet->setCellValue('J8', 'Arete madre');
    $sheet->setCellValue('K8', 'Arete padre');
    $sheet->setCellValue('L8', 'Comentarios');
    $sheet->setCellValue('A9', 1);
    $writer = new Xlsx($spreadsheet);
    $filename = 'formato_registro_ovinos';

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename .  date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
  }
  public function exportRegisterExcel($specie)
  {
    $rodeos = $this->getRodeosBySpecie($specie);
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png'); // put your path and image here
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);

    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
    $sheet->mergeCells('A1:O4');
    $sheet->mergeCells('A5:K6');
    $sheet->mergeCells('L5:O6');
    $sheet->mergeCells('J7:K7');


    $sheet->mergeCells('M7:O7');

    $sheet->mergeCells('N8:O8');
    $sheet->mergeCells('P1:W1');
    $sheet->mergeCells('P2:W2');
    $sheet->mergeCells('P3:W3');
    $sheet->mergeCells('P4:W4');
    $sheet->mergeCells('P5:W5');
    $sheet->mergeCells('P6:W6');
    $sheet->mergeCells('I11:K11');
    $sheet->mergeCells('I12:K15');
    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);
    $sheet->getStyle('I12')->getAlignment()->setVertical('center');
    $sheet->getStyle('I11')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('I12')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A1')->getAlignment()->setVertical('center');
    $sheet->getStyle('P1')->getAlignment()->setVertical('center');
    $sheet->getStyle('P1')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('P2')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('P2')->getAlignment()->setVertical('center');
    $sheet->getStyle('P2:P6')->getAlignment()->setWrapText(true);
    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('I12:K15')->getAlignment()->setWrapText(true);
    $sheet->getStyle('H6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('L5')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('L6')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('J7:J9')->getAlignment()->setHorizontal('center');

    $sheet->getStyle('M7')->getAlignment()->setHorizontal('center');

    $sheet->getStyle('M8')->getAlignment()->setHorizontal('center');

    $sheet->getStyle('N8')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("P1")->getFont()->setSize(14)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("N7")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("L5")->getFont()->setBold(true);

    $spreadsheet->getActiveSheet()->getStyle("M7")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("I11")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("M8")->getFont()->setBold(true);

    $spreadsheet->getActiveSheet()->getStyle("N8")->getFont()->setBold(true);
    $sheet->getStyle('L5:O6')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('L5')->getAlignment()->setVertical('center');
    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('H8')->applyFromArray($styleArray);


    $spreadsheet->getActiveSheet()->getStyle('M8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('J7:K7')->applyFromArray($styleArray);

    $spreadsheet->getActiveSheet()->getStyle('M7:O7')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('J8:K9')->applyFromArray($styleArray);

    $spreadsheet->getActiveSheet()->getStyle('N8:O8')->applyFromArray($styleArray);

    $sheet->setCellValue('A1', 'Formato de registro de animales');
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(12);
    $sheet->getColumnDimension('C')->setWidth(10);
    $sheet->getColumnDimension('D')->setWidth(10);
    $sheet->getColumnDimension('E')->setWidth(20);
    $sheet->getColumnDimension('F')->setWidth(12);
    $sheet->getColumnDimension('G')->setWidth(15);
    $sheet->getColumnDimension('H')->setWidth(15);

    $sheet->setCellValue('P1', 'Instrucciones de uso');
    $sheet->setCellValue('P2', 'Todos los campos deben ser llenados de forma correcta, para ello se debe considerar lo siguiente:');
    $sheet->setCellValue('P3', '1.- N.°: Ingresar número de fila comenzando por el 1 (1, 2, 3 etc)');
    $sheet->setCellValue('P4', '2.- Genero: Ingresar M para macho ó H para hembra');
    $sheet->setCellValue('P5', '3.- Corrales: Ingresar el ID del corral correspondiente (ver tabla de corrales)');
    $sheet->setCellValue('M7', 'Corrales');
    $sheet->setCellValue('M8', 'ID');

    $sheet->setCellValue('N8', 'NOMBRE');
    $sheet->setCellValue('E7', 'DD/MM/AAAA');

    $cn = 8;
    foreach ($rodeos as $rodeo) {
      $cn = $cn + 1;
      $sheet->setCellValue("M{$cn}", $rodeo->id_rodeos);
      $sheet->mergeCells("N{$cn}:O{$cn}");
      $sheet->setCellValue("N{$cn}", $rodeo->name_rodeo);
    }
    $spreadsheet->getActiveSheet()->getStyle("P1:W6")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('ffff00');
    $spreadsheet->getActiveSheet()->getStyle("I11:K15")->getFill()->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)->getStartColor()->setARGB('ffff00');
    $spreadsheet->getActiveSheet()->getStyle("M8:M{$cn}")->applyFromArray($styleArray);
    $sheet->getStyle("M8:M{$cn}")->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getStyle("N8:O{$cn}")->applyFromArray($styleArray);
    $sheet->getStyle("M8:O{$cn}")->getAlignment()->setHorizontal('center');

    $sheet->setCellValue('L5', 'Especie: ' . $specie);
    $sheet->setCellValue('J7', 'Genero');
    $sheet->setCellValue('I11', 'NOTA:');
    $sheet->setCellValue('I12', 'Los campos que no contengan información deberán tener lo siguiente: N/A ');
    $sheet->setCellValue('J8', 'M');
    $sheet->setCellValue('J9', 'H');
    $sheet->setCellValue('K8', 'Macho');
    $sheet->setCellValue('K9', 'Hembra');
    $sheet->setCellValue('A8', 'N.°');
    $sheet->setCellValue('B8', 'Genero');
    $sheet->setCellValue('C8', 'Grapa');
    $sheet->setCellValue('D8', 'Raza');
    $sheet->setCellValue('E8', 'Fecha nac.');
    $sheet->setCellValue('F8', 'Peso al nacer');
    $sheet->setCellValue('G8', 'Corral');
    $sheet->setCellValue('H8', 'Comentarios');
    $sheet->setCellValue('A9', 1);
    //$writer = new Xlsx($spreadsheet);
    $writer = new Xlsx($spreadsheet);

    $filename = 'formato_registro_' . $specie;

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename .  date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
  }

  function readDataOvisRegister($file)
  {
    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
    $reader->setReadDataOnly(FALSE);
    $spreadsheet = $reader->load($file);
    $sheet = $spreadsheet->getSheet(0);
    $highestRow = $sheet->getHighestRow();

    for ($row = 9; $row <= $highestRow; $row++) {
      $cellValue = $spreadsheet->getActiveSheet()->getCell("A{$row}")->getValue();
      if ($cellValue) {

        $birth = $spreadsheet->getActiveSheet()->getCell("G{$row}")->getValue();
        if ($birth == 'N/A' || $birth == 'n/a' || $birth == '') {
          $resultDate = '';
        } else {
          $resultDate = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($birth)->format('Y-m-d');
        }
        $gender = $spreadsheet->getActiveSheet()->getCell("B{$row}")->getValue();
        if ($gender == 'N/A' || $gender == 'n/a') {
          $gender = '';
        } else {
          if ($gender == 'M' || $gender == 'm') {
            $gender = 'Macho';
          } else if ($gender == 'H' || $gender == 'h') {
            $gender = 'Hembra';
          }
        }
        $earring = $spreadsheet->getActiveSheet()->getCell("C{$row}")->getValue();
        if ($earring == 'N/A' || $earring == 'n/a') {
          $earring = '';
        }
        $grapa = $spreadsheet->getActiveSheet()->getCell("D{$row}")->getValue();
        if ($grapa == 'N/A' || $grapa == 'n/a') {
          $grapa = '';
        }
        $raza = $spreadsheet->getActiveSheet()->getCell("E{$row}")->getValue();
        if ($raza == 'N/A' || $raza == 'n/a') {
          $raza = '';
        }
        $category = $spreadsheet->getActiveSheet()->getCell("F{$row}")->getValue();
        if ($category == 'N/A' || $category == 'n/a') {
          $category = '';
        }
        $weight = $spreadsheet->getActiveSheet()->getCell("H{$row}")->getValue();
        if ($weight == 'N/A' || $weight == 'n/a') {
          $weight = '';
        }
        $rodeo = $spreadsheet->getActiveSheet()->getCell("I{$row}")->getValue();
        if ($rodeo == 'N/A' || $rodeo == 'n/a') {
          $rodeo = '';
        }
        $mother_earring = $spreadsheet->getActiveSheet()->getCell("J{$row}")->getValue();
        if ($mother_earring == 'N/A' || $mother_earring == 'n/a') {
          $mother_earring = '';
        }
        $father_earring = $spreadsheet->getActiveSheet()->getCell("K{$row}")->getValue();
        if ($father_earring == 'N/A' || $father_earring == 'n/a') {
          $father_earring = '';
        }
        $comments = $spreadsheet->getActiveSheet()->getCell("L{$row}")->getValue();
        if ($comments == 'N/A' || $comments == 'n/a') {
          $comments = '';
        }
        yield array(
          'number' => $spreadsheet->getActiveSheet()->getCell("A{$row}")->getValue(),
          'gender' => $gender,
          'earring' => $earring,
          'grapa' => $grapa,
          'race' => $raza,
          'category' => $category,
          'birthdate' => $resultDate,
          'weight' => $weight,
          'rodeo' => $rodeo,
          'mother_earring' => $mother_earring,
          'father_earring' => $father_earring,
          'comments' => $comments
        );
      }
    }
  }
  function importRegisterFormatOvinoExcel()
  {
    $file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');

    if (isset($_FILES['registerFormat']['name']) && in_array($_FILES['registerFormat']['type'], $file_mimes)) {
      $arr_file = explode('.', $_FILES['registerFormat']['name']);
      $extension = end($arr_file);
      $file = $_FILES['registerFormat']['tmp_name'];
      $dataAnimal = $this->readDataOvisRegister($file);
      $created_user = $this->session->userdata('user_admin_sess')->fullname;
      $data = [];

      foreach ($dataAnimal as $key => $value) {

        $data[] = array(
          'specie' => "Ovino",
          'race' => $value['race'],
          'gender' => $value['gender'],
          'birth_date' => $value['birthdate'],
          'earring' => $value['earring'],
          'birth_weight' => $value['weight'],
          "mother_earring" => $value['mother_earring'],
          "father_earring" => $value['father_earring'],
          "category" => $value['category'],
          "comments" => $value['comments'],
          "id_rodeo" => $value['rodeo'],
          "grapa" => $value['grapa'],
          "created_user" => $created_user,
        );
      }

      $data_to_string = json_encode($data);
      $curl_request = curl_init(API_URL . "animals/api/animals_excel");

      curl_setopt($curl_request, CURLOPT_CUSTOMREQUEST, "POST");
      curl_setopt($curl_request, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'x-api-key: QroSystem%21#'
      ));
      curl_setopt($curl_request, CURLOPT_RETURNTRANSFER, True);
      curl_setopt($curl_request, CURLOPT_POSTFIELDS, $data_to_string);
      $response = curl_exec($curl_request);

      if (!$response) {
        $response = json_encode(array(
          "status" => "error",
          "message" => curl_errno($curl_request)
        ));
        echo var_dump($response);
      }
      curl_close($curl_request);
      $response = json_decode($response);
    }

    if ($response->status == 'error') {
      $this->session->set_flashdata('error', array('message' => $response->message, 'validations' => $response->validations));
      redirect('animals');
    } else {
      redirect('animals');
    }
  }
    function readDataAnimalsRegister($file)
  {
    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
    $reader->setReadDataOnly(FALSE);
    $spreadsheet = $reader->load($file);
    $sheet = $spreadsheet->getSheet(0);
    $highestRow = $sheet->getHighestRow();
    for ($row = 9; $row <= $highestRow; $row++) {
      $cellValue = $spreadsheet->getActiveSheet()->getCell("A{$row}")->getValue();
      if ($cellValue) {

        $birth = $spreadsheet->getActiveSheet()->getCell("E{$row}")->getValue();
        if ($birth == 'N/A' || $birth == 'n/a' || $birth == '') {
          $resultDate = '';
        } else {
          $resultDate = \PhpOffice\PhpSpreadsheet\Shared\Date::excelToDateTimeObject($birth)->format('Y-m-d');
        }

        $gender = $spreadsheet->getActiveSheet()->getCell("B{$row}")->getValue();
        if ($gender == 'N/A' || $gender == 'n/a') {
          $gender = '';
        } else {
          if ($gender == 'M' || $gender == 'm') {
            $gender = 'Macho';
          } else if ($gender == 'H' || $gender == 'h') {
            $gender = 'Hembra';
          }
        }
        $grapa = $spreadsheet->getActiveSheet()->getCell("C{$row}")->getValue();
        if ($grapa == 'N/A' || $grapa == 'n/a') {
          $grapa = '';
        }
        $raza = $spreadsheet->getActiveSheet()->getCell("D{$row}")->getValue();
        if ($raza == 'N/A' || $raza == 'n/a') {
          $raza = '';
        }

        $weight = $spreadsheet->getActiveSheet()->getCell("F{$row}")->getValue();
        if ($weight == 'N/A' || $weight == 'n/a') {
          $weight = '';
        }
        $rodeo = $spreadsheet->getActiveSheet()->getCell("G{$row}")->getValue();
        if ($rodeo == 'N/A' || $rodeo == 'n/a') {
          $rodeo = '';
        }
        $comments = $spreadsheet->getActiveSheet()->getCell("H{$row}")->getValue();
        if ($comments == 'N/A' || $comments == 'n/a') {
          $comments = '';
        }


        yield array(
          'number' => $spreadsheet->getActiveSheet()->getCell("A{$row}")->getValue(),
          'gender' => $gender,
          'grapa' => $grapa,
          'race' => $raza,
          'birthdate' => $resultDate,
          'weight' => $weight,
          'rodeo' => $rodeo,
          'comments' => $comments,
        );
      }
    }
  }
  function importRegisterFormatAnimalsExcel($specie)
  {
    $file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');

    if (isset($_FILES['registerFormat']['name']) && in_array($_FILES['registerFormat']['type'], $file_mimes)) {
      $arr_file = explode('.', $_FILES['registerFormat']['name']);
      $extension = end($arr_file);
      $file = $_FILES['registerFormat']['tmp_name'];
      $dataAnimal = $this->readDataAnimalsRegister($file);
      $data = [];
      $created_user = $this->session->userdata('user_admin_sess')->fullname;
      foreach ($dataAnimal as $key => $value) {
        $data[] = array(
          'specie' => $specie,
          'race' => $value['race'],
          'gender' => $value['gender'],
          'birth_date' => $value['birthdate'],
          'birth_weight' => $value['weight'],
          "comments" => $value['comments'],
          "id_rodeo" => $value['rodeo'],
          "grapa" => $value['grapa'],
          "created_user" => $created_user,
        );
      }
      $data_to_string = json_encode($data);
      $curl_request = curl_init(API_URL . "animals/api/animals_excel");

      curl_setopt($curl_request, CURLOPT_CUSTOMREQUEST, "POST");
      curl_setopt($curl_request, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'x-api-key: QroSystem%21#'
      ));
      curl_setopt($curl_request, CURLOPT_RETURNTRANSFER, True);
      curl_setopt($curl_request, CURLOPT_POSTFIELDS, $data_to_string);
      $response = curl_exec($curl_request);

      if (!$response) {
        $response = json_encode(array(
          "status" => "error",
          "message" => curl_errno($curl_request)
        ));
        echo var_dump($response);
      }
      curl_close($curl_request);
      $response = json_decode($response);
    }

    if ($response->status == 'error') {
      $this->session->set_flashdata('error', array('message' => $response->message, 'validations' => $response->validations));
      echo var_dump($response);
    } else {
      redirect('animals');
    }
    /*  */
  }

}