<?php
defined('BASEPATH') or exit('No direct script access allowed');


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Births extends CI_Controller
{

  public function __construct()
  {
    parent::__construct();
    if (!$this->session->userdata('user_admin_sess')) {
      redirect('login');
    }
  }

  public function index()
  {
    $data['body'] = 'births/births';
    $data['births'] = $this->getBirths();
    $data['abortions'] = $this->getAbortion();
    $this->load->view('layout/main', $data);
  }

  function getBirths()
  {

    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'births/api/births/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $births = json_decode($response);
    return $births->data;
  }

  function getAbortion()
  {

    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'abortion/api/abortion/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $abortion = json_decode($response);
    return $abortion->data;
  }

  function abortionById($id_abortion)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL.'abortion/api/abortion/id/'. $id_abortion,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $abortionID = json_decode($response);
    $this->session->set_flashdata('abortionDetails', array('data' => $abortionID->data));
    redirect('births');

  }

  function getAnimalsAbortion($id)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL.'abortion/api/animalsForabortion/id/'.$id,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $AnimalsAbortion = json_decode($response);
    $this->session->set_flashdata('animalsAbortion', array('data' => $AnimalsAbortion->data));
    redirect('births');
  }


  function birthsForReport($desde, $hasta)
  {

    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'births/api/birthsForReport/desde/' . $desde . '/hasta/' . $hasta,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);


    $birthsReport = json_decode($response);
    return $birthsReport->data;
  }


  function getBirthsById($id_Births)
  {


    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'births/api/births/id/' . $id_Births,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $births = json_decode($response);
    $this->session->set_flashdata('births_details', array('data' => $births->data));
    redirect('births');
  }



  function getAnimalForid($id_birt)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'births/api/animalsForbirths/id/' . $id_birt,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $Animalsbirth = json_decode($response);
    $this->session->set_flashdata('animal_births', array('data' => $Animalsbirth->data));
    redirect('births');
    
  }


  function abortions($desde_, $hasta_)
  {


    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'births/api/birthsForReportAbort/desde/'. $desde_.'/hasta/'. $hasta_,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $abortions = json_decode($response);
    return $abortions->data;
  }


  function getBirthsPdf($desde, $hasta)
  {

    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'births/api/birthsForReport/desde/' . $desde . '/hasta/' . $hasta,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);


    $birthsReport = json_decode($response);
    return $birthsReport->data;
  }

  function getAbortionPdf($desde, $hasta)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL .'abortion/api/abortionForReport/desde/'. $desde.'/hasta/'. $hasta,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $abortionReport = json_decode($response);
    return $abortionReport->data;

  }
  function births_pdf()
  {
    $start = $this->input->post('start');
    $end = $this->input->post('end');
    setlocale(LC_TIME, 'spanish');
    $startDate = strftime('%d-%m-%Y', strtotime($start));
    $endDate = strftime('%d-%m-%Y', strtotime($end));
  
      $births = $this->getBirthsPdf($start, $end);
      $title = "Reporte de partos";
      $doc_title = "Reporte_partos";
    

    $general_info = array(
      'begin' => $startDate,
      'end' => $endDate,
      'title' => $title
    );
    $mpdf = new \Mpdf\Mpdf();
    $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
    $header = $this->load->view('reports/births/header', array('general_info' => $general_info), true);
    $mpdf->SetHTMLHeader($header);
    $footer = $this->load->view('reports/births/footer', [], true);
    $mpdf->SetHTMLFooter($footer);
    $html = $this->load->view('reports/births/body', array('births' => $births, 'general_info' => $general_info), true);
    $css = file_get_contents('assets/pdf-reports.css');
    $mpdf->SetTitle($title);
    $mpdf->WriteHTML('<body>');
    $mpdf->WriteHTML($css, 1);
    $mpdf->WriteHTML($html);
    $mpdf->WriteHTML('</body>');
    $mpdf->Output($doc_title . date("Ymd") . '.pdf', 'I');

    exit;
    $mpdf->Output();
  }

  function abortion_pdf()
  {
    $start = $this->input->post('startAb');
    $end = $this->input->post('endAb');
    setlocale(LC_TIME, 'spanish');
    $startDate = strftime('%d-%m-%Y', strtotime($start));
    $endDate = strftime('%d-%m-%Y', strtotime($end));

    $abortions = $this->getAbortionPdf($start, $end);
    $title = "Reporte de abortos";
    $doc_title = "Reporte_abortos";


    $general_info = array(
      'begin' => $startDate,
      'end' => $endDate,
      'title' => $title
    );
    $mpdf = new \Mpdf\Mpdf();
    $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
    $header = $this->load->view('reports/abortion/header', array('general_info' => $general_info), true);
    $mpdf->SetHTMLHeader($header);
    $footer = $this->load->view('reports/abortion/footer', [], true);
    $mpdf->SetHTMLFooter($footer);
    $html = $this->load->view('reports/abortion/body', array('abortions' => $abortions, 'general_info' => $general_info), true);
    $css = file_get_contents('assets/pdf-reports.css');
    $mpdf->SetTitle($title);
    $mpdf->WriteHTML('<body>');
    $mpdf->WriteHTML($css, 1);
    $mpdf->WriteHTML($html);
    $mpdf->WriteHTML('</body>');
    $mpdf->Output($doc_title . date("Ymd") . '.pdf', 'I');

    exit;
    $mpdf->Output();
  }


  function births_excel()
  {
    $start = $this->input->post('start');
    $end = $this->input->post('end');
    setlocale(LC_TIME, 'spanish');
    $startDate = strftime('%d-%m-%Y', strtotime($start));
    $endDate = strftime('%d-%m-%Y', strtotime($end));
   
      $births = $this->getBirths($start, $end);
      $title = "Reporte de partos";
      $doc_title = "Reporte_partos";
    

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png');
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);

    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
    $sheet->mergeCells('A1:J4');
    $sheet->mergeCells('A5:H6');
    $sheet->mergeCells('I5:J6');

    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

    $sheet->getStyle('A1')->getAlignment()->setVertical('center');

    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('I5')->getAlignment()->setWrapText(true);
    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("E5:E6")->getFont()->setBold(true);

    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('H8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('I8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('J8')->applyFromArray($styleArray);

    $sheet->setCellValue('A1', $title);
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(15);
    $sheet->getColumnDimension('C')->setWidth(30);
    $sheet->getColumnDimension('D')->setWidth(30);
    $sheet->getColumnDimension('E')->setWidth(30);
    $sheet->getColumnDimension('F')->setWidth(15);
    $sheet->getColumnDimension('G')->setWidth(15);
    $sheet->getColumnDimension('H')->setWidth(30);
    $sheet->getColumnDimension('I')->setWidth(10);
    $sheet->getColumnDimension('J')->setWidth(20);


    $sheet->setCellValue('I5', "Desde: {$startDate} Hasta: {$endDate}");
    $sheet->setCellValue('A8', 'N.°');
    $sheet->setCellValue('B8', 'Arete');
    $sheet->setCellValue('C8', 'Corral');
    $sheet->setCellValue('D8', 'Fecha de parto/aborto');
    $sheet->setCellValue('E8', 'Aborto');
    $sheet->setCellValue('F8', 'Muertes');
    $sheet->setCellValue('G8', 'Hembras');
    $sheet->setCellValue('H8', 'Machos');
    $sheet->setCellValue('I8', 'Causa');
    $sheet->setCellValue('J8', 'Comentarios');
    $counter = 8;
    foreach ($births as $i => $birth) {
      $counter = $counter + 1;
      $i = $i + 1;
      if ($birth->cause == "") {
        $cause = "N/A";
      } else {
        $cause = $birth->cause;
      }
      if ($birth->abortions == 1) {
        $abortion = "Si";
      } else {
        $abortion = "No";
      }

      $i = $i + 1;
      setlocale(LC_TIME, 'spanish');
      $fechaT = strftime('%d-%m-%Y', strtotime($birth->date_birth));

      $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("F{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("G{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("H{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("I{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("J{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->setCellValue("A{$counter}", $i);
      $sheet->setCellValue("B{$counter}", $birth->earring);
      $sheet->setCellValue("C{$counter}", $birth->name_rodeo);
      $sheet->setCellValue("D{$counter}", $fechaT);
      $sheet->setCellValue("E{$counter}", $abortion);
      $sheet->setCellValue("F{$counter}", $birth->dead);
      $sheet->setCellValue("G{$counter}", $birth->females);
      $sheet->setCellValue("H{$counter}", $birth->males);
      $sheet->setCellValue("I{$counter}", $cause);
      $sheet->setCellValue("J{$counter}", $birth->comments);
    }
    $writer = new Xlsx($spreadsheet);
    $filename = $doc_title;

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
  }


  function abortion_excel()
  {
    $start = $this->input->post('startAb');
    $end = $this->input->post('endAb');
    setlocale(LC_TIME, 'spanish');
    $startDate = strftime('%d-%m-%Y', strtotime($start));
    $endDate = strftime('%d-%m-%Y', strtotime($end));

    $abortions = $this->getAbortionPdf($start, $end);
    $title = "Reporte de abortos";
    $doc_title = "Reporte_abortos";


    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png');
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);

    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
    $sheet->mergeCells('A1:J4');
    $sheet->mergeCells('A5:H6');
    $sheet->mergeCells('I5:J6');

    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

    $sheet->getStyle('A1')->getAlignment()->setVertical('center');

    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('I5')->getAlignment()->setWrapText(true);
    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("E5:E6")->getFont()->setBold(true);

    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('H8')->applyFromArray($styleArray);
   
    $sheet->setCellValue('A1', $title);
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(25);
    $sheet->getColumnDimension('C')->setWidth(30);
    $sheet->getColumnDimension('D')->setWidth(30);
    $sheet->getColumnDimension('E')->setWidth(30);
    $sheet->getColumnDimension('F')->setWidth(15);
    $sheet->getColumnDimension('G')->setWidth(15);
    $sheet->getColumnDimension('H')->setWidth(30);



    $sheet->setCellValue('I5', "Desde: {$startDate} Hasta: {$endDate}");
    $sheet->setCellValue('A8', 'N.°');
    $sheet->setCellValue('B8', 'Arete de la madre');
    $sheet->setCellValue('C8', 'Corral');
    $sheet->setCellValue('D8', 'Fecha de aborto');
    $sheet->setCellValue('E8', 'Causa');
    $sheet->setCellValue('F8', 'Hembras');
    $sheet->setCellValue('G8', 'Machos');
    $sheet->setCellValue('H8', 'Comentarios');

    $counter = 9;
    foreach ($abortions as $i => $abortion) {
      

      $i = $i + 1;
      setlocale(LC_TIME, 'spanish');
      $fechaT = strftime('%d-%m-%Y', strtotime($abortion->date_abortion));

      $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("F{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("G{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("H{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->setCellValue("A{$counter}", $i);
      $sheet->setCellValue("B{$counter}", $abortion->earring_female);
      $sheet->setCellValue("C{$counter}", $abortion->name_rodeo);
      $sheet->setCellValue("D{$counter}", $fechaT);
      $sheet->setCellValue("E{$counter}", $abortion->cause);
      $sheet->setCellValue("F{$counter}", $abortion->total_hembras);
      $sheet->setCellValue("G{$counter}", $abortion->total_machos);
      $sheet->setCellValue("H{$counter}", $abortion->comment);
     
    }
    $writer = new Xlsx($spreadsheet);
    $filename = $doc_title;

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
  }





}
