<?php
defined('BASEPATH') or exit('No direct script access allowed');


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


class Insemination extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if (!$this->session->userdata('user_admin_sess')) {
            redirect('login');
        }
    }
    public function index()
    {
        $data['body'] = 'inseminations/list';
        $data['inseminations'] = $this->getInsemination();
        $data['animals'] = $this->getAnimals();
        $this->load->view('layout/main', $data);
    }

    function getInsemination()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'inseminations/api/inseminations',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $inseminations = json_decode($response);
        return $inseminations->data;
    }
    function getInseminationById($insemination_id)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'inseminations/api/inseminations/id/' . $insemination_id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));
        $response = curl_exec($curl);

        curl_close($curl);
        $insemination = json_decode($response);
        $this->session->set_flashdata('insemination_details', array('data' => $insemination->data));
        redirect('insemination');
    }

    function getAnimals()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'animals/api/animals',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $animals = json_decode($response);
        return $animals->data;
    }


    function getInseminationForReport($desde_, $hasta_)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'inseminations/api/inseminationsForReport/desde/' . $desde_ . '/hasta/' . $hasta_,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $inseminations1 = json_decode($response);
        return $inseminations1->data;
    }


    public function insemination_report()
    {
        $desde_ = $this->input->post('desde');
        $hasta_ = $this->input->post('hasta');
        setlocale(LC_TIME, 'spanish');
        $dateDesde = strftime('%d-%b-%y', strtotime($desde_));
        $dateHasta = strftime('%d-%b-%y', strtotime($hasta_));
        $inseminations = $this->getInseminationForReport($desde_, $hasta_);
        $mpdf = new \Mpdf\Mpdf();
        $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $mpdf->SetHTMLHeader('
        <table class="normal" width="100%">
        <tr>
            <td width="33%"> <img src="' . base_url() . 'assets/img/logo.jpg" width="95" height="95"> </td>
            <td width="33%" align="center"><h1>Rancho El Arenal</h1></td>
            <td width="33%" style="text-align: right;"><h4>Reporte de Inseminacion</h4> <h5>Desde ' . $dateDesde . ' Hasta ' . $dateHasta . ' </h5> </td>
        </tr>
    </table>');
        $mpdf->SetHTMLFooter('
        <table class="normal" width="100%">
        <tr>
            <td width="33%"></td>
            <td width="33%" align="center">{PAGENO}/{nbpg}</td>
            <td width="33%" style="text-align: right;"> {DATE j-m-Y}</td>
        </tr>
    </table>        ');
        $html = '	
        <table width="100%" class="table table-bordered">
             <thead>
             <tr>
              <th>N°</th>
              <th>Arete</th>    
              <th>Fecha de inseminación</th>       
			  <th>Hora de inseminación</th>
              <th>Tipo de esperma</th>
              </thead>                   
        ';
        $html .= '<tbody>';
        $total = 0;
        $males = 0;
        $dead = 0;
        $females = 0;
        foreach ($inseminations as $i => $insemination) {
            $i = $i + 1;
            $total = $total + 1;
            setlocale(LC_TIME, 'spanish');
            $fechaT = strftime('%d-%b-%y', strtotime($insemination->date_insemination));
            $html .= '<tr>'
                . '<td>' . $i . '</td>'
                . '<td>' . $insemination->earring . '</td>'
                . '<td>' . strftime("%R %p", strtotime($insemination->hour_insemination)) . '</td>'
                . '<td>' . strftime("%d-%b-%Y", strtotime($insemination->date_insemination)) . '</td>'
                . '<td>' . $insemination->sperm_type . '</td>';
        }
        $html .= '<tr>
                </tr>
                </tbody> 
                <tfoot>
                <tr>
                  <th colspan="2">Total de inseminaciones</th>
                  <td colspan="2"></td>   
                
				  <th colspan="1">' . $total . '</th>
                </tr>
              </tfoot>
                </table>
                ';
        $data = '';
        $data .= '
        <style>
            h1 {
            }
        </style>';
        $data .= '<img width = "10" src = "assets/img/logo.jpg>';
        $css = file_get_contents('assets/pdf.css');
        $mpdf->WriteHTML($data);
        $mpdf->SetTitle('Reporte de partos');
        $mpdf->WriteHTML('<body>');
        $mpdf->writeHTML($css, 1);
        $mpdf->WriteHTML($html);
        $mpdf->WriteHTML('</body>');
        $mpdf->Output('Reporte_de_partos.pdf', 'I');
        $mpdf->setFooter('{PAGENO}');
        $mpdf->WriteHTML('Section 1');
        $mpdf->WriteHTML('');
        exit;
        $mpdf->Output();
    }


    public function insemination_excel()
    {
        $desde_ = $this->input->post('desde');
        $hasta_ = $this->input->post('hasta');
        setlocale(LC_TIME, 'spanish');
        $dateDesde = strftime('%d-%b-%y', strtotime($desde_));
        $dateHasta = strftime('%d-%b-%y', strtotime($hasta_));
        $inseminations = $this->getInseminationForReport($desde_, $hasta_);
        $contador = 1;
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->getColumnDimension('A')->setWidth(5);
        $sheet->getColumnDimension('B')->setWidth(20);
        $sheet->getColumnDimension('C')->setWidth(25);
        $sheet->getColumnDimension('D')->setWidth(25);
        $sheet->getColumnDimension('E')->setWidth(25);
        $sheet->getStyle("A{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("B{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("C{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("D{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("E{$contador}")->getFont()->setBold(true);
        $sheet->setCellValue("A{$contador}", 'N°');
        $sheet->setCellValue("B{$contador}", 'Arete');
        $sheet->setCellValue("C{$contador}", 'Fecha de inseminación');
        $sheet->setCellValue("D{$contador}", 'Hora de inseminación');
        $sheet->setCellValue("E{$contador}", 'Tipo de esperma');
        foreach ($inseminations as $i => $insemination) {
            $i = $i + 1;
            setlocale(LC_TIME, 'spanish');
            //Incrementamos una fila más, para ir a la siguiente.
            $contador++;
            //Informacion de las filas de la consulta.
            $sheet->setCellValue("A{$contador}", $i);
            $sheet->setCellValue("B{$contador}", $insemination->earring);
            $sheet->setCellValue("C{$contador}", strftime("%R %p", strtotime($insemination->hour_insemination)));
            $sheet->setCellValue("D{$contador}", strftime("%d-%b-%Y", strtotime($insemination->date_insemination)));
            $sheet->setCellValue("E{$contador}", $insemination->sperm_type);
        }
        $writer = new Xlsx($spreadsheet);
        $filename = 'Reporte_Inseminacion';
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        $writer->save('php://output');
    }
}
