<?php
defined('BASEPATH') or exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


class Productions extends CI_Controller
{

  public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata('user_admin_sess')) {
			redirect('login');
		}
	}
  
    public function index()
    {
        $data['body'] = 'productions/productions';
        $data['productions'] = $this->productions_get();
        $data['rodeos'] = $this->getRodeos();
        $this->load->view('layout/main', $data);
    }
    
     function eggsProduction()
  {
    $data['body'] = 'productions/eggsProduction';
    $data['production'] = $this->productions_eggs();
    $data['weightUnits'] = $this->egg_weight_unit();
    $data['rodeos'] = $this->getRodeos();
    $this->load->view('layout/main', $data);
  }

  function egg_weight_unit()
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'egg_weight_unit/api/egg_weight_unit',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $weightUnits = json_decode($response);
    return $weightUnits->data;
  }

    
  function productions_eggs()
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'productions/api/eggs_productions',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $productions = json_decode($response);
    return $productions->data;
  }

  function getProductionEggById($production_id)
  {
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'productions/api/eggs_productions/id/' . $production_id,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    $production = json_decode($response);
    $this->session->set_flashdata('production_details', array('data' => $production->data));
    redirect('productions/eggsProduction');
  }

  
  function getProductionEggDetailsById($detail_id)
  {
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'productions/api/eggs_productions_details/detail_id/' . $detail_id,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    $production_eggs = json_decode($response);
    $this->session->set_flashdata('productionEggs_details', array('data' => $production_eggs->data));
    redirect('productions/eggsProduction');
  }
  
    function productionEggs_add()
  {
    $date_productions = $this->input->post('date_productions');
    $id_rodeo = $this->input->post('id_rodeo');
    $responsible = $this->input->post('responsible');
    $quantity_kg = $this->input->post('quantity_kg');
    $num_pieces = $this->input->post('num_pieces');
    $status_eggs = $this->input->post('status_eggs');
    $comments = $this->input->post('comments');
    $sizeEgg = $this->input->post('sizeEgg');
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'productions/api/eggs_productions',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS => '{
                  "date_productions": "' . $date_productions . '",
                  "id_rodeo": "' . $id_rodeo . '",
                  "responsible": "' . $responsible . '",
                  "quantity_kg": "' . $quantity_kg . '",
                  "num_pieces": "' . $num_pieces . '",
                  "status_eggs": "' . $status_eggs . '",
                  "comments": "' . $comments . '",
                  "sizeEgg": "' . $sizeEgg . '"
              }',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#',
        'Content-Type: application/json'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $clients = json_decode($response);
    echo var_dump($clients);
    /* 		return $clients->data; */
    /*  redirect('productions'); */
    /*  echo var_dump($_POST); */
  }
    
    function productions_get()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
          CURLOPT_URL => API_URL.'productions/api/productions',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
          CURLOPT_HTTPHEADER => array(
            'x-api-key: QroSystem%21#'
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        $productions = json_decode($response);
        return $productions->data;
      
    }
    
    function getRodeos()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => API_URL.'rodeos/api/rodeos',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
          CURLOPT_HTTPHEADER => array(
            'x-api-key: QroSystem%21#'
          ),
        ));
        
        $response = curl_exec($curl);
        curl_close($curl);
        $rodeos = json_decode($response);
        return $rodeos->data;
    }

    function production_add()
    {

    $created_user = $this->session->userdata('user_admin_sess')->fullname;
    $species = $this->input->post('species');
    $date_productions= $this->input->post('date_productions');
    $quantity= $this->input->post('quantity');
    $id_rodeo= $this->input->post('id_rodeo');
    $anialsForRodeo= $this->input->post('anialsForRodeo');
    $product_type= $this->input->post('product_type');
    $comments= $this->input->post('comments');
    $unit_measure= $this->input->post('unit_measure');
        $curl = curl_init();
        curl_setopt_array($curl, array(
          CURLOPT_URL => API_URL.'productions/api/productions',
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'POST',
          CURLOPT_POSTFIELDS =>'{
                "species": "'.$species.'",
                "date_productions": "'.$date_productions.'",
                "quantity": "'.$quantity.'",
                "id_rodeo": "'. $id_rodeo.'",
                "anialsForRodeo": "'.$anialsForRodeo.'",
                "comments": "'.$comments. '",
                 "created_user": "' . $created_user . '",
                "unit_measure": "'.$unit_measure.'",
                "product_type": "'.$product_type.'"
            }',
          CURLOPT_HTTPHEADER => array(
            'x-api-key: QroSystem%21#',
            'Content-Type: application/json'
          ),
        ));
        
        $response = curl_exec($curl);
        
        curl_close($curl);
        redirect('productions');
        
    }

    public function produtions_report()
    {
      $specie_ = $this->input->post('specie');
      $desde_ = $this->input->post('desde');
      $hasta_ = $this->input->post('hasta');
      setlocale(LC_TIME, 'spanish');
      $dateDesde = strftime('%d-%b-%y', strtotime($desde_));
      $dateHasta = strftime('%d-%b-%y', strtotime($hasta_));
      $produtions = $this->productions_get($specie_,$desde_,$hasta_);
      $mpdf = new \Mpdf\Mpdf();
      $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
      $mpdf->SetHTMLHeader('
          <table class="normal" width="100%">
          <tr>
              <td width="33%"> <img src="' . base_url() . 'assets/img/logo.jpg" width="95" height="95"> </td>
              <td width="33%" align="center"><h1>Rancho El Arenal</h1></td>
              <td width="33%" style="text-align: right;"><h4>Reporte de registro de animales</h4> <h5>Desde '.$dateDesde .' Hasta '.$dateHasta.' </h5> </td>
          </tr>
      </table>');
      $mpdf->SetHTMLFooter('
          <table class="normal" width="100%">
          <tr>
              <td width="33%"></td>
              <td width="33%" align="center">{PAGENO}/{nbpg}</td>
              <td width="33%" style="text-align: right;"> {DATE j-m-Y}</td>
          </tr>
      </table>        ');
      $html = '	
          <table width="100%" class="table table-bordered">
               <thead>
               <tr>
                <th>N°</th>
                <th>Especie</th>        
                <th>Corral</th>
                <th>Animales por corral</th>
                <th>Tipo de producto</th>
                <th>Cantidad producida</th>
                <th>Fecha</th>        
                <th>Comentarios</th>
                </thead>                   
          ';
      $html .= '<tbody>';
      $total = 0;
      foreach ($produtions as $i => $prodution) {
        $i = $i + 1;
        $total = $total + $prodution->quantity;
        setlocale(LC_TIME, 'spanish');
        $fechaT = strftime('%d-%b-%y', strtotime($prodution->date_productions));
        $html .= '<tr>'
          . '<td>' . $i . '</td>'
          . '<td>' . $prodution->species . '</td>'
         
          . '<td>' . $prodution->name_rodeo . '</td>'
          . '<td>' . $prodution->anialsForRodeo . '</td>'
          . '<td>' . $prodution->product_type . '</td>'
          . '<td>' . $prodution->quantity .' '.$prodution->unit_measure. '</td>'
          . '<td>' . $fechaT . '</td>'
          . '<td>' . $prodution->comments . '</td>';
      }
      $html .= '<tr>
                  </tr>
                  </tbody> 
                  <tfoot>
                  <tr>
                    <th colspan="2">Produccion total</th>
                    <td colspan="5"></td>    
            <th colspan="1">' . $total .' '.$prodution->unit_measure. '</th>
                  </tr>
                </tfoot>
                  </table>
                  ';
      $data = '';
      $data .= '
          <style>
              h1 {
              }
          </style>';
      $data .= '<img width = "10" src = "assets/img/logo.jpg>';
      $css = file_get_contents('assets/pdf.css');
      /* Impresion y salida del documento */
      $mpdf->WriteHTML($data);
      /*   $mpdf->Image('assets/img/logo.jpg', 20, 0, 30, 30, 'jpg', '', true, false); */
      $mpdf->SetTitle('Reporte de ventas');
      $mpdf->WriteHTML('<body>');
      $mpdf->writeHTML($css, 1);
      $mpdf->WriteHTML($html);
      $mpdf->WriteHTML('</body>');
      $mpdf->Output('Reporte_de_ventas.pdf', 'I');
      $mpdf->setFooter('{PAGENO}');
  
      $mpdf->WriteHTML('Section 1');
      $mpdf->WriteHTML('');
  
      exit;
      $mpdf->Output();
    }

    public function productions_excel(){
      $specie_ = $this->input->post('specie');
      $desde_ = $this->input->post('desde');
      $hasta_ = $this->input->post('hasta');
      setlocale(LC_TIME, 'spanish');
      $dateDesde = strftime('%d-%b-%y', strtotime($desde_));
      $dateHasta = strftime('%d-%b-%y', strtotime($hasta_));
      $productions = $this->productions_get($specie_,$desde_,$hasta_);
        $contador1 = 1;
        $contador = 3;
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->getColumnDimension('A')->setWidth(10);
        $sheet->getColumnDimension('B')->setWidth(17);
        $sheet->getColumnDimension('C')->setWidth(16);
        $sheet->getColumnDimension('D')->setWidth(25);
        $sheet->getColumnDimension('E')->setWidth(25);
        $sheet->getColumnDimension('F')->setWidth(10);
        $sheet->getColumnDimension('G')->setWidth(19);
        $sheet->getColumnDimension('H')->setWidth(14);
        $sheet->getStyle("B{$contador1}")->getFont()->setBold(true);
        $sheet->getStyle("E{$contador1}")->getFont()->setBold(true);
        $sheet->getStyle("A{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("B{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("C{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("D{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("E{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("F{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("G{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("H{$contador}")->getFont()->setBold(true); 
        $sheet->mergeCells ("B{$contador1}".":C{$contador1}");
        $sheet->setCellValue("B{$contador1}", 'Reporte de Produccion');
        $sheet->setCellValue("E{$contador1}", 'Del:'.$dateDesde.' Al:'. $dateHasta);
        $sheet->setCellValue("A{$contador}", 'N°');
        $sheet->setCellValue("B{$contador}", 'Especie');
        $sheet->setCellValue("C{$contador}", 'Corral');
        $sheet->setCellValue("D{$contador}", 'Animales por corral');
        $sheet->setCellValue("E{$contador}", 'Tipo de producto');
        $sheet->setCellValue("F{$contador}", 'Cantidad producida');
        $sheet->setCellValue("G{$contador}", 'Fecha');
        $sheet->setCellValue("H{$contador}", 'Comentarios');
        
        foreach($productions as $i =>$l){
          $i = $i + 1;
          setlocale(LC_TIME, 'spanish');
          $fechaT = strftime('%d-%b-%y', strtotime($l->date_productions));
            //Incrementamos una fila más, para ir a la siguiente.
            $contador++;
            //Informacion de las filas de la consulta.
            $sheet->setCellValue("A{$contador}", $i);
            $sheet->setCellValue("B{$contador}", $l->species);
            $sheet->setCellValue("C{$contador}", $l->name_rodeo);
            $sheet->setCellValue("D{$contador}", $l->anialsForRodeo);
            $sheet->setCellValue("E{$contador}", $l->product_type);
            $sheet->setCellValue("F{$contador}", $l->quantity.$l->unit_measure);
            $sheet->setCellValue("G{$contador}", $fechaT);
            $sheet->setCellValue("H{$contador}", $l->comments);
           
           
         }
        $writer = new Xlsx($spreadsheet);
        $filename = 'Reporte_mortality';
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="'. $filename .'.xlsx"'); 
        header('Cache-Control: max-age=0');
        $writer->save('php://output'); 
      }

  function getEggsProductionReport($start, $end, $rodeo)
  {

    $curl = curl_init();

    curl_setopt_array($curl, [
      CURLOPT_URL => API_URL . "eggs_production/api/report_egg_production/start/{$start}/end/{$end}/rodeo/{$rodeo}",
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => "",
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 30,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => "GET",
      CURLOPT_POSTFIELDS => "",
      CURLOPT_HTTPHEADER => [
        "x-api-key: QroSystem%21#"
      ],
    ]);

    $response = curl_exec($curl);
    $err = curl_error($curl);

    curl_close($curl);

    if ($err) {
      echo "cURL Error #:" . $err;
    } else {
      $production = json_decode($response);
      return $production->data;
    }
  }

  function report_eggProduction()
  {
    $rodeo = $this->input->post('rodeo');
    $status_eggs = $this->input->post('status');
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');

    $productionData = $this->getEggsProductionReport($start_date, $end_date, $rodeo);
    if ($rodeo == 'all') {
      $rodeo_name = '';
    } else {
      $rodeo_name = $productionData[0]->rodeo_name;
    }
    $general_info = array(
      'begin' => $start_date,
      'end' => $end_date,
      'rodeo_name' => $rodeo_name,
      'rodeo' => $rodeo,
      'status' => $status_eggs
    );
    $mpdf = new \Mpdf\Mpdf();
    $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
    $header = $this->load->view('reports/eggs_production/header', array('general_info' => $general_info), true);
    $mpdf->SetHTMLHeader($header);
    $footer = $this->load->view('reports/eggs_production/footer', [], true);
    $mpdf->SetHTMLFooter($footer);
    $html = $this->load->view('reports/eggs_production/body', array('productionData' => $productionData, 'general_info' => $general_info), true);
    $css = file_get_contents('assets/pdf-reports.css');
    $mpdf->WriteHTML('<body>');
    $mpdf->WriteHTML($css, 1);
    $mpdf->WriteHTML($html);
    $mpdf->WriteHTML('</body>');

    $mpdf->Output();
  }

  function report_eggProductionExcel()
  {
    $rodeo = $this->input->post('rodeo');
    $status_eggs = $this->input->post('status');
    $start_date = $this->input->post('start_date');
    $end_date = $this->input->post('end_date');

    $productionData = $this->getEggsProductionReport($start_date, $end_date, $rodeo);
    if ($rodeo == 'all') {
      $rodeo_name = '';
    } else {
      $rodeo_name = $productionData[0]->rodeo_name;
    }
    $general_info = array(
      'begin' => $start_date,
      'end' => $end_date,
      'rodeo_name' => $rodeo_name,
      'rodeo' => $rodeo,
      'status' => $status_eggs
    );

    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);

    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png');
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);

    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);

    $sheet->mergeCells('A1:R4');
    $sheet->mergeCells('A5:Q6');
    $sheet->mergeCells('A8:A10');
    $sheet->mergeCells('B8:B10');
    $sheet->mergeCells('C8:N8');
    $sheet->mergeCells('C9:D9');
    $sheet->mergeCells('E9:F9');
    $sheet->mergeCells('G9:H9');
    $sheet->mergeCells('I9:J9');
    $sheet->mergeCells('K9:L9');
    $sheet->mergeCells('M9:N9');
    $sheet->mergeCells('O8:P9');
    $sheet->mergeCells('Q8:Q10');
    $sheet->mergeCells('R8:R10');


    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);

    $sheet->getStyle('A1')->getAlignment()->setVertical('center');
    $sheet->getStyle('O8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('O8')->getAlignment()->setVertical('center');
    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A8')->getAlignment()->setVertical('center');
    $sheet->getStyle('A8')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('B8')->getAlignment()->setVertical('center');
    $sheet->getStyle('B8')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('Q8')->getAlignment()->setVertical('center');
    $sheet->getStyle('Q8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('R8')->getAlignment()->setVertical('center');
    $sheet->getStyle('R8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('E5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('E6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A8:P10')->getAlignment()->setHorizontal('center');

    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:R10")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("E5:E6")->getFont()->setBold(true);

    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('A10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('H8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('I8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('J8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('K8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('L8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('M8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('N8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('O8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('P8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('Q8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('R8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('A9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('H10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('I10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('J10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('K10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('L10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('M10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('N10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('G9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('H9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('I9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('J9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('K9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('L9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('M9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('N9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('O9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('P9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('O10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('P10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('Q9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('R9')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('Q10')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('R10')->applyFromArray($styleArray);
    $sheet->setCellValue('A1', 'Reporte de producción de huevo');
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(10);
    $sheet->getColumnDimension('B')->setWidth(15);
    $sheet->getColumnDimension('Q')->setWidth(35);
    $sheet->getColumnDimension('R')->setWidth(35);

    $sheet->setCellValue('R5', 'Desde: ' . $general_info['begin']);
    $sheet->setCellValue('R6', 'Hasta: ' . $general_info['end']);

    $sheet->setCellValue('B8', 'Fecha');
    $sheet->setCellValue('A8', 'N.°');
    $sheet->setCellValue('B8', 'Fecha');
    $sheet->setCellValue('C8', 'Huevo');
    $sheet->setCellValue('C9', 'Chico');
    $sheet->setCellValue('C10', 'KG');
    $sheet->setCellValue('D10', 'PZ');
    $sheet->setCellValue('E10', 'KG');
    $sheet->setCellValue('F10', 'PZ');
    $sheet->setCellValue('G10', 'KG');
    $sheet->setCellValue('H10', 'PZ');
    $sheet->setCellValue('I10', 'KG');
    $sheet->setCellValue('J10', 'PZ');
    $sheet->setCellValue('K10', 'KG');
    $sheet->setCellValue('L10', 'PZ');
    $sheet->setCellValue('M10', 'KG');
    $sheet->setCellValue('N10', 'PZ');
    $sheet->setCellValue('E9', 'Mediano');
    $sheet->setCellValue('G9', 'Grande');
    $sheet->setCellValue('I9', 'Extra Grande');
    $sheet->setCellValue('K9', 'Jumbo');
    $sheet->setCellValue('M9', 'Quebrado');
    $sheet->setCellValue('O8', 'Total producción');
    $sheet->setCellValue('O10', 'KG');
    $sheet->setCellValue('P10', 'PZ');
    $sheet->setCellValue('Q8', 'Responsable');
    $sheet->setCellValue('R8', 'Observaciones');
    $counter = 10;
    foreach ($productionData as $i => $production) {
      $counter = $counter + 1;
      $i = $i + 1;
      $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("F{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("G{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("H{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("I{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("J{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("K{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("L{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("M{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("O{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("P{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("Q{$counter}")->getAlignment()->setHorizontal('center');
      $sheet->getStyle("R{$counter}")->getAlignment()->setHorizontal('center');

      $sheet->setCellValue("A{$counter}", $i);
      $sheet->setCellValue("B{$counter}", $production->date_productions);
      $sheet->setCellValue("C{$counter}", number_format($production->chico_kg, 2, '.', ','));
      $sheet->setCellValue("D{$counter}", $production->chico_pz);
      $sheet->setCellValue("E{$counter}", number_format($production->mediano_kg, 2, '.', ','));
      $sheet->setCellValue("F{$counter}", $production->mediano_pz);
      $sheet->setCellValue("G{$counter}", number_format($production->grande_kg, 2, '.', ','));
      $sheet->setCellValue("H{$counter}", $production->grande_pz);
      $sheet->setCellValue("I{$counter}", number_format($production->extra_grande_kg, 2, '.', ','));
      $sheet->setCellValue("J{$counter}", $production->extra_grande_pz);
      $sheet->setCellValue("K{$counter}", number_format($production->jumbo_kg, 2, '.', ','));
      $sheet->setCellValue("L{$counter}", $production->jumbo_pz);
      $sheet->setCellValue("M{$counter}", number_format($production->quebrado_kg, 2, '.', ','));
      $sheet->setCellValue("N{$counter}", $production->quebrado_pz);
      $sheet->setCellValue("O{$counter}", number_format($production->total_kg, 2, '.', ','));
      $sheet->setCellValue("P{$counter}", $production->total_pz);
      $sheet->setCellValue("Q{$counter}", $production->responsible);
      $sheet->setCellValue("R{$counter}", $production->comments);
    }
    $writer = new Xlsx($spreadsheet);

    $filename = 'Reporte_de_produccion_huevo';

    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');

    $writer->save('php://output');
    /*     $writer = new Xlsx($spreadsheet);
    $writer->save('test.xlsx'); */
  }
  function get_details_production($production)
  {
      $curl = curl_init();
  
      curl_setopt_array($curl, array(
          CURLOPT_URL => API_URL . 'productions/api/eggs_productions_details/production/' . $production,
          CURLOPT_RETURNTRANSFER => true,
          CURLOPT_ENCODING => '',
          CURLOPT_MAXREDIRS => 10,
          CURLOPT_TIMEOUT => 0,
          CURLOPT_FOLLOWLOCATION => true,
          CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
          CURLOPT_CUSTOMREQUEST => 'GET',
          CURLOPT_HTTPHEADER => array(
              'x-api-key: QroSystem%21#'
          ),
      ));
  
      $response = curl_exec($curl);
  
      curl_close($curl);
      // echo $response;
      $production = json_decode($response);
      return $production->data;
  }
   
}
