<?php
defined('BASEPATH') or exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;


class ReproductiveCycle extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if (!$this->session->userdata('user_admin_sess')) {
            redirect('login');
        }
    }

    public function index()
    {
        // Si hoy es lunes, nos daría el lunes pasado.
        // $year = 2021;
        // $month = 8;
        // $day = 5;

       
        // $semana = date("W", mktime(0, 0, 0, $month, $day, $year));

        
        // $diaSemana = date("w", mktime(0, 0, 0, $month, $day, $year));

        // if ($diaSemana == 0)
        // $diaSemana = 7;

       
        // $primerDia = date("d-m-Y", mktime(0, 0, 0, $month, $day - $diaSemana + 1, $year));

      
        // $ultimoDia = date("d-m-Y", mktime(0, 0, 0, $month, $day + (7 - $diaSemana), $year));

        // echo "<br>Semana: " . $semana . " - año: " . $year;
        // echo "<br>Primer día " . $primerDia;
        // echo "<br>Ultimo día " . $ultimoDia;

        $data['body'] = 'reproductiveCycle/reproductiveCycle';
        $data['reproductiveCycle'] = $this->reproductiveCycle_get();
        $this->load->view('layout/main', $data);
    }

    function reproductiveCycle_get()
    {



        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'reproductiveCycle/api/reproductiveCycle',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        // echo $response;

        $reproductiveCycle = json_decode($response);
        return $reproductiveCycle->data;
    }

    function estrus_add()
    {
        $week = $this->input->post('earring');
        $food_rest = $this->input->post('food_rest');
        $average_tem = $this->input->post('average_tem');
        $average_tem = $this->input->post('average_tem');
        $broken_eggs = $this->input->post('broken_eggs');
        $good_eggs = $this->input->post('good_eggs');
        $total_eggs = $this->input->post('total_eggs');
        $total_kg = $this->input->post('total_kg');
        $average_weight = $this->input->post('earring');

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'reproductiveCycle/api/reproductiveCycle',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => '{
                "week": "20",
                "food_rest": "10",
                "average_tem": "12",
                "light_hours": "1",
                "broken_eggs": "10",
                "good_eggs": "40",
                "total_eggs": "50",
                "total_kg": "11",
                "average_weight": "0.20"
            }',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        echo $response;
        redirect('estrus');
    }

    public function cycle_report()
    {
        $desde_ = $this->input->post('desde');
        $hasta_ = $this->input->post('hasta');


        setlocale(LC_TIME, 'spanish');
        $dateDesde = strftime('%d-%b-%y', strtotime($desde_));
        $dateHasta = strftime('%d-%b-%y', strtotime($hasta_));

        // $births = $this->birthsForReport($desde_, $hasta_);
        $reproductiveCycle = $this->reproductiveCycle_get();
        $mpdf = new \Mpdf\Mpdf();
        $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $mpdf->SetHTMLHeader('
        <table class="normal" width="100%">
        <tr>
            <td width="33%"> <img src="' . base_url() . 'assets/img/logo.jpg" width="95" height="95"> </td>
            <td width="33%" align="center"><h1>Rancho El Arenal</h1></td>
            <td width="33%" style="text-align: right;"><h4>Evaluación de ciclo productivo semanal gallinas de postura</h4> <h5>Desde 01-Agosto-2021 Hasta 04-Agosto-2021 </h5> </td>
        </tr>
    </table>');
        $mpdf->SetHTMLFooter('
        <table class="normal" width="100%">
        <tr>
            <td width="33%"></td>
            <td width="33%" align="center">{PAGENO}/{nbpg}</td>
            <td width="33%" style="text-align: right;"> {DATE j-m-Y}</td>
        </tr>
    </table>        ');
        $html = '	
        <table width="100%" class="table table-bordered">
             <thead>
             <tr>
              <th>N°</th>
              <th>Semana</th>    
              <th>Alimento restante</th>       
			    <th>Promedio de T°</th>
              <th>Horas luz tot</th>
              <th>Huevos rotos</th>        
				<th>Huevos buenos</th>
              <th>Total de huevos</th>
              <th>Total Kg</th>
              <th>Peso promedio por huevo</th>
              </thead>                   
        ';
        $html .= '<tbody>';
        $total = 0;
        $males = 0;
        $dead = 0;
        $females = 0;
        foreach ($reproductiveCycle as $i => $Cycle) {
            $i = $i + 1;
            $total = $total + $Cycle->total_kg;
            setlocale(LC_TIME, 'spanish');

            $html .= '<tr>'
                . '<td>' . $i . '</td>'
                . '<td>' . $Cycle->week . '</td>'
                . '<td>' . $Cycle->food_rest . '</td>'
                . '<td>' . $Cycle->average_tem . '</td>'
                . '<td>' . $Cycle->light_hours . '</td>'
                . '<td>' . $Cycle->broken_eggs . '</td>'
                . '<td>' . $Cycle->good_eggs . '</td>'
                . '<td>' . $Cycle->total_eggs . '</td>'
                . '<td>' . $Cycle->total_kg . '</td>'
                . '<td>' . $Cycle->average_weight . '</td>';
        }
        $html .= '<tr>
                </tr>
                </tbody> 
                <tfoot>
                <tr>
                  <th colspan="2">Kilos totales</th>
                  <td colspan="7"></td>   
				  <th colspan="1">' . $total . '</th>
                </tr>
              </tfoot>
                </table>
                ';
        $data = '';
        $data .= '
        <style>
            h1 {
            }
        </style>';
        $data .= '<img width = "10" src = "assets/img/logo.jpg>';
        $css = file_get_contents('assets/pdf.css');
        /* Impresion y salida del documento */
        $mpdf->WriteHTML($data);
        /*   $mpdf->Image('assets/img/logo.jpg', 20, 0, 30, 30, 'jpg', '', true, false); */
        $mpdf->SetTitle('Reporte de produccion');
        $mpdf->WriteHTML('<body>');
        $mpdf->writeHTML($css, 1);
        $mpdf->WriteHTML($html);
        $mpdf->WriteHTML('</body>');
        $mpdf->Output('Reporte_de_produccion.pdf', 'I');
        $mpdf->setFooter('{PAGENO}');

        $mpdf->WriteHTML('Section 1');
        $mpdf->WriteHTML('');

        exit;
        $mpdf->Output();
    }

    public function cycle_excel()
    {
        $specie_ = $this->input->post('specie');
        $desde_ = $this->input->post('desde');
        $hasta_ = $this->input->post('hasta');
        setlocale(LC_TIME, 'spanish');
        $dateDesde = strftime('%d-%b-%y', strtotime($desde_));
        $dateHasta = strftime('%d-%b-%y', strtotime($hasta_));
        // $animals = $this->animForReport($specie_, $desde_, $hasta_);
        $reproductiveCycle = $this->reproductiveCycle_get();
        /*  $mortalities = $this->getMortality(); */
        $contador1 = 1;
        $contador = 3;
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->getColumnDimension('A')->setWidth(10);
        $sheet->getColumnDimension('B')->setWidth(17);
        $sheet->getColumnDimension('C')->setWidth(16);
        $sheet->getColumnDimension('D')->setWidth(25);
        $sheet->getColumnDimension('E')->setWidth(25);
        $sheet->getColumnDimension('F')->setWidth(10);
        $sheet->getColumnDimension('G')->setWidth(19);
        $sheet->getColumnDimension('H')->setWidth(14);
        $sheet->getColumnDimension('I')->setWidth(10);
        $sheet->getColumnDimension('J')->setWidth(16);
        $sheet->getStyle("B{$contador1}")->getFont()->setBold(true);
        $sheet->getStyle("E{$contador1}")->getFont()->setBold(true);
        $sheet->getStyle("A{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("B{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("C{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("D{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("E{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("F{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("G{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("H{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("I{$contador}")->getFont()->setBold(true);
        $sheet->getStyle("J{$contador}")->getFont()->setBold(true);
        $sheet->mergeCells("B{$contador1}" . ":C{$contador1}");
        $sheet->setCellValue("B{$contador1}", 'Evaluación de ciclo productivo semanal gallinas de postura');
        $sheet->setCellValue("E{$contador1}", 'Del:01-08-2021 Al: 05-08-2021');
        $sheet->setCellValue("A{$contador}", 'N°');
        $sheet->setCellValue("B{$contador}", 'Semana');
        $sheet->setCellValue("C{$contador}", 'Alimento restante');
        $sheet->setCellValue("D{$contador}", 'Promedio de T°');
        $sheet->setCellValue("E{$contador}", 'Horas luz tot');
        $sheet->setCellValue("F{$contador}", 'Huevos rotos');
        $sheet->setCellValue("G{$contador}", 'Huevos buenos');
        $sheet->setCellValue("H{$contador}", 'Total de huevos');
        $sheet->setCellValue("I{$contador}", 'Total Kg');
        $sheet->setCellValue("J{$contador}", 'Peso promedio por huevo');
       
        foreach ($reproductiveCycle as $i => $l) {
            $i = $i + 1;
            
            //Incrementamos una fila más, para ir a la siguiente.
            $contador++;
            //Informacion de las filas de la consulta.
            $sheet->setCellValue("A{$contador}", $i);
            $sheet->setCellValue("B{$contador}", $l->week);
            $sheet->setCellValue("C{$contador}", $l->food_rest);
            $sheet->setCellValue("D{$contador}", $l->average_tem);
            $sheet->setCellValue("E{$contador}", $l->light_hours);
            $sheet->setCellValue("F{$contador}", $l->broken_eggs);
            $sheet->setCellValue("G{$contador}", $l->good_eggs);
            $sheet->setCellValue("H{$contador}", $l->total_eggs);
            $sheet->setCellValue("I{$contador}", $l->total_kg);
            $sheet->setCellValue("J{$contador}", $l->average_weight);
           
        }
        $writer = new Xlsx($spreadsheet);
        $filename = 'Reporte_ciclo_productivo';
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $filename . '.xlsx"');
        header('Cache-Control: max-age=0');
        $writer->save('php://output');
    }

}
