<?php
defined('BASEPATH') or exit('No direct script access allowed');



use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use SebastianBergmann\Environment\Console;

class ReproductiveManagement extends CI_Controller
{

  public function __construct()
  {
    parent::__construct();
    if (!$this->session->userdata('user_admin_sess')) {
      redirect('login');
    }
  }

  function index()
  {
    $data['body'] = 'reproductive_management/list';
    $data['records_rm'] = $this->get_reproductive_management();
    $data['animals'] = $this->getAnimals();
    $data['rod'] = $this->getRodeos();
    $data['rod1'] = $this->getRodeos();
    $data['rod2'] = $this->getRodeos();
    $this->load->view('layout/main', $data);
  }





  function get_reproductive_management()
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'reproductive_management/api/reproductive_management',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    $reproductive_management = json_decode($response);
    return $reproductive_management->data;
  }

  function get_reproductiveForId($id)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL.'reproductive_management/api/reproductive_management/id/'.$id,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $reproductiveForId = json_decode($response);
    $this->session->set_flashdata('reproductive_details', array('data' => $reproductiveForId->data));
    redirect('ReproductiveManagement');

  }


  function edit_females($id)
  {

    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL.'reproductive_management/api/reproductive_managementFemales/idEdit/'. $id,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_POSTFIELDS => '
',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#',
        'Content-Type: application/json'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    $edit_females = json_decode($response);
    $this->session->set_flashdata('dataFemales_details', array('data' => $edit_females->data));
    redirect('ReproductiveManagement');

  }




  function getRodeos()
  {
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'rodeos/api/rodeos',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);
    curl_close($curl);
    $rodeos = json_decode($response);
    return $rodeos->data;
  }


  function getRecordRMById($id)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'reproductive_management/api/reproductive_management/id/' . $id,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));
    $response = curl_exec($curl);

    curl_close($curl);
    $reproductiveM = json_decode($response);
    $this->session->set_flashdata('record_details', array('data' => $reproductiveM->data));
    redirect('reproductiveManagement');
  }

  public function exportExcel()
  {
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);
    $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
    $drawing->setName('Logo');
    $drawing->setDescription('Logo');
    $drawing->setPath('assets/img/logo.png');
    $drawing->setCoordinates('A1');
    $drawing->setWidthAndHeight(75, 75);
    $drawing->getShadow()->setVisible(false);
    $drawing->getShadow()->setDirection(0);
    $drawing->setWorksheet($spreadsheet->getActiveSheet());
    $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
    $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
    $sheet->mergeCells('A1:G4');
    $sheet->mergeCells('A5:G6');
    $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);
    $sheet->getStyle('A1')->getAlignment()->setVertical('center');
    $sheet->getStyle('P1')->getAlignment()->setVertical('center');
    $sheet->getStyle('M12')->getAlignment()->setVertical('center');
    $sheet->getStyle('P1')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('M11')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('M12')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('P2')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('P2')->getAlignment()->setVertical('center');
    $sheet->getStyle('P2:P6')->getAlignment()->setWrapText(true);
    $sheet->getStyle('M12:O15')->getAlignment()->setWrapText(true);
    $sheet->getStyle('A5')->getAlignment()->setVertical('center');
    $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('H6')->getAlignment()->setHorizontal('right');
    $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('L5')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('L6')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('Q7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('U7')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('Q8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('U8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('R8')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('V8')->getAlignment()->setHorizontal('center');
    $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("P1")->getFont()->setSize(14)->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);

    $spreadsheet->getActiveSheet()->getStyle("L5")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("M11")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("Q8")->getFont()->setBold(true);
    $spreadsheet->getActiveSheet()->getStyle("U8")->getFont()->setBold(true);

    $sheet->getStyle('L5:O6')->getAlignment()->setHorizontal('center');
    $sheet->getStyle('L5')->getAlignment()->setVertical('center');
    $styleArray = [
      'borders' => [
        'outline' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'right' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
        'left' => [
          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
          'color' => ['argb' => '#000'],
        ],
      ],
    ];
    $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
    $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
    $sheet->setCellValue('A1', 'Formato de registro de datos de las hembras(Empadres)');
    $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
    $sheet->getColumnDimension('A')->setWidth(25);
    $sheet->getColumnDimension('B')->setWidth(25);
    $sheet->getColumnDimension('C')->setWidth(25);
    $sheet->getColumnDimension('D')->setWidth(25);
    $sheet->getColumnDimension('E')->setWidth(25);
    $sheet->getColumnDimension('F')->setWidth(50);
    $sheet->setCellValue('A8', 'N.°');
    $sheet->setCellValue('B8', 'Arete de la borrega');
    $sheet->setCellValue('C8', 'Fenotipo');
    $sheet->setCellValue('D8', 'Número de empadre');
    $sheet->setCellValue('E8', 'Resultado Dx');
    $sheet->setCellValue('F8', 'Observaciones');
    $sheet->setCellValue('A9', 1);
    $writer = new Xlsx($spreadsheet);
    $filename = 'formato_registro_empadres';
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="' . $filename .  date("Ymd") . '.xlsx"');
    header('Cache-Control: max-age=0');
    $writer->save('php://output');
  }


  function getFemales($id)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'reproductive_management/api/reproductive_managementFemales/id/' . $id,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $Females = json_decode($response);
    $this->session->set_flashdata('dataFemales', array('data' => $Females->data));
    redirect('ReproductiveManagement');
  }

  
  function getFemalesEdit($id)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'reproductive_management/api/reproductive_managementFemales/id/' . $id,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    $Females = json_decode($response);
    $this->session->set_flashdata('dataFemalesEdit', array('data' => $Females->data));
    redirect('ReproductiveManagement');
  }


  function getAnimals()
  {
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'animals/api/animals',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    $animals = json_decode($response);
    return $animals->data;
  }

  function readDataReproductiveRegister($file)
  {
    $reader = new \PhpOffice\PhpSpreadsheet\Reader\Xlsx();
    $reader->setReadDataOnly(FALSE);
    $spreadsheet = $reader->load($file);
    $sheet = $spreadsheet->getSheet(0);
    $highestRow = $sheet->getHighestRow();
    for ($row = 9; $row <= $highestRow; $row++) {
      $cellValue = $spreadsheet->getActiveSheet()->getCell("A{$row}")->getValue();
      if ($cellValue) {

        $earring_female = $spreadsheet->getActiveSheet()->getCell("B{$row}")->getValue();
        if ($earring_female == 'N/A' || $earring_female == 'n/a') {
          $earring_female = '';
        }
        $fenotipo = $spreadsheet->getActiveSheet()->getCell("C{$row}")->getValue();
        if ($fenotipo == 'N/A' || $fenotipo == 'n/a') {
          $fenotipo = '';
        }
        $number_empadre = $spreadsheet->getActiveSheet()->getCell("D{$row}")->getValue();
        if ($number_empadre == 'N/A' || $number_empadre == 'n/a') {
          $number_empadre = '';
        }
        $result_dx = $spreadsheet->getActiveSheet()->getCell("E{$row}")->getValue();
        if ($result_dx == 'N/A' || $result_dx == 'n/a') {
          $result_dx = '';
        }
        $comment = $spreadsheet->getActiveSheet()->getCell("F{$row}")->getValue();
        if ($comment == 'N/A' || $comment == 'n/a') {
          $comment = '';
        }
        yield array(
          'number' => $spreadsheet->getActiveSheet()->getCell("A{$row}")->getValue(),
          'earring_female' => $earring_female,
          'fenotipo' => $fenotipo,
          'number_empadre' => $number_empadre,
          'result_dx' => $result_dx,
          'comment' => $comment,
        );
      }
    }
  }
  function importRegisterFormatExcel()
  {
    $date_reproductive = $this->input->post('date_reproductive');
    $rodeo_id = $this->input->post('rodeo_id');
    $lote = $this->input->post('lot_reproductive');
    $earring_stallion = $this->input->post('earring_stallion');
    $date_start = $this->input->post('date_start');
    $date_end = $this->input->post('date_end');
    $fenotipoSemental = $this->input->post('fenotipoSemental');
    $dateDx = $this->input->post('dateDx');
    $Fertility = $this->input->post('Fertility');
    $created_user = $this->input->post('created_user');

    $file_mimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    if (isset($_FILES['registerFormat']['name']) && in_array($_FILES['registerFormat']['type'], $file_mimes)) {
      $arr_file = explode('.', $_FILES['registerFormat']['name']);
      $extension = end($arr_file);
      $file = $_FILES['registerFormat']['tmp_name'];
      $datacontactos = $this->readDataReproductiveRegister($file);
      $data = [];


      $reproductive_management = array(

        'date_reproductive' => $date_reproductive,
          'rodeo_id' => $rodeo_id,
          'lot_reproductive' => $lote,
          'earring_stallion' => $earring_stallion,
          'date_start' => $date_start,
          'date_end' => $date_end,
          'fenotipoSemental' => $fenotipoSemental,
          'dateDx' => $dateDx,
          'Fertility' => $Fertility,
          'created_user' => $created_user,);

      foreach ($datacontactos as $key => $value) {

        $data[] = array(
          'earring_female' => $value['earring_female'],
          'fenotipo' => $value['fenotipo'],
          'number_empadre' => $value['number_empadre'],
          'result_dx' => $value['result_dx'],
          'comment' => $value['comment'],
          'created_user' => $created_user,
        );
      }
      $reproductiveManagementData = array(
        'reproductive_management' => $reproductive_management,
        'reproductive_females' => $data
      );


      $data_to_string = json_encode($reproductiveManagementData);

      //  var_dump($data_to_string);
       $curl_request = curl_init(API_URL . "reproductive_management/api/reproductive_excel");
       curl_setopt($curl_request, CURLOPT_CUSTOMREQUEST, "POST");
       curl_setopt($curl_request, CURLOPT_HTTPHEADER, array(
         'Content-Type: application/json',
        'x-api-key: QroSystem%21#'
       ));
       curl_setopt($curl_request, CURLOPT_RETURNTRANSFER, True);
       curl_setopt($curl_request, CURLOPT_POSTFIELDS, $data_to_string);
       $response = curl_exec($curl_request);

       if (!$response) {
         $response = json_encode(array(
           "status" => "error",
          "message" => curl_errno($curl_request)
        ));
       echo var_dump($response);
     }
       curl_close($curl_request);
     $response = json_decode($response);
    }

    var_dump($response);

      if ($response->status == 'error') {
       $this->session->set_flashdata('error', array('message' => $response->message, 'validations' => $response->validations));
      redirect('ReproductiveManagement');
    } else {
      redirect('ReproductiveManagement');
    }
  }




}
