<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Rodeos extends CI_Controller
{

  public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata('user_admin_sess')) {
			redirect('login');
		}
	}
  public function index()
  {
    $data['body'] = 'rodeos/rodeos';
    $data['rodeos'] = $this->getRodeos();
    $data['rod'] = $this->getRodeos();
    $data['rod1'] = $this->getRodeos();
    $this->load->view('layout/main', $data);
  }

  function getRodeos()
  {
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'rodeos/api/rodeos',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);
    curl_close($curl);
    $rodeos = json_decode($response);
    return $rodeos->data;
  }

  function add_rodeo()
  {
    $created_user = $this->session->userdata('user_admin_sess')->fullname;
    $name_rodeo = $this->input->post('name_rodeo');
    $type_animals = $this->input->post('type_animals');
    $description = $this->input->post('description');
    $alert_weaning = $this->input->post('alert_weaning');
    $move_after = $this->input->post('move_after');
    $move_before = $this->input->post('move_before');
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'rodeos/api/rodeo/',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'POST',
      CURLOPT_POSTFIELDS => '{
              "name_rodeo": "' . $name_rodeo . '",
              "type_animals": "' . $type_animals . '",
              "description": "' . $description . '",
              "alert_weaning": "' . $alert_weaning . '",
              "created_user": "' . $created_user . '",
              "move_after": "' . $move_after . '",
              "move_before": "' . $move_before . '"
          }',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#',
        'Content-Type: application/json'
      ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);

    redirect('rodeos');
  }

  function getRodeossById($id_rode)
  {


    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'rodeos/api/rodeos/id/' . $id_rode,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));

    $response = curl_exec($curl);
    curl_close($curl);
    $rodeos = json_decode($response);
    $this->session->set_flashdata('rodeos_details', array('data' => $rodeos->data));
    redirect('rodeos');
  }

  function move_animals()
  {
    $earring = explode(",", $_POST['animalsEarring']);
    $rodeo = $_POST['id_rod'];
    $cause = $_POST['cause'];
    $id_old = $_POST['id_old'];
    foreach ($earring as $earring) {
      $animalsDetails = $this->animalByEarring($earring);
      if ($animalsDetails) {
        $id_animalsU = $animalsDetails->id_animals;
        $this->update_rodeo($id_animalsU, $rodeo,$cause,$id_old);
      }
    }
    redirect('rodeos');
  }

  function animalByEarring($_earring)
  {
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'animals/api/animalsByEarring/earring/' . $_earring,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    $animalBy = json_decode($response);
    return $animalBy->data;
  }

  function update_rodeo($id_animal,$rodeoU, $cause, $id_old)
  {
    $curl = curl_init();

    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL . 'rodeos/api/animalsRodeo/id/' . $id_animal,
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'PUT',
      CURLOPT_POSTFIELDS => '{
            "id_rodeos": "' . $rodeoU . '",
            "cause": "' . $cause . '",
            "id_old": "' . $id_old . '",
        }',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#',
        'Content-Type: application/json'
      ),
    ));

    $response = curl_exec($curl);
    curl_close($curl);
  }

  function getDisabledRodeos()
  {
    $curl = curl_init();
    curl_setopt_array($curl, array(
      CURLOPT_URL => API_URL.'rodeos/api/inactive_rodeos',
      CURLOPT_RETURNTRANSFER => true,
      CURLOPT_ENCODING => '',
      CURLOPT_MAXREDIRS => 10,
      CURLOPT_TIMEOUT => 0,
      CURLOPT_FOLLOWLOCATION => true,
      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
      CURLOPT_CUSTOMREQUEST => 'GET',
      CURLOPT_HTTPHEADER => array(
        'x-api-key: QroSystem%21#'
      ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    $disabledRodeos = json_decode($response);
    return $disabledRodeos->data;
  }

  function inactiveRodeos(){
    $data['body'] = 'rodeos/inactive_rodeos';
    $data['rodeos'] = $this->getDisabledRodeos();
    $this->load->view('layout/main', $data);
  }

}
