<?php
defined('BASEPATH') or exit('No direct script access allowed');


use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class TreatmentCaninos extends CI_Controller
{

    public function __construct()
    {
        parent::__construct();
        if (!$this->session->userdata('user_admin_sess')) {
            redirect('login');
        }
    }

    public function index()
    {
        $data['body'] = 'treatments/caninos';
        $data['vaccinations'] = $this->vaccination();
        $data['diseases'] = $this->diseases_get();
        $data['caninos'] = $this->getCaninos();
        $data['treatments'] = $this->getTreatments();
        
        $data['dewormings'] = $this->get_deworming();
        $this->load->view('layout/main', $data);
    }

    function getTreatments()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'treatments/api/treatmentsobinos',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $treatments = json_decode($response);
        return $treatments->data;
    }


    function getTreatmentById($treatment_id, $name = 0)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'treatments/api/treatments/id/' . $treatment_id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));
        $response = curl_exec($curl);

        curl_close($curl);
        $treatment = json_decode($response);
        $this->session->set_flashdata('treatment_details', array('data' => $treatment->data, 'tipoSelec' => $name));
        redirect('TreatmentCaninos');
    }

    function get_doc($diseases_id)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL.'diseases/api/diseasesDoc/id/'. $diseases_id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $treatmentDoc = json_decode($response);
        $this->session->set_flashdata('diseasesDoc_details', array('data' => $treatmentDoc->data));
        redirect('TreatmentCaninos');
    }

    function get_docvaccination($idVaccination)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL.'vaccination/api/vaccinationDoc/id/'. $idVaccination,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $vaccinationDoc = json_decode($response);
        $this->session->set_flashdata('vaccinationDoc_details', array('data' => $vaccinationDoc->data));
        redirect('TreatmentCaninos');
    }




    function getCaninos()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'animals/api/animalsCaninos',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $caninos = json_decode($response);
        return $caninos->data;
    }

    function get_deworming()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'deworming/api/deworming/',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $deworming = json_decode($response);
        return $deworming->data;
    }


    function vaccination()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'vaccination/api/vaccination/',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $vaccination = json_decode($response);
        return $vaccination->data;
    }

    function diseases_get()
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'diseases/api/diseases/',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_POSTFIELDS => '
        ',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        // echo $response;
        $diseases = json_decode($response);
        return $diseases->data;
    }


    function diseasesById_get($id, $name = 0)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'diseases/api/diseases/idAnimal/' . $id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_POSTFIELDS => '
        ',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        // echo $response;
        $diseasesBy = json_decode($response);
        $this->session->set_flashdata('vaccination_details', array('data' => $diseasesBy->data, 'tipoSelec' => $name));
        redirect('TreatmentCaninos/index/' . $diseasesBy->data->id_animal);
    }

    function dewormingById($id, $name = 0)
    {

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'deworming/api/deworming/id/' . $id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $dewormingBy = json_decode($response);
        $this->session->set_flashdata('deworming_details', array('data' => $dewormingBy->data, 'tipoSelec' => $name));
        redirect('TreatmentCaninos/index/' . $dewormingBy->data->id_animal);
    }

    function vaccinationById($id, $name = 0)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'vaccination/api/vaccination/id/' . $id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        $vaccinationById = json_decode($response);
        $this->session->set_flashdata('vaccination_details', array('data' => $vaccinationById->data, 'tipoSelec' => $name));
        redirect('TreatmentCaninos/index/' . $vaccinationById->data->id_animal);
    }



}