<?php
defined('BASEPATH') or exit('No direct script access allowed');

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

class Weaning extends CI_Controller
{

    public function __construct()
	{
		parent::__construct();
		if (!$this->session->userdata('user_admin_sess')) {
			redirect('login');
		}
	}
    
    public function index()
    {
        $data['body'] = 'weanings/list';
        $data['weanings'] = $this->getWeanings();
        $data['animals'] = $this->getAnimals();
        $this->load->view('layout/main', $data);
    }

    function getWeanings()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'weanings/api/weanings',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $weanings = json_decode($response);
        return $weanings->data;
    }

    function getWeaningById($weaning_id)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'weanings/api/weanings/id/' . $weaning_id,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));
        $response = curl_exec($curl);

        curl_close($curl);
        $weaning = json_decode($response);
        $this->session->set_flashdata('weaning_details', array('data' => $weaning->data));
        redirect('weaning');
    }

    function getAnimals()
    {
        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'animals/api/animals',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $animals = json_decode($response);
        return $animals->data;
    }

    function weaning_report()
    {
        $start = $this->input->post('desde');
        $end = $this->input->post('hasta');
        setlocale(LC_TIME, 'spanish');
        $startDate = strftime('%d-%m-%Y', strtotime($start));
        $endDate = strftime('%d-%m-%Y', strtotime($end));
        $weanings = $this->weaningsForReport($start, $end);
        $general_info = array(
            'begin' => $startDate,
            'end' => $endDate
        );
        $mpdf = new \Mpdf\Mpdf();
        $mpdf = new \Mpdf\Mpdf(['orientation' => 'L']);
        $header = $this->load->view('reports/weanings/header', array('general_info' => $general_info), true);
        $mpdf->SetHTMLHeader($header);
        $footer = $this->load->view('reports/weanings/footer', [], true);
        $mpdf->SetHTMLFooter($footer);
        $html = $this->load->view('reports/weanings/body', array('weanings' => $weanings, 'general_info' => $general_info), true);
        $css = file_get_contents('assets/pdf-reports.css');
        $mpdf->SetTitle('Reporte de destetes');
        $mpdf->WriteHTML('<body>');
        $mpdf->WriteHTML($css, 1);
        $mpdf->WriteHTML($html);
        $mpdf->WriteHTML('</body>');
        $mpdf->Output('Reporte_destetes' . date("Ymd") . '.pdf', 'I');

        exit;
        $mpdf->Output();
    }

    function weaning_excel()
    {
        $start = $this->input->post('desde');
        $end = $this->input->post('hasta');
        setlocale(LC_TIME, 'spanish');
        $startDate = strftime('%d-%m-%Y', strtotime($start));
        $endDate = strftime('%d-%m-%Y', strtotime($end));
        $weanings = $this->weaningsForReport($start, $end);
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();
        $sheet->getPageSetup()->setOrientation(PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_LANDSCAPE);
    
        $drawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
        $drawing->setName('Logo');
        $drawing->setDescription('Logo');
        $drawing->setPath('assets/img/logo.png');
        $drawing->setCoordinates('A1');
        $drawing->setWidthAndHeight(75, 75);
    
        $drawing->getShadow()->setVisible(false);
        $drawing->getShadow()->setDirection(0);
        $drawing->setWorksheet($spreadsheet->getActiveSheet());
        $spreadsheet->getDefaultStyle()->getFont()->setName('Verdana');
        $spreadsheet->getDefaultStyle()->getFont()->setSize(7);
        $sheet->mergeCells('A1:J4');
        $sheet->mergeCells('A5:H6');
        $sheet->mergeCells('I5:J6');
    
        $sheet->getStyle('A1')->getAlignment()->setHorizontal('center');
        $spreadsheet->getActiveSheet()->getRowDimension('1')->setRowHeight(40);
    
        $sheet->getStyle('A1')->getAlignment()->setVertical('center');
    
        $sheet->getStyle('A5')->getAlignment()->setVertical('center');
        $sheet->getStyle('H5')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('E5')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('E6')->getAlignment()->setHorizontal('right');
        $sheet->getStyle('A7:W7')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('A8:W8')->getAlignment()->setHorizontal('center');
        $sheet->getStyle('I5')->getAlignment()->setWrapText(true);
        $spreadsheet->getActiveSheet()->getStyle("A1")->getFont()->setSize(20)->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A5")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("A8:L8")->getFont()->setBold(true);
        $spreadsheet->getActiveSheet()->getStyle("E5:E6")->getFont()->setBold(true);
    
        $styleArray = [
          'borders' => [
            'outline' => [
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
              'color' => ['argb' => '#000'],
            ],
            'right' => [
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
              'color' => ['argb' => '#000'],
            ],
            'left' => [
              'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
              'color' => ['argb' => '#000'],
            ],
          ],
        ];
        $spreadsheet->getActiveSheet()->getStyle('A8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('B8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('C8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('D8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('E8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('F8')->applyFromArray($styleArray);
        $spreadsheet->getActiveSheet()->getStyle('G8')->applyFromArray($styleArray);
 
    
        $sheet->setCellValue('A1', 'Reporte de destetes');
        $sheet->setCellValue('A5', 'Rancho Eco Turístico el Arenal');
        $sheet->getColumnDimension('A')->setWidth(10);
        $sheet->getColumnDimension('B')->setWidth(15);
        $sheet->getColumnDimension('C')->setWidth(10);
        $sheet->getColumnDimension('D')->setWidth(30);
        $sheet->getColumnDimension('E')->setWidth(30);
        $sheet->getColumnDimension('F')->setWidth(30);
        $sheet->getColumnDimension('G')->setWidth(15);

    
        $sheet->setCellValue('I5', "Desde: {$startDate} Hasta: {$endDate}");
        $sheet->setCellValue('A8', 'N.°');
        $sheet->setCellValue('B8', 'Arete');
        $sheet->setCellValue('C8', 'Fecha');
        $sheet->setCellValue('D8', 'Edad al destetar (Dias)');
        $sheet->setCellValue('E8', 'Peso al destetar');
        $sheet->setCellValue('F8', 'Ganancia de peso');
        $sheet->setCellValue('G8', 'Comentarios');
     
        $counter = 8;
        foreach ($weanings as $i => $weaning) {
          $counter = $counter + 1;
          $i = $i + 1;
          if ($weaning->comments == "" || $weaning->comments == null) {
            $observations = "---";
        } else {
            $observations = $weaning->comments;
        }
        if ($weaning->gdp == "" || $weaning->gdp == null || $weaning->gdp == 0) {
            $gdp = 0;
        } else {
            $gdp = $weaning->gdp;
        }
        $date = strftime('%d-%m-%Y', strtotime($weaning->date));
    
          $sheet->getStyle("A{$counter}")->getAlignment()->setHorizontal('center');
          $sheet->getStyle("B{$counter}")->getAlignment()->setHorizontal('center');
          $sheet->getStyle("C{$counter}")->getAlignment()->setHorizontal('center');
          $sheet->getStyle("D{$counter}")->getAlignment()->setHorizontal('center');
          $sheet->getStyle("E{$counter}")->getAlignment()->setHorizontal('center');
          $sheet->getStyle("F{$counter}")->getAlignment()->setHorizontal('center');
          $sheet->getStyle("G{$counter}")->getAlignment()->setHorizontal('center');

          $sheet->setCellValue("A{$counter}", $i);
          $sheet->setCellValue("B{$counter}", $weaning->earring);
          $sheet->setCellValue("C{$counter}", $date);
          $sheet->setCellValue("D{$counter}", $weaning->weaning_age);
          $sheet->setCellValue("E{$counter}", $weaning->weaning_weight);
          $sheet->setCellValue("F{$counter}", $gdp);
          $sheet->setCellValue("G{$counter}", $observations);
        }
        $writer = new Xlsx($spreadsheet);
        $filename = 'Reporte_destetes';
    
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="' . $filename . date("Ymd") . '.xlsx"');
        header('Cache-Control: max-age=0');
    
        $writer->save('php://output');
    }

    function weaningsForReport($desde, $hasta)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => API_URL . 'weanings/api/weaningsForReport/desde/' . $desde . '/hasta/' . $hasta,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_HTTPHEADER => array(
                'x-api-key: QroSystem%21#'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        /*  echo $response; */
        $weaningsFor1 = json_decode($response);
        return $weaningsFor1->data;
    }
}
