<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.25/css/jquery.dataTables.css">

<?php
if (@$this->session->flashdata('animals_details')) {
    $animals_details = $this->session->flashdata('animals_details')['data'];
} ?>

<div class="right_col" role="main">


    <div class="row">

        <div class="col-md-12 col-sm-12 ">

            <div class="dashboard_graph">

                <div class="row x_title">

                    <div class="col-md-6">
                        <h3>Lista de animales <small>registrados </small></h3>
                    </div>
                    <div class="col-md-6">
                        <div id="reportrange" class="pull-right" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc">
                            <i class="glyphicon glyphicon-calendar fa fa-calendar"></i>
                            <span>December 30, 2014 - January 28, 2015</span> <b class="caret"></b>
                        </div>


                    </div>

                </div>


                <div class="row x_title">
                    <div class="col-md-12">
                        <a data-toggle="modal" style="color:#fff" data-target="#add_animals" class="btn btn-secondary btn-sm pull-right">
                            <i class="fa fa-plus-square"></i> Registrar animales</a>
                        <a data-toggle="modal" style="color:#fff" data-target="#pdf_modal" class="btn btn-success btn-sm pull-right">
                            <i class="fa fa-folder-open"></i> Generar reportes</a>
                        <table class="table table-striped table-bordered dt-responsive nowrap" id="table_prestaciones">
                            <thead>
                                <tr>
                                    <th class="all hidden-print">#</th>
                                    <th>Nombre</th>
                                    <th>Especie</th>
                                    <th>Categoria</th>
                                    <th>Arete</th>
                                    <th>Raza</th>
                                    <th>Genero</th>
                                    <th>Fecha/Nac</th>
                                    <th>Rodeo</th>
                                    <th>Acciones</th>
                                    <th class="none">Información adicional</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $count = 1;
                                foreach ($animals as $animal) : ?>
                                    <tr>
                                        <td><?php echo $count++; ?></td>
                                        <td><?= ($animal->name) ? $animal->name : '---'  ?></td>
                                        <td><?= $animal->specie ?></td>
                                        <td><?= ($animal->category_name) ? $animal->category_name : '---'  ?></td>
                                        <td><?= ($animal->earring) ? $animal->earring : '---' ?></td>
                                        <td><?= $animal->race ?></td>
                                        <td><?= $animal->gender ?></td>
                                        <td><?= $animal->birth_date ?></td>
                                        <td><?= ($animal->rodeo_name) ? $animal->rodeo_name : '---' ?></td>
                                        <td>
                                            <div class="btn-group">
                                                <button type="button" class="btn btn-secondary btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                    Acciones
                                                </button>
                                                <div class="dropdown-menu">

                                                    <a class="dropdown-item" href="<?= base_url('index.php/animals/getAnimalsById/' . $animal->id_animals); ?>"><i class="fa fa-edit"></i> Editar</a>
                                                    <div class="dropdown-divider"></div>
                                                    <a class="dropdown-item" onclick="elimnarAnimals(<?= $animal->id_animals ?>)"><i class="fa fa-trash-o"></i> Eliminar</a>

                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <?php if ($animal->specie == 'Ovino') { ?>
                                                <table class="table table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th>Arete del padre</th>
                                                            <th>Arete de la madre</th>
                                                            <th>Comentarios</th>

                                                        </tr>
                                                    </thead>
                                                    <tbody>

                                                        <td><?= $animal->father_earring ?></td>
                                                        <td><?= $animal->mother_earring ?></td>
                                                        <td><?= ($animal->comments) ? $animal->comments : '---' ?></td>
                                                    </tbody>
                                                </table>
                                            <?php } else { ?>
                                                <table class="table table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th>Comentarios</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <td><?= ($animal->comments) ? $animal->comments : '---' ?></td>
                                                    </tbody>
                                                </table>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <br />
</div>

<?php include APPPATH . 'views/modals/animals/add_animals.php'; ?>
<?php include APPPATH . 'views/modals/animals/pdf_modal.php'; ?>
<?php include APPPATH . 'views/scripts/animals.php'; ?>