<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.25/css/jquery.dataTables.css">

<?php
if (@$this->session->flashdata('animals_details')) {
    $animals_details = $this->session->flashdata('animals_details')['data'];
}

function get_weaning($earring)
{
    $curl = curl_init();

    curl_setopt_array($curl, array(
        CURLOPT_URL => API_URL . 'animal_weighing/api/animalForearring/earring/' . $earring,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'x-api-key: QroSystem%21#'
        ),
    ));

    $response = curl_exec($curl);

    curl_close($curl);
    // echo $response;
    $weaning = json_decode($response);
    return $weaning->data;
}
?>

<style>
    .pdfobject-container {
        height: 40rem;
        border: 1rem solid rgba(0, 0, 0, .1);
    }
</style>

<div class="right_col" role="main">

    <div class="col-md-12 col-sm-12 ">

        <div class="dashboard_graph">

            <div class="row x_title">

                <div class="col-md-6">
                    <h3>Lista de animales <small>registrados </small></h3>
                </div>
                <div class="col-md-6">
                    <div id="reportrange" class="pull-right" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc">
                        <i class="glyphicon glyphicon-calendar fa fa-calendar"></i>
                        <span>December 30, 2014 - January 28, 2015</span> <b class="caret"></b>
                    </div>


                </div>

            </div>


            <div class="row x_title">
                <div class="col-md-12">
                    <a data-toggle="modal" style="color:#fff" data-target="#formato_registro_excel" class="btn btn-success btn-sm pull-right">
                        <i class="fa fa-download"></i> Formato de registro</a>
                    <a data-toggle="modal" style="color:#fff" data-target="#add_animals" class="btn btn-secondary btn-sm pull-right">
                        <i class="fa fa-plus-square"></i> Registrar animales</a>
                    <a data-toggle="modal" style="color:#fff" data-target="#pdf_modal" class="btn btn-success btn-sm pull-right">
                        <i class="fa fa-folder-open"></i> Generar reportes</a>
                   <!-- <a data-toggle="modal" style="color:#fff" data-target="#cartilla_modal" class="btn btn-secondary btn-sm pull-right">
                        <i class="fa fa-file-text"></i> Ver cartillas</a>  -->
                    <!-- <a data-toggle="modal" style="color:#fff" data-target="#myModal" class="btn btn-success btn-sm pull-right">
                        <i class="fa fa-plus-square"></i> Importar</a>
                    -->
                    <br>
                    <br>

                    <?php
                    if (@$this->session->flashdata('error')) {
                        $error = $this->session->flashdata('error');
                    ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <h4 class="alert-heading"><?= $error['message']; ?></h4>
                            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                            <p><?= print_r($error['validations']); ?></p>
                            <hr>
                            <p class="mb-0">Error en el documento de registro de animales en excel.</p>
                        </div>
                    <?php }
                    ?>

                    <table class="table table-striped table-bordered dt-responsive nowrap table-sm" id="table_animals">
                        <thead>
                            <tr>
                                <th scope="col" id="_no" class="all hidden-print">#</th>
                                <th scope="col" id="_earring">Arete / Id</th>
                                <th scope="col" id="_name">Nombre</th>
                                <th scope="col" id="_specie">Especie</th>
                                <th scope="col" id="_categoria">Categoria</th>
                                <th scope="col" id="_date_b">Fecha Nac</th>
                                <th scope="col" id="_rodeo">Corral</th>
                                <th scope="col" id="_weight">Peso</th>
                                <th scope="col" id="_status2">status</th>
                                <th scope="col" id="_actions">Acciones</th>
                                <th scope="col" class="none">Información adicional</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $count = 1;
                            foreach ($animals as $animal) :
                                setlocale(LC_TIME, 'es_ES', 'Spanish_Spain', 'Spanish');
                                if ($animal->birth_date == '0000-00-00' || $animal->birth_date == '' || $animal->birth_date == null) {
                                    $birth_date = '---';
                                } else {
                                    $birth_date = strftime('%d-%m-%Y', strtotime($animal->birth_date));
                                }
                                $weight1 = get_weaning($animal->earring);
                                if ($weight1) {
                                    if ($weight1->weight >= 30) {
                                        $stat = '<span class="badge badge-success text-white fa fa-check-square-o"> Buena</span>';
                                    }
                                    if ($weight1->weight > 25 && $weight1->weight < 30) {
                                        $stat = '<span class="badge badge-warning text-white fa fa-exclamation-circle"> Mediana</span>';
                                    }
                                    if ($weight1->weight < 25) {
                                        $stat = '<span class="badge badge-danger text-white fa fa-ban"> Deficiente</span>';
                                    }
                                    $date_ = strftime("%d-%b-%Y", strtotime($weight1->date));

                                    $weight_ = '<b>' . $weight1->weight . ' Kg</b>';
                                } else {
                                    $stat = "N/A";
                                }

                                setlocale(LC_ALL, "es_MX.utf8");


                            ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td><?= ($animal->earring) ? $animal->earring : '---' ?></td>
                                    <td><?= ($animal->name) ? $animal->name : '---'  ?></td>
                                    <td><?= $animal->specie ?></td>
                                    <td><?= ($animal->category_name) ? $animal->category_name : '---'  ?></td>


                                    <td><?= $birth_date ?></td>
                                    <td><?= ($animal->rodeo_name) ? $animal->rodeo_name : '---' ?></td>
                                    <td><?= (isset($weight1)) ? $weight_ . " (" . $date_ . ")"  : '---' ?></td>
                                    <th><?= $stat ?></th>
                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-secondary btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Acciones
                                            </button>
                                            <div class="dropdown-menu">

                                                <a class="dropdown-item" href="<?= base_url('index.php/animals/getAnimalsById/' . $animal->id_animals); ?>"><i class="fa fa-edit"></i> Editar</a>
                                                <div class="dropdown-divider"></div>
                                                <?php
                                                if ($animal->doc_registro == 1) {
                                                    "";
                                                } else { ?>
                                                    <a class="dropdown-item" onclick="view_doc('<?= $animal->doc_registro ?>')"><i class="fa fa-file-photo-o"></i> Ver documento</a>
                                                <?php
                                                }

                                                ?>
                                                <a class="dropdown-item" onclick="elimnarAnimals(<?= $animal->id_animals ?>)"><i class="fa fa-trash-o"></i> Eliminar</a>

                                                <?php
                                                if ($animal->specie == 'Caninos') { ?>
                                                    <a class="dropdown-item" href="<?= base_url('index.php/Vaccination_card/index/' . $animal->id_animals); ?>"><i class="fa fa-book"></i> Cartilla de vacunación</a>
                                                <?php   }
                                                ?>

                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <?php if ($animal->specie == 'Ovino') { ?>
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th id="_race">Raza</th>
                                                        <th id="_gender">Genero</th>
                                                        <th>Arete del padre</th>
                                                        <th>Arete de la madre</th>
                                                        <th>Comentarios</th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <td><?= $animal->race ?></td>
                                                    <td><?= $animal->gender ?></td>
                                                    <td><?= $animal->father_earring ?></td>
                                                    <td><?= $animal->mother_earring ?></td>
                                                    <td><?= ($animal->comments) ? $animal->comments : '---' ?></td>
                                                </tbody>
                                            </table>
                                        <?php } else { ?>
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>Comentarios</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <td><?= ($animal->comments) ? $animal->comments : '---' ?></td>
                                                </tbody>
                                            </table>
                                        <?php } ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>

</div>
</div>


<?php include APPPATH . 'views/loader/view.php'; ?>
<?php include APPPATH . 'views/modals/animals/add_animals.php'; ?>
<?php include APPPATH . 'views/modals/animals/formato_registro_excel.php'; ?>
<?php include APPPATH . 'views/modals/animals/pdf_modal.php'; ?>
<?php include APPPATH . 'views/modals/animals/document.php'; ?>
<?php include APPPATH . 'views/modals/animals/cartilla_modal.php'; ?>
<?php include APPPATH . 'views/modals/animals/add_rodeo.php'; ?>
<?php include APPPATH . 'views/scripts/animals.php'; ?>