<div class="modal fade" id="formato_registro_excel" data-backdrop="static" tabindex="-1" style="overflow-y: scroll;" data-keyboard="false" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Exportar / Importar formato de registro de animales</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div id="show_loading">
            </div>
            <div class="modal-body">
                <span class="text-danger" id="errorMsg"></span>

                <p>Campos requeridos (<span class="text-danger">*</span>)</p>
                <form role="form" method="post" id="importExportForm" autocomplete="off" enctype="multipart/form-data">
                    <div class="form-group row">
                        <div class="col-md-4">
                            <label>Tipo <span class="text-danger">*</span></label>
                            <select name="typeAction" id="typeAction" class="form-control">
                                <option value="export" selected>Exportar</option>
                                <option value="import">Importar</option>
                            </select>
                        </div>
                        <div class="col-md-8">
                            <label>Especie <span class="text-danger">*</span></label>
                            <select name="specieName" id="specieName" class="form-control" <?= (isset($animals_details)) ? 'disabled' : '' ?>>
                                <option value="" selected> -Seleccione una opción-</option>
                                <option value="Aves" <?= (isset($animals_details)) ? (($animals_details->specie == 'Aves') ?  'selected' : '') : '' ?>>Aves</option>
                                <option value="Ovino" <?= (isset($animals_details)) ? (($animals_details->specie == 'Ovino') ?  'selected' : '') : '' ?>>Ovinos</option>
                                <option value="Bovino" <?= (isset($animals_details)) ? (($animals_details->specie == 'Bovino') ?  'selected' : '') : '' ?>>Bovinos</option>
                                <option value="Porcino" <?= (isset($animals_details)) ? (($animals_details->specie == 'Porcino') ?  'selected' : '') : '' ?>>Porcinos</option>
                                <option value="Caprino" <?= (isset($animals_details)) ? (($animals_details->specie == 'Caprino') ?  'selected' : '') : '' ?>>Caprinos</option>
                                <option value="Felinos" <?= (isset($animals_details)) ? (($animals_details->specie == 'Felinos') ?  'selected' : '') : '' ?>>Felinos</option>
                                <option value="Caninos" <?= (isset($animals_details)) ? (($animals_details->specie == 'Caninos') ?  'selected' : '') : '' ?>>Caninos</option>
                                <option value="Equino" <?= (isset($animals_details)) ? (($animals_details->specie == 'Equino') ?  'selected' : '') : '' ?>>Equinos (Caballos y Yeguas)</option>
                            </select>
                        </div>

                    </div>
                    <div class="form-group row" id="fileTag" style="display: none">
                        <div class="col-md-12">
                            <label for="exampleInputFile">Formato de registro<span class="text-danger">*</span></label>
                            <input type="file" name="registerFormat" class="form-control" id="registerFormat">
                        </div>
                    </div>
                    <hr>
                    <br>
                    <div id="demoExcelOvis" style="display: none">
                        <h5>Plantilla demo registro de ovinos:</h5>
                        <div class="table-responsive">

                            <table class="table table-bordered table-sm  text-center table-hover " width="100%" cellspacing="0" cellpadding="" style="font-size: 9px">

                                <thead class="thead-light">

                                    <th scope="col"></th>
                                    <th scope="col">A</th>
                                    <th scope="col">B</th>
                                    <th scope="col">C</th>
                                    <th scope="col">D</th>
                                    <th scope="col">E</th>
                                    <th scope="col">F</th>
                                    <th scope="col">G</th>
                                    <th scope="col">H</th>
                                    <th scope="col">I</th>
                                    <th scope="col">J</th>
                                    <th scope="col">K</th>
                                    <th scope="col">L</th>

                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="background-color: #e9ecef">8</td>
                                        <th class="border border-dark">N°</th>
                                        <th class="border border-dark">Genero</th>
                                        <th class="border border-dark">Arete</th>
                                        <th class="border border-dark">Grapa</th>
                                        <th class="border border-dark">Raza</th>
                                        <th class="border border-dark">Categoria</th>
                                        <th class="border border-dark">Fecha nac.</th>
                                        <th class="border border-dark">Peso al nacer</th>
                                        <th class="border border-dark">Corral</th>
                                        <th class="border border-dark">Arete madre</th>
                                        <th class="border border-dark">Arete padre</th>
                                        <th class="border border-dark">Comentarios</th>
                                    </tr>
                                    <tr>
                                        <td style="background-color: #e9ecef">9</td>
                                        <td>1</td>
                                        <td>M</td>
                                        <td>871</td>
                                        <td>N/A</td>
                                        <td>N/A</td>
                                        <td>1</td>
                                        <td>02/06/2021</td>
                                        <td>2</td>
                                        <td>14</td>
                                        <td>535</td>
                                        <td>N/A</td>
                                        <td>Ejemplo de comentario</td>
                                    </tr>
                                    <tr>
                                        <td style="background-color: #e9ecef">10</td>
                                        <td>2</td>
                                        <td>H</td>
                                        <td>88</td>
                                        <td>N/A</td>
                                        <td>Dopper</td>
                                        <td>2</td>
                                        <td>02/05/2020</td>
                                        <td>N/A</td>
                                        <td>7</td>
                                        <td>N/A</td>
                                        <td>N/A</td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td style="background-color: #e9ecef">11</td>
                                        <td>3</td>
                                        <td>M</td>
                                        <td>N/A</td>
                                        <td>55</td>
                                        <td>Charolais</td>
                                        <td>1</td>
                                        <td>07/06/2020</td>
                                        <td>3.9</td>
                                        <td>19</td>
                                        <td>419</td>
                                        <td>N/A</td>
                                        <td></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div>
                            <strong>Descripción</strong>
                            <ol>
                                <li>Todos los campos deben ser llenados de forma correcta para que puedan ser registrados de manera <b>exitosa</b> y así evitar <b>errores</b></li>
                                <li>El <b>Genero</b>, <b>Arete</b> ó <b>Grapa</b>, <b>Categoría</b>, <b>Corral</b> son campos requeridos</li>
                                <li>El campo de fecha de nacimiento debe ser en formato <b>dd/mm/aaaa</b> ó <b>dd/mm/aa</b></li>
                                <li>Todos los campos que no contengan información deben tener la siguiente abreviatura:
                                    <ul>
                                        <li><b>N/A</b> ó <b>n/a</b></li>
                                    </ul>
                                    <label style="background:#ffff00;"><b>Si no se usa la abreviatura se debe dejar el campo vacío</b></label>
                                </li>
                                <li>El campo de genero debe contener la siguiente abreviatura:
                                    <ul>
                                        <li><b>M</b> para macho</li>
                                        <li><b>H</b> para hembra</li>
                                    </ul>
                                </li>
                                <li>En el campo de categoria debe ingresar el <b>ID</b> de categoria, en el formato se mostrara una tabla con el listado de categorias con su id y nombre</li>
                                <li>En el campo de corral debe ingresar el <b>ID</b> de corral, en el formato se mostrara una tabla con el listado de corrales con su id y nombre</li>
                                <li>En el campo N° debe indicar el número de fila, es decir debe ser consecutivo (1,2,3 ...) <br> <label style="background:#ffff00;"><b>Evitar poner numeración de más</b>
                                        , por ejemplo si se tienen 130 animales la númeración va del 1 hasta el 130 </label></li>
                            </ol>
                        </div>
                    </div>
                    <div id="demoExcelAnimals" style="display: none">
                        <h5>Plantilla demo registro de animales:</h5>
                        <div class="table-responsive">

                            <table class="table table-bordered table-sm  text-center table-hover " width="100%" cellspacing="0" cellpadding="" style="font-size: 9px">

                                <thead class="thead-light">

                                    <th scope="col"></th>
                                    <th scope="col">A</th>
                                    <th scope="col">B</th>
                                    <th scope="col">C</th>
                                    <th scope="col">D</th>
                                    <th scope="col">E</th>
                                    <th scope="col">F</th>
                                    <th scope="col">G</th>
                                    <th scope="col">H</th>

                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="background-color: #e9ecef">8</td>
                                        <th class="border border-dark">N°</th>
                                        <th class="border border-dark">Genero</th>
                                        <th class="border border-dark">Grapa</th>
                                        <th class="border border-dark">Raza</th>
                                        <th class="border border-dark">Fecha nac.</th>
                                        <th class="border border-dark">Peso al nacer</th>
                                        <th class="border border-dark">Corral</th>
                                        <th class="border border-dark">Comentarios</th>
                                    </tr>
                                    <tr>
                                        <td style="background-color: #e9ecef">9</td>
                                        <td>1</td>
                                        <td>M</td>
                                        <td>123</td>
                                        <td>N/A</td>
                                        <td>02/06/2021</td>
                                        <td>N/A</td>
                                        <td>14</td>
                                        <td>Ejemplo de comentario</td>
                                    </tr>
                                    <tr>
                                        <td style="background-color: #e9ecef">10</td>
                                        <td>2</td>
                                        <td>H</td>
                                        <td>88</td>
                                        <td></td>
                                        <td>02/05/2020</td>
                                        <td>N/A</td>
                                        <td>7</td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td style="background-color: #e9ecef">11</td>
                                        <td>3</td>
                                        <td>M</td>
                                        <td>55</td>
                                        <td>n/a</td>
                                        <td>07/06/2020</td>
                                        <td>N/A</td>
                                        <td>19</td>
                                        <td></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div>
                            <strong>Descripción</strong>
                            <ol>
                                <li>Todos los campos deben ser llenados de forma correcta para que puedan ser registrados de manera <b>exitosa</b> y así evitar <b>errores</b></li>
                                <li>El <b>Genero</b>, <b>Grapa</b>, <b>Corral</b> son campos requeridos</li>
                                <li>El campo de fecha de nacimiento debe ser en formato <b>dd/mm/aaaa</b> ó <b>dd/mm/aa</b></li>
                                <li>Todos los campos que no contengan información deben tener la siguiente abreviatura:
                                    <ul>
                                        <li><b>N/A</b> ó <b>n/a</b></li>
                                    </ul>
                                    <label style="background:#ffff00;"><b>Si no se usa la abreviatura se debe dejar el campo vacío</b></label>
                                </li>
                                <li>El campo de genero debe contener la siguiente abreviatura:
                                    <ul>
                                        <li><b>M</b> para macho</li>
                                        <li><b>H</b> para hembra</li>
                                    </ul>
                                </li>
                                <li>En el campo de corral debe ingresar el <b>ID</b> de corral, en el formato se mostrara una tabla con el listado de corrales con su id y nombre</li>
                                <li>En el campo N° debe indicar el número de fila, es decir debe ser consecutivo (1,2,3 ...) <br> <label style="background:#ffff00;"><b>Evitar poner numeración de más</b>
                                        , por ejemplo si se tienen 130 animales la númeración va del 1 hasta el 130 </label></li>
                            </ol>
                        </div>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default btn-sm" data-dismiss="modal">Cancelar</button>

                <div id="btn-save">
                    <button type="submit" class="btn btn-primary btn-sm">Guardar</button>
                </div>
            </div>
            </form>
        </div>
    </div>
</div>

<script>
    $("#typeAction").on('change', function() {
        val = $(this).val();
        specie = $("#specieName").val();
        if (val == 'import') {
            $("#fileTag").show();
            if (specie == 'Aves') {
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatAnimalsExcel/Aves") ?>')
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
            } else if (specie == 'Ovino') {
                $("#demoExcelOvis").show();
                $("#demoExcelAnimals").hide();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatOvinoExcel/") ?>')
            } else if (specie == 'Bovino') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                //exportRegisterExcel
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatAnimalsExcel/Bovino") ?>')
            } else if (specie == 'Porcino') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatAnimalsExcel/Porcino") ?>')

            } else if (specie == 'Caprino') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatAnimalsExcel/Caprino") ?>')
            } else if (specie == 'Felinos') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatAnimalsExcel/Felinos") ?>')
            } else if (specie == 'Caninos') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatAnimalsExcel/Caninos") ?>')
            } else if (specie == 'Equino') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatAnimalsExcel/Equino") ?>')
            }
        } else {
            $("#fileTag").hide();
            if (specie == 'Aves') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterExcel/Aves") ?>')
            } else if (specie == 'Ovino') {
                $("#demoExcelOvis").show();
                $("#demoExcelAnimals").hide();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterOvinoExcel/") ?>')
            } else if (specie == 'Bovino') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                //exportRegisterExcel
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterExcel/Bovino") ?>')
            } else if (specie == 'Porcino') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterExcel/Porcino") ?>')
            } else if (specie == 'Caprino') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterExcel/Caprino") ?>')
            } else if (specie == 'Felinos') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterExcel/Felinos") ?>')
            } else if (specie == 'Caninos') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterExcel/Caninos") ?>')
            } else if (specie == 'Equino') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterExcel/Equino") ?>')
            }
        }

    })
    $("#specieName").on('change', function() {
        val = $(this).val();
        type_action = $("#typeAction").val();
        if (type_action == 'import') {
            if (val == 'Aves') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatAnimalsExcel/Aves") ?>')
            } else if (val == 'Ovino') {
                $("#demoExcelOvis").show();
                $("#demoExcelAnimals").hide();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatOvinoExcel/") ?>')
            } else if (val == 'Bovino') {
                //exportRegisterExcel
                $("#demoExcelAnimals").show();
                $("#demoExcelOvis").hide();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatAnimalsExcel/Bovino") ?>')
            } else if (val == 'Porcino') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatAnimalsExcel/Porcino") ?>')
            } else if (val == 'Caprino') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatAnimalsExcel/Caprino") ?>')
            } else if (val == 'Felinos') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatAnimalsExcel/Felinos") ?>')
            } else if (val == 'Caninos') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatAnimalsExcel/Caninos") ?>')
            } else if (val == 'Equino') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/importRegisterFormatAnimalsExcel/Equino") ?>')
            }
        } else {
            if (val == 'Aves') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterExcel/Aves") ?>')
            } else if (val == 'Ovino') {
                $("#demoExcelOvis").show();
                $("#demoExcelAnimals").hide();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterOvinoExcel/") ?>')
            } else if (val == 'Bovino') {
                //exportRegisterExcel
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterExcel/Bovino") ?>')
            } else if (val == 'Porcino') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterExcel/Porcino") ?>')
            } else if (val == 'Caprino') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterExcel/Caprino") ?>')
            } else if (val == 'Felinos') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterExcel/Felinos") ?>')
            } else if (val == 'Caninos') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterExcel/Caninos") ?>')
            } else if (val == 'Equino') {
                $("#demoExcelOvis").hide();
                $("#demoExcelAnimals").show();
                document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/animals/exportRegisterExcel/Equino") ?>')
            }
        }
    })

    $(document).ready(function() {
        $("#importExportForm").validate({
            rules: {
                typeAction: "required",
                specieName: "required",
                registerFormat: "required",
            },
            messages: {
                typeAction: "Campo requerido.",
                specieName: "Campo requerido.",
                registerFormat: "Campo requerido.",
            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");
                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            },
            submitHandler: function(form) {
                $("#formato_registro_excel").modal('hide');
                if($("#typeAction").val()=='import'){
                    showLoader();
                } 
                form.submit();
            }
        });

    });

    function showLoader() {
        var timer = new Timer();
        timer.start();

        timer.addEventListener('secondsUpdated', function(e) {
            $('#watchTime').html(timer.getTimeValues().toString());
        });
        $("#loader_alert").modal('show');
    }

    $("#registerFormat").on('change', function() {
        var ext = $(this).val().split('.').pop();
        if ($(this).val() != '') {
            if (ext != "xlsx") {
                Swal.fire({
                    title: 'Archivo no permitido',
                    text: 'Debe subir un archivo en formato xlsx',
                    icon: 'error'

                })
                $(this).val('');
            }
        }
    })
</script>