<div class="modal fade" id="formato_registro_excel" data-backdrop="static" tabindex="-1" style="overflow-y: scroll;" data-keyboard="false" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Exportar / Importar formato de registro de mortalidad</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div id="show_loading">
            </div>
            <div class="modal-body">
                <span class="text-danger" id="errorMsg"></span>

                <p>Campos requeridos (<span class="text-danger">*</span>)</p>
                <form role="form" method="post" id="importExportForm" autocomplete="off" enctype="multipart/form-data" action="<?= base_url("index.php/mortality/exportRegisterExcel") ?>">
                    <div class="form-group row">
                        <div class="col-md-4">
                            <label>Tipo <span class="text-danger">*</span></label>
                            <select name="typeAction" id="typeAction" class="form-control">
                                <option value="export" selected>Exportar</option>
                                <option value="import">Importar</option>
                            </select>
                        </div>

                    </div>
                    <div class="form-group row" id="fileTag" style="display: none">
                        <div class="col-md-12">
                            <label for="exampleInputFile">Formato de registro<span class="text-danger">*</span></label>
                            <input type="file" name="registerFormat" class="form-control" id="registerFormat">
                        </div>
                    </div>
                    <div>
                        <hr>
                        <br>
                        <h5>Plantilla demo registro de mortalidad:</h5>
                        <div class="table-responsive">

                            <table class="table table-bordered table-sm  text-center table-hover " width="100%" cellspacing="0" cellpadding="" style="font-size: 9px">

                                <thead class="thead-light">

                                    <th scope="col"></th>
                                    <th scope="col">A</th>
                                    <th scope="col">B</th>
                                    <th scope="col">C</th>
                                    <th scope="col">D</th>
                                    <th scope="col">E</th>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="background-color: #e9ecef">8</td>
                                        <th class="border border-dark">N°</th>
                                        <th class="border border-dark">Arete</th>
                                        <th class="border border-dark">Causa</th>
                                        <th class="border border-dark">Fecha</th>
                                        <th class="border border-dark">Comentarios</th>
                                    </tr>
                                    <tr>
                                        <td style="background-color: #e9ecef">9</td>
                                        <td>1</td>
                                        <td>892</td>
                                        <td>Hipotermia</td>
                                        <td>01/09/2021</td>
                                        <td>Debido a las altas temperaturas</td>
                                    </tr>
                                    <tr>
                                        <td style="background-color: #e9ecef">10</td>
                                        <td>2</td>
                                        <td>023</td>
                                        <td>Enfermedades infecciosas</td>
                                        <td>05/10/2020</td>
                                        <td>Le dio gripe</td>
                                    </tr>
                                    <tr>
                                        <td style="background-color: #e9ecef">11</td>
                                        <td>3</td>
                                        <td>007</td>
                                        <td>Accidentes</td>
                                        <td>03/08/2021</td>
                                        <td>N/A</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div>
                            <strong>Descripción</strong>
                            <ol>
                                <li>Todos los campos deben ser llenados de forma correcta para que puedan ser registrados de manera <b>exitosa</b> y así evitar <b>errores</b></li>
                                <li>El <b>Arete</b>, <b>Causa</b>, <b>Fecha</b> son campos requeridos</li>
                                <li>El campo de fecha debe ser en formato <b>dd/mm/aaaa</b> ó <b>dd/mm/aa</b></li>
                                <li>Todos los campos que no contengan información deben tener la siguiente abreviatura:
                                    <ul>
                                        <li><b>N/A</b> ó <b>n/a</b></li>
                                    </ul>
                                    <label style="background:#ffff00;"><b>Si no se usa la abreviatura se debe dejar el campo vacío</b></label>
                                </li>
                                <li>En el campo de causa debe ingresar el <b>NOMBRE</b> de la causa, en el formato se mostrara una tabla con el listado de causas</li>
                                <li>En el campo N° debe indicar el número de fila, es decir debe ser consecutivo (1,2,3 ...) <br> <label style="background:#ffff00;"><b>Evitar poner numeración de más</b>
                                        , por ejemplo si se tienen 10 registros de mortalidad la númeración va del 1 hasta el 10 </label></li>
                            </ol>
                        </div>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default btn-sm" data-dismiss="modal">Cancelar</button>

                <div id="btn-save">
                    <button type="submit" class="btn btn-primary btn-sm">Guardar</button>
                </div>
            </div>
            </form>
        </div>
    </div>
</div>

<script>
    $("#typeAction").on('change', function() {
        val = $(this).val();
        specie = $("#specieName").val();
        if (val == 'import') {
            $("#fileTag").show();
            document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/mortality/importRegisterFormatMortalityExcel") ?>')
        } else {
            $("#fileTag").hide();
            document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/mortality/exportRegisterExcel") ?>')
        }
    })

    $(document).ready(function() {
        $("#importExportForm").validate({
            rules: {
                typeAction: "required",
                registerFormat: "required",
            },
            messages: {
                typeAction: "Campo requerido.",
                registerFormat: "Campo requerido.",
            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");
                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            },
            submitHandler: function(form) {
                $("#formato_registro_excel").modal('hide');
                if ($("#typeAction").val() == 'import') {
                    showLoader();
                }
                form.submit();
            }
        });

    });

    function showLoader() {
        var timer = new Timer();
        timer.start();

        timer.addEventListener('secondsUpdated', function(e) {
            $('#watchTime').html(timer.getTimeValues().toString());
        });
        $("#loader_alert").modal('show');
    }

    $("#registerFormat").on('change', function() {
        var ext = $(this).val().split('.').pop();
        if ($(this).val() != '') {
            if (ext != "xlsx") {
                Swal.fire({
                    title: 'Archivo no permitido',
                    text: 'Debe subir un archivo en formato xlsx',
                    icon: 'error'

                })
                $(this).val('');
            }
        }
    })
</script>