<div class="modal fade" id="formato_registro_excel" data-backdrop="static" tabindex="-1" style="overflow-y: scroll;" data-keyboard="false" aria-labelledby="staticBackdropLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="staticBackdropLabel">Exportar / Importar formato de registro de tratamientos</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div id="show_loading">
            </div>
            <div class="modal-body">
                <span class="text-danger" id="errorMsg"></span>

                <p>Campos requeridos (<span class="text-danger">*</span>)</p>
                <form role="form" method="post" id="importExportForm" autocomplete="off" enctype="multipart/form-data" action="<?= base_url("index.php/Treatment/exportRegisterExcel") ?>">
                    <div class="form-group row">
                        <div class="col-md-3">
                            <label>Tipo <span class="text-danger">*</span></label>
                            <select name="typeAction" id="typeAction" class="form-control">
                                <option value="export" selected>Exportar</option>
                                <option value="import">Importar</option>
                            </select>
                        </div>

                    </div>

                    <hr>
                    <br>

                    <div id="plantillaDemo">
                        <h5>Plantilla demo registro de partos:</h5>
                        <div class="table-responsive">
                            <table class="table table-bordered table-sm  text-center table-hover " width="100%" cellspacing="0" cellpadding="" style="font-size: 9px">
                                <thead class="thead-light">
                                    <th scope="col"></th>
                                    <th scope="col">A</th>
                                    <th scope="col">B</th>
                                    <th scope="col">C</th>

                                </thead>
                                <tbody>
                                    <tr>
                                        <td style="background-color: #e9ecef">8</td>
                                        <th class="border border-dark">N°</th>
                                        <th class="border border-dark">Arete/Grapa</th>
                                        <th class="border border-dark">Observación</th>
                                    </tr>
                                    <tr>
                                        <td style="background-color: #e9ecef">9</td>
                                        <td>1</td>

                                        <td>034</td>
                                        <td>Observación de prueba</td>
                                    </tr>
                                    <tr>
                                        <td style="background-color: #e9ecef">10</td>
                                        <td>2</td>
                                        <td>034</td>
                                        <td>El animal esta demaciado enfermo</td>
                                    </tr>
                                    <tr>
                                        <td style="background-color: #e9ecef">11</td>
                                        <td>3</td>
                                        <td>098</td>
                                        <td>Observación</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div>
                            <strong>Descripción</strong>
                            <ol>
                                <li>Todos los campos deben ser llenados de forma correcta para que puedan ser registrados de manera <b>exitosa</b> y así evitar <b>errores</b></li>
                                <li>El <b>Arete</b>, <b>Fecha</b> son campos requeridos</li>
                                <li>En el campo N° debe indicar el número de fila, es decir debe ser consecutivo (1,2,3 ...) <br> <label style="background:#ffff00;"><b>Evitar poner numeración de más</b>
                                        , por ejemplo si se tienen 10 registros de tratamientos la númeración va del 1 hasta el 10 </label></li>
                            </ol>
                        </div>
                    </div>
                    <div id="form_excel" style="display: none">
                        <div class="form-group row">

                            <div class="col-md-3">
                                <label>Especie <span class="text-danger">*</span></label>
                                <select name="specie" id="specie" class="form-control" <?= (isset($animals_details)) ? 'readonly' : '' ?>>
                                    <option value="" selected> -Seleccione una opción-</option>
                                    <option value="AVE">Aves</option>
                                    <option value="OVI">Ovinos</option>
                                    <option value="BOV">Bovinos</option>
                                    <option value="POR">Porcinos</option>
                                    <option value="CAP">Caprinos</option>
                                    <option value="FEL">Felinos</option>
                                    <option value="EQU">Equinos (Caballos y Yeguas)</option>
                                </select>
                            </div>

                            <div class="col-md-6">
                                <label for="treatment">Tratamiento <span class="text-danger">*</span></label>
                                <textarea name="treatment" id="treatment" cols="30" rows="2" placeholder="Escriba aquí el tratamiento" class="form-control"><?= @$treatment_details->treatment; ?></textarea>
                            </div>
                            <div class="col-md-2 mt-4">
                                <label for="duration">Unica dosis</label>
                                <label>
                                    <input type="checkbox" id="dosis1_" class="js-switch"></label>
                            </div>

                        </div>
                        <div class="form-group row mt-4">
                            <div class="col-md-3">
                                <label for="duration">Duración </label>
                                <input type="text" class="form-control" placeholder="Duración" name="duration" id="duration1" value="<?= @$treatment_details->duration; ?>">
                            </div>
                            <div class="col-md-3 col-sm-3">
                                <label for="start_date">Fecha inicio<span class="text-danger">*</span></label>
                                <input type="date" class="form-control" placeholder="" name="start_date" id="start_date" value="<?= @$treatment_details->start_date; ?>">
                            </div>
                            <div class="col-md-3  col-sm-3">
                                <label for="end_date">Fecha termino</label>
                                <input type="date" class="form-control" placeholder="" name="end_date" id="end_date" value="<?= @$treatment_details->end_date; ?>">
                            </div>


                            <div class="col-md-3">
                                <label for="responsible">Responsable <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" placeholder="Responsable" name="responsible" id="responsible" value="<?= @$treatment_details->responsible; ?>">
                            </div>




                        </div>
                        <div class="form-group row mt-4">
                            <div class="col-md-4">
                                <label for="exampleInputFile">Formato de registro<span class="text-danger">*</span></label>
                                <input type="file" name="registerFormat" class="form-control" id="registerFormat">
                            </div>
                        </div>

                        <div class="form-group row">

                        </div>

                        <input type="hidden" class="form-control" name="created_user" value="<?= $this->session->userdata('user_admin_sess')->fullname ?>" id="created_user">
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default btn-sm" data-dismiss="modal">Cancelar</button>

                <div id="btn-save">
                    <button type="submit" class="btn btn-primary btn-sm">Guardar</button>
                </div>
            </div>
            </form>
        </div>
    </div>
</div>

<script>
    $("#typeAction").on('change', function() {
        val = $(this).val();
        specie = $("#specieName").val();
        if (val == 'import') {
            $("#fileTag").show();
            $("#plantillaDemo").hide();
            $("#form_excel").show();
            document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/Treatment/importRegisterFormatTreatmenExcel") ?>')

        } else {
            $("#fileTag").hide();
            $("#plantillaDemo").show();
            $("#form_excel").hide();
            $("#fileTag").hide();
            document.getElementById("importExportForm").setAttribute('action', '<?= base_url("index.php/Treatment/exportRegisterExcel") ?>')
        }

    })

    $(document).ready(function() {
        $("#importExportForm").validate({
            rules: {
                typeAction: "required",
                registerFormat: "required",
            },
            messages: {
                typeAction: "Campo requerido.",
                registerFormat: "Campo requerido.",
            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");
                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            },
            submitHandler: function(form) {
                $("#formato_registro_excel").modal('hide');
                form.submit();
                showLoader();
            }
        });

    });


    function showLoader() {
        var timer = new Timer();
        timer.start();

        timer.addEventListener('secondsUpdated', function(e) {
            $('#watchTime').html(timer.getTimeValues().toString());
        });
        $("#loader_alert").modal('show');
    }

    $("#registerFormat").on('change', function() {
        var ext = $(this).val().split('.').pop();
        if ($(this).val() != '') {
            if (ext != "xlsx") {
                Swal.fire({
                    title: 'Archivo no permitido',
                    text: 'Debe subir un archivo en formato xlsx',
                    icon: 'error'

                })
                $(this).val('');
            }
        }
    })
</script>