<link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.25/css/jquery.dataTables.css">

<?php
if (@$this->session->flashdata('ornamentalEgg_details')) {
    $ornamentalEgg_details = $this->session->flashdata('ornamentalEgg_details')['data'];
} ?>

<div class="right_col" role="main">
    <!-- <div class="row"> -->
    <div class="col-md-12 col-sm-12 ">
        <div class="dashboard_graph">
            <div class="row x_title">
                <div class="col-md-6">
                    <h3>Huevos de aves ornamentales (Recolección) </h3>
                </div>
            </div>
            <div class="row x_title">
                <div class="col-md-12">
                    <a data-toggle="modal" style="color:#fff" data-target="#add_ornamentalEgg" class="btn btn-secondary btn-sm pull-right">
                        <i class="fa fa-plus-square"></i> Registrar </a>
                    <a data-toggle="modal" style="color:#fff" data-target="#pdf_modal" class="btn btn-success btn-sm pull-right">
                        <i class="fa fa-folder-open"></i> Generar reportes</a>

                    <table class="table table-striped table-bordered dt-responsive nowrap" id="table_ornamentalEgg">
                        <thead>
                            <tr>
                                <th id="_no" class="all hidden-print">#</th>
                                <th id="collection_date_">Fecha de recoleccion</th>
                                <th id="mother_earring_">Arete madre</th>
                                <th id="egg_weight_">Peso del huevo (s) </th>
                                <th id="total_eggs_">Número de huevos</th>
                                <th id="specie_">Especie</th>
                                <th id="collection_location_">Lugar de recolección</th>
                                <th id="collection_location_">Observaciones</th>
                                <th id="action_">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $count = 1;
                            foreach ($ornamentalEgg as $ornamental) : ?>
                                <tr>
                                    <td><?php echo $count++; ?></td>
                                    <td><?= $ornamental->collection_date ?> </td>
                                    <td><?= $ornamental->mother_earring ?> </td>
                                    <td><?= $ornamental->egg_weight ?> Kg</td>
                                    <td><?= $ornamental->total_eggs ?></td>
                                    <td><?= $ornamental->specie ?></td>
                                    <td><?= $ornamental->collection_location ?></td>
                                    <td><?= (isset($ornamental->comment)) ? $ornamental->comment : '---' ?></td>

                                    <td>
                                        <div class="btn-group">
                                            <button type="button" class="btn btn-secondary btn-sm dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                                Acciones
                                            </button>
                                            <div class="dropdown-menu">

                                                <a class="dropdown-item" href="<?= base_url('index.php/ornamentalEgg/ornamentalEggBY/' . $ornamental->id_ornamental_egg); ?>"><i class="fa fa-edit"></i> Editar</a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" onclick="ornamentalEgg_delete(<?= $ornamental->id_ornamental_egg ?>)"><i class="fa fa-trash-o"></i> Eliminar</a>
                                            </div>
                                        </div>
                                    </td>

                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
<br />
</div>


<script>
    function mayus(e) {
        e.value = e.value.toUpperCase();
    }

    function capit(word) {
        return word.trim().toLowerCase().replace(/\w\S*/g, (w) => (w.replace(/^\w/, (c) => c.toUpperCase())));

    }
</script>

<?php include APPPATH . 'views/modals/ornamentalEgg/add_ornamentalEgg.php'; ?>
<?php include APPPATH . 'views/modals/ornamentalEgg/pdf_modal.php'; ?>
<?php include APPPATH . 'views/scripts/ornamentalEgg.php'; ?>