<script>
    $(document).ready(function() {
        $('#temperature_table').DataTable({
            "language": {
                "decimal": "",
                "emptyTable": "No hay información",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",
                "infoFiltered": "(Filtrado de _MAX_ total entradas)",
                "infoPostFix": "",
                "ihousands": ",",
                "lengthMenu": "Mostrar _MENU_ Entradas",
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "search": "Buscar:",
                "zeroRecords": "Sin resultados encontrados",
                "paginate": {
                    "first": "Primero",
                    "last": "Ultimo",
                    "next": "Siguiente",
                    "previous": "Anterior"
                }
            },
        });

        $("#importForm").validate({
            rules: {
                file_data: "required"
            },
            messages: {
                file_data: "Campo requerido.",
            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");
                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            },
            submitHandler: function(form) {
                $("#import-file").modal('hide');
                form.submit();
                showLoader();
            }
        });
    });
    
        function showLoader() {
        var timer = new Timer();
        timer.start();

        timer.addEventListener('secondsUpdated', function(e) {
            $('#watchTime').html(timer.getTimeValues().toString());
        });
        $("#loader_alert").modal('show');
    }

    $("#file_data").on('change', function() {
        var ext = $(this).val().split('.').pop();
        if ($(this).val() != '') {
            if (ext != "xlsx") {
                Swal.fire({
                    title: 'Archivo no permitido',
                    text: 'Debe subir un archivo en formato xlsx',
                    icon: 'error'

                })
                $(this).val('');
            }
        }
    })
</script>