<script>
  $(document).ready(function() {
    $('#diet_table').DataTable({
      "language": {
        "decimal": "",
        "emptyTable": "No hay información",
        "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
        "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",
        "infoFiltered": "(Filtrado de _MAX_ total entradas)",
        "infoPostFix": "",
        "ihousands": ",",
        "lengthMenu": "Mostrar _MENU_ Entradas",
        "loadingRecords": "Cargando...",
        "processing": "Procesando...",
        "search": "Buscar:",
        "zeroRecords": "Sin resultados encontrados",
        "paginate": {
          "first": "Primero",
          "last": "Ultimo",
          "next": "Siguiente",
          "previous": "Anterior"
        }
      },
    });
  });


  $(document).ready(function() {
    $(".diet_form").validate({
      rules: {
        name_diet: "required",

        id_rodeo: "required",
        date_displacement: "required",
      },
      messages: {
        name_diet: "Campo requerido.",
        id_rodeo: "Campo requerido.",
        date_displacement: "Campo requerido.",
      },
      errorElement: "em",
      errorPlacement: function(error, element) {
        error.addClass("invalid-feedback");
        if (element.prop("type") === "checkbox") {
          error.insertAfter(element.next("label"));
        } else {
          error.insertAfter(element);
        }
      },
      highlight: function(element, errorClass, validClass) {
        $(element).addClass("is-invalid").removeClass("is-valid");
      },
      unhighlight: function(element, errorClass, validClass) {
        $(element).addClass("is-valid").removeClass("is-invalid");
      },
      
    });
  });
  function delete_diet(_id) {
    Swal.fire({
      title: '¿Está seguro?',
      text: "¡No podrá recuperar este registro, una vez sea eliminado!",
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Si, Eliminar!'
    }).then((result) => {
      if (result.value) {

        $.ajax({
          url: "<?= API_URL; ?>diet/api/diet/id/" + _id,
          method: "DELETE",
          headers: {
            "X-API-KEY": "QroSystem%21#",
          },
          success: function(_response) {
            response = _response.message;
            if (_response.status == "error") {
              Swal.fire({
                position: 'center',
                icon: 'error',
                title: 'Ha ocurrido un error interno',
                text: "'" + response + "'",
                showConfirmButton: true,
                onAfterClose: () => {
                  window.location.reload();

                }
              })
            } else {

              Swal.fire({
                position: 'center',
                icon: 'success',
                title: 'Registro eliminado correctamente',
                showConfirmButton: false,
                timer: 2500,
                onAfterClose: () => {
                  window.location.reload();

                }
              })
            }
          },
          error: function() {

            Swal.fire({
              position: 'center',
              icon: 'error',
              title: 'Ha ocurrido un error interno',
              showConfirmButton: true,
              onAfterClose: () => {
                window.location.reload();

              }
            })
          },
        });
      }
    })

  }




  $(document).on("submit", "#diet_form", function(event) {
    event.preventDefault();

    $.ajax({
      url: "<?= API_URL ?>diet/api/diet/",
      method: "POST",
      headers: {
        "X-API-KEY": "QroSystem%21#",
      },
      data: $(document).find(this).serialize(),
      success: function(_response) {
        response = _response.message;
        $('#insemination_modal').modal('hide')
        Swal.fire({
          position: 'center',
          icon: 'success',
          title: 'Dieta registrada con exito',
          showConfirmButton: false,
          timer: 2500,
          onAfterClose: () => {
            window.location.reload();
            show_loading();
          }
        })
      },
      error: function(error) {
        response = JSON.stringify(error.responseText);
        $("#show_loading").html('');
        Swal.fire({
          position: 'center',
          icon: 'error',
          title: 'Ha ocurrido un error interno',
          text: "'" + response.message + "'",
          showConfirmButton: true,
          onAfterClose: () => {
            window.location.reload();
            show_loading();
          }
        })
      },
    });
  });


  <?php if (@$ingredient_details) { ?>


    $(document).ready(function() {
      $("#editIngredient_modal").modal('show');
    });

    $(document).on("submit", "#ingredient_form ", function(event) {
      event.preventDefault();

      $.ajax({
        url: "<?= API_URL . 'diet/api/ingredient/id/' . $ingredient_details->id_ingredient ?>",
        method: "PUT",
        headers: {
          "X-API-KEY": "QroSystem%21#",
        },
        data: $(document).find(this).serialize(),
        success: function(_response) {
          response = _response.message;
          $('#weaning_modal').modal('hide')
          Swal.fire({
            position: 'center',
            icon: 'success',
            title: 'Ingrediente actualizado con exito',
            showConfirmButton: false,
            timer: 2500,
            onAfterClose: () => {
              window.location.reload();
              show_loading();
            }
          })
        },
        error: function(error) {
          response = JSON.stringify(error.responseText);
          Swal.fire({
            position: 'center',
            icon: 'error',
            title: 'Ha ocurrido un error interno',
            text: response.message,
            showConfirmButton: true,
          })
        },
      });
    });

  <?php } ?>
</script>