<script src="<?php echo base_url('assets/plugins/sweetalert2/sweetalert2.all.min.js') ?>"></script>
<script>
    $(document).ready(function() {
        $("#productionEggs_form").validate({
            rules: {
                date_productions: "required",
                id_rodeo: "required",
                responsible: "required",
                quantity_kg: "required",
                num_pieces: "required",
                status_eggs: "required",
            },
            messages: {
                date_productions: "Campo requerido.",
                id_rodeo: "Campo requerido.",
                responsible: "Campo requerido.",
                quantity_kg: "Campo requerido.",
                num_pieces: "Campo requerido.",
                status_eggs: "Campo requerido.",
            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");

                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            }
        });
    });
    $(document).ready(function() {
        $("#productionEggs_details_form").validate({
            rules: {
                quantity_kg_u: "required",
                num_pieces_u: "required",
                status_eggs_u: "required",
            },
            messages: {
                quantity_kg_u: "Campo requerido.",
                num_pieces_u: "Campo requerido.",
                status_eggs_u: "Campo requerido.",
            },
            errorElement: "em",
            errorPlacement: function(error, element) {
                error.addClass("invalid-feedback");

                if (element.prop("type") === "checkbox") {
                    error.insertAfter(element.next("label"));
                } else {
                    error.insertAfter(element);
                }
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass("is-invalid").removeClass("is-valid");
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).addClass("is-valid").removeClass("is-invalid");
            }
        });
    });

    $(document).ready(function() {

        $('#production_table').DataTable({
            "language": {
                "decimal": "",
                "emptyTable": "No hay información",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
                "infoEmpty": "Mostrando 0 to 0 of 0 Entradas",
                "infoFiltered": "(Filtrado de _MAX_ total entradas)",
                "infoPostFix": "",
                "ihousands": ",",
                "lengthMenu": "Mostrar _MENU_ Entradas",
                "loadingRecords": "Cargando...",
                "processing": "Procesando...",
                "search": "Buscar:",
                "zeroRecords": "Sin resultados encontrados",
                "paginate": {
                    "first": "Primero",
                    "last": "Ultimo",
                    "next": "Siguiente",
                    "previous": "Anterior"
                }
            },
        });


    });

    $(document).on("submit", "#productionEggs_form ", function(event) {
        event.preventDefault();
        $.ajax({
            url: "<?= API_URL ?>productions/api/eggs_productions/",
            method: "POST",
            headers: {
                "X-API-KEY": "QroSystem%21#",
            },
            data: $(document).find(this).serialize(),
            success: function(_response) {
                response = _response.message;
                console.log(response)
                location.reload();
                show_loading();
            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Ha ocurrido un error interno',
                    text: "'" + response.message + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                        show_loading();
                    }
                })
            },
        });
    });

    $(document).on("submit", "#productionEggsUpdate_form ", function(event) {
        event.preventDefault();
        $.ajax({
            url: "<?= API_URL ?>productions/api/eggs_productions/id/<?= @$production_details->id_production ?>",
            method: "PUT",
            headers: {
                "X-API-KEY": "QroSystem%21#",
            },
            data: $(document).find(this).serialize(),
            success: function(_response) {
                response = _response.message;
                console.log(response)
                location.reload();
                show_loading();
            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Ha ocurrido un error interno',
                    text: "'" + response.message + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                        show_loading();
                    }
                })
            },
        });
    });


    $(document).on("submit", "#productionEggs_details_form ", function(event) {
        event.preventDefault();
        $.ajax({
            url: "<?= API_URL ?>productions/api/eggs_productions_details/id/<?= @$productionEggs_details->id_egg_production ?>",
            method: "PUT",
            headers: {
                "X-API-KEY": "QroSystem%21#",
            },
            data: $(document).find(this).serialize(),
            success: function(_response) {
                response = _response.message;
                console.log(response)
                location.reload();
                show_loading();
            },
            error: function(error) {
                response = JSON.stringify(error.responseText);
                Swal.fire({
                    position: 'center',
                    icon: 'error',
                    title: 'Ha ocurrido un error interno',
                    text: "'" + response.message + "'",
                    showConfirmButton: true,
                    onAfterClose: () => {
                        window.location.reload();
                        show_loading();
                    }
                })
            },
        });
    });
    <?php if (isset($production_details)) { ?>

        $(document).ready(function() {
            $("#add_eggsProduction").modal('show');
        });

    <?php } ?>

    <?php if (isset($productionEggs_details)) { ?>

        $(document).ready(function() {
            $("#update_eggsProductionDetails").modal('show');
        });

    <?php } ?>
    $('.close_modal').on('click', function(e) {
        e.preventDefault();
        <?php if (isset($production_details)) { ?>
            location.reload();
        <?php } else { ?>
            document.getElementById('productionEggs_form').reset();

        <?php } ?>

    })

    function deleteProductionEgg(_id) {
        Swal.fire({
            title: '¿Está seguro?',
            text: "¡No podrá recuperar este registro, una vez sea eliminado!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Si, Eliminar!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?= API_URL; ?>productions/api/eggs_productions/id/" +
                        _id,
                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "QroSystem%21#",
                    },
                    success: function(_response) {
                        response = _response.message;
                        if (_response.status == "error") {
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                title: 'Ha ocurrido un error interno', 
                                text: "'" + response + "'",
                                showConfirmButton: true,
                                onAfterClose: () => {
                                    window.location.reload();
                                }
                            })
                        } else {
                            Swal.fire({
                                position: 'center',
                                icon: 'success',
                                title: 'Registro eliminado correctamente',
                                showConfirmButton: false,
                                timer: 2500,
                                onAfterClose: () => {
                                    window.location.reload();

                                }
                            })
                        }
                    },
                    error: function() {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();

                            }
                        })
                    },
                });
            }
        })
    }

    function deleteProductionEggDetails(_id) {
        Swal.fire({
            title: '¿Está seguro?',
            text: "¡No podrá recuperar este registro, una vez sea eliminado!",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Si, Eliminar!'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?= API_URL; ?>productions/api/eggs_productions_details/id/" +
                        _id,
                    method: "DELETE",
                    headers: {
                        "X-API-KEY": "QroSystem%21#",
                    },
                    success: function(_response) {
                        response = _response.message;
                        if (_response.status == "error") {
                            Swal.fire({
                                position: 'center',
                                icon: 'error',
                                title: 'Ha ocurrido un error interno',
                                text: "'" + response + "'",
                                showConfirmButton: true,
                                onAfterClose: () => {
                                    window.location.reload();
                                }
                            })
                        } else {
                            Swal.fire({
                                position: 'center',
                                icon: 'success',
                                title: 'Registro eliminado correctamente',
                                showConfirmButton: false,
                                timer: 2500,
                                onAfterClose: () => {
                                    window.location.reload();

                                }
                            })
                        }
                    },
                    error: function() {
                        Swal.fire({
                            position: 'center',
                            icon: 'error',
                            title: 'Ha ocurrido un error interno',
                            showConfirmButton: true,
                            onAfterClose: () => {
                                window.location.reload();

                            }
                        })
                    },
                });
            }
        })
    }
</script>